/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v27.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.v27.segment.NK1;
import ca.uhn.hl7v2.model.v27.segment.PD1;
import ca.uhn.hl7v2.model.v27.segment.PID;
import ca.uhn.hl7v2.model.v27.segment.QRI;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class RSP_K22_QUERY_RESPONSE
extends AbstractGroup {
    public RSP_K22_QUERY_RESPONSE(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(PID.class, true, false, false);
            this.add(PD1.class, false, false, false);
            this.add(NK1.class, false, true, false);
            this.add(QRI.class, false, false, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating RSP_K22_QUERY_RESPONSE - this is probably a bug in the source code generator.", e);
        }
    }

    public String getVersion() {
        return "2.7";
    }

    public PID getPID() {
        PID retVal = this.getTyped("PID", PID.class);
        return retVal;
    }

    public PD1 getPD1() {
        PD1 retVal = this.getTyped("PD1", PD1.class);
        return retVal;
    }

    public NK1 getNK1() {
        NK1 retVal = this.getTyped("NK1", NK1.class);
        return retVal;
    }

    public NK1 getNK1(int rep) {
        NK1 retVal = this.getTyped("NK1", rep, NK1.class);
        return retVal;
    }

    public int getNK1Reps() {
        return this.getReps("NK1");
    }

    public List<NK1> getNK1All() throws HL7Exception {
        return this.getAllAsList("NK1", NK1.class);
    }

    public void insertNK1(NK1 structure, int rep) throws HL7Exception {
        super.insertRepetition("NK1", structure, rep);
    }

    public NK1 insertNK1(int rep) throws HL7Exception {
        return (NK1)super.insertRepetition("NK1", rep);
    }

    public NK1 removeNK1(int rep) throws HL7Exception {
        return (NK1)super.removeRepetition("NK1", rep);
    }

    public QRI getQRI() {
        QRI retVal = this.getTyped("QRI", QRI.class);
        return retVal;
    }
}

