/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v27.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.v27.segment.OBX;
import ca.uhn.hl7v2.model.v27.segment.RXA;
import ca.uhn.hl7v2.model.v27.segment.RXR;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class CCR_I16_MEDICATION_ADMINISTRATION_DETAIL
extends AbstractGroup {
    public CCR_I16_MEDICATION_ADMINISTRATION_DETAIL(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(RXA.class, true, true, false);
            this.add(RXR.class, true, false, false);
            this.add(OBX.class, false, true, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating CCR_I16_MEDICATION_ADMINISTRATION_DETAIL - this is probably a bug in the source code generator.", e);
        }
    }

    public String getVersion() {
        return "2.7";
    }

    public RXA getRXA() {
        RXA retVal = this.getTyped("RXA", RXA.class);
        return retVal;
    }

    public RXA getRXA(int rep) {
        RXA retVal = this.getTyped("RXA", rep, RXA.class);
        return retVal;
    }

    public int getRXAReps() {
        return this.getReps("RXA");
    }

    public List<RXA> getRXAAll() throws HL7Exception {
        return this.getAllAsList("RXA", RXA.class);
    }

    public void insertRXA(RXA structure, int rep) throws HL7Exception {
        super.insertRepetition("RXA", structure, rep);
    }

    public RXA insertRXA(int rep) throws HL7Exception {
        return (RXA)super.insertRepetition("RXA", rep);
    }

    public RXA removeRXA(int rep) throws HL7Exception {
        return (RXA)super.removeRepetition("RXA", rep);
    }

    public RXR getRXR() {
        RXR retVal = this.getTyped("RXR", RXR.class);
        return retVal;
    }

    public OBX getOBX() {
        OBX retVal = this.getTyped("OBX", OBX.class);
        return retVal;
    }

    public OBX getOBX(int rep) {
        OBX retVal = this.getTyped("OBX", rep, OBX.class);
        return retVal;
    }

    public int getOBXReps() {
        return this.getReps("OBX");
    }

    public List<OBX> getOBXAll() throws HL7Exception {
        return this.getAllAsList("OBX", OBX.class);
    }

    public void insertOBX(OBX structure, int rep) throws HL7Exception {
        super.insertRepetition("OBX", structure, rep);
    }

    public OBX insertOBX(int rep) throws HL7Exception {
        return (OBX)super.insertRepetition("OBX", rep);
    }

    public OBX removeOBX(int rep) throws HL7Exception {
        return (OBX)super.removeRepetition("OBX", rep);
    }
}

