/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v26.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v26.datatype.CWE;
import ca.uhn.hl7v2.model.v26.datatype.CX;
import ca.uhn.hl7v2.model.v26.datatype.DT;
import ca.uhn.hl7v2.model.v26.datatype.ID;
import ca.uhn.hl7v2.model.v26.datatype.IS;
import ca.uhn.hl7v2.model.v26.datatype.XCN;
import ca.uhn.hl7v2.model.v26.datatype.XON;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class PD1
extends AbstractSegment {
    public PD1(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(IS.class, false, 0, 2, new Object[]{this.getMessage(), new Integer(223)}, "Living Dependency");
            this.add(IS.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(220)}, "Living Arrangement");
            this.add(XON.class, false, 0, 250, new Object[]{this.getMessage()}, "Patient Primary Facility");
            this.add(XCN.class, false, 0, 0, new Object[]{this.getMessage()}, "Patient Primary Care Provider Name & ID No.");
            this.add(IS.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(231)}, "Student Indicator");
            this.add(IS.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(295)}, "Handicap");
            this.add(IS.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(315)}, "Living Will Code");
            this.add(IS.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(316)}, "Organ Donor Code");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(136)}, "Separate Bill");
            this.add(CX.class, false, 0, 250, new Object[]{this.getMessage()}, "Duplicate Patient");
            this.add(CWE.class, false, 1, 705, new Object[]{this.getMessage()}, "Publicity Code");
            this.add(ID.class, false, 1, 0, new Object[]{this.getMessage(), new Integer(136)}, "Protection Indicator");
            this.add(DT.class, false, 1, 0, new Object[]{this.getMessage()}, "Protection Indicator Effective Date");
            this.add(XON.class, false, 0, 250, new Object[]{this.getMessage()}, "Place of Worship");
            this.add(CWE.class, false, 0, 705, new Object[]{this.getMessage()}, "Advance Directive Code");
            this.add(IS.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(441)}, "Immunization Registry Status");
            this.add(DT.class, false, 1, 8, new Object[]{this.getMessage()}, "Immunization Registry Status Effective Date");
            this.add(DT.class, false, 1, 8, new Object[]{this.getMessage()}, "Publicity Code Effective Date");
            this.add(IS.class, false, 1, 5, new Object[]{this.getMessage(), new Integer(140)}, "Military Branch");
            this.add(IS.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(141)}, "Military Rank/Grade");
            this.add(IS.class, false, 1, 3, new Object[]{this.getMessage(), new Integer(142)}, "Military Status");
            this.add(DT.class, false, 1, 8, new Object[]{this.getMessage()}, "Advance Directive Last Verified Date");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating PD1 - this is probably a bug in the source code generator.", e);
        }
    }

    public IS[] getLivingDependency() {
        IS[] retVal = (IS[])this.getTypedField(1, new IS[0]);
        return retVal;
    }

    public IS[] getPd11_LivingDependency() {
        IS[] retVal = (IS[])this.getTypedField(1, new IS[0]);
        return retVal;
    }

    public int getLivingDependencyReps() {
        return this.getReps(1);
    }

    public IS getLivingDependency(int rep) {
        IS retVal = (IS)this.getTypedField(1, rep);
        return retVal;
    }

    public IS getPd11_LivingDependency(int rep) {
        IS retVal = (IS)this.getTypedField(1, rep);
        return retVal;
    }

    public int getPd11_LivingDependencyReps() {
        return this.getReps(1);
    }

    public IS insertLivingDependency(int rep) throws HL7Exception {
        return (IS)super.insertRepetition(1, rep);
    }

    public IS insertPd11_LivingDependency(int rep) throws HL7Exception {
        return (IS)super.insertRepetition(1, rep);
    }

    public IS removeLivingDependency(int rep) throws HL7Exception {
        return (IS)super.removeRepetition(1, rep);
    }

    public IS removePd11_LivingDependency(int rep) throws HL7Exception {
        return (IS)super.removeRepetition(1, rep);
    }

    public IS getLivingArrangement() {
        IS retVal = (IS)this.getTypedField(2, 0);
        return retVal;
    }

    public IS getPd12_LivingArrangement() {
        IS retVal = (IS)this.getTypedField(2, 0);
        return retVal;
    }

    public XON[] getPatientPrimaryFacility() {
        XON[] retVal = (XON[])this.getTypedField(3, new XON[0]);
        return retVal;
    }

    public XON[] getPd13_PatientPrimaryFacility() {
        XON[] retVal = (XON[])this.getTypedField(3, new XON[0]);
        return retVal;
    }

    public int getPatientPrimaryFacilityReps() {
        return this.getReps(3);
    }

    public XON getPatientPrimaryFacility(int rep) {
        XON retVal = (XON)this.getTypedField(3, rep);
        return retVal;
    }

    public XON getPd13_PatientPrimaryFacility(int rep) {
        XON retVal = (XON)this.getTypedField(3, rep);
        return retVal;
    }

    public int getPd13_PatientPrimaryFacilityReps() {
        return this.getReps(3);
    }

    public XON insertPatientPrimaryFacility(int rep) throws HL7Exception {
        return (XON)super.insertRepetition(3, rep);
    }

    public XON insertPd13_PatientPrimaryFacility(int rep) throws HL7Exception {
        return (XON)super.insertRepetition(3, rep);
    }

    public XON removePatientPrimaryFacility(int rep) throws HL7Exception {
        return (XON)super.removeRepetition(3, rep);
    }

    public XON removePd13_PatientPrimaryFacility(int rep) throws HL7Exception {
        return (XON)super.removeRepetition(3, rep);
    }

    public XCN[] getPatientPrimaryCareProviderNameIDNo() {
        XCN[] retVal = (XCN[])this.getTypedField(4, new XCN[0]);
        return retVal;
    }

    public XCN[] getPd14_PatientPrimaryCareProviderNameIDNo() {
        XCN[] retVal = (XCN[])this.getTypedField(4, new XCN[0]);
        return retVal;
    }

    public int getPatientPrimaryCareProviderNameIDNoReps() {
        return this.getReps(4);
    }

    public XCN getPatientPrimaryCareProviderNameIDNo(int rep) {
        XCN retVal = (XCN)this.getTypedField(4, rep);
        return retVal;
    }

    public XCN getPd14_PatientPrimaryCareProviderNameIDNo(int rep) {
        XCN retVal = (XCN)this.getTypedField(4, rep);
        return retVal;
    }

    public int getPd14_PatientPrimaryCareProviderNameIDNoReps() {
        return this.getReps(4);
    }

    public XCN insertPatientPrimaryCareProviderNameIDNo(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(4, rep);
    }

    public XCN insertPd14_PatientPrimaryCareProviderNameIDNo(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(4, rep);
    }

    public XCN removePatientPrimaryCareProviderNameIDNo(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(4, rep);
    }

    public XCN removePd14_PatientPrimaryCareProviderNameIDNo(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(4, rep);
    }

    public IS getStudentIndicator() {
        IS retVal = (IS)this.getTypedField(5, 0);
        return retVal;
    }

    public IS getPd15_StudentIndicator() {
        IS retVal = (IS)this.getTypedField(5, 0);
        return retVal;
    }

    public IS getHandicap() {
        IS retVal = (IS)this.getTypedField(6, 0);
        return retVal;
    }

    public IS getPd16_Handicap() {
        IS retVal = (IS)this.getTypedField(6, 0);
        return retVal;
    }

    public IS getLivingWillCode() {
        IS retVal = (IS)this.getTypedField(7, 0);
        return retVal;
    }

    public IS getPd17_LivingWillCode() {
        IS retVal = (IS)this.getTypedField(7, 0);
        return retVal;
    }

    public IS getOrganDonorCode() {
        IS retVal = (IS)this.getTypedField(8, 0);
        return retVal;
    }

    public IS getPd18_OrganDonorCode() {
        IS retVal = (IS)this.getTypedField(8, 0);
        return retVal;
    }

    public ID getSeparateBill() {
        ID retVal = (ID)this.getTypedField(9, 0);
        return retVal;
    }

    public ID getPd19_SeparateBill() {
        ID retVal = (ID)this.getTypedField(9, 0);
        return retVal;
    }

    public CX[] getDuplicatePatient() {
        CX[] retVal = (CX[])this.getTypedField(10, new CX[0]);
        return retVal;
    }

    public CX[] getPd110_DuplicatePatient() {
        CX[] retVal = (CX[])this.getTypedField(10, new CX[0]);
        return retVal;
    }

    public int getDuplicatePatientReps() {
        return this.getReps(10);
    }

    public CX getDuplicatePatient(int rep) {
        CX retVal = (CX)this.getTypedField(10, rep);
        return retVal;
    }

    public CX getPd110_DuplicatePatient(int rep) {
        CX retVal = (CX)this.getTypedField(10, rep);
        return retVal;
    }

    public int getPd110_DuplicatePatientReps() {
        return this.getReps(10);
    }

    public CX insertDuplicatePatient(int rep) throws HL7Exception {
        return (CX)super.insertRepetition(10, rep);
    }

    public CX insertPd110_DuplicatePatient(int rep) throws HL7Exception {
        return (CX)super.insertRepetition(10, rep);
    }

    public CX removeDuplicatePatient(int rep) throws HL7Exception {
        return (CX)super.removeRepetition(10, rep);
    }

    public CX removePd110_DuplicatePatient(int rep) throws HL7Exception {
        return (CX)super.removeRepetition(10, rep);
    }

    public CWE getPublicityCode() {
        CWE retVal = (CWE)this.getTypedField(11, 0);
        return retVal;
    }

    public CWE getPd111_PublicityCode() {
        CWE retVal = (CWE)this.getTypedField(11, 0);
        return retVal;
    }

    public ID getProtectionIndicator() {
        ID retVal = (ID)this.getTypedField(12, 0);
        return retVal;
    }

    public ID getPd112_ProtectionIndicator() {
        ID retVal = (ID)this.getTypedField(12, 0);
        return retVal;
    }

    public DT getProtectionIndicatorEffectiveDate() {
        DT retVal = (DT)this.getTypedField(13, 0);
        return retVal;
    }

    public DT getPd113_ProtectionIndicatorEffectiveDate() {
        DT retVal = (DT)this.getTypedField(13, 0);
        return retVal;
    }

    public XON[] getPlaceOfWorship() {
        XON[] retVal = (XON[])this.getTypedField(14, new XON[0]);
        return retVal;
    }

    public XON[] getPd114_PlaceOfWorship() {
        XON[] retVal = (XON[])this.getTypedField(14, new XON[0]);
        return retVal;
    }

    public int getPlaceOfWorshipReps() {
        return this.getReps(14);
    }

    public XON getPlaceOfWorship(int rep) {
        XON retVal = (XON)this.getTypedField(14, rep);
        return retVal;
    }

    public XON getPd114_PlaceOfWorship(int rep) {
        XON retVal = (XON)this.getTypedField(14, rep);
        return retVal;
    }

    public int getPd114_PlaceOfWorshipReps() {
        return this.getReps(14);
    }

    public XON insertPlaceOfWorship(int rep) throws HL7Exception {
        return (XON)super.insertRepetition(14, rep);
    }

    public XON insertPd114_PlaceOfWorship(int rep) throws HL7Exception {
        return (XON)super.insertRepetition(14, rep);
    }

    public XON removePlaceOfWorship(int rep) throws HL7Exception {
        return (XON)super.removeRepetition(14, rep);
    }

    public XON removePd114_PlaceOfWorship(int rep) throws HL7Exception {
        return (XON)super.removeRepetition(14, rep);
    }

    public CWE[] getAdvanceDirectiveCode() {
        CWE[] retVal = (CWE[])this.getTypedField(15, new CWE[0]);
        return retVal;
    }

    public CWE[] getPd115_AdvanceDirectiveCode() {
        CWE[] retVal = (CWE[])this.getTypedField(15, new CWE[0]);
        return retVal;
    }

    public int getAdvanceDirectiveCodeReps() {
        return this.getReps(15);
    }

    public CWE getAdvanceDirectiveCode(int rep) {
        CWE retVal = (CWE)this.getTypedField(15, rep);
        return retVal;
    }

    public CWE getPd115_AdvanceDirectiveCode(int rep) {
        CWE retVal = (CWE)this.getTypedField(15, rep);
        return retVal;
    }

    public int getPd115_AdvanceDirectiveCodeReps() {
        return this.getReps(15);
    }

    public CWE insertAdvanceDirectiveCode(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(15, rep);
    }

    public CWE insertPd115_AdvanceDirectiveCode(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(15, rep);
    }

    public CWE removeAdvanceDirectiveCode(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(15, rep);
    }

    public CWE removePd115_AdvanceDirectiveCode(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(15, rep);
    }

    public IS getImmunizationRegistryStatus() {
        IS retVal = (IS)this.getTypedField(16, 0);
        return retVal;
    }

    public IS getPd116_ImmunizationRegistryStatus() {
        IS retVal = (IS)this.getTypedField(16, 0);
        return retVal;
    }

    public DT getImmunizationRegistryStatusEffectiveDate() {
        DT retVal = (DT)this.getTypedField(17, 0);
        return retVal;
    }

    public DT getPd117_ImmunizationRegistryStatusEffectiveDate() {
        DT retVal = (DT)this.getTypedField(17, 0);
        return retVal;
    }

    public DT getPublicityCodeEffectiveDate() {
        DT retVal = (DT)this.getTypedField(18, 0);
        return retVal;
    }

    public DT getPd118_PublicityCodeEffectiveDate() {
        DT retVal = (DT)this.getTypedField(18, 0);
        return retVal;
    }

    public IS getMilitaryBranch() {
        IS retVal = (IS)this.getTypedField(19, 0);
        return retVal;
    }

    public IS getPd119_MilitaryBranch() {
        IS retVal = (IS)this.getTypedField(19, 0);
        return retVal;
    }

    public IS getMilitaryRankGrade() {
        IS retVal = (IS)this.getTypedField(20, 0);
        return retVal;
    }

    public IS getPd120_MilitaryRankGrade() {
        IS retVal = (IS)this.getTypedField(20, 0);
        return retVal;
    }

    public IS getMilitaryStatus() {
        IS retVal = (IS)this.getTypedField(21, 0);
        return retVal;
    }

    public IS getPd121_MilitaryStatus() {
        IS retVal = (IS)this.getTypedField(21, 0);
        return retVal;
    }

    public DT getAdvanceDirectiveLastVerifiedDate() {
        DT retVal = (DT)this.getTypedField(22, 0);
        return retVal;
    }

    public DT getPd122_AdvanceDirectiveLastVerifiedDate() {
        DT retVal = (DT)this.getTypedField(22, 0);
        return retVal;
    }

    @Override
    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new IS(this.getMessage(), new Integer(223));
            }
            case 1: {
                return new IS(this.getMessage(), new Integer(220));
            }
            case 2: {
                return new XON(this.getMessage());
            }
            case 3: {
                return new XCN(this.getMessage());
            }
            case 4: {
                return new IS(this.getMessage(), new Integer(231));
            }
            case 5: {
                return new IS(this.getMessage(), new Integer(295));
            }
            case 6: {
                return new IS(this.getMessage(), new Integer(315));
            }
            case 7: {
                return new IS(this.getMessage(), new Integer(316));
            }
            case 8: {
                return new ID(this.getMessage(), new Integer(136));
            }
            case 9: {
                return new CX(this.getMessage());
            }
            case 10: {
                return new CWE(this.getMessage());
            }
            case 11: {
                return new ID(this.getMessage(), new Integer(136));
            }
            case 12: {
                return new DT(this.getMessage());
            }
            case 13: {
                return new XON(this.getMessage());
            }
            case 14: {
                return new CWE(this.getMessage());
            }
            case 15: {
                return new IS(this.getMessage(), new Integer(441));
            }
            case 16: {
                return new DT(this.getMessage());
            }
            case 17: {
                return new DT(this.getMessage());
            }
            case 18: {
                return new IS(this.getMessage(), new Integer(140));
            }
            case 19: {
                return new IS(this.getMessage(), new Integer(141));
            }
            case 20: {
                return new IS(this.getMessage(), new Integer(142));
            }
            case 21: {
                return new DT(this.getMessage());
            }
        }
        return null;
    }
}

