/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v26.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.v26.group.OPU_R25_PATIENT;
import ca.uhn.hl7v2.model.v26.group.OPU_R25_SPECIMEN;
import ca.uhn.hl7v2.model.v26.segment.NK1;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class OPU_R25_ACCESSION_DETAIL
extends AbstractGroup {
    public OPU_R25_ACCESSION_DETAIL(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(NK1.class, true, true, false);
            this.add(OPU_R25_PATIENT.class, false, false, false);
            this.add(OPU_R25_SPECIMEN.class, true, true, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating OPU_R25_ACCESSION_DETAIL - this is probably a bug in the source code generator.", e);
        }
    }

    public String getVersion() {
        return "2.6";
    }

    public NK1 getNK1() {
        NK1 retVal = this.getTyped("NK1", NK1.class);
        return retVal;
    }

    public NK1 getNK1(int rep) {
        NK1 retVal = this.getTyped("NK1", rep, NK1.class);
        return retVal;
    }

    public int getNK1Reps() {
        return this.getReps("NK1");
    }

    public List<NK1> getNK1All() throws HL7Exception {
        return this.getAllAsList("NK1", NK1.class);
    }

    public void insertNK1(NK1 structure, int rep) throws HL7Exception {
        super.insertRepetition("NK1", structure, rep);
    }

    public NK1 insertNK1(int rep) throws HL7Exception {
        return (NK1)super.insertRepetition("NK1", rep);
    }

    public NK1 removeNK1(int rep) throws HL7Exception {
        return (NK1)super.removeRepetition("NK1", rep);
    }

    public OPU_R25_PATIENT getPATIENT() {
        OPU_R25_PATIENT retVal = this.getTyped("PATIENT", OPU_R25_PATIENT.class);
        return retVal;
    }

    public OPU_R25_SPECIMEN getSPECIMEN() {
        OPU_R25_SPECIMEN retVal = this.getTyped("SPECIMEN", OPU_R25_SPECIMEN.class);
        return retVal;
    }

    public OPU_R25_SPECIMEN getSPECIMEN(int rep) {
        OPU_R25_SPECIMEN retVal = this.getTyped("SPECIMEN", rep, OPU_R25_SPECIMEN.class);
        return retVal;
    }

    public int getSPECIMENReps() {
        return this.getReps("SPECIMEN");
    }

    public List<OPU_R25_SPECIMEN> getSPECIMENAll() throws HL7Exception {
        return this.getAllAsList("SPECIMEN", OPU_R25_SPECIMEN.class);
    }

    public void insertSPECIMEN(OPU_R25_SPECIMEN structure, int rep) throws HL7Exception {
        super.insertRepetition("SPECIMEN", structure, rep);
    }

    public OPU_R25_SPECIMEN insertSPECIMEN(int rep) throws HL7Exception {
        return (OPU_R25_SPECIMEN)super.insertRepetition("SPECIMEN", rep);
    }

    public OPU_R25_SPECIMEN removeSPECIMEN(int rep) throws HL7Exception {
        return (OPU_R25_SPECIMEN)super.removeRepetition("SPECIMEN", rep);
    }
}

