/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v22.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.v22.group.ADT_A07_INSURANCE;
import ca.uhn.hl7v2.model.v22.segment.ACC;
import ca.uhn.hl7v2.model.v22.segment.AL1;
import ca.uhn.hl7v2.model.v22.segment.DG1;
import ca.uhn.hl7v2.model.v22.segment.EVN;
import ca.uhn.hl7v2.model.v22.segment.GT1;
import ca.uhn.hl7v2.model.v22.segment.MRG;
import ca.uhn.hl7v2.model.v22.segment.MSH;
import ca.uhn.hl7v2.model.v22.segment.NK1;
import ca.uhn.hl7v2.model.v22.segment.OBX;
import ca.uhn.hl7v2.model.v22.segment.PID;
import ca.uhn.hl7v2.model.v22.segment.PR1;
import ca.uhn.hl7v2.model.v22.segment.PV1;
import ca.uhn.hl7v2.model.v22.segment.PV2;
import ca.uhn.hl7v2.model.v22.segment.UB1;
import ca.uhn.hl7v2.model.v22.segment.UB2;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class ADT_A07
extends AbstractMessage {
    public ADT_A07() {
        this(new DefaultModelClassFactory());
    }

    public ADT_A07(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(EVN.class, true, false);
            this.add(PID.class, true, false);
            this.add(MRG.class, false, false);
            this.add(NK1.class, false, true);
            this.add(PV1.class, true, false);
            this.add(PV2.class, false, false);
            this.add(OBX.class, false, true);
            this.add(AL1.class, false, true);
            this.add(DG1.class, false, true);
            this.add(PR1.class, false, true);
            this.add(GT1.class, false, true);
            this.add(ADT_A07_INSURANCE.class, false, true);
            this.add(ACC.class, false, false);
            this.add(UB1.class, false, false);
            this.add(UB2.class, false, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating ADT_A07 - this is probably a bug in the source code generator.", e);
        }
    }

    @Override
    public String getVersion() {
        return "2.2";
    }

    public MSH getMSH() {
        return this.getTyped("MSH", MSH.class);
    }

    public EVN getEVN() {
        return this.getTyped("EVN", EVN.class);
    }

    public PID getPID() {
        return this.getTyped("PID", PID.class);
    }

    public MRG getMRG() {
        return this.getTyped("MRG", MRG.class);
    }

    public NK1 getNK1() {
        return this.getTyped("NK1", NK1.class);
    }

    public NK1 getNK1(int rep) {
        return this.getTyped("NK1", rep, NK1.class);
    }

    public int getNK1Reps() {
        return this.getReps("NK1");
    }

    public List<NK1> getNK1All() throws HL7Exception {
        return this.getAllAsList("NK1", NK1.class);
    }

    public void insertNK1(NK1 structure, int rep) throws HL7Exception {
        super.insertRepetition("NK1", structure, rep);
    }

    public NK1 insertNK1(int rep) throws HL7Exception {
        return (NK1)super.insertRepetition("NK1", rep);
    }

    public NK1 removeNK1(int rep) throws HL7Exception {
        return (NK1)super.removeRepetition("NK1", rep);
    }

    public PV1 getPV1() {
        return this.getTyped("PV1", PV1.class);
    }

    public PV2 getPV2() {
        return this.getTyped("PV2", PV2.class);
    }

    public OBX getOBX() {
        return this.getTyped("OBX", OBX.class);
    }

    public OBX getOBX(int rep) {
        return this.getTyped("OBX", rep, OBX.class);
    }

    public int getOBXReps() {
        return this.getReps("OBX");
    }

    public List<OBX> getOBXAll() throws HL7Exception {
        return this.getAllAsList("OBX", OBX.class);
    }

    public void insertOBX(OBX structure, int rep) throws HL7Exception {
        super.insertRepetition("OBX", structure, rep);
    }

    public OBX insertOBX(int rep) throws HL7Exception {
        return (OBX)super.insertRepetition("OBX", rep);
    }

    public OBX removeOBX(int rep) throws HL7Exception {
        return (OBX)super.removeRepetition("OBX", rep);
    }

    public AL1 getAL1() {
        return this.getTyped("AL1", AL1.class);
    }

    public AL1 getAL1(int rep) {
        return this.getTyped("AL1", rep, AL1.class);
    }

    public int getAL1Reps() {
        return this.getReps("AL1");
    }

    public List<AL1> getAL1All() throws HL7Exception {
        return this.getAllAsList("AL1", AL1.class);
    }

    public void insertAL1(AL1 structure, int rep) throws HL7Exception {
        super.insertRepetition("AL1", structure, rep);
    }

    public AL1 insertAL1(int rep) throws HL7Exception {
        return (AL1)super.insertRepetition("AL1", rep);
    }

    public AL1 removeAL1(int rep) throws HL7Exception {
        return (AL1)super.removeRepetition("AL1", rep);
    }

    public DG1 getDG1() {
        return this.getTyped("DG1", DG1.class);
    }

    public DG1 getDG1(int rep) {
        return this.getTyped("DG1", rep, DG1.class);
    }

    public int getDG1Reps() {
        return this.getReps("DG1");
    }

    public List<DG1> getDG1All() throws HL7Exception {
        return this.getAllAsList("DG1", DG1.class);
    }

    public void insertDG1(DG1 structure, int rep) throws HL7Exception {
        super.insertRepetition("DG1", structure, rep);
    }

    public DG1 insertDG1(int rep) throws HL7Exception {
        return (DG1)super.insertRepetition("DG1", rep);
    }

    public DG1 removeDG1(int rep) throws HL7Exception {
        return (DG1)super.removeRepetition("DG1", rep);
    }

    public PR1 getPR1() {
        return this.getTyped("PR1", PR1.class);
    }

    public PR1 getPR1(int rep) {
        return this.getTyped("PR1", rep, PR1.class);
    }

    public int getPR1Reps() {
        return this.getReps("PR1");
    }

    public List<PR1> getPR1All() throws HL7Exception {
        return this.getAllAsList("PR1", PR1.class);
    }

    public void insertPR1(PR1 structure, int rep) throws HL7Exception {
        super.insertRepetition("PR1", structure, rep);
    }

    public PR1 insertPR1(int rep) throws HL7Exception {
        return (PR1)super.insertRepetition("PR1", rep);
    }

    public PR1 removePR1(int rep) throws HL7Exception {
        return (PR1)super.removeRepetition("PR1", rep);
    }

    public GT1 getGT1() {
        return this.getTyped("GT1", GT1.class);
    }

    public GT1 getGT1(int rep) {
        return this.getTyped("GT1", rep, GT1.class);
    }

    public int getGT1Reps() {
        return this.getReps("GT1");
    }

    public List<GT1> getGT1All() throws HL7Exception {
        return this.getAllAsList("GT1", GT1.class);
    }

    public void insertGT1(GT1 structure, int rep) throws HL7Exception {
        super.insertRepetition("GT1", structure, rep);
    }

    public GT1 insertGT1(int rep) throws HL7Exception {
        return (GT1)super.insertRepetition("GT1", rep);
    }

    public GT1 removeGT1(int rep) throws HL7Exception {
        return (GT1)super.removeRepetition("GT1", rep);
    }

    public ADT_A07_INSURANCE getINSURANCE() {
        return this.getTyped("INSURANCE", ADT_A07_INSURANCE.class);
    }

    public ADT_A07_INSURANCE getINSURANCE(int rep) {
        return this.getTyped("INSURANCE", rep, ADT_A07_INSURANCE.class);
    }

    public int getINSURANCEReps() {
        return this.getReps("INSURANCE");
    }

    public List<ADT_A07_INSURANCE> getINSURANCEAll() throws HL7Exception {
        return this.getAllAsList("INSURANCE", ADT_A07_INSURANCE.class);
    }

    public void insertINSURANCE(ADT_A07_INSURANCE structure, int rep) throws HL7Exception {
        super.insertRepetition("INSURANCE", structure, rep);
    }

    public ADT_A07_INSURANCE insertINSURANCE(int rep) throws HL7Exception {
        return (ADT_A07_INSURANCE)super.insertRepetition("INSURANCE", rep);
    }

    public ADT_A07_INSURANCE removeINSURANCE(int rep) throws HL7Exception {
        return (ADT_A07_INSURANCE)super.removeRepetition("INSURANCE", rep);
    }

    public ACC getACC() {
        return this.getTyped("ACC", ACC.class);
    }

    public UB1 getUB1() {
        return this.getTyped("UB1", UB1.class);
    }

    public UB2 getUB2() {
        return this.getTyped("UB2", UB2.class);
    }
}

