/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.util1.image;

public class ImageUtil {
    public static boolean isPng(byte[] data) {
        byte[] key = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
        return ImageUtil.startWithKey(key, data);
    }

    public static boolean isJpeg(byte[] data) {
        byte[] key = ImageUtil.hexToBytes(new char[]{'\u00ff', '\u00d8'});
        return ImageUtil.startWithKey(key, data);
    }

    private static byte[] hexToBytes(char[] hex) {
        int length = hex.length / 2;
        byte[] raw = new byte[length];
        for (int i = 0; i < length; ++i) {
            int low;
            int high = Character.digit(hex[i * 2], 16);
            int value = high << 4 | (low = Character.digit(hex[i * 2 + 1], 16));
            if (value > 127) {
                value -= 256;
            }
            raw[i] = (byte)value;
        }
        return raw;
    }

    public static boolean isTiff(byte[] data) {
        boolean b = ImageUtil.startWithKey("II".getBytes(), data);
        if (b && data.length >= 4) {
            return data[2] == 4 && data[3] == 2;
        }
        return false;
    }

    public static boolean isGif(byte[] data) {
        return ImageUtil.startWithKey("GIF".getBytes(), data);
    }

    private static boolean startWithKey(byte[] key, byte[] data) {
        for (int i = 0; i < data.length && i < key.length; ++i) {
            if (key[i] != data[i]) {
                return false;
            }
            if (i != key.length - 1) continue;
            return true;
        }
        return false;
    }
}

