/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.util1.config;

import ca.infodata.util1.StringUtils;
import ca.infodata.util1.config.ConfigKey;
import java.util.logging.Logger;
import org.apache.commons.lang.math.NumberUtils;

public class IntegerConfigKey
extends ConfigKey<Integer> {
    private static final Logger logger = Logger.getLogger(IntegerConfigKey.class.getName());

    public IntegerConfigKey(String ... keys) {
        super(keys);
    }

    public IntegerConfigKey setDefaultValue(Integer value) {
        return (IntegerConfigKey)super.setDefaultValue(value);
    }

    @Override
    protected Integer convertFoundValueToT(Object value) {
        if (value == null) {
            return (Integer)this.getDefaultValue();
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        if (value instanceof String) {
            String s = (String)value;
            if (StringUtils.isBlank(s)) {
                return (Integer)this.getDefaultValue();
            }
            if (NumberUtils.isNumber(s)) {
                return Integer.parseInt(s);
            }
        }
        logger.severe("invalid value type for property with key " + this + ". expected integer type but was " + value.getClass().getName() + ". using default value. " + this.getDefaultValue());
        return (Integer)this.getDefaultValue();
    }
}

