/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.readhl7.tools;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.ga.log.ro.DebugLevel;
import org.ga.log.ro.SimpleLogger;

public class Utils {
    protected static SimpleLogger log = new SimpleLogger(Utils.class);
    static String expression2Numeric = "[0-9]{1,4}";
    static Pattern pattern2Numeric = Pattern.compile(expression2Numeric);
    static long MILLISECOND_PER_DAY = 86400000L;
    static Pattern aPattern = Pattern.compile("[\u00c0\u00c2]");
    static Pattern ePattern = Pattern.compile("[\u00c9\u00c8\u00ca\u00cb]");
    static Pattern iPattern = Pattern.compile("[\u00ce\u00cf]");
    static Pattern oPattern = Pattern.compile("[\u00d4\u00d6]");
    static Pattern uPattern = Pattern.compile("[\u00d9\u00db]");
    static Pattern cPattern = Pattern.compile("[\u00c7]");
    static final Map<String, String> mapCode = new HashMap<String, String>(100);
    static final Map<String, String> mapCode2 = new HashMap<String, String>(20);
    static final String[] specChar;
    static final String[] htmlChar;
    static final String[] utf8Char;
    static final Map<String, String> mapSpCode;
    static final String[] specSpChar;
    static final String[] htmlSpChar;
    static final String[] utf8SpChar;

    public Utils() {
        log.setDebugLevel(DebugLevel.L4_INFO);
    }

    public boolean doProcess(String[] processToExecute, String pswd) {
        log.entry("doProcess");
        boolean ok = true;
        try {
            ArrayList<String> cmds = new ArrayList<String>();
            for (String element : processToExecute) {
                cmds.add(element);
            }
            ProcessBuilder builder = new ProcessBuilder(cmds);
            Process proc = builder.start();
            log.debugObject("proc", proc);
            StreamGobbler errorGobbler = new StreamGobbler(proc.getErrorStream(), "");
            StreamGobbler outputGobbler = new StreamGobbler(proc.getInputStream(), "OUTPUT");
            errorGobbler.start();
            outputGobbler.start();
            int exitVal = proc.waitFor();
            if (exitVal == 0) {
                log.info("");
                log.info(" PROCESS ENDED WITH NO ERROR.");
                log.info("");
            } else {
                log.info("");
                log.info("* * * ERROR * * *");
                log.info("");
                log.error("* * * PROCESS ENDED WITH AN ERROR * * *");
                log.error("* * * Value returned by the process: " + exitVal);
                log.info("");
                ok = false;
            }
        }
        catch (Exception e) {
            log.info("");
            log.error("* * * PROCESS ENDED WITH AN ERROR * * *");
            log.error("* * * " + (e.getMessage() == null ? "NO ERROR MESSAGE..." : e.getMessage()) + (e.getCause() == null ? "" : " CAUSE: " + e.getCause().getMessage()));
            log.info("");
            ok = false;
        }
        return ok;
    }

    public static String ttoc(long l, boolean withSeparator) {
        String s = "";
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(l);
        s = new StringBuffer(10).append(String.valueOf(c.get(1))).append(withSeparator ? "/" : "").append(Utils.padL(c.get(2) + 1, 2)).append(withSeparator ? "/" : "").append(Utils.padL(c.get(5), 2)).append(withSeparator ? ": " : "").append(Utils.padL(c.get(11), 2)).append(withSeparator ? "H" : "").append(Utils.padL(c.get(12), 2)).toString();
        return s;
    }

    public static String dtos(Calendar c) {
        String s = "";
        if (c != null) {
            s = String.valueOf(c.get(1)) + Utils.padL(c.get(2) + 1, 2) + Utils.padL(c.get(5), 2);
        }
        return s;
    }

    public static String padL(int numberToPad, int toLength) {
        String stringToPad = "" + numberToPad;
        if (stringToPad.length() < toLength) {
            stringToPad = "0" + stringToPad;
        }
        return stringToPad;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties getPropertiesFromFile(File f) {
        log.entry("getPropertiesFromFile");
        Properties prop = new Properties();
        if (f.exists()) {
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(f);
                prop.load(fis);
            }
            catch (FileNotFoundException e) {
                log.fatalException(e);
            }
            catch (IOException e) {
                log.fatalException(e);
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        return prop;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setPropertiesToFile(File propFile, Properties props) {
        log.entry("setPropertiesToFile");
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(propFile);
            props.store(fos, "");
            fos.close();
        }
        catch (IOException e1) {
            log.errorException(e1);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static String fileToStr(String s) {
        StringBuffer buf = new StringBuffer();
        FileReader in = null;
        try {
            in = new FileReader(s);
            int i = ((Reader)in).read();
            while (i > -1) {
                char c = (char)i;
                buf.append(c);
                i = ((Reader)in).read();
            }
            ((Reader)in).close();
        }
        catch (FileNotFoundException fileProblem) {
            try {
                ((Reader)in).close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            System.err.println("File not found");
            return null;
        }
        catch (IOException ioProblem) {
            try {
                ((Reader)in).close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }
        return buf.toString();
    }

    public static boolean deleteDirectory(File path, boolean keepdir) {
        boolean result = true;
        if (path.exists()) {
            File[] files = path.listFiles();
            if (files != null) {
                for (File element : files) {
                    if (element.isDirectory()) {
                        Utils.deleteDirectory(element, keepdir);
                        continue;
                    }
                    element.delete();
                }
            }
            if ((result = path.delete()) && keepdir) {
                result = path.mkdir();
            }
        }
        return result;
    }

    public static boolean copyDirectory(File srcPath, File dstPath) {
        int err = 0;
        boolean ok = false;
        if (srcPath.isDirectory()) {
            String[] files;
            if (!dstPath.exists()) {
                dstPath.mkdir();
            }
            for (String file : files = srcPath.list()) {
                ok = Utils.copyDirectory(new File(srcPath, file), new File(dstPath, file));
                if (ok) continue;
                ++err;
            }
        } else {
            ok = Utils.copy(srcPath, dstPath);
            if (!ok) {
                ++err;
            }
        }
        return ok && err == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copy(File srcFile, File destFile) {
        boolean ok = false;
        FileChannel srcChannel = null;
        AbstractInterruptibleChannel destChannel = null;
        try {
            srcChannel = new FileInputStream(srcFile).getChannel();
            destChannel = new FileOutputStream(destFile).getChannel();
            ((FileChannel)destChannel).transferFrom(srcChannel, 0L, srcChannel.size());
            ok = true;
        }
        catch (IOException e) {
            log.fatalException(e);
        }
        finally {
            if (srcChannel != null) {
                try {
                    srcChannel.close();
                }
                catch (IOException ex) {
                    log.fatalException(ex);
                }
            }
            if (destChannel != null) {
                try {
                    destChannel.close();
                }
                catch (IOException ex) {
                    log.fatalException(ex);
                }
            }
        }
        return ok;
    }

    public static boolean uncompress(File zipname, String pathToUnzipTo) {
        boolean ok = false;
        try {
            ZipFile zipFile = new ZipFile(zipname);
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                int size;
                ZipEntry zipEntry = enumeration.nextElement();
                System.out.println("Unzipping: " + zipEntry.getName());
                BufferedInputStream bis = new BufferedInputStream(zipFile.getInputStream(zipEntry));
                byte[] buffer = new byte[2048];
                FileOutputStream fos = new FileOutputStream(pathToUnzipTo + "/" + zipEntry.getName());
                BufferedOutputStream bos = new BufferedOutputStream(fos, buffer.length);
                while ((size = bis.read(buffer, 0, buffer.length)) != -1) {
                    bos.write(buffer, 0, size);
                }
                bos.flush();
                bos.close();
                fos.close();
                bis.close();
            }
            zipFile.close();
            ok = true;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return ok;
    }

    public static void zipToStore(String dir, String fileExt, String zipfile) throws IOException, IllegalArgumentException {
        File d = new File(dir);
        if (!d.isDirectory()) {
            throw new IllegalArgumentException("Not a directory:  " + dir);
        }
        File theZipFile = new File(zipfile);
        if (theZipFile.exists()) {
            Calendar now = Calendar.getInstance();
            String path = theZipFile.getParent();
            String name = theZipFile.getName().substring(0, theZipFile.getName().indexOf(".zip"));
            theZipFile.renameTo(new File(path + "/" + name + Utils.ttoc(now.getTimeInMillis(), false) + ".zip"));
        }
        FileFilter filter7z = new FileFilter(fileExt);
        String[] entries = d.list(filter7z);
        byte[] buffer = new byte[4096];
        ZipOutputStream out = new ZipOutputStream(new FileOutputStream(zipfile));
        out.setLevel(0);
        for (String entrie : entries) {
            int bytesRead;
            File f = new File(d, entrie);
            if (f.isDirectory()) continue;
            FileInputStream in = new FileInputStream(f);
            ZipEntry entry = new ZipEntry(f.getPath());
            out.putNextEntry(entry);
            while ((bytesRead = in.read(buffer)) != -1) {
                out.write(buffer, 0, bytesRead);
            }
            in.close();
        }
        out.close();
    }

    public static void zipToStore(String[] entries, String zipfile) throws IOException, IllegalArgumentException {
        File theZipFile = new File(zipfile);
        if (theZipFile.exists()) {
            Calendar now = Calendar.getInstance();
            String path = theZipFile.getParent();
            String name = theZipFile.getName().substring(0, theZipFile.getName().indexOf(".zip"));
            theZipFile.renameTo(new File(path + "/" + name + Utils.ttoc(now.getTimeInMillis(), false) + ".zip"));
        }
        File d = theZipFile.getParentFile();
        byte[] buffer = new byte[4096];
        ZipOutputStream out = new ZipOutputStream(new FileOutputStream(zipfile));
        out.setLevel(0);
        for (String entrie : entries) {
            int bytesRead;
            File f = new File(d, entrie);
            if (f.isDirectory()) continue;
            FileInputStream in = new FileInputStream(f);
            ZipEntry entry = new ZipEntry(f.getPath());
            out.putNextEntry(entry);
            while ((bytesRead = in.read(buffer)) != -1) {
                out.write(buffer, 0, bytesRead);
            }
            in.close();
        }
        out.close();
    }

    public static boolean isMinute(String no) {
        String inputStr = no;
        Matcher matcher = pattern2Numeric.matcher(inputStr);
        return matcher.matches();
    }

    public static String removeAccent(String s) {
        try {
            s = aPattern.matcher(s).replaceAll("A");
            s = ePattern.matcher(s).replaceAll("E");
            s = iPattern.matcher(s).replaceAll("I");
            s = oPattern.matcher(s).replaceAll("O");
            s = uPattern.matcher(s).replaceAll("U");
            s = cPattern.matcher(s).replaceAll("C");
        }
        catch (Exception e) {
            s = "";
        }
        return s;
    }

    public static String toUpperRemoveAccent(String s) {
        try {
            s = s.toUpperCase();
        }
        catch (Exception e) {
            s = "";
        }
        s = Utils.removeAccent(s);
        return s;
    }

    public static int getJrAbsent() {
        Calendar today = Calendar.getInstance();
        int todayI = today.get(7);
        int noJr = 1;
        if (todayI == 6) {
            noJr = 3;
        } else if (todayI == 7) {
            noJr = 2;
        }
        return noJr;
    }

    public static int getJrOnCall() {
        Calendar today = Calendar.getInstance();
        int todayI = today.get(7);
        int noJr = 1;
        if (todayI == 6) {
            noJr = 3;
        } else if (todayI == 7) {
            noJr = 2;
        }
        return noJr;
    }

    public static long getDaysFrom1970(Calendar myCalendar) {
        if (myCalendar == null) {
            myCalendar = Calendar.getInstance();
        }
        myCalendar.set(11, 0);
        myCalendar.set(12, 0);
        myCalendar.set(13, 0);
        myCalendar.set(14, 0);
        long t = myCalendar.getTimeInMillis();
        return Utils.fromTimeInMillis(t);
    }

    public static int fromTimeInMillis(long timeInMillis) {
        long t = timeInMillis > Integer.MAX_VALUE ? timeInMillis / MILLISECOND_PER_DAY : timeInMillis;
        return (int)t;
    }

    public static String replaceCharToHtmlChar(String s) {
        return StringUtils.replaceEach(s, specChar, htmlChar);
    }

    public static String replaceSpaceToThinHtmlChar(String s) {
        return StringUtils.replaceEach(s, specSpChar, htmlSpChar);
    }

    public static String replaceCharToEncodedChar(String s) {
        return StringUtils.replaceEach(s, specChar, utf8Char);
    }

    private static String getUnicodeCharacterOfChar(char ch) {
        return String.format("\\u%04x", ch);
    }

    public static String decodeBase64(String encodedBytes) {
        try {
            byte[] decodedBytes = Base64.decodeBase64(encodedBytes);
            String result = new String(decodedBytes, "ISO-8859-1");
            return result;
        }
        catch (UnsupportedEncodingException ex) {
            Logger.getLogger(Utils.class.getName()).log(Level.SEVERE, null, ex);
            return "";
        }
    }

    public static File savePdfFile(String folder, String nameFile, String pdfData) {
        boolean ok = false;
        try {
            FileUtils.forceMkdir(new File(folder));
            ok = true;
        }
        catch (IOException e) {
            Logger.getLogger(Utils.class.getName()).log(Level.SEVERE, null, e);
        }
        if (ok) {
            String decodedString;
            File file = new File(folder + "/" + nameFile);
            if (!file.exists() && !(decodedString = Utils.decodeBase64(pdfData)).isEmpty()) {
                ok = false;
                try {
                    FileUtils.writeByteArrayToFile(file, decodedString.getBytes("ISO-8859-1"));
                    ok = true;
                }
                catch (IOException ex) {
                    Logger.getLogger(Utils.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            return file;
        }
        return null;
    }

    static {
        mapCode.put("<", "&lt;");
        mapCode.put("\u2264", "&le;");
        mapCode.put(">", "&gt;");
        mapCode.put("\u2265", "&ge;");
        mapCode.put("\u2260", "&ne;");
        mapCode.put(" ", "&nbsp;");
        mapCode.put("\u00a1", "&iexcl;");
        mapCode.put("\u00a2", "&cent;");
        mapCode.put("\u00a3", "&pound;");
        mapCode.put("\u00a4", "&curren;");
        mapCode.put("\u00a5", "&yen;");
        mapCode.put("\u00a6", "&brvbar;");
        mapCode.put("\u00a7", "&sect;");
        mapCode.put("\u00a8", "&uml;");
        mapCode.put("\u00a9", "&copy;");
        mapCode.put("\u00aa", "&ordf;");
        mapCode.put("\u00ab", "&laquo;");
        mapCode.put("\u00ac", "&not;");
        mapCode.put("\u00ae", "&reg;");
        mapCode.put("\u00af", "&macr;");
        mapCode.put("\u00b0", "&deg;");
        mapCode.put("\u00b1", "&plusmn;");
        mapCode.put("\u00b2", "&sup2;");
        mapCode.put("\u00b3", "&sup3;");
        mapCode.put("\u00b4", "&acute;");
        mapCode.put("\u00b5", "&micro;");
        mapCode.put("\u00b6", "&para;");
        mapCode.put("\u00b7", "&middot;");
        mapCode.put("\u00b8", "&cedil;");
        mapCode.put("\u00b9", "&sup1;");
        mapCode.put("\u00ba", "&ordm;");
        mapCode.put("\u00bb", "&raquo;");
        mapCode.put("\u00bc", "&frac14;");
        mapCode.put("\u00bd", "&frac12;");
        mapCode.put("\u00be", "&frac34;");
        mapCode.put("\u00bf", "&iquest;");
        mapCode.put("\u00c0", "&Agrave;");
        mapCode.put("\u00c1", "&Aacute;");
        mapCode.put("\u00c2", "&Acirc;");
        mapCode.put("\u00c3", "&Atilde;");
        mapCode.put("\u00c4", "&Auml;");
        mapCode.put("\u00c5", "&Aring;");
        mapCode.put("\u00c6", "&AElig;");
        mapCode.put("\u00c7", "&Ccedil;");
        mapCode.put("\u00c8", "&Egrave;");
        mapCode.put("\u00c9", "&Eacute;");
        mapCode.put("\u00ca", "&Ecirc;");
        mapCode.put("\u00cb", "&Euml;");
        mapCode.put("\u00cc", "&Igrave;");
        mapCode.put("\u00cd", "&Iacute;");
        mapCode.put("\u00ce", "&Icirc;");
        mapCode.put("\u00cf", "&Iuml;");
        mapCode.put("\u00d0", "&ETH;");
        mapCode.put("\u00d1", "&Ntilde;");
        mapCode.put("\u00d2", "&Ograve;");
        mapCode.put("\u00d3", "&Oacute;");
        mapCode.put("\u00d4", "&Ocirc;");
        mapCode.put("\u00d5", "&Otilde;");
        mapCode.put("\u00d6", "&Ouml;");
        mapCode.put("\u00d7", "&times;");
        mapCode.put("\u00d8", "&Oslash;");
        mapCode.put("\u00d9", "&Ugrave;");
        mapCode.put("\u00da", "&Uacute;");
        mapCode.put("\u00db", "&Ucirc;");
        mapCode.put("\u00dc", "&Uuml;");
        mapCode.put("\u00dd", "&Yacute;");
        mapCode.put("\u00de", "&THORN;");
        mapCode.put("\u00df", "&szlig;");
        mapCode.put("\u00e0", "&agrave;");
        mapCode.put("\u00e1", "&aacute;");
        mapCode.put("\u00e2", "&acirc;");
        mapCode.put("\u00e3", "&atilde;");
        mapCode.put("\u00e4", "&auml;");
        mapCode.put("\u00e5", "&aring;");
        mapCode.put("\u00e6", "&aelig;");
        mapCode.put("\u00e7", "&ccedil;");
        mapCode.put("\u00e8", "&egrave;");
        mapCode.put("\u00e9", "&eacute;");
        mapCode.put("\u00ea", "&ecirc;");
        mapCode.put("\u00eb", "&euml;");
        mapCode.put("\u00ec", "&igrave;");
        mapCode.put("\u00ed", "&iacute;");
        mapCode.put("\u00ee", "&icirc;");
        mapCode.put("\u00ef", "&iuml;");
        mapCode.put("\u00f0", "&eth;");
        mapCode.put("\u00f1", "&ntilde;");
        mapCode.put("\u00f2", "&ograve;");
        mapCode.put("\u00f3", "&oacute;");
        mapCode.put("\u00f4", "&ocirc;");
        mapCode.put("\u00f5", "&otilde;");
        mapCode.put("\u00f6", "&ouml;");
        mapCode.put("\u00f7", "&divide;");
        mapCode.put("\u00f8", "&oslash;");
        mapCode.put("\u00f9", "&ugrave;");
        mapCode.put("\u00fa", "&uacute;");
        mapCode.put("\u00fb", "&ucirc;");
        mapCode.put("\u00fc", "&uuml;");
        mapCode.put("\u00fd", "&yacute;");
        mapCode.put("\u00fe", "&thorn;");
        mapCode.put("\u00ff", "&yuml;");
        specChar = new String[mapCode.size()];
        htmlChar = new String[mapCode.size()];
        utf8Char = new String[mapCode.size()];
        int i = 0;
        for (Map.Entry<String, String> codes : mapCode.entrySet()) {
            Utils.specChar[i] = codes.getKey();
            Utils.htmlChar[i] = codes.getValue();
            Utils.utf8Char[i] = Utils.getUnicodeCharacterOfChar(codes.getKey().charAt(0));
            ++i;
        }
        mapSpCode = new HashMap<String, String>(100);
        mapSpCode.put(" ", "&#8196;");
        specSpChar = new String[mapCode.size()];
        htmlSpChar = new String[mapCode.size()];
        utf8SpChar = new String[mapCode.size()];
        i = 0;
        for (Map.Entry<String, String> codes : mapSpCode.entrySet()) {
            Utils.specSpChar[i] = codes.getKey();
            Utils.htmlSpChar[i] = codes.getValue();
            Utils.utf8SpChar[i] = Utils.getUnicodeCharacterOfChar(codes.getKey().charAt(0));
            ++i;
        }
    }

    static class FileFilter
    implements FilenameFilter {
        String ext = "";

        public FileFilter(String s) {
            this.ext = s;
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.endsWith(this.ext);
        }
    }

    private static class StreamGobbler
    extends Thread {
        InputStream is;
        String type;

        StreamGobbler(InputStream is, String type) {
            this.is = is;
            this.type = type;
        }

        @Override
        public void run() {
            log.entry("StreamGobbler.run");
            try {
                InputStreamReader isr = new InputStreamReader(this.is);
                BufferedReader br = new BufferedReader(isr);
                String line = null;
                while ((line = br.readLine()) != null) {
                    log.info(this.type + ">" + line);
                }
            }
            catch (IOException ioe) {
                log.fatalException(ioe);
            }
        }
    }
}

