/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.readhl7;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class OscarProperties
extends Properties {
    private static Logger logger = Logger.getLogger(OscarProperties.class.getName());
    private static final long serialVersionUID = -5965807410049845132L;
    private static OscarProperties oscarProperties = new OscarProperties();
    private static boolean loaded = false;
    private static final Set<String> activeMarkers = new HashSet<String>(Arrays.asList("true", "yes", "on"));

    public static OscarProperties getInstance() {
        return oscarProperties;
    }

    private static void readFromFile(String url, Properties p) throws IOException {
        InputStream is = OscarProperties.class.getResourceAsStream(url);
        if (is == null) {
            is = new FileInputStream(url);
        }
        try {
            p.load(is);
        }
        finally {
            is.close();
        }
    }

    private OscarProperties() {
        logger.log(Level.FINE, "OSCAR PROPS CONSTRUCTOR");
    }

    public boolean hasProperty(String key) {
        boolean prop = false;
        String propertyValue = this.getProperty(key);
        if (propertyValue != null) {
            prop = true;
        }
        return prop;
    }

    public boolean getBooleanProperty(String key, String val) {
        if (val != null && activeMarkers.contains(val.toLowerCase())) {
            return this.isPropertyActive(key);
        }
        return this.getProperty(key, "").equalsIgnoreCase(val);
    }

    public boolean isPropertyActive(String key) {
        return activeMarkers.contains(this.getProperty(key, "").toLowerCase());
    }

    public void loader(InputStream propertyStream) {
        if (!loaded) {
            try {
                this.load(propertyStream);
                propertyStream.close();
                loaded = true;
            }
            catch (IOException ex) {
                logger.log(Level.SEVERE, "IO Error: ", ex);
            }
        }
    }

    public void loader(String propFileName) throws FileNotFoundException {
        if (!loaded) {
            FileInputStream fis2 = new FileInputStream(propFileName);
            try {
                this.load(fis2);
                fis2.close();
                loaded = true;
            }
            catch (IOException ex) {
                logger.log(Level.SEVERE, "IO Error: ", ex);
            }
        }
    }

    public Date getStartTime() {
        String str = this.getProperty("OSCAR_START_TIME");
        Date ret = null;
        try {
            ret = new Date(Long.parseLong(str));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }

    public boolean isTorontoRFQ() {
        return this.isPropertyActive("TORONTO_RFQ");
    }

    public boolean isProviderNoAuto() {
        return this.isPropertyActive("AUTO_GENERATE_PROVIDER_NO");
    }

    public boolean isPINEncripted() {
        return this.isPropertyActive("IS_PIN_ENCRYPTED");
    }

    public boolean isSiteSecured() {
        return this.isPropertyActive("security_site_control");
    }

    public boolean isAdminOptionOn() {
        return this.isPropertyActive("with_admin_option");
    }

    public boolean isLogAccessClient() {
        return this.isPropertyActive("log_accesses_of_client");
    }

    public boolean isLogAccessProgram() {
        return this.isPropertyActive("log_accesses_of_program");
    }

    public boolean isAccountLockingEnabled() {
        return this.isPropertyActive("ENABLE_ACCOUNT_LOCKING");
    }

    public boolean isCaisiLoaded() {
        return this.isPropertyActive("caisi");
    }

    public String getDbType() {
        return this.getProperty("db_type");
    }

    public String getDbUserName() {
        return this.getProperty("db_username");
    }

    public String getDbPassword() {
        return this.getProperty("db_password");
    }

    public String getDbUri() {
        return this.getProperty("db_uri");
    }

    public String getDbDriver() {
        return this.getProperty("db_driver");
    }

    public String getBuildDate() {
        return this.getProperty("builddate");
    }

    public boolean isOscarLearning() {
        return this.isPropertyActive("OSCAR_LEARNING");
    }

    static {
        try {
            OscarProperties.readFromFile("/oscar_mcmaster.properties", oscarProperties);
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Error", e);
        }
    }
}

