/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.readhl7;

import ca.infodata.readhl7.LaboHtmlFormatter;
import ca.infodata.readhl7.MessageHandler;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Calendar;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.apache.commons.lang.time.FastDateFormat;
import org.ga.log.ro.DebugLevel;
import org.ga.log.ro.SimpleLogger;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import parser.DefaultGenericHandler;

public class Doit {
    public static boolean HIDE_NAME = "true".equalsIgnoreCase(System.getenv("hidename"));
    protected static SimpleLogger log = new SimpleLogger(Doit.class);
    public static DebugLevel LOG_LEVEL = DebugLevel.L2_ERROR;
    Pattern aPattern;
    Pattern ePattern;
    Pattern iPattern;
    Pattern oPattern;
    Pattern uPattern;
    Pattern cPattern;
    List<Exception> errorMsgs;
    List<Exception> warningMsgs;
    List<Exception> infoMsgs;
    protected static final String SESSION = "!SESSION";
    protected static final String MESSAGE = "!MESSAGE";
    protected static final String STACK = "!STACK";
    protected static final String LINE_SEPARATOR;
    protected static final String TAB_STRING = "\t";

    public Doit() {
        log.setDebugLevel(DebugLevel.L6_VERBOSE);
        this.aPattern = Pattern.compile("[\u00c0\u00c2\u00c4]");
        this.ePattern = Pattern.compile("[\u00c9\u00c8\u00ca\u00cb]");
        this.iPattern = Pattern.compile("[\u00ce\u00cf\u00cc]");
        this.oPattern = Pattern.compile("[\u00d4\u00d6\u00d2]");
        this.uPattern = Pattern.compile("[\u00db\u00d9\u00dc]");
        this.cPattern = Pattern.compile("[\u00c7]");
    }

    public int getOrderStatusFromHl7(String hl7Text) {
        int status = 0;
        String r = "";
        if (hl7Text != null && hl7Text.length() > 0) {
            int idxPid;
            if (hl7Text.startsWith("MSH")) {
                r = hl7Text;
            }
            if ((idxPid = r.indexOf("PID")) < 0) {
                return status;
            }
            String l1 = r.substring(0, idxPid);
            String lab_type = "";
            if (l1.indexOf("|ORU^R0") > 0) {
                lab_type = "ORU_R01";
            } else if (l1.indexOf("|OUL^R|") > 0) {
                lab_type = "OUL_R21";
            } else if (l1.indexOf("|OUL^R") > 0) {
                lab_type = "OUL_R21";
            }
            if (lab_type.isEmpty()) {
                return status;
            }
            MessageHandler handler = Doit.getHandler(lab_type, hl7Text);
            if (handler != null) {
                String os = handler.getOrderStatus();
                if ("F".equals(os)) {
                    status = 10;
                } else if ("C".equals(os)) {
                    status = 8;
                } else if ("P".equals(os)) {
                    status = 6;
                }
            }
        }
        return status;
    }

    public String getHtmlFromHl7(String hl7Text) {
        return this.getHtmlFromHl7(hl7Text, null);
    }

    public String getHtmlFromHl7(String hl7Text, String fileName) {
        String r = "";
        if (hl7Text != null && hl7Text.length() > 0) {
            int idxPid;
            if (hl7Text.startsWith("MSH")) {
                StringWriter stringWriter = new StringWriter();
                BufferedReader reader = new BufferedReader(new StringReader(hl7Text));
                BufferedWriter writer = new BufferedWriter(stringWriter);
                String lineToRemove = "NTE|";
                try {
                    String currentLine;
                    int l = 0;
                    while ((currentLine = reader.readLine()) != null) {
                        String trimmedLine = currentLine.trim();
                        if (++l < 5 && trimmedLine.startsWith(lineToRemove)) continue;
                        writer.write(currentLine + "\r\n");
                    }
                    writer.close();
                    reader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                r = stringWriter.toString();
            }
            if ((idxPid = r.indexOf("PID")) < 0) {
                return r;
            }
            String l1 = r.substring(0, idxPid);
            String lab_type = "";
            String lab_version = "2.6";
            if (l1.indexOf("|ORU^R0") > 0) {
                lab_type = "ORU_R01";
            } else if (l1.indexOf("|OUL^R|") > 0) {
                lab_type = "OUL_R21";
            } else if (l1.indexOf("|OUL^R") > 0) {
                lab_type = "OUL_R21";
            }
            if (lab_type.isEmpty()) {
                return "";
            }
            MessageHandler handler = Doit.getHandler(lab_type + "v" + lab_version, r);
            if (handler != null) {
                LaboHtmlFormatter labo = new LaboHtmlFormatter(handler, fileName);
                return labo.getHtml();
            }
        }
        return r;
    }

    public MessageHandler getHandler(String hl7Text) {
        MessageHandler ret = null;
        if (hl7Text != null && hl7Text.length() > 0) {
            int idxPid;
            String r = "";
            if (hl7Text.startsWith("MSH")) {
                StringWriter stringWriter = new StringWriter();
                BufferedReader reader = new BufferedReader(new StringReader(hl7Text));
                BufferedWriter writer = new BufferedWriter(stringWriter);
                String lineToRemove = "NTE|";
                try {
                    String currentLine;
                    int l = 0;
                    while ((currentLine = reader.readLine()) != null) {
                        String trimmedLine = currentLine.trim();
                        if (++l < 5 && trimmedLine.startsWith(lineToRemove)) continue;
                        writer.write(currentLine + "\r\n");
                    }
                    writer.close();
                    reader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                r = stringWriter.toString();
            }
            if ((idxPid = r.indexOf("PID")) < 0) {
                return ret;
            }
            String l1 = r.substring(0, idxPid);
            String lab_type = "";
            String lab_version = "2.6";
            if (l1.indexOf("|ORU^R0") > 0) {
                lab_type = "ORU_R01";
            } else if (l1.indexOf("|OUL^R|") > 0) {
                lab_type = "OUL_R21";
            } else if (l1.indexOf("|OUL^R") > 0) {
                lab_type = "OUL_R21";
            }
            if (lab_type.isEmpty()) {
                return null;
            }
            return Doit.getHandler(lab_type + "v" + lab_version, r);
        }
        return null;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static MessageHandler getHandler(String type, String hl7Body) {
        MessageHandler mh;
        String msgHandler;
        block8: {
            Document doc = null;
            msgHandler = "";
            String typeVersion = type;
            if (type == null) {
                DefaultGenericHandler handler = new DefaultGenericHandler();
                handler.init(hl7Body);
                return handler;
            }
            InputStream is = Doit.class.getClassLoader().getResourceAsStream("ca/infodata/readhl7/message_config.xml");
            SAXBuilder parser = new SAXBuilder();
            doc = parser.build(is);
            Element root = doc.getRootElement();
            List items = root.getChildren();
            for (Object item : items) {
                Element e = (Element)item;
                String msgType = e.getAttributeValue("name");
                if (!msgType.equals(typeVersion)) continue;
                msgHandler = "parser." + e.getAttributeValue("className");
                break;
            }
            if (!msgHandler.equals("")) break block8;
            DefaultGenericHandler mh2 = new DefaultGenericHandler();
            mh2.init(hl7Body);
            return mh2;
            {
                catch (Exception e) {
                    Logger.getLogger(Doit.class.getName()).log(Level.SEVERE, "Could not create message handler", e);
                    return null;
                }
            }
        }
        try {
            Class<?> classRef = Class.forName(msgHandler);
            mh = (MessageHandler)classRef.newInstance();
            log.info("Message handler '" + msgHandler + "' created successfully");
            mh.init(hl7Body);
            return mh;
        }
        catch (ClassNotFoundException e) {
            log.info("Could not find message handler: " + msgHandler + "\nUsing default message handler instead");
            mh = new DefaultGenericHandler();
            mh.init(hl7Body);
            return mh;
            catch (Exception e1) {
                log.errorException(e1);
                mh = new DefaultGenericHandler();
                mh.init(hl7Body);
                return mh;
            }
        }
    }

    private String getTodayDTOS() {
        Calendar c = Calendar.getInstance();
        return FastDateFormat.getInstance("yyyyMMdd").format(c);
    }

    public String getFormattedFileName(int idClient, String name) {
        String c = "_0_";
        if (idClient > -1) {
            c = "_" + idClient + "_";
        }
        return c + this.getTodayDTOS() + "_" + name;
    }

    protected static String padL(int numberToPad, int toLength) {
        String stringToPad = "" + numberToPad;
        if (stringToPad.length() < toLength) {
            stringToPad = "0" + stringToPad;
        }
        return stringToPad;
    }

    static {
        String s = System.getProperty("line.separator");
        LINE_SEPARATOR = s == null ? "\n" : s;
    }
}

