/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.task.wizard;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.CannotConnectToServerException;
import ca.infodata.ofys.data.dataaccess.util.MessageUtil;
import ca.infodata.ofys.data.middle.dataobjects.XBaseUser;
import ca.infodata.ofys.data.middle.dataobjects.XPersonGroup;
import ca.infodata.ofys.data.middle.dataobjects.chat.MessageLink;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.data.middle.dataobjects.task.XTask;
import ca.infodata.ofys.status.IStatus;
import ca.infodata.ofys.ui.controls.util.PreferencesSettings;
import ca.infodata.ofys.ui.person.PersonUiPlugin;
import ca.infodata.ofys.ui.person.patient.PatientUtil;
import ca.infodata.ofys.ui.task.TaskPlugin;
import ca.infodata.ofys.ui.task.data.client.dataaccess.TaskAccessorClient;
import ca.infodata.ofys.ui.task.wizard.TaskPageOne;
import ca.infodata.util1.JoinList;
import java.io.Serializable;
import java.util.List;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;

public class TaskWizard
extends Wizard {
    private static final String TASK_TO_USER_ID_PREF = "task.toUserId";
    private static final String TASK_TO_GROUP_ID_PREF = "task.toGroupId";
    private TaskPageOne one;
    private final XTask task;

    public TaskWizard() {
        this(null);
    }

    public TaskWizard(XTask task, MessageLink link) {
        this.task = task == null ? this.newTask(link) : task;
        this.setNeedsProgressMonitor(false);
        this.setHelpAvailable(false);
    }

    public TaskWizard(XTask task) {
        this.task = task == null ? this.newTask(null) : task;
        this.setNeedsProgressMonitor(false);
        this.setHelpAvailable(false);
    }

    private XTask newTask(MessageLink link) {
        XPersonGroup group;
        int toGroupId;
        XBaseUser user;
        XTask x = new XTask();
        x.setFromUser(Application.get().getGlobalInstances().getSession().getUser().getId());
        int toUserId = PreferencesSettings.getInstance().getIntSafe(TASK_TO_USER_ID_PREF, -1);
        if (toUserId != -1 && (user = PersonUiPlugin.getDefault().getUser(Integer.valueOf(toUserId))) != null) {
            x.setToUser(user.getId());
        }
        if ((toGroupId = PreferencesSettings.getInstance().getIntSafe(TASK_TO_GROUP_ID_PREF, -1)) != -1 && (group = Application.get().getPersonPluginController().getPersonGroupById(Integer.valueOf(toGroupId), false, true)) != null) {
            x.setToGroup(group.getId());
        }
        if (x.getToUser() == null && x.getToGroup() == null) {
            x.setToUser(Application.get().getGlobalInstances().getSession().getUser().getId());
        }
        MessageLink messageLink = link = link == null ? TaskPlugin.getDefault().getCurrentMessageLink() : link;
        if (link != null) {
            x.setIdLink(link.id);
            x.setLinkType(link.linkType);
            x.setIdPatient(link.patient == null ? null : link.patient.getId());
            x.setPatient(PatientUtil.getXPatient((Object)link.patient));
        }
        return x;
    }

    public boolean performFinish() {
        if (this.task.isDirty()) {
            try {
                PreferencesSettings.getInstance().put(TASK_TO_USER_ID_PREF, (Serializable)this.task.getToUser());
                PreferencesSettings.getInstance().put(TASK_TO_GROUP_ID_PREF, (Serializable)this.task.getToGroup());
                ReturnObject ret = TaskAccessorClient.getInstance().saveSync(((Object)((Object)this)).hashCode(), Application.get().getGlobalInstances().getSession(), (Serializable)this.task, true);
                if (!ret.getStatus().isOkToProceed()) {
                    List list = ret.getStatus().getFlattenedNonOKChildren();
                    JoinList message = new JoinList("\n");
                    for (IStatus s : list) {
                        message.add((CharSequence)s.getMessage());
                    }
                    this.one.setErrorMessage(message.toString());
                    return false;
                }
                return true;
            }
            catch (CannotConnectToServerException cannotConnectToServerException) {
                this.one.setErrorMessage(MessageUtil.CANNOT_CONNECT_TO_SERVER_MESSAGE);
            }
            catch (Exception e) {
                this.one.setErrorMessage(e.getMessage());
            }
            return false;
        }
        return true;
    }

    public void addPages() {
        this.one = new TaskPageOne(this.task);
        this.addPage((IWizardPage)this.one);
    }
}

