/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.task.menu;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.middle.dataobjects.XBaseProfessionnal;
import ca.infodata.ofys.data.middle.dataobjects.XBaseUser;
import ca.infodata.ofys.data.middle.dataobjects.XPatient;
import ca.infodata.ofys.data.middle.dataobjects.XRight;
import ca.infodata.ofys.data.middle.dataobjects.XSession;
import ca.infodata.ofys.data.middle.dataobjects.patient.XConsentement;
import ca.infodata.ofys.ui.controls.ITreeElements;
import ca.infodata.ofys.ui.controls.ITreeElementsFactory;
import ca.infodata.ofys.ui.person.PersonUiPlugin;
import ca.infodata.ofys.ui.person.menu.element.PatientElements;
import ca.infodata.ofys.ui.task.menu.ListPatientTaskElement;
import ca.infodata.ofys.ui.task.menu.ListUserTaskElement;
import ca.infodata.util1.date.LocalDate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IConfigurationElement;

public class TaskTreeElementsFactory
implements ITreeElementsFactory {
    public List<? extends ITreeElements> newITreeElements(ITreeElements parent, IConfigurationElement e) {
        XSession session = Application.get().getGlobalInstances().getSession();
        if (session != null && Application.get().getGlobalInstances().hasRight(XRight.TASK)) {
            String c = e.getAttribute("class");
            if (c.equals(ListUserTaskElement.class.getName())) {
                List replacements;
                ArrayList<ListUserTaskElement> list = new ArrayList<ListUserTaskElement>();
                list.add(this.newListUserTaskElement(parent, (XBaseUser)session.getUser()));
                XBaseProfessionnal sessionProf = PersonUiPlugin.getDefault().getSessionProfessionnal();
                if (sessionProf != null && (replacements = PersonUiPlugin.getDefault().getWhoProfReplace(sessionProf.getId(), LocalDate.today()).collect(Collectors.toList())) != null) {
                    HashSet<Integer> setAddedUserIds = new HashSet<Integer>();
                    for (XBaseProfessionnal prof : replacements) {
                        XBaseUser user = PersonUiPlugin.getDefault().getUserByIdPerson(prof.getIdPerson());
                        if (user == null) continue;
                        setAddedUserIds.add(user.getId());
                        list.add(this.newListUserTaskElement(parent, user));
                    }
                    Application.get().getGlobalInstances().getNotificationSystem().addProfIdForApptNotification(setAddedUserIds);
                }
                return list;
            }
            if (c.equals(ListPatientTaskElement.class.getName())) {
                ArrayList<ListPatientTaskElement> list = new ArrayList<ListPatientTaskElement>();
                XPatient patient = ((PatientElements)parent).getPatient();
                if (patient != null && patient.getId() != null) {
                    boolean showOther = true;
                    if (patient instanceof XPatient) {
                        XConsentement consent = new XConsentement();
                        boolean showToAll = patient.getShowToAllAndConsent(consent, Application.get().getGlobalInstances().getSessionIdUser());
                        boolean checkDroit = false;
                        if (!showToAll && consent.getDroits() != null) {
                            checkDroit = true;
                        }
                        boolean bl = showOther = showToAll || checkDroit && consent.hasRightPatientOther();
                    }
                    if (showOther) {
                        list.add(this.newListPatientTaskElement(parent, patient));
                    }
                }
                return list;
            }
            throw new RuntimeException("unsuppored class tag " + c);
        }
        return null;
    }

    private ListPatientTaskElement newListPatientTaskElement(ITreeElements parent, XPatient patient) {
        ListPatientTaskElement e = new ListPatientTaskElement(parent, patient);
        e.setForceRefreshEnabled(true);
        return e;
    }

    private ListUserTaskElement newListUserTaskElement(ITreeElements parent, XBaseUser user) {
        ListUserTaskElement e = new ListUserTaskElement(parent, user);
        e.setForceRefreshEnabled(true);
        return e;
    }
}

