/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.task.menu;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.util.notification.IConsumerListener;
import ca.infodata.ofys.data.middle.dataobjects.XImageDecorator;
import ca.infodata.ofys.data.middle.dataobjects.XSession;
import ca.infodata.ofys.data.middle.dataobjects.notification.DataObjectUpdatedNotification;
import ca.infodata.ofys.data.middle.dataobjects.notification.Notification;
import ca.infodata.ofys.data.middle.dataobjects.task.XTask;
import ca.infodata.ofys.data.middle.dataobjects.task.XTaskCriteria;
import ca.infodata.ofys.data.middle.dataobjects.task.XTaskPriority;
import ca.infodata.ofys.ui.controls.ITreeElements;
import ca.infodata.ofys.ui.controls.ITreeElementsPastille;
import ca.infodata.ofys.ui.library.ResourceGetter;
import ca.infodata.ofys.ui.menu.DossierPlugin;
import ca.infodata.ofys.ui.menu.treeelements.CallbackElement;
import ca.infodata.ofys.ui.menu.treeelements.LoadingElement;
import ca.infodata.ofys.ui.task.data.client.dataaccess.TaskAccessorClient;
import ca.infodata.ofys.ui.task.menu.TaskElement;
import ca.infodata.util1.date.DateUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;

public abstract class AbstractListTaskElement
extends CallbackElement
implements ITreeElementsPastille,
ITreeElements,
IFontProvider {
    private static final Logger logger = Logger.getLogger(AbstractListTaskElement.class.getName());
    private XTaskCriteria criteria;
    private CopyOnWriteArrayList<XTask> tasks;
    private final IConsumerListener consumerListener;
    private boolean forceRefreshEnabled;

    public AbstractListTaskElement(ITreeElements parent, final XTaskCriteria criteria) {
        super(parent);
        this.criteria = criteria;
        this.consumerListener = new IConsumerListener(){

            public void handleOther(Notification notification) {
            }

            public synchronized void handle(DataObjectUpdatedNotification notification) {
                try {
                    this._handle(criteria, notification);
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Error in AbstractListTaskElement.handle", e);
                }
            }

            private void _handle(XTaskCriteria criteria2, DataObjectUpdatedNotification notification) {
                if (notification.getObject() instanceof XTask) {
                    XTask task = (XTask)notification.getObject();
                    boolean needRefresh = true;
                    if (AbstractListTaskElement.this.tasks != null) {
                        int index = -1;
                        int i = 0;
                        while (i < AbstractListTaskElement.this.tasks.size()) {
                            XTask c = (XTask)AbstractListTaskElement.this.tasks.get(i);
                            if (c.getId().equals(task.getId())) {
                                index = i;
                                break;
                            }
                            ++i;
                        }
                        boolean evaluate = criteria2.evaluate(task);
                        if (evaluate) {
                            if (index != -1) {
                                AbstractListTaskElement.this.tasks.set(index, task);
                            } else {
                                AbstractListTaskElement.this.tasks.add(task);
                            }
                        } else if (index == -1) {
                            needRefresh = false;
                        } else {
                            AbstractListTaskElement.this.tasks.remove(index);
                        }
                    }
                    if (needRefresh) {
                        AbstractListTaskElement.this.refreshLocal();
                    }
                }
            }

            public void forceRefresh() {
                try {
                    AbstractListTaskElement.this.refresh();
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Error in AbstractListTaskElement.forceRefresh", e);
                }
            }
        };
        Application.get().getGlobalInstances().getNotificationSystem().addListener(this.consumerListener);
    }

    public XTaskCriteria getCriteria() {
        return this.criteria;
    }

    public void initAsLoading() {
        this.setText(String.valueOf(this.getBaseText()) + this.getLoadingTextFlag());
    }

    protected abstract String getBaseText();

    public void loadListAsync() {
        this.setChilds(this.getListLoading());
        try {
            XSession session = Application.get().getGlobalInstances().getSession();
            if (session != null) {
                TaskAccessorClient.getInstance().findTask(this.criteria, this.getCallback(1), session);
            } else {
                this.getCallback(1).response(null);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to find task for " + this.criteria, e);
            this.loadResponse(1, null);
        }
    }

    protected List<ITreeElements> getListLoading() {
        ArrayList<ITreeElements> list = new ArrayList<ITreeElements>();
        list.add((ITreeElements)new LoadingElement((ITreeElements)this));
        return list;
    }

    public void loadCountAsync() {
    }

    public void loadCountResponse(Object response) {
    }

    public void loadListResponse(Object response) {
        this.setText(this.getBaseText());
        ArrayList<XTask> list = response == null ? new ArrayList<XTask>(0) : new ArrayList((List)response);
        Collections.sort(list, Collections.reverseOrder());
        this.tasks = new CopyOnWriteArrayList(list);
        List<ITreeElements> listChild = this.getListResponse(list);
        this.setChilds(listChild);
        this.childrenNumber = list.size();
    }

    protected List<ITreeElements> getListResponse(List<XTask> list) {
        ArrayList<ITreeElements> listChild = new ArrayList<ITreeElements>(list == null ? 0 : list.size() + 1);
        if (list != null) {
            for (XTask e : list) {
                listChild.add((ITreeElements)this.newTaskElement(e));
            }
        }
        return listChild;
    }

    protected TaskElement newTaskElement(XTask task) {
        if (task.getIdPatient() != null && task.getPatient() == null) {
            throw new RuntimeException("task patient field is not set");
        }
        return new TaskElement(this, task);
    }

    public void refreshLocal() {
        this.loadListResponse(this.tasks);
        DossierPlugin.getDefault().refreshTreeInSwtThread((ITreeElements)this);
    }

    public Image getImage() {
        return ResourceGetter.getImage((String)"images/date-task-icon16.png");
    }

    public boolean hasChildren() {
        return true;
    }

    protected void refresh() {
        if (this.forceRefreshEnabled) {
            this.initAsLoading();
            this.loadListAsync();
        }
    }

    public int getChildrenNumberForPastille() {
        return this.childrenNumber;
    }

    public Color getPastilleColor() {
        if (this.needRedPastilleColor()) {
            return ResourceGetter.getColor((RGB)ResourceGetter.RED_WARNING_COLOR);
        }
        return ResourceGetter.getColor((RGB)ResourceGetter.GREEN_WARNING_COLOR);
    }

    protected boolean needRedPastilleColor() {
        if (this.tasks == null) {
            return false;
        }
        long now = DateUtil.now();
        for (XTask e : this.tasks) {
            if (e.getPriority() != XTaskPriority.HAUT && (e.getDueDatetime() == null || e.getDueDatetime() >= now)) continue;
            return true;
        }
        return false;
    }

    public Font getFont(Object element) {
        return ResourceGetter.getFontNormal();
    }

    public int hashCode() {
        return new String((this.criteria == null ? Integer.valueOf("XTaskCriteriaNull".hashCode()) : String.valueOf(this.criteria.hashCode())) + ((Object)((Object)this)).getClass().getName()).hashCode();
    }

    public boolean equals(Object toCompare) {
        if (toCompare == null) {
            return false;
        }
        return this.hashCode() == toCompare.hashCode();
    }

    public XImageDecorator getDecorators() {
        return XImageDecorator.NULL_DECORATORS;
    }

    public boolean isForceRefreshEnabled() {
        return this.forceRefreshEnabled;
    }

    public void setForceRefreshEnabled(boolean forceRefreshEnabled) {
        this.forceRefreshEnabled = forceRefreshEnabled;
    }
}

