/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.task;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.util.GlobalInstancesAdapter;
import ca.infodata.ofys.data.dataaccess.util.GlobalInstancesListener;
import ca.infodata.ofys.data.middle.dataobjects.XPatient;
import ca.infodata.ofys.data.middle.dataobjects.chat.LINK_TYPE;
import ca.infodata.ofys.data.middle.dataobjects.chat.MessageLink;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IPatient;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.data.middle.dataobjects.patient.IPatientRelated;
import ca.infodata.ofys.ui.person.PersonUiPlugin;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class TaskPlugin
extends AbstractUIPlugin {
    public static Logger logger = Logger.getLogger("ca.infodata.ofys.ui.task");
    public static final String PLUGIN_ID = "ca.infodata.ofys.ui.task";
    private static TaskPlugin plugin;
    private Cache<String, ReturnObject> cache = Caffeine.newBuilder().maximumSize(20L).expireAfterWrite(15L, TimeUnit.SECONDS).softValues().build();
    private GlobalInstancesAdapter globalInstancesListener = new GlobalInstancesAdapter(){

        public void sessionChanged() {
            TaskPlugin.this.cache.invalidateAll();
        }

        public void logout() {
            TaskPlugin.this.cache.invalidateAll();
        }
    };

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        Application.get().getGlobalInstances().addGlobalInstancesListener((GlobalInstancesListener)this.globalInstancesListener);
        System.err.println("TaskPlugin started");
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        Application.get().getGlobalInstances().removeGlobalInstancesListener((GlobalInstancesListener)this.globalInstancesListener);
        if (this.cache != null) {
            this.cache.invalidateAll();
            this.cache = null;
        }
        super.stop(context);
        System.err.println("TaskPlugin stopped");
    }

    public static TaskPlugin getDefault() {
        return plugin;
    }

    public void add(String hash, ReturnObject response) throws Exception {
        if (this.cache != null) {
            this.cache.put((Object)hash, (Object)response);
        }
    }

    public ReturnObject getCached(String hash) throws Exception {
        if (this.cache != null) {
            return (ReturnObject)this.cache.getIfPresent((Object)hash);
        }
        return null;
    }

    public MessageLink getCurrentMessageLink() {
        XPatient currentPatient;
        IWorkbenchPage page;
        MessageLink ml = null;
        IWorkbenchWindow window = this.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && (page = window.getActivePage()) != null) {
            IWorkbenchPart part = null;
            if (page.getActivePart() instanceof IPatientRelated) {
                part = page.getActivePart();
            } else if (page.getActiveEditor() instanceof IPatientRelated) {
                part = page.getActiveEditor();
            }
            if (part != null) {
                ml = ((IPatientRelated)part).getMessageLink();
            }
        }
        if (ml == null && (currentPatient = PersonUiPlugin.getDefault().getCurrentPatient()) != null) {
            ml = new MessageLink((IPatient)currentPatient, LINK_TYPE.PATIENT, currentPatient.getId());
        }
        return ml;
    }
}

