/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.scan.scan;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.CannotConnectToServerException;
import ca.infodata.ofys.data.dataaccess.ICallback;
import ca.infodata.ofys.data.dataaccess.ProfessionnalRequestAccessorClient;
import ca.infodata.ofys.data.dataaccess.util.MessageUtil;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.XProfessionnalSpeciality;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IPatient;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.data.middle.dataobjects.preferences.FormatDateProvider;
import ca.infodata.ofys.data.middle.dataobjects.request.XProfessionnalRequest;
import ca.infodata.ofys.data.middle.dataobjects.request.XSearchProfessionnalRequestCriteria;
import ca.infodata.ofys.ui.controls.CallbackComposite;
import ca.infodata.ofys.ui.controls.FontAwareComposite;
import ca.infodata.ofys.ui.controls.FontAwareShell;
import ca.infodata.ofys.ui.controls.form.MyButton;
import ca.infodata.ofys.ui.controls.form.MyLabel;
import ca.infodata.ofys.ui.controls.form.MyList;
import ca.infodata.ofys.ui.library.UI;
import ca.infodata.util1.ProviderAR;
import ca.infodata.util1.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.time.FastDateFormat;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class NewOrderResponseControl
extends FontAwareShell {
    private static final Logger logger = Logger.getLogger(NewOrderResponseControl.class.getName());
    private MyList<XProfessionnalRequest> listRequest;
    private MyButton chkRequestWasRejected;
    private MyButton btnCancel;
    private MyButton btnOk;
    private OrderResponse order;
    private static FastDateFormat dateFormatter = FastDateFormat.getInstance((String)FormatDateProvider.getFormatDate().toString());

    public NewOrderResponseControl(Shell parent, IPatient patient) {
        super(parent, 65536);
        FormToolkit toolKit = UI.createToolKit((Widget)this);
        toolKit.adapt((Composite)this);
        MyLabel lblTitle = new MyLabel((Composite)this, Messages.getString((String)"NewOrderResponseControl.LE_DOCUMENT_SERA_CONSIDERE_COMME_UNE_REPONSE", (String[])new String[0]), 64, toolKit);
        lblTitle.setFont(0, 1);
        MyLabel lblListRequest = new MyLabel((Composite)this, Messages.getString((String)"NewOrderResponseControl.LISTE_DES_DEMANDES_NON_REPONDUES", (String[])new String[0]), 16384, toolKit);
        CallbackComposite requestComposite = new CallbackComposite((Composite)this, 0, toolKit){

            protected FontAwareComposite createLoadedComposite(Composite parent, FormToolkit toolKit, ReturnObject response) {
                List list = (List)response.getObj();
                FontAwareComposite main = new FontAwareComposite(parent, 0);
                toolKit.adapt((Composite)main);
                NewOrderResponseControl.this.listRequest = new MyList((Composite)main, 2052);
                NewOrderResponseControl.this.listRequest.setLabelProvider((ProviderAR)new ProviderAR<XProfessionnalRequest, String>(){

                    public String get(XProfessionnalRequest e) {
                        return NewOrderResponseControl.format(e);
                    }
                });
                NewOrderResponseControl.this.listRequest.setItems((Collection)list);
                if (NewOrderResponseControl.this.order != null && ((NewOrderResponseControl)NewOrderResponseControl.this).order.request != null) {
                    NewOrderResponseControl.this.listRequest.select((Object)((NewOrderResponseControl)NewOrderResponseControl.this).order.request);
                }
                FormLayout layout = new FormLayout();
                layout.spacing = 5;
                main.setLayout((Layout)layout);
                FormData data = new FormData();
                data.top = new FormAttachment(0);
                data.left = new FormAttachment(0);
                data.right = new FormAttachment(100);
                data.height = 150;
                NewOrderResponseControl.this.listRequest.setLayoutData((Object)data);
                return main;
            }
        };
        toolKit.adapt((Composite)requestComposite);
        if (patient != null) {
            try {
                XSearchProfessionnalRequestCriteria criteria = new XSearchProfessionnalRequestCriteria();
                criteria.idPatient = patient.getId();
                criteria.responseReceived = false;
                ProfessionnalRequestAccessorClient.getInstance().findProfessionnalRequest(Application.get().getGlobalInstances().getSession(), (ICallback)requestComposite.getCallback(), criteria);
            }
            catch (CannotConnectToServerException cannotConnectToServerException) {
                requestComposite.getCallback().kill();
                requestComposite.showErrorComposite(MessageUtil.CANNOT_CONNECT_TO_SERVER_MESSAGE);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Erreur", e);
                requestComposite.getCallback().kill();
                requestComposite.showErrorComposite(e.getMessage(), (Throwable)e);
            }
        } else {
            requestComposite.showErrorComposite(Messages.getString((String)"NewOrderResponseControl.AUCUN_PATIENT_SELECTIONNE", (String[])new String[0]));
        }
        this.chkRequestWasRejected = new MyButton((Composite)this, Messages.getString((String)"NewOrderResponseControl.LA_DEMANDE_A_ETE_REFUSEE", (String[])new String[0]), 32, toolKit);
        this.btnCancel = new MyButton((Composite)this, Messages.getString((String)"ANNULER", (String[])new String[0]), 8, toolKit);
        this.btnCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewOrderResponseControl.this.doCancel();
            }
        });
        this.btnOk = new MyButton((Composite)this, Messages.getString((String)"TERMINER", (String[])new String[0]), 8, toolKit);
        this.btnOk.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewOrderResponseControl.this.doOK();
            }
        });
        FormLayout layout = new FormLayout();
        layout.spacing = 5;
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        this.setLayout((Layout)layout);
        FormData data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        lblTitle.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(lblTitle.getControl());
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        lblListRequest.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(lblListRequest.getControl());
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        data.height = 200;
        requestComposite.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)requestComposite);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        this.chkRequestWasRejected.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.chkRequestWasRejected.getControl());
        data.right = new FormAttachment(100);
        data.width = MyButton.getStandardButtonWidth();
        this.btnCancel.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.chkRequestWasRejected.getControl());
        data.right = new FormAttachment(this.btnCancel.getControl());
        data.width = MyButton.getStandardButtonWidth();
        this.btnOk.setLayoutData((Object)data);
        this.pack();
        UI.centerComposite((Composite)this, (Composite)parent);
    }

    protected void doOK() {
        if (this.listRequest == null || this.listRequest.getSelection3() == null) {
            return;
        }
        OrderResponse order = new OrderResponse();
        order.request = (XProfessionnalRequest)this.listRequest.getSelection3();
        order.wasRejected = this.chkRequestWasRejected.getSelection();
        this.order = order;
        this.close();
        this.dispose();
    }

    protected void doCancel() {
        this.order = null;
        this.close();
        this.dispose();
    }

    public OrderResponse getResponse() {
        return this.order;
    }

    public void setResponse(OrderResponse order) {
        this.order = order;
        if (this.order != null) {
            this.chkRequestWasRejected.setSelection(this.order.wasRejected);
        }
    }

    private static String format(XProfessionnalRequest request) {
        if (request == null) {
            return "null";
        }
        ArrayList<String> list = new ArrayList<String>(5);
        if (Application.get().getGlobalInstances().inDebugMode()) {
            list.add("id=" + request.id);
        }
        if (request.entryDatetime != null) {
            list.add(dateFormatter.format(new Date(request.entryDatetime)));
        }
        if (request.getTargetProfessionnal() != null) {
            list.add(request.getTargetProfessionnal().getName());
        }
        if (request.getSpeciality() != null) {
            list.add(XProfessionnalSpeciality.valueOf((Integer)request.getSpeciality()).getName());
        } else if (StringUtils.isNotEmpty((String)request.getTitle())) {
            list.add(request.getTitle());
        }
        return StringUtils.join(list, (String)", ");
    }

    static class OrderResponse {
        XProfessionnalRequest request;
        boolean wasRejected;

        OrderResponse() {
        }
    }
}

