/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.scan.scan;

import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.ui.controls.form.MyButton;
import ca.infodata.ofys.ui.controls.form.MyLabel;
import ca.infodata.ofys.ui.controls.form.MyText;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class HumanOCRDialog {
    private static final String RECONNAISSANCE_DE_CARACTERES = Messages.getString((String)"HumanOCRDialog.RECONNAISSANCE_DE_CARACTERES", (String[])new String[0]);
    private static final String OK = Messages.getString((String)"HumanOCRDialog.OK", (String[])new String[0]);
    private static final String ANNULER = Messages.getString((String)"HumanOCRDialog.ANNULER", (String[])new String[0]);
    private final Shell shell;
    private String text = new String();

    public HumanOCRDialog(Display parent, FormToolkit toolkit, Image image, String initialText, String initialValue) {
        this.shell = new Shell(parent, 67680);
        this.shell.setText(RECONNAISSANCE_DE_CARACTERES);
        this.shell.setBounds((parent.getBounds().width - image.getBounds().width - 20) / 2, (parent.getBounds().height - image.getBounds().height - 100) / 2, image.getBounds().width + 20, image.getBounds().height + 100);
        this.createControls(this.shell, toolkit, image, initialText, initialValue);
        Color white = new Color((Device)parent, 255, 255, 255);
        this.shell.setBackground(white);
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (Display.getDefault().readAndDispatch()) continue;
            Display.getDefault().sleep();
        }
        white.dispose();
    }

    private void createControls(Shell parent, FormToolkit toolkit, final Image image, String initialText, String initialValue) {
        FormLayout layout = new FormLayout();
        layout.spacing = 5;
        layout.marginHeight = 5;
        layout.marginWidth = 10;
        parent.setLayout((Layout)layout);
        final Canvas canvas = new Canvas((Composite)parent, 0);
        canvas.setBackgroundImage(image);
        canvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                e.gc.drawImage(image, 0, 0);
            }
        });
        MyButton btnOk = new MyButton((Composite)parent, OK, 8, toolkit);
        btnOk.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                canvas.getBackgroundImage().dispose();
                HumanOCRDialog.this.shell.close();
            }
        });
        MyButton btnCancel = new MyButton((Composite)parent, ANNULER, 8, toolkit);
        btnCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HumanOCRDialog.this.text = new String();
                canvas.getBackgroundImage().dispose();
                HumanOCRDialog.this.shell.close();
            }
        });
        final MyLabel lblInitialText = new MyLabel((Composite)parent, initialText, 0, toolkit);
        final MyText txtText = new MyText((Composite)parent, toolkit, 0);
        if (initialValue != null) {
            txtText.setText(initialValue);
        }
        txtText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                HumanOCRDialog.this.text = String.valueOf(lblInitialText.getText()) + txtText.getText().toUpperCase();
            }
        });
        txtText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x1000050 || e.keyCode == 13) {
                    canvas.getBackgroundImage().dispose();
                    HumanOCRDialog.this.shell.close();
                }
            }
        });
        FormData data = new FormData();
        data.left = new FormAttachment(0);
        data.top = new FormAttachment(0);
        data.right = new FormAttachment(0, image.getBounds().width);
        data.bottom = new FormAttachment(0, image.getBounds().height);
        canvas.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment(0);
        data.top = new FormAttachment((Control)canvas);
        lblInitialText.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment(lblInitialText.getControl());
        data.top = new FormAttachment((Control)canvas);
        data.right = new FormAttachment(100);
        txtText.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(txtText.getControl());
        data.right = new FormAttachment(100);
        data.width = 80;
        btnOk.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(txtText.getControl());
        data.right = new FormAttachment(btnOk.getControl());
        data.width = 80;
        btnCancel.setLayoutData((Object)data);
        txtText.setFocus();
    }

    public String getText() {
        return this.text;
    }

    public boolean isDisposed() {
        return this.shell.isDisposed();
    }
}

