/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.scan.menu;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.CannotConnectToServerException;
import ca.infodata.ofys.data.dataaccess.ICallback;
import ca.infodata.ofys.data.dataaccess.PatientImageAccessorClient;
import ca.infodata.ofys.data.dataaccess.callback.IStatusHandler;
import ca.infodata.ofys.data.dataaccess.callback.JobCallback;
import ca.infodata.ofys.data.dataaccess.util.MessageUtil;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.XBaseProfessionnal;
import ca.infodata.ofys.data.middle.dataobjects.XImageDecorator;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.data.middle.dataobjects.scan.XBasePatientImage;
import ca.infodata.ofys.data.middle.dataobjects.scan.XScanImageContainer;
import ca.infodata.ofys.ui.controls.ITreeElements;
import ca.infodata.ofys.ui.intro.DefaultStatusHandler;
import ca.infodata.ofys.ui.library.ResourceGetter;
import ca.infodata.ofys.ui.menu.DossierPlugin;
import ca.infodata.ofys.ui.menu.treeelements.LoadingElement;
import ca.infodata.ofys.ui.scan.menu.PatientImageElements;
import ca.infodata.util1.date.IPartialDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorInput;

public class ListScannedLastUsed
implements ITreeElements {
    private static final Logger logger = Logger.getLogger(ListScannedLastUsed.class.getName());
    private static final String DERNIERS_VUS = Messages.getString((String)"ListScannedLastUsed.DERNIERS_VUS", (String[])new String[0]);
    private XScanImageContainer imageContainer;
    private final ITreeElements parent;
    private ITreeElements[] children;
    private boolean isLoading;

    public ListScannedLastUsed(ITreeElements parent, XBaseProfessionnal professionnal) {
        if (parent == null) {
            throw new NullPointerException("parent");
        }
        if (professionnal == null) {
            throw new NullPointerException("professionnal");
        }
        this.parent = parent;
        this.imageContainer = new XScanImageContainer(25);
        this.imageContainer.setProfessionnal(professionnal);
        this.imageContainer.setPatient(null);
        this.imageContainer.setLabelDefs(null);
        this.imageContainer.setStatus(null);
        this.imageContainer.setResults(null);
    }

    public Object[] getChildren() {
        if (this.notLoaded()) {
            this.fillAsLoading();
        }
        return this.children;
    }

    private void fillAsLoading() {
        this.isLoading = true;
        this.children = new ITreeElements[]{new LoadingElement((ITreeElements)this)};
        this.find();
    }

    private boolean notLoaded() {
        return this.children == null || this.isLoading;
    }

    private void find() {
        JobCallback callback = new JobCallback(Messages.getString((String)"RECHERCHE", (String[])new String[0]), (IStatusHandler)DefaultStatusHandler.getInstance()){

            public void responseReceived(ReturnObject response) {
                if (response != null && response.getObj() instanceof XScanImageContainer) {
                    ListScannedLastUsed.this.fill((XScanImageContainer)response.getObj());
                } else {
                    ListScannedLastUsed.this.fill(null);
                }
            }

            public void exception(Exception e) {
                super.exception(e);
                ListScannedLastUsed.this.fill(null);
            }
        };
        try {
            try {
                PatientImageAccessorClient.getInstance().findLastUsedBasePatientImage(this.hashCode(), Application.get().getGlobalInstances().getSession(), (ICallback)callback, this.getImageContainer());
            }
            catch (CannotConnectToServerException cannotConnectToServerException) {
                MessageUtil.cannotConnectToServerExceptionMsg();
                callback.kill();
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Error " + this.getImageContainer(), e);
                callback.kill();
            }
        }
        finally {
            callback.kill();
        }
    }

    private void fill(XScanImageContainer container) {
        if (container == null) {
            this.children = new ITreeElements[0];
        } else {
            ArrayList<PatientImageElements> listChild = new ArrayList<PatientImageElements>(container.getBaseImages().length);
            Arrays.sort(container.getBaseImages(), new Comparator<XBasePatientImage>(){

                @Override
                public int compare(XBasePatientImage o1, XBasePatientImage o2) {
                    return o1.getDocumentDate().compareTo((IPartialDate)o2.getDocumentDate()) * -1;
                }
            });
            XBasePatientImage[] xBasePatientImageArray = container.getBaseImages();
            int n = xBasePatientImageArray.length;
            int n2 = 0;
            while (n2 < n) {
                XBasePatientImage image = xBasePatientImageArray[n2];
                listChild.add(new PatientImageElements(this, image));
                ++n2;
            }
            this.children = listChild.toArray(new ITreeElements[listChild.size()]);
        }
        this.isLoading = false;
        DossierPlugin.getDefault().refreshTree((ITreeElements)this);
    }

    public String getText() {
        return DERNIERS_VUS;
    }

    public String getTooltipText() {
        return this.getText();
    }

    public Image getImage() {
        return ResourceGetter.getImage((String)"images/print-icon16.png");
    }

    public String getEditorClass() {
        return null;
    }

    public IEditorInput getEditorInput() {
        return null;
    }

    public XScanImageContainer getImageContainer() {
        return this.imageContainer;
    }

    public void showContextMenu(Control control) {
    }

    public Object getParent() {
        return this.parent;
    }

    public boolean hasChildren() {
        return true;
    }

    public XImageDecorator getDecorators() {
        return null;
    }

    public void doKeyListener(Control control, KeyEvent ke) {
    }

    public int getChildrenNumberForPastille() {
        return 0;
    }
}

