/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.scan.menu;

import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.XBaseProfessionnal;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IPatient;
import ca.infodata.ofys.data.middle.dataobjects.label.XLabelDef;
import ca.infodata.ofys.data.middle.dataobjects.scan.XPatientImageProfessionnalStatus;
import ca.infodata.ofys.data.middle.dataobjects.scan.XScanImageNumberContainer;
import ca.infodata.ofys.ui.controls.ITreeElements;
import ca.infodata.ofys.ui.library.ResourceGetter;
import ca.infodata.ofys.ui.person.PersonUiPlugin;
import ca.infodata.ofys.ui.preferences.PreferencesPlugin;
import ca.infodata.ofys.ui.scan.dsq.GetLaboListElement;
import ca.infodata.ofys.ui.scan.dsq.imaging.ListImagingExamElement;
import ca.infodata.ofys.ui.scan.menu.AllScannedElement;
import ca.infodata.ofys.ui.scan.menu.ListScanned;
import ca.infodata.ofys.ui.scan.menu.ListScannedToResolve;
import ca.infodata.ofys.ui.scan.menu.ListScannedToSee;
import ca.infodata.ofys.ui.scan.menu.ListScannedType;
import ca.infodata.ofys.ui.scan.menu.SearchScanElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.graphics.Image;

public class ListScanedPatient
extends ListScanned {
    private IPatient patient;
    private XBaseProfessionnal professionnal;

    public ListScanedPatient(ITreeElements parent, IPatient patient, XBaseProfessionnal professionnal) {
        super(parent);
        if (patient == null) {
            throw new NullPointerException("patient");
        }
        this.patient = patient;
        this.professionnal = professionnal;
        this.countContainer = new XScanImageNumberContainer();
        this.countContainer.doCountAll = true;
        this.countContainer.doCountByLabel = true;
        this.countContainer.doCountByStatus = true;
        this.countContainer.idPatient = patient == null ? null : patient.getId();
        this.countContainer.idProfessionnal = professionnal == null ? null : professionnal.getId();
        this.initAsLoading();
        this.loadCountAsync();
    }

    public void initAsLoading() {
        this.setText(String.valueOf(ListScanned.DOCUMENT_SCAN) + Messages.getString((String)"CHARGEMENT", (String[])new String[0]) + ")");
        ArrayList<Object> list = new ArrayList<Object>();
        list.addAll(this.getChildrenByExtension());
        list.add(new GetLaboListElement(this));
        list.add(new ListImagingExamElement(this));
        list.add(new SearchScanElement((ITreeElements)this, this.patient));
        list.add((Object)new ListScannedToSee(this, this.patient, this.professionnal));
        list.add((Object)new ListScannedToResolve(this, this.patient, this.professionnal));
        list.add((Object)new AllScannedElement(this, this.patient, null));
        this.setChilds(list);
    }

    public void loadCountResponse(Object response) {
        XScanImageNumberContainer container = response == null ? new XScanImageNumberContainer() : (XScanImageNumberContainer)response;
        Integer unseenCount = (Integer)container.countByStatus.get(XPatientImageProfessionnalStatus.UNSEEN);
        Integer toResolveCount = (Integer)container.countByStatus.get(XPatientImageProfessionnalStatus.TO_RESOLVE);
        this.setText(String.valueOf(ListScanned.DOCUMENT_SCAN) + (toResolveCount == null ? "-" : String.valueOf(toResolveCount)) + ListScanned._a_REGLER + ", " + (unseenCount == null ? "-" : String.valueOf(unseenCount)) + ListScanned.TO_SEE);
        this.forwardResponseToChildren(0, container);
        ArrayList<ITreeElements> list = new ArrayList<ITreeElements>(this.getChilds());
        list.addAll(this.addLabelElements(container));
        this.setChilds(list);
    }

    private List<ITreeElements> addLabelElements(XScanImageNumberContainer response) {
        ArrayList<ITreeElements> list = new ArrayList<ITreeElements>();
        ArrayList<XLabelDef> labels = new ArrayList<XLabelDef>();
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        for (Map.Entry e : response.countByLabel.entrySet()) {
            XLabelDef label;
            Integer count = (Integer)e.getValue();
            if (count == null || count <= 0 || (label = PreferencesPlugin.getDefault().getLabelOrItsReplacement((Integer)e.getKey())) == null) continue;
            Integer value = (Integer)map.get(label.getId());
            value = value == null ? count : Integer.valueOf(value + count);
            map.put(label.getId(), value);
            labels.add(label);
        }
        response.countByLabel = map;
        Collections.sort(labels, XLabelDef.sortLabels);
        for (XLabelDef label : labels) {
            ListScannedType c = new ListScannedType(this, this.patient, null, label);
            c.loadResponse(0, response);
            list.add(c);
        }
        return list;
    }

    @Override
    public void loadListAsync() {
    }

    public Object[] getChildren() {
        PersonUiPlugin.getDefault().setTimeItemInPatientClicked(System.currentTimeMillis());
        return this.children;
    }

    @Override
    public int hashCode() {
        int result = ((Object)((Object)this)).getClass().getName().hashCode();
        result = 31 * result + (this.getParent() == null ? 0 : this.getParent().hashCode());
        result = 31 * result + (this.patient == null ? 0 : this.patient.hashCode());
        return result;
    }

    public IPatient getPatient() {
        return this.patient;
    }

    @Override
    public boolean hasChildren() {
        return true;
    }

    @Override
    public Image getImage() {
        return ResourceGetter.getImage((String)"images/print-icon16.png");
    }
}

