/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.scan.dsq.imaging;

import ca.infodata.dsq.domain.Code;
import ca.infodata.dsq.domain.imaging.ImagingResultExam;
import ca.infodata.ofys.data.middle.dataobjects.XImageDecorator;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IPatient;
import ca.infodata.ofys.data.middle.dataobjects.scan.XBasePatientImage;
import ca.infodata.ofys.data.middle.dataobjects.scan.XPatientImageResultType;
import ca.infodata.ofys.ui.controls.ITreeElements;
import ca.infodata.ofys.ui.dsq.DsqFormatter;
import ca.infodata.ofys.ui.person.patient.PatientUtil;
import ca.infodata.ofys.ui.scan.dsq.imaging.ImagingExamEditor;
import ca.infodata.ofys.ui.scan.menu.PatientImageElements;
import ca.infodata.util1.JoinList;
import ca.infodata.util1.date.DateUtil;
import ca.infodata.util1.date.LocalDate;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorInput;

public class ImagingResultExamElement
extends PatientImageElements {
    private ImagingResultExam exam;
    private IPatient patient;

    public ImagingResultExamElement(ITreeElements parent, IPatient iPatient, ImagingResultExam exam) {
        super(parent);
        this.patient = iPatient;
        this.exam = exam;
        this.setShowPatientName(false);
        this.setPatientImageInfo(ImagingResultExamElement.getPatientImage(this.patient, this.exam));
    }

    public static XBasePatientImage getPatientImage(IPatient patient, ImagingResultExam exam) {
        XBasePatientImage image = new XBasePatientImage();
        image.patient = PatientUtil.getXPatient((Object)patient);
        image.setIdPatient(patient.getId());
        image.setResult(XPatientImageResultType.SO);
        image.setId(null);
        image.setDecorators(XImageDecorator.NULL_DECORATORS);
        image.setDocumentDate(LocalDate.fromTimeInMillisUTC((Long)exam.effectiveTime));
        image.dsqImagingResultExam = exam;
        image.setStr(ImagingResultExamElement.formatDsqPatientImage(patient, exam));
        image.setStrWithoutPatient(ImagingResultExamElement.formatDsqPatientImage(null, exam));
        return image;
    }

    public static String formatDsqPatientImage(IPatient patient, ImagingResultExam exam) {
        JoinList joinList = new JoinList(", ");
        joinList.setAllowBlank(false);
        joinList.setTrim(true);
        String date = DateUtil.format((Long)exam.effectiveTime, (String)"yyyy-MM-dd HH:mm:ss");
        if (exam.code != null) {
            joinList.add((CharSequence)DsqFormatter.formatCode((Code)exam.code));
        }
        if ("completed".equals(exam.status.text)) {
            joinList.add((CharSequence)"C");
        } else {
            joinList.add((CharSequence)exam.status.text);
        }
        for (Code code : exam.modality) {
            joinList.add((CharSequence)code.code);
        }
        String text = "";
        if (patient != null) {
            String ptnom = " (" + patient.getName() + ")";
            text = String.valueOf(date) + " : " + ptnom + " " + joinList.toString();
        } else {
            text = String.valueOf(date) + " : " + joinList.toString();
        }
        return text;
    }

    @Override
    public void doKeyListener(Control control, KeyEvent ke) {
        super.doKeyListener(control, ke);
    }

    @Override
    public void doDoubleClick() {
        super.doDoubleClick();
    }

    @Override
    public void doSelect() {
        super.doSelect();
    }

    @Override
    public String getEditorClass() {
        return ImagingExamEditor.class.getName();
    }

    @Override
    public IEditorInput getEditorInput() {
        return super.getEditorInput();
    }
}

