/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.ressource.search;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.CannotConnectToServerException;
import ca.infodata.ofys.data.dataaccess.ICallback;
import ca.infodata.ofys.data.dataaccess.RessourceAccessorClient;
import ca.infodata.ofys.data.dataaccess.callback.IStatusHandler;
import ca.infodata.ofys.data.dataaccess.callback.JobCallback;
import ca.infodata.ofys.data.dataaccess.util.MessageUtil;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.XBaseProfessionnal;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.data.middle.dataobjects.service.XResponsablePmt;
import ca.infodata.ofys.data.middle.dataobjects.service.XRessource;
import ca.infodata.ofys.data.middle.dataobjects.service.XRessourceCriteria;
import ca.infodata.ofys.data.middle.dataobjects.service.XServiceType;
import ca.infodata.ofys.ui.controls.BaseEditor;
import ca.infodata.ofys.ui.controls.EditorInput;
import ca.infodata.ofys.ui.controls.IControl;
import ca.infodata.ofys.ui.controls.MyMaskedText;
import ca.infodata.ofys.ui.controls.calendarcombo.MyCalendarText;
import ca.infodata.ofys.ui.controls.form.MyButton;
import ca.infodata.ofys.ui.controls.form.MyLabel;
import ca.infodata.ofys.ui.controls.form.combo.MyCombo;
import ca.infodata.ofys.ui.controls.plugins.searchview.BaseSearchComposite;
import ca.infodata.ofys.ui.controls.plugins.searchview.EnumWithValueAdapter;
import ca.infodata.ofys.ui.controls.plugins.searchview.ErrorWhileSearchingException;
import ca.infodata.ofys.ui.controls.plugins.searchview.SearchColumnChoiceElement;
import ca.infodata.ofys.ui.controls.plugins.searchview.SearchControlAdapter;
import ca.infodata.ofys.ui.controls.plugins.searchview.SearchItem;
import ca.infodata.ofys.ui.intro.DefaultStatusHandler;
import ca.infodata.ofys.ui.library.ResourceGetter;
import ca.infodata.ofys.ui.person.professionnal.ProfessionalBySiteCombo;
import ca.infodata.ofys.ui.person.professionnal.ProfessionalBySiteComboASearchAdapter;
import ca.infodata.ofys.ui.ressource.RessourceEditor;
import ca.infodata.ofys.ui.ressource.RessourceEditorFactory;
import ca.infodata.ofys.ui.ressource.RessourceFormatter;
import ca.infodata.util1.StringUtils;
import java.util.EnumSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class RessourceSearchComposite
extends BaseSearchComposite {
    private static final Logger logger = Logger.getLogger(RessourceSearchComposite.class.getName());
    private MyLabel lblName;
    private MyMaskedText txtName;
    private MyLabel lblCode;
    private MyMaskedText txtCode;
    private MyLabel lblResponsablePmt;
    private MyCombo<XResponsablePmt> cmbResponsablePmt;
    private MyLabel lblServiceType;
    private MyCombo<XServiceType> cmbServiceType;
    private MyLabel lblDate;
    private MyCalendarText txtDate;
    private MyLabel lblProfessionnal;
    private ProfessionalBySiteCombo cmbProfessionnal;

    public RessourceSearchComposite(Composite parent, FormToolkit toolkit, int style) {
        super(parent, toolkit, style);
    }

    public void setFocus() {
        this.setVisible(true);
        this.txtName.setFocus();
    }

    public void createMyPartControl(Composite theParent, FormToolkit toolkit, int style) {
        this.isWithTemplateTool = false;
        super.createMyPartControl(theParent, toolkit, style);
    }

    protected void createMyControl(Composite parent, FormToolkit toolkit) {
        this.setViewSelectInactive();
        this.setIsWithButtonNew(true);
        FormLayout layout = new FormLayout();
        layout.marginWidth = 2;
        layout.marginHeight = 2;
        layout.spacing = 5;
        parent.setLayout((Layout)layout);
        this.lblDate = new MyLabel(parent, Messages.getString((String)"DATE", (String[])new String[0]), 16384, toolkit);
        this.txtDate = new MyCalendarText(parent, 0, toolkit, true);
        this.addSearchControl("txtDate", (IControl)this.txtDate);
        this.lblName = new MyLabel(parent, Messages.getString((String)"NOM", (String[])new String[0]), 16384, toolkit);
        this.txtName = new MyMaskedText(parent, 4, toolkit);
        this.txtName.addKeyListener(this.enterCtrlEnterListener);
        this.addSearchControl("txtName", (IControl)this.txtName);
        this.lblCode = new MyLabel(parent, Messages.getString((String)"CODE", (String[])new String[0]), 16384, toolkit);
        this.txtCode = new MyMaskedText(parent, 4, toolkit);
        this.txtCode.addKeyListener(this.enterCtrlEnterListener);
        this.addSearchControl("txtCode", (IControl)this.txtCode);
        this.lblResponsablePmt = new MyLabel(parent, Messages.getString((String)"RESPONSABLE_PMT", (String[])new String[0]), 16384, toolkit);
        this.cmbResponsablePmt = new MyCombo(parent, 8, toolkit);
        this.cmbResponsablePmt.setItemsWithNull((Object[])XResponsablePmt.values());
        this.addSearchControl("cmbResponsablePmt", (IControl)this.cmbResponsablePmt, (SearchControlAdapter)new EnumWithValueAdapter(XResponsablePmt.class));
        MyButton btnDeleteRespPmt = new MyButton(parent, null, 8, toolkit);
        btnDeleteRespPmt.setImage(ResourceGetter.getImage((String)"images/delete_edit.gif"));
        this.lblServiceType = new MyLabel(parent, Messages.getString((String)"TYPE_DE_SERVICE", (String[])new String[0]), 16384, toolkit);
        this.cmbServiceType = new MyCombo(parent, 8, toolkit);
        this.cmbServiceType.setItemsWithNull((Object[])XServiceType.values());
        this.addSearchControl("cmbServiceType", (IControl)this.cmbServiceType, (SearchControlAdapter)new EnumWithValueAdapter(XServiceType.class));
        MyButton btnDeleteServiceType = new MyButton(parent, null, 8, toolkit);
        btnDeleteServiceType.setImage(ResourceGetter.getImage((String)"images/delete_edit.gif"));
        this.lblProfessionnal = new MyLabel(parent, Messages.getString((String)"PROFESSIONNEL", (String[])new String[0]), 16384, toolkit);
        this.cmbProfessionnal = new ProfessionalBySiteCombo(parent, 65544, toolkit);
        this.cmbProfessionnal.fill();
        this.addSearchControl("cmbProfessionnal", (IControl)this.cmbProfessionnal, (SearchControlAdapter)new ProfessionalBySiteComboASearchAdapter(this.cmbProfessionnal));
        MyButton btnDeleteProf = new MyButton(parent, null, 8, toolkit);
        btnDeleteProf.setImage(ResourceGetter.getImage((String)"images/delete_edit.gif"));
        btnDeleteRespPmt.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                RessourceSearchComposite.this.cmbResponsablePmt.selectNone();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        btnDeleteServiceType.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                RessourceSearchComposite.this.cmbServiceType.selectNone();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        btnDeleteProf.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                RessourceSearchComposite.this.cmbProfessionnal.selectNone();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        int i1 = 49;
        int i2 = 100;
        FormData data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(i1);
        this.lblName.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.lblName.getControl());
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(i1);
        this.txtName.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(this.txtName.getControl(), 5);
        data.right = new FormAttachment(i2);
        this.lblCode.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.lblCode.getControl());
        data.left = new FormAttachment(this.txtName.getControl(), 5);
        data.right = new FormAttachment(i2);
        this.txtCode.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.txtName.getControl(), 5);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(i1);
        this.lblDate.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.lblDate.getControl());
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(i1);
        this.txtDate.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.txtName.getControl());
        data.left = new FormAttachment(this.txtDate.getControl(), 5);
        data.right = new FormAttachment(100);
        this.lblProfessionnal.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.lblProfessionnal.getControl());
        data.right = new FormAttachment(100);
        btnDeleteProf.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.lblProfessionnal.getControl());
        data.left = new FormAttachment(this.txtDate.getControl(), 5);
        data.right = new FormAttachment(btnDeleteProf.getControl());
        this.cmbProfessionnal.setLayoutData(data);
        data = new FormData();
        data.top = new FormAttachment(this.txtDate.getControl());
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(i1);
        this.lblServiceType.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.lblServiceType.getControl());
        data.right = new FormAttachment(i1);
        btnDeleteServiceType.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.lblServiceType.getControl());
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(btnDeleteServiceType.getControl());
        this.cmbServiceType.setLayoutData(data);
        data = new FormData();
        data.top = new FormAttachment(this.txtDate.getControl());
        data.left = new FormAttachment(btnDeleteServiceType.getControl(), 5);
        data.right = new FormAttachment(100);
        this.lblResponsablePmt.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.lblResponsablePmt.getControl());
        data.right = new FormAttachment(100);
        btnDeleteRespPmt.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.lblResponsablePmt.getControl());
        data.left = new FormAttachment(btnDeleteServiceType.getControl(), 5);
        data.right = new FormAttachment(btnDeleteRespPmt.getControl());
        this.cmbResponsablePmt.setLayoutData(data);
    }

    protected void search() throws ErrorWhileSearchingException {
        block8: {
            XRessourceCriteria container = new XRessourceCriteria();
            container.name = StringUtils.removeMultiSpace((String)this.txtName.getText().trim());
            container.code = this.txtCode.getText();
            if (this.txtDate.getDate() != null) {
                container.date = this.txtDate.getDate().dayFrom1970;
            }
            if (this.cmbProfessionnal.getSelection() != null) {
                container.idProfessionnalAnchor = this.cmbProfessionnal.getSelection().getId();
            }
            if (this.cmbResponsablePmt.getSelection() != null) {
                container.responsablePmt = EnumSet.of((XResponsablePmt)this.cmbResponsablePmt.getSelection());
            }
            if (this.cmbServiceType.getSelection() != null) {
                container.serviceType = EnumSet.of((XServiceType)this.cmbServiceType.getSelection());
            }
            JobCallback callback = null;
            try {
                callback = new JobCallback(Messages.getString((String)"RECHERCHE", (String[])new String[0]), (IStatusHandler)DefaultStatusHandler.getInstance()){

                    public void responseReceived(ReturnObject response) {
                        RessourceSearchComposite.this.searchResponse((List)response.getObj());
                    }

                    public void exception(Exception e) {
                        super.exception(e);
                        RessourceSearchComposite.this.searchResponse(null);
                    }
                };
                RessourceAccessorClient.getInstance().getRessourceByCriteria(container, Application.get().getGlobalInstances().getSession(), (ICallback)callback);
            }
            catch (CannotConnectToServerException e) {
                MessageUtil.cannotConnectToServerExceptionMsg();
                if (callback != null && !callback.killed()) {
                    callback.kill();
                }
                throw new ErrorWhileSearchingException((Exception)((Object)e));
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Erreur", e);
                if (callback == null || callback.killed()) break block8;
                callback.kill();
            }
        }
    }

    private void searchResponse(final List<XRessource> list) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    if (!RessourceSearchComposite.this.parent.isDisposed()) {
                        SearchItem[] items = new SearchItem[list == null ? 0 : list.size()];
                        int i = 0;
                        while (i < items.length) {
                            XRessource ress = (XRessource)list.get(i);
                            items[i] = new SearchItem((Object)ress, RessourceFormatter.format(ress, false));
                            ++i;
                        }
                        if (Application.get().getGlobalInstances().getSession().getClientPreferences().getReturnListLength() < i) {
                            RessourceSearchComposite.this.setMessage(MSG_TROP_DONNEES);
                        } else if (i == 0) {
                            RessourceSearchComposite.this.setMessage(MSG_AUCUNES_DONNEES);
                            RessourceSearchComposite.this.txtName.setFocus();
                        } else {
                            RessourceSearchComposite.this.setMessage(null);
                        }
                        RessourceSearchComposite.this.loadSearchListInTable(items);
                        RessourceSearchComposite.this.callbackContainerReferenceControlFromTableItems();
                    }
                }
                catch (RuntimeException e) {
                    logger.log(Level.SEVERE, "Erreur", e);
                }
            }
        });
    }

    protected void processSelection(SearchItem item) {
        if (item != null) {
            XRessource x = (XRessource)item.getData();
            try {
                if (Application.get().getGlobalInstances().getSession() != null) {
                    RessourceEditorFactory.openRessource(x);
                }
            }
            catch (ErrorWhileSearchingException e) {
                logger.log(Level.SEVERE, "", e);
            }
        }
    }

    protected void showContextMenu(Control parent) {
    }

    public void reset() {
        super.reset();
        this.txtDate.setDate(null);
        this.txtName.clear();
        this.txtCode.clear();
        this.cmbServiceType.selectNone();
        this.cmbResponsablePmt.selectNone();
        this.cmbProfessionnal.selectNone();
    }

    protected void createNew() {
        try {
            XRessource ress = new XRessource();
            ress.initialize();
            if (Application.get().getGlobalInstances().getSession() != null) {
                BaseEditor.openEditor((IEditorInput)new EditorInput((IDataObject)ress), (String)RessourceEditor.class.getName());
            }
        }
        catch (PartInitException e) {
            logger.log(Level.SEVERE, "", e);
        }
    }

    public void setProfessionnal(XBaseProfessionnal professionnal) {
        if (professionnal == null) {
            this.cmbProfessionnal.selectNone();
        } else {
            this.cmbProfessionnal.select(professionnal);
        }
    }

    protected SearchColumnChoiceElement[] getSearchColumnChoiceElements() {
        return null;
    }

    protected String getPreferencesKeys() {
        return null;
    }
}

