/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.ressource.menu;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.middle.dataobjects.XImageDecorator;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IDataObject;
import ca.infodata.ofys.data.middle.dataobjects.service.XRessource;
import ca.infodata.ofys.ui.controls.EditorInput;
import ca.infodata.ofys.ui.controls.ITreeElements;
import ca.infodata.ofys.ui.controls.ITreeElements2;
import ca.infodata.ofys.ui.controls.plugins.searchview.ErrorWhileSearchingException;
import ca.infodata.ofys.ui.library.ResourceGetter;
import ca.infodata.ofys.ui.ressource.RessourceEditorFactory;
import ca.infodata.ofys.ui.ressource.RessourceFormatter;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorInput;

public class RessourceElement
implements ITreeElements2 {
    private static final Logger logger = Logger.getLogger(RessourceElement.class.getName());
    private ITreeElements parent;
    private XRessource ressource;

    public RessourceElement(ITreeElements parent, XRessource ressource) {
        if (parent == null) {
            throw new NullPointerException("parent");
        }
        if (ressource == null) {
            throw new NullPointerException("ressource");
        }
        this.parent = parent;
        this.ressource = ressource;
    }

    public RessourceElement(ITreeElements parent) {
        if (parent == null) {
            throw new NullPointerException("parent");
        }
        this.parent = parent;
    }

    public XRessource getRessource() {
        return this.ressource;
    }

    public Object[] getChildren() {
        return null;
    }

    public Object getParent() {
        return this.parent;
    }

    public boolean hasChildren() {
        return false;
    }

    public String getText() {
        return RessourceFormatter.format(this.ressource, false);
    }

    public String getTooltipText() {
        return this.getText();
    }

    public Image getImage() {
        return ResourceGetter.getImage((String)"images/attributes-display-icon16.png");
    }

    public String getEditorClass() {
        return null;
    }

    public IEditorInput getEditorInput() {
        return new EditorInput((IDataObject)this.getRessource());
    }

    public XImageDecorator getDecorators() {
        if (this.ressource.getId() == null) {
            return new XImageDecorator(null, null, null, "ajouter_decorator.gif");
        }
        return XImageDecorator.NULL_DECORATORS;
    }

    public void showContextMenu(Control control) {
    }

    public int hashCode() {
        return new String(String.valueOf(this.getParent().hashCode()) + " " + (this.ressource == null ? 0 : this.ressource.hashCode()) + " " + this.getClass().getName()).hashCode();
    }

    public boolean equals(Object toCompare) {
        boolean ret = false;
        if (toCompare instanceof RessourceElement && toCompare.hashCode() == this.hashCode()) {
            ret = true;
        }
        return ret;
    }

    public void doKeyListener(Control control, KeyEvent ke) {
    }

    public void doDoubleClick() {
        try {
            if (Application.get().getGlobalInstances().getSession() != null) {
                RessourceEditorFactory.openRessource(this.ressource);
            }
        }
        catch (ErrorWhileSearchingException e) {
            logger.log(Level.SEVERE, "", e);
        }
    }

    public void doSelect() {
    }

    public int getChildrenNumberForPastille() {
        return 0;
    }
}

