/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.ressource.editor;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.CannotConnectToServerException;
import ca.infodata.ofys.data.dataaccess.RessourceAccessorClient;
import ca.infodata.ofys.data.dataaccess.callback.IStatusHandler;
import ca.infodata.ofys.data.dataaccess.util.MessageUtil;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.XBaseProfessionnal;
import ca.infodata.ofys.data.middle.dataobjects.XObjectContainer;
import ca.infodata.ofys.data.middle.dataobjects.XPatient;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IEditableDataObjectList;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IMinimalEditableDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ModificationStatus;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ModificationStatusManager;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.data.middle.dataobjects.service.XBilledRessource;
import ca.infodata.ofys.data.middle.dataobjects.service.XBilledRessourcePaid;
import ca.infodata.ofys.data.middle.dataobjects.service.XBillingRessource;
import ca.infodata.ofys.data.middle.dataobjects.service.XBillingRessourceData;
import ca.infodata.ofys.data.middle.dataobjects.service.XBillingRessourceDataTaxe;
import ca.infodata.ofys.data.middle.dataobjects.service.XRessourceDefData;
import ca.infodata.ofys.data.middle.dataobjects.service.XRessourceUnit;
import ca.infodata.ofys.data.middle.dataobjects.service.XServiceType;
import ca.infodata.ofys.data.middle.dataobjects.service.XTaxeDefData;
import ca.infodata.ofys.data.middle.dataobjects.site.SiteAddedAs;
import ca.infodata.ofys.data.middle.dataobjects.site.XPersonSite;
import ca.infodata.ofys.data.middle.dataobjects.site.XSite;
import ca.infodata.ofys.mb.listener.object.IObjectListener;
import ca.infodata.ofys.mb.listener.object.ObjectListenerManager;
import ca.infodata.ofys.status.IStatus;
import ca.infodata.ofys.status.Status;
import ca.infodata.ofys.ui.library.UI;
import ca.infodata.ofys.ui.library.log.Log;
import ca.infodata.ofys.ui.person.PersonUiPlugin;
import ca.infodata.ofys.ui.site.SitePlugin;
import ca.infodata.ofys.util.MiscUtil;
import ca.infodata.util1.date.DateUtil;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.mb.listeners.GenListenerManager;
import org.mb.listeners.IListenerManager;

public class BillingRessourceController
implements IObjectListener<Object> {
    private static final Logger logger = Logger.getLogger(BillingRessourceController.class.getName());
    private final IListenerManager<IBillingRessourceControllerListener> manager;
    private final IBillingRessourceControllerListener proxy;
    private List<XBillingRessource> lstBillingRessources = new ArrayList<XBillingRessource>();
    private XBillingRessource currentBillingRessource;
    private XBilledRessource currentBilledRessource;
    private XPatient currentPatient;
    private XSite currentSite;
    private XBaseProfessionnal currentProfessionnal;
    public static Integer lastUsedProf;

    public BillingRessourceController(XBillingRessource billingRess, XPatient pt, XSite site) {
        this.manager = new GenListenerManager(IBillingRessourceControllerListener.class);
        this.proxy = (IBillingRessourceControllerListener)this.manager.getProxy();
        this.currentBillingRessource = billingRess;
        this.currentPatient = pt;
        this.currentSite = site;
    }

    private void setBillingRessource(XBillingRessource a) {
        this.currentBillingRessource = a;
        this.proxy.billingRessourceChanged();
    }

    private void setBilledRessource(XBilledRessource a) {
        this.currentBilledRessource = a;
        this.proxy.billedRessourceChanged();
    }

    public IStatus save(IProgressMonitor monitor, boolean askQuestion, IStatusHandler statusHandler) {
        IStatus status;
        block16: {
            XBillingRessource billingRessource = this.getBillingRessource();
            if (billingRessource != null && billingRessource.getIdProfessionnalAnchor() != null) {
                lastUsedProf = billingRessource.getIdProfessionnalAnchor();
            }
            Log.logOperation((String)"BillingController.save", (Object[])new Object[]{billingRessource});
            status = Status.OK_STATUS;
            try {
                try {
                    ArrayList<XBillingRessource> lstBR = new ArrayList<XBillingRessource>();
                    for (XBillingRessource x : this.lstBillingRessources) {
                        if (!x.isUpdated() && !x.isNewOrNewUpdated()) continue;
                        x.setTag();
                        for (XBillingRessourceData xbrd : x.getBillingRessourceDatas()) {
                            xbrd.setTag();
                        }
                        lstBR.add(x);
                    }
                    if (lstBR.size() <= 0) break block16;
                    XObjectContainer xObjectContainer = new XObjectContainer(lstBR);
                    ReturnObject ret = null;
                    try {
                        ret = RessourceAccessorClient.getInstance().saveSync(this.hashCode(), Application.get().getGlobalInstances().getSession(), (Serializable)xObjectContainer, askQuestion);
                        status = ret.getStatus();
                    }
                    catch (CannotConnectToServerException e) {
                        status = new Status(IStatus.Severity.ERROR, "CannotConnectToServer", (Throwable)e);
                        MessageUtil.cannotConnectToServerExceptionMsg();
                    }
                    catch (Exception e) {
                        status = new Status(IStatus.Severity.ERROR, "save exception", (Throwable)e);
                        logger.log(Level.WARNING, "Failed to save", e);
                    }
                    if (status.isOkToProceed() && ret != null && ret.getObj() != null && (e = (IMinimalEditableDataObject)ret.getObj()) instanceof XObjectContainer) {
                        XObjectContainer ee = (XObjectContainer)e;
                        XBillingRessource x = null;
                        for (IMinimalEditableDataObject xe : ee.getObjects()) {
                            x = (XBillingRessource)xe;
                            int i = 0;
                            while (i < this.lstBillingRessources.size()) {
                                XBillingRessource xb = this.lstBillingRessources.get(i);
                                if (xb.getTag() != null && xb.getTag().equals(x.getTag())) {
                                    this.lstBillingRessources.set(i, xb);
                                }
                                ++i;
                            }
                        }
                        this.setBillingRessource(x);
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            finally {
                if (monitor != null) {
                    monitor.done();
                }
            }
        }
        return status;
    }

    public IStatus doConfirmPayment(IProgressMonitor monitor, boolean askQuestion, IStatusHandler statusHandlerExtension) {
        IStatus status;
        block16: {
            status = Status.OK_STATUS;
            if (this.getCurrentPatient() != null) {
                try {
                    try {
                        HashSet<XBilledRessource> setBR = new HashSet<XBilledRessource>();
                        for (XBillingRessource x : this.lstBillingRessources) {
                            boolean hasPaid = false;
                            if (x.billedRessource == null) continue;
                            for (XBilledRessourcePaid xPaid : x.billedRessource.lstBilledRessourcePaid) {
                                if (!xPaid.isDirty()) continue;
                                xPaid.setTag();
                                hasPaid = true;
                            }
                            if (!hasPaid && !x.billedRessource.isDirty()) continue;
                            x.billedRessource.setTag();
                            setBR.add(x.billedRessource);
                        }
                        if (setBR.size() <= 0) break block16;
                        ArrayList lstBR = new ArrayList(setBR);
                        XObjectContainer xObjectContainer = new XObjectContainer(lstBR);
                        ReturnObject ret = null;
                        try {
                            ret = RessourceAccessorClient.getInstance().saveSync(this.hashCode(), Application.get().getGlobalInstances().getSession(), (Serializable)xObjectContainer, askQuestion);
                            status = ret.getStatus();
                        }
                        catch (CannotConnectToServerException e) {
                            status = new Status(IStatus.Severity.ERROR, "CannotConnectToServer", (Throwable)e);
                            MessageUtil.cannotConnectToServerExceptionMsg();
                        }
                        catch (Exception e) {
                            status = new Status(IStatus.Severity.ERROR, "save exception", (Throwable)e);
                            logger.log(Level.WARNING, "Failed to save", e);
                        }
                        if (status.isOkToProceed()) {
                            if (ret != null && ret.getObj() != null && (e = (IMinimalEditableDataObject)ret.getObj()) instanceof XObjectContainer) {
                                XObjectContainer ee = (XObjectContainer)e;
                                for (IMinimalEditableDataObject xe : ee.getObjects()) {
                                    XBilledRessource x = (XBilledRessource)xe;
                                    for (XBillingRessource xblr : this.lstBillingRessources) {
                                        if (x.getTag() == null || !x.getTag().equals(xblr.getBilledRessource().getTag())) continue;
                                        xblr.billedRessource = x;
                                    }
                                }
                            }
                            MessageDialog.openInformation((Shell)UI.getWorkbenchShell().getShell(), (String)Messages.getString((String)"FACTURATION", (String[])new String[0]), (String)Messages.getString((String)"PMT_CONFIRME", (String[])new String[0]));
                        }
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                finally {
                    if (monitor != null) {
                        monitor.done();
                    }
                }
            }
        }
        return status;
    }

    public IStatus billAll(IProgressMonitor monitor, boolean askQuestion, IStatusHandler statusHandlerExtension) {
        IStatus status = Status.OK_STATUS;
        Integer nullIdProf = new Integer(-1000);
        BigDecimal ZERO = new BigDecimal(0);
        Long now = DateUtil.now();
        if (this.getCurrentPatient() != null) {
            try {
                try {
                    ArrayList<XBilledRessource> lstBR = new ArrayList<XBilledRessource>();
                    HashSet<Integer> setIdProf = new HashSet<Integer>();
                    for (XBillingRessource x : this.lstBillingRessources) {
                        if (x.getBilledRessource() != null) continue;
                        if (x.getIdProfessionnalAnchor() != null) {
                            setIdProf.add(x.getIdProfessionnalAnchor());
                            continue;
                        }
                        setIdProf.add(nullIdProf);
                    }
                    HashMap mapProfListXBilling = new HashMap();
                    for (XBillingRessource x : this.lstBillingRessources) {
                        Integer idProf;
                        if (x.getBilledRessource() != null) continue;
                        Integer n = idProf = x.getIdProfessionnalAnchor() == null ? nullIdProf : x.getIdProfessionnalAnchor();
                        if (mapProfListXBilling.containsKey(idProf)) {
                            ((List)mapProfListXBilling.get(idProf)).add(x);
                            continue;
                        }
                        ArrayList<XBillingRessource> lstProf = new ArrayList<XBillingRessource>();
                        lstProf.add(x);
                        mapProfListXBilling.put(idProf, lstProf);
                    }
                    for (Integer i : mapProfListXBilling.keySet()) {
                        Integer profId;
                        XBilledRessource b = new XBilledRessource();
                        b.initialize();
                        b.setTag();
                        b.idProfessionnalAnchor = profId = i.equals(nullIdProf) ? null : i;
                        List lst = (List)mapProfListXBilling.get(i);
                        BigDecimal fact_total = new BigDecimal(0);
                        BigDecimal fact_grand_total = new BigDecimal(0);
                        BigDecimal fact_taxes_total = new BigDecimal(0);
                        for (XBillingRessource xx : lst) {
                            if (!XRessourceUnit.ITEM.equals((Object)xx.getRessourceDefData().getUnit())) {
                                xx.setDateTimeEnd(now);
                            }
                            xx.setBilledRessource(b);
                            b.addBillingRessource(xx);
                            b.idPatientAnchor = xx.idPatientAnchor;
                            xx.setTag();
                            for (XBillingRessourceData xbrd : xx.getBillingRessourceDatas()) {
                                if (Boolean.TRUE.equals(xbrd.getIsDeleted())) continue;
                                BigDecimal escPrix = new BigDecimal(0);
                                if (ZERO.compareTo(xbrd.getEscompte()) < 0) {
                                    escPrix = xbrd.getPrix().multiply(xbrd.getEscompte());
                                }
                                BigDecimal prix = xbrd.getPrix().subtract(escPrix);
                                for (XBillingRessourceDataTaxe brdt : xbrd.billingRessourceDataTaxes) {
                                    if (ZERO.compareTo(brdt.getTaux()) >= 0) continue;
                                    BigDecimal prixTx = prix.multiply(brdt.getTaux());
                                    fact_taxes_total = fact_taxes_total.add(prixTx);
                                }
                                fact_total = fact_total.add(prix);
                                fact_grand_total = fact_total.add(fact_taxes_total);
                                xbrd.setTag();
                            }
                        }
                        fact_grand_total = fact_grand_total.setScale(2, 4);
                        b.setGrandTotal(fact_grand_total);
                        b.setSolde(b.getGrandTotal());
                        lstBR.add(b);
                    }
                    if (lstBR.size() > 0) {
                        XObjectContainer xObjectContainer = new XObjectContainer(lstBR);
                        ReturnObject ret = null;
                        try {
                            ret = RessourceAccessorClient.getInstance().saveSync(this.hashCode(), Application.get().getGlobalInstances().getSession(), (Serializable)xObjectContainer, askQuestion);
                            status = ret.getStatus();
                        }
                        catch (CannotConnectToServerException e) {
                            status = new Status(IStatus.Severity.ERROR, "CannotConnectToServer", (Throwable)e);
                            MessageUtil.cannotConnectToServerExceptionMsg();
                        }
                        catch (Exception e) {
                            status = new Status(IStatus.Severity.ERROR, "save exception", (Throwable)e);
                            logger.log(Level.WARNING, "Failed to save", e);
                        }
                        if (status.isOkToProceed() && ret != null && ret.getObj() != null && (e = (IMinimalEditableDataObject)ret.getObj()) instanceof XObjectContainer) {
                            XObjectContainer ee = (XObjectContainer)e;
                            XBilledRessource x = null;
                            for (IMinimalEditableDataObject xe : ee.getObjects()) {
                                x = (XBilledRessource)xe;
                                int i = 0;
                                while (i < this.lstBillingRessources.size()) {
                                    XBillingRessource xb = this.lstBillingRessources.get(i);
                                    if (xb.getBilledRessource() != null && xb.getBilledRessource().getTag() != null && xb.getBilledRessource().getTag().equals(x.getTag())) {
                                        XRessourceDefData ressourceDefData = xb.ressourceDefData;
                                        IEditableDataObjectList lstBillingRessource = x.lstBillingRessource;
                                        for (XBillingRessource xbr : lstBillingRessource) {
                                            if (xbr.getTag() == null || !xbr.getTag().equals(xb.getTag())) continue;
                                            xbr.ressourceDefData = ressourceDefData;
                                        }
                                        xb.billedRessource = x;
                                    }
                                    ++i;
                                }
                            }
                        }
                    }
                    if (monitor != null) {
                        monitor.done();
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            finally {
                if (monitor != null) {
                    monitor.done();
                }
            }
        }
        return status;
    }

    public boolean hasBillingRessourceReadyToSave() {
        boolean somethingToSave = false;
        for (XBillingRessource x : this.lstBillingRessources) {
            if (!x.isUpdated() && !x.isNewOrNewUpdated() && !x.isChildrenUpdated()) continue;
            somethingToSave = true;
            break;
        }
        return somethingToSave;
    }

    public boolean hasBilledRessourceReadyToSave() {
        boolean somethingToSave = false;
        for (XBillingRessource x : this.lstBillingRessources) {
            if (x.billedRessource == null || !x.billedRessource.isDirty()) continue;
            somethingToSave = true;
            break;
        }
        return somethingToSave;
    }

    public void cancel() {
        Log.logOperation((String)"BillingRessourceController.cancel", (Object[])new Object[0]);
        this.setBillingRessource(null);
    }

    public String format(boolean includeDate, boolean includeProfessional) {
        XBillingRessource billingRessource = this.getBillingRessource();
        if (billingRessource != null && billingRessource.getPatient() != null) {
            return billingRessource.getPatient().getNameBirthdateSex();
        }
        return "";
    }

    public Integer getVersion() {
        return this.getBillingRessource() == null ? null : this.getBillingRessource().getVersion();
    }

    public boolean isDirty() {
        XBillingRessource billingRessource = this.getBillingRessource();
        return billingRessource != null && billingRessource.isDirty();
    }

    public Integer getId() {
        return this.getBillingRessource() == null ? null : this.getBillingRessource().getId();
    }

    public ModificationStatus getModificationStatus() {
        return this.getBillingRessource() == null ? null : this.getBillingRessource().getModificationStatus();
    }

    public Long getDateTimeStart() {
        return this.getBillingRessource() == null ? null : this.getBillingRessource().getDateTimeStart();
    }

    public Integer getIdProfessionnalAnchor() {
        return this.getBillingRessource() == null ? null : this.getBillingRessource().getIdProfessionnalAnchor();
    }

    public final boolean isDeleted() {
        return this.getBillingRessource() == null ? false : this.getBillingRessource().isStatusDeleted();
    }

    public void setId(Integer id) {
        if (this.getBillingRessource() != null) {
            this.getBillingRessource().setId(id);
        }
    }

    public void setIsDeleted(Boolean isDeleted) {
        if (this.getBillingRessource() != null && Boolean.TRUE.equals(isDeleted)) {
            this.getBillingRessource().setDeleted();
        }
    }

    public void setListenerEnabled(boolean enable) {
        if (this.getBillingRessource() != null) {
            this.getBillingRessource().setListenerEnabled(enable);
        }
    }

    public void setDateTimeStart(Long dateTimeStart) {
        if (this.getBillingRessource() != null) {
            this.getBillingRessource().setDateTimeStart(dateTimeStart);
        }
    }

    public void setAutoRepeat(Boolean autoRepeat) {
        if (this.getBillingRessource() != null) {
            this.getBillingRessource().setAutoRepeat(autoRepeat);
        }
    }

    public void addListener(IBillingRessourceControllerListener listener) {
        this.manager.addListener((Object)listener);
    }

    public void removeListener(IBillingRessourceControllerListener listener) {
        this.manager.removeListener((Object)listener);
    }

    public void dispose() {
        ObjectListenerManager.removeListener((IObjectListener)this);
    }

    public XBillingRessource getBillingRessource() {
        return this.currentBillingRessource;
    }

    public XBilledRessource getBilledRessource() {
        return this.currentBilledRessource;
    }

    public void setSite(XSite site) {
        if (this.getBillingRessource() != null) {
            this.getBillingRessource().setIdSite(site == null ? null : site.getId());
        }
    }

    public XSite getSite() {
        if (this.getBillingRessource() == null) {
            return SitePlugin.getDefault().getContextSite();
        }
        return SitePlugin.getDefault().getSite(this.getBillingRessource().getIdSite());
    }

    public String toString() {
        return String.format("AppointmentController [billingRessource=%s]", this.getBillingRessource());
    }

    public XPatient getCurrentPatient() {
        return this.currentPatient;
    }

    public void setPatient(XPatient currentPatient) {
        this.setCurrentPatient(currentPatient);
        this.proxy.patientChanged();
    }

    public void setCurrentPatient(XPatient currentPatient) {
        this.currentPatient = currentPatient;
    }

    public XBillingRessource addNewBillingRessource(XRessourceDefData rdd) {
        if (this.getCurrentPatient() == null) {
            MessageDialog.openError((Shell)UI.getWorkbenchShell().getShell(), (String)"Patient", (String)"Vous devez avoir s\u00e9lectionn\u00e9 un patient auparavant");
            return null;
        }
        if (rdd == null) {
            MessageDialog.openError((Shell)UI.getWorkbenchShell().getShell(), (String)"Ressource", (String)"Vous devez avoir s\u00e9lectionn\u00e9 une ressource auparavant");
            return null;
        }
        XBillingRessource x = new XBillingRessource();
        x.initialize();
        x.setPatient(this.getCurrentPatient());
        Long now = DateUtil.now();
        x.setDateTimeStart(now);
        x.setIdSite(this.currentSite.getId());
        if (rdd.getRessourceDef().getServiceType().contains(XServiceType.DISPENSATEUR)) {
            if (rdd.getIdProfessionnalAnchor() != null) {
                x.setIdProfessionnalAnchor(rdd.getIdProfessionnalAnchor());
            } else if (this.currentProfessionnal != null) {
                x.setIdProfessionnalAnchor(this.currentProfessionnal.getId());
            } else {
                XBaseProfessionnal prof = PersonUiPlugin.getDefault().getSessionProfessionnal();
                if (prof != null) {
                    x.setIdProfessionnalAnchor(prof.getId());
                } else if (lastUsedProf != null) {
                    x.setIdProfessionnalAnchor(lastUsedProf);
                }
            }
        }
        x.setNbOrdered(new Integer(1));
        x.setRessourceDefData(rdd);
        XBillingRessourceData xd = new XBillingRessourceData();
        xd.initialize();
        xd.setBillingRessource(x);
        xd.setCreatedDatetime(now);
        xd.setEscompte(new BigDecimal(0));
        xd.setPrix(rdd.getPrixBaseInitial().add(rdd.getPrixParUnit()));
        if (rdd.ressourceDef.taxeDef != null) {
            for (XTaxeDefData xtdd : rdd.ressourceDef.taxeDef.lstTaxeDefData) {
                XBillingRessourceDataTaxe xbrdt = new XBillingRessourceDataTaxe();
                xbrdt.initialize();
                xbrdt.billingRessourceData = xd;
                xbrdt.nameEn = xtdd.getNameEn();
                xbrdt.nameFr = xtdd.getNameFr();
                xbrdt.taux = xtdd.getTaux();
                xd.billingRessourceDataTaxes.add((IMinimalEditableDataObject)xbrdt);
            }
        }
        x.billingRessourceDatas.add((IMinimalEditableDataObject)xd);
        this.lstBillingRessources.add(x);
        this.proxy.billingRessourceChanged();
        this.setBillingRessource(x);
        return x;
    }

    public XPatient addNewPatient() {
        Integer site;
        XBillingRessource billingRessource = this.getBillingRessource();
        Integer n = site = billingRessource == null ? null : billingRessource.getIdSite();
        if (site == null) {
            site = SitePlugin.getDefault().getContextSite().getId();
        }
        XPatient patient = new XPatient();
        XPersonSite ps = new XPersonSite();
        ps.setIdSite(site);
        ps.setAddedAs(SiteAddedAs.WORK_SITE);
        ps.setNew();
        patient.getLstSites().add((IMinimalEditableDataObject)ps);
        patient.setNew();
        this.setPatient(patient);
        return patient;
    }

    public void replacePatient(XPatient simplePatient) {
    }

    public final List<XBillingRessource> getActiveLstBillingRessources() {
        ArrayList<XBillingRessource> lstModel = new ArrayList<XBillingRessource>();
        for (XBillingRessource xbr : this.lstBillingRessources) {
            if (xbr.id != null || xbr.billedRessource != null || xbr.isStatusDeleted() || xbr.isNonExisting()) continue;
            lstModel.add(xbr);
        }
        return lstModel;
    }

    public final List<XBillingRessource> getLstBillingRessources() {
        return this.lstBillingRessources;
    }

    public final void setLstBillingRessources(List<XBillingRessource> lstBillingRessources) {
        this.lstBillingRessources = lstBillingRessources;
    }

    public final XBillingRessource getCurrentBillingRessource() {
        return this.currentBillingRessource;
    }

    public final void setCurrentBillingRessource(XBillingRessource currentBillingRessource) {
        this.currentBillingRessource = currentBillingRessource;
    }

    public final XBilledRessource getCurrentBilledRessource() {
        return this.currentBilledRessource;
    }

    public final void setCurrentBilledRessource(XBilledRessource currentBilledRessource) {
        this.currentBilledRessource = currentBilledRessource;
    }

    public final XSite getCurrentSite() {
        return this.currentSite;
    }

    public final void setCurrentSite(XSite currentSite) {
        this.currentSite = currentSite;
    }

    public final XBaseProfessionnal getCurrentProfessionnal() {
        return this.currentProfessionnal;
    }

    public final void setCurrentProfessionnal(XBaseProfessionnal currentProfessionnal) {
        this.currentProfessionnal = currentProfessionnal;
    }

    public boolean validPatientChange(XPatient patient) {
        boolean canChange = true;
        if (!MiscUtil.areObjectsEquals((Object)this.currentPatient, (Object)patient) && this.lstBillingRessources.size() > 0) {
            for (XBillingRessource x : this.lstBillingRessources) {
                if (!x.isUpdated() && !x.isNewOrNewUpdated() && (x.billedRessource == null || !x.billedRessource.isDirty())) continue;
                canChange = false;
                break;
            }
        }
        return canChange;
    }

    public final IBillingRessourceControllerListener getProxy() {
        return this.proxy;
    }

    public void objectModified(Object object) {
        if (object instanceof XBillingRessourceData) {
            XBillingRessourceData a = (XBillingRessourceData)object;
            this.getBillingRessource().modificationStatus.set((Object)ModificationStatusManager.modifyStatus((ModificationStatus)((ModificationStatus)a.billingRessource.modificationStatus.get()), (ModificationStatus)ModificationStatus.STATUS_CHILDREN_UPDATED));
            this.proxy.billingRessourceModified();
        }
    }

    public static interface IBillingRessourceControllerListener {
        public void billedRessourceChanged();

        public void billingRessourceChanged();

        public void billingRessourceModified();

        public void patientChanged();

        public void patientModified();
    }
}

