/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.ressource.editor;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.BaseAccessorClient;
import ca.infodata.ofys.data.dataaccess.CannotConnectToServerException;
import ca.infodata.ofys.data.dataaccess.DelegateSearchTextAccessor;
import ca.infodata.ofys.data.dataaccess.ICallback;
import ca.infodata.ofys.data.dataaccess.ISearchTextAccessor;
import ca.infodata.ofys.data.dataaccess.PatientAccessorClient;
import ca.infodata.ofys.data.dataaccess.RessourceAccessorClient;
import ca.infodata.ofys.data.dataaccess.callback.IStatusHandler;
import ca.infodata.ofys.data.dataaccess.callback.JobCallback;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.XPatient;
import ca.infodata.ofys.data.middle.dataobjects.XPatientListText;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.EditableDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.data.middle.dataobjects.service.XBillCriteria;
import ca.infodata.ofys.data.middle.dataobjects.service.XBillingRessource;
import ca.infodata.ofys.data.middle.dataobjects.service.XRessourceDefData;
import ca.infodata.ofys.data.middle.dataobjects.site.XSite;
import ca.infodata.ofys.mb.listener.object.IObjectListener;
import ca.infodata.ofys.mb.listener.object.ObjectListenerManager;
import ca.infodata.ofys.mb.listener.property.PropertyListenerManager;
import ca.infodata.ofys.status.IStatus;
import ca.infodata.ofys.status.Status;
import ca.infodata.ofys.ui.controls.EditorModifyListener;
import ca.infodata.ofys.ui.controls.FontAwareComposite;
import ca.infodata.ofys.ui.controls.FontAwareGroup;
import ca.infodata.ofys.ui.controls.IBaseEditor;
import ca.infodata.ofys.ui.controls.IBaseEditor2;
import ca.infodata.ofys.ui.controls.form.IReferenceControl;
import ca.infodata.ofys.ui.controls.form.ISearchTextListener;
import ca.infodata.ofys.ui.controls.form.MyButton;
import ca.infodata.ofys.ui.controls.form.MyLabel;
import ca.infodata.ofys.ui.controls.form.MyList;
import ca.infodata.ofys.ui.controls.form.MySearchText;
import ca.infodata.ofys.ui.library.IRefreshFont;
import ca.infodata.ofys.ui.library.ResourceGetter;
import ca.infodata.ofys.ui.library.UI;
import ca.infodata.ofys.ui.library.log.Log;
import ca.infodata.ofys.ui.person.patient.PatientSearchText;
import ca.infodata.ofys.ui.person.search.PatientSearchComposite;
import ca.infodata.ofys.ui.person.search.ProfessionnalSearchComposite;
import ca.infodata.ofys.ui.person.simple.IPatientController;
import ca.infodata.ofys.ui.person.simple.PatientController;
import ca.infodata.ofys.ui.ressource.BillingRessourceFormatter;
import ca.infodata.ofys.ui.ressource.FakeEditor;
import ca.infodata.ofys.ui.ressource.RessourceSearchText;
import ca.infodata.ofys.ui.ressource.editor.BillingRessourceControl;
import ca.infodata.ofys.ui.ressource.editor.BillingRessourceController;
import ca.infodata.ofys.ui.ressource.editor.BillingSimplePatientControl;
import ca.infodata.ofys.ui.ressource.search.RessourceDefDataSearchComposite;
import ca.infodata.ofys.ui.site.ContextSiteProvider;
import ca.infodata.ofys.ui.site.WorkSiteCombo;
import ca.infodata.util1.ProviderAR;
import ca.infodata.util1.ProviderR;
import ca.infodata.util1.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.util.Util;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class BillingEditionControl
implements IRefreshFont,
BillingRessourceController.IBillingRessourceControllerListener,
ContextSiteProvider {
    private static final Logger logger = Logger.getLogger(BillingEditionControl.class.getName());
    private static final String AUCUN_TROUVE = Messages.getString((String)"AUCUNE_RESSOURCE_TROUVE", (String[])new String[0]);
    private static final String RECHERCHE = Messages.getString((String)"RECHERCHE", (String[])new String[0]);
    private static final String RAPPELS_RDV = Messages.getString((String)"RAPPELS_RDV", (String[])new String[0]);
    private static final String FERMER = Messages.getString((String)"CLOSE", (String[])new String[0]);
    private static final String BILLS = Messages.getString((String)"FACTURE", (String[])new String[0]);
    private final Integer id;
    private MyList<XBillingRessource> myListBillingRessource;
    public MyLabel lblRessourceNotFoundText;
    private RessourceSearchText txtRessourceDefData;
    private PatientSearchText txtPatient;
    private BillingSimplePatientControl patientControl;
    private BillingRessourceControl billingRessourceControl;
    public FontAwareGroup grpShowRight;
    public MyButton btnShowRightSearch;
    public MyButton btnShowRightBilled;
    public MyButton btnShowRightAppt;
    public MyButton btnShowRightNil;
    private WorkSiteCombo siteCombo;
    private FakeEditor fakeEditor;
    private BillingRessourceController controller;
    private boolean guiCreated = false;
    private FormToolkit toolkit;
    private FontAwareComposite main;
    private ProviderR<RessourceDefDataSearchComposite> ressourceDefDataSearchProvider;
    private ProviderR<PatientSearchComposite> patientSearchProvider;
    private ProviderR<ProfessionnalSearchComposite> professionalSearchProvider;
    private Color white;
    private TabFolder tabFolder;
    private TabItem tabPatient;
    private final Runnable refresh = new Runnable(){

        @Override
        public void run() {
            BillingEditionControl.this.refresh();
        }
    };
    private IReferenceControl listRessourceDefDataReferenceControl;
    private IReferenceControl listPatientReferenceControl;

    public BillingEditionControl() {
        this.id = System.identityHashCode(this);
    }

    public void setController(BillingRessourceController newController) {
        Log.log((Logger)logger, (Level)Level.FINE, (String)"setController", (String[])new String[]{"newController"}, (Object[])new Object[]{newController});
        if (!this.guiCreated) {
            throw new IllegalStateException("gui must be created to set controller");
        }
        if (this.controller != null) {
            this.controller.removeListener(this);
        }
        this.controller = newController;
        if (this.controller != null) {
            this.controller.addListener(this);
        }
        PropertyListenerManager.firePropertyChanged((Object)this, (int)1);
        this.billingRessourceControl.setController(this.controller);
        this.refresh();
    }

    public BillingRessourceController getController() {
        return this.controller;
    }

    public IStatus doSave(IProgressMonitor monitor) {
        IStatus[] status = new IStatus[]{Status.OK_STATUS};
        if (this.getController() != null) {
            status[0] = this.getController().save(monitor, true, new StatusHandlerExtension());
        }
        if (status[0] == null) {
            status[0] = Status.OK_STATUS;
        }
        return status[0];
    }

    public IStatus doBillAll(IProgressMonitor monitor) {
        IStatus[] status = new IStatus[]{Status.OK_STATUS};
        if (this.getController() != null) {
            status[0] = this.getController().billAll(monitor, true, new StatusHandlerExtension());
        }
        if (status[0] == null) {
            status[0] = Status.OK_STATUS;
        }
        return status[0];
    }

    public IStatus doConfirmPayment(IProgressMonitor monitor) {
        IStatus[] status = new IStatus[]{Status.OK_STATUS};
        if (this.getController() != null) {
            status[0] = this.getController().doConfirmPayment(monitor, true, new StatusHandlerExtension());
        }
        if (status[0] == null) {
            status[0] = Status.OK_STATUS;
        }
        return status[0];
    }

    public IStatus doCancel(IProgressMonitor monitor) {
        if (this.getController() != null) {
            this.getController().cancel();
        }
        return Status.OK_STATUS;
    }

    public boolean isDirty() {
        return this.getController().isDirty();
    }

    public void createPartControl(Composite parent) {
        this.main = new FontAwareComposite(parent, 0);
        this.toolkit = UI.createToolKit((Widget)this.main);
        this.white = ResourceGetter.getColor((int)255, (int)255, (int)255);
        int macAdjust = Util.isMac() ? 0 : -5;
        this.grpShowRight = new FontAwareGroup((Composite)this.main, 32);
        this.grpShowRight.setSize(116 - macAdjust, 87 - macAdjust * 3);
        this.grpShowRight.setBackground(this.white);
        this.grpShowRight.setBackgroundMode(1);
        this.btnShowRightSearch = new MyButton((Composite)this.grpShowRight, String.valueOf(RECHERCHE) + "...", 16, this.toolkit);
        this.btnShowRightSearch.setData("do", (Object)"search");
        this.btnShowRightBilled = new MyButton((Composite)this.grpShowRight, BILLS, 16, this.toolkit);
        this.btnShowRightBilled.setData("text", (Object)"Factures");
        this.btnShowRightBilled.setData("do", (Object)"billed");
        this.btnShowRightAppt = new MyButton((Composite)this.grpShowRight, RAPPELS_RDV, 16, this.toolkit);
        this.btnShowRightAppt.setData("text", (Object)RAPPELS_RDV);
        this.btnShowRightAppt.setData("do", (Object)"appt");
        this.btnShowRightNil = new MyButton((Composite)this.grpShowRight, FERMER, 16, this.toolkit);
        this.btnShowRightNil.setData("do", (Object)"nil");
        FillLayout grpLayout = new FillLayout(512);
        this.grpShowRight.setLayout((Layout)grpLayout);
        this.siteCombo = new WorkSiteCombo((Composite)this.main, 4096, this.toolkit);
        MyLabel lblFacturesOuvertes = new MyLabel((Composite)this.main, Messages.getString((String)"SERVICES_COURANTS", (String[])new String[0]), 0, this.toolkit);
        this.myListBillingRessource = new MyList((Composite)this.main, 2816);
        this.fakeEditor = new FakeEditor(this.myListBillingRessource);
        this.myListBillingRessource.setLabelProvider((ProviderAR)new ProviderAR<XBillingRessource, String>(){

            public String get(XBillingRessource p) {
                String n = "";
                if (p.getId() == null || p.isUpdated() || p.isChildrenUpdated()) {
                    n = "* ";
                }
                return String.valueOf(n) + BillingRessourceFormatter.format(p);
            }
        });
        this.myListBillingRessource.setComparator((Comparator)new Comparator<XBillingRessource>(){

            @Override
            public int compare(XBillingRessource o1, XBillingRessource o2) {
                return o2.getDateTimeStart().compareTo(o1.getDateTimeStart());
            }
        });
        this.lblRessourceNotFoundText = new MyLabel((Composite)this.main, AUCUN_TROUVE, 0x1000000, this.toolkit);
        this.lblRessourceNotFoundText.setFont(1, 1);
        Color red = ResourceGetter.getColor((int)255, (int)0, (int)0);
        ResourceGetter.linkResourceWithWidgetLife((Object)red, (Widget)this.lblRessourceNotFoundText.getControl());
        this.lblRessourceNotFoundText.setForeground(red);
        this.lblRessourceNotFoundText.setVisible(false);
        this.txtRessourceDefData = new RessourceSearchText((Composite)this.main, 172032, this.toolkit){

            @Override
            protected void showRessourceSearch() {
                RessourceDefDataSearchComposite search = (RessourceDefDataSearchComposite)((Object)BillingEditionControl.this.ressourceDefDataSearchProvider.get());
                search.setReferenceControl(BillingEditionControl.this.listRessourceDefDataReferenceControl);
                String text = BillingEditionControl.this.txtRessourceDefData.getMyText().getText();
                if (StringUtils.isNotBlank((String)text)) {
                    search.setSearchText(text);
                }
                search.setFocus();
            }
        };
        this.txtRessourceDefData.setSearchTextAccessor((ISearchTextAccessor)new DelegateSearchTextAccessor(RessourceAccessorClient.class));
        this.txtRessourceDefData.setSpecialSearchCase(1);
        this.txtRessourceDefData.setSearchOnFocusLost(false);
        this.txtRessourceDefData.getMyText().setMessage("#" + Messages.getString((String)"CODE_OU_NOM", (String[])new String[0]));
        this.txtRessourceDefData.setGroup(this.id);
        this.billingRessourceControl = new BillingRessourceControl((Composite)this.main, this.toolkit, this.fakeEditor){

            @Override
            public ProfessionnalSearchComposite getProfessionnalSearch() {
                ProfessionnalSearchComposite professionnalSearch = (ProfessionnalSearchComposite)BillingEditionControl.this.professionalSearchProvider.get();
                if (professionnalSearch != null) {
                    professionnalSearch.setSelectionReferenceControl((Object)BillingEditionControl.this.billingRessourceControl.getTxtTreatingProfessionnal());
                }
                return professionnalSearch;
            }
        };
        this.tabFolder = new TabFolder((Composite)this.main, 256);
        this.tabPatient = new TabItem(this.tabFolder, -1);
        this.tabPatient.setText("Patient");
        Composite tabPatientControl = this.toolkit.createComposite((Composite)this.tabFolder, 0);
        this.tabPatient.setControl((Control)tabPatientControl);
        this.txtPatient = new PatientSearchText(tabPatientControl, 172032, this.toolkit){

            protected void showPatientSearch() {
                PatientSearchComposite search = (PatientSearchComposite)BillingEditionControl.this.patientSearchProvider.get();
                search.setReferenceControl((Object)BillingEditionControl.this.listPatientReferenceControl);
                String text = BillingEditionControl.this.txtPatient.getMyText().getText();
                if (StringUtils.isNotBlank((String)text)) {
                    search.setSearchText(text);
                }
                search.setFocus();
            }
        };
        this.txtPatient.setSearchTextAccessor((ISearchTextAccessor)new DelegateSearchTextAccessor(PatientAccessorClient.class));
        this.txtPatient.setSpecialSearchCase(1);
        this.txtPatient.setSearchOnFocusLost(false);
        this.txtPatient.getMyText().setMessage(Messages.getString((String)"NOMPRENOMNO_DE_DOSSIER", (String[])new String[0]));
        this.txtPatient.setGroup((Object)this.id);
        this.patientControl = new BillingSimplePatientControl(tabPatientControl, this.toolkit, (IBaseEditor)this.fakeEditor){

            public ProfessionnalSearchComposite getProfessionnalSearch() {
                ProfessionnalSearchComposite professionnalSearch = (ProfessionnalSearchComposite)BillingEditionControl.this.professionalSearchProvider.get();
                if (professionnalSearch != null) {
                    professionnalSearch.setSelectionReferenceControl((Object)BillingEditionControl.this.patientControl.getTxtTreatingProfessionnal());
                }
                return professionnalSearch;
            }
        };
        this.patientControl.setEnabled(false);
        this.patientControl.setController((IPatientController)new PatientController((ProviderR)new ProviderR<XPatient>(){

            public XPatient get() {
                return BillingEditionControl.this.getController().getCurrentPatient();
            }
        }));
        tabPatientControl.setTabList(new Control[]{this.txtPatient, this.patientControl});
        FormLayout layout2 = new FormLayout();
        layout2.marginHeight = 3;
        layout2.marginWidth = 3;
        layout2.spacing = 1;
        tabPatientControl.setLayout((Layout)layout2);
        FormData data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        this.txtPatient.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.txtPatient.getControl(), -13);
        data.left = new FormAttachment(0);
        Point defPt = this.patientControl.computeSize(-1, -1);
        data.height = defPt.y;
        data.right = new FormAttachment(100);
        this.patientControl.setLayoutData(data);
        FormLayout layout = new FormLayout();
        int marge = 3;
        int iSiteComboPc = 25;
        layout.marginHeight = marge;
        layout.marginWidth = marge;
        layout.spacing = 1;
        this.main.setLayout((Layout)layout);
        data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(iSiteComboPc);
        this.siteCombo.getControl().setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.siteCombo.getControl());
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(iSiteComboPc);
        lblFacturesOuvertes.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(lblFacturesOuvertes.getControl());
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(iSiteComboPc);
        data.height = 220;
        this.myListBillingRessource.getControl().setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(this.myListBillingRessource.getControl());
        data.right = new FormAttachment((Control)this.grpShowRight);
        this.txtRessourceDefData.getControl().setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.txtRessourceDefData.getControl(), -1);
        data.left = new FormAttachment(this.myListBillingRessource.getControl());
        data.right = new FormAttachment((Control)this.grpShowRight);
        data.bottom = new FormAttachment(this.myListBillingRessource.getControl(), 0, 1024);
        this.billingRessourceControl.setLayoutData(data);
        data = new FormData();
        data.top = new FormAttachment(this.txtRessourceDefData.getControl(), -2);
        data.left = new FormAttachment(this.myListBillingRessource.getControl());
        data.right = new FormAttachment((Control)this.grpShowRight);
        this.lblRessourceNotFoundText.getControl().setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(0);
        data.right = new FormAttachment(100);
        this.grpShowRight.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.myListBillingRessource.getControl(), 5);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        data.bottom = new FormAttachment(100);
        this.tabFolder.setLayoutData((Object)data);
        this.createEvents();
        this.main.pack();
        this.toolkit.adapt((Composite)this.main);
        this.guiCreated = true;
    }

    private void createEvents() {
        this.myListBillingRessource.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                XBillingRessource selection = (XBillingRessource)BillingEditionControl.this.myListBillingRessource.getSelection3();
                BillingEditionControl.this.getController().setCurrentBillingRessource(selection);
                BillingEditionControl.this.setBillingRessource(selection);
            }
        });
        this.myListBillingRessource.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                if ((e.keyCode == 127 || e.keyCode == 8) && BillingEditionControl.this.myListBillingRessource.getSelectionCount() > 0) {
                    BillingEditionControl.this.deleteBillingRessourceFromGroup(BillingEditionControl.this.myListBillingRessource.getSelectionIndices());
                }
            }
        });
        this.listRessourceDefDataReferenceControl = new TxtRessourceDefDataReferenceControl();
        this.txtRessourceDefData.setReferenceControl(this.listRessourceDefDataReferenceControl);
        this.txtRessourceDefData.addSearchTextListener(new ISearchTextListener(){

            public void objectReceived(IDataObject o) {
                System.out.println(o);
            }
        });
        this.txtRessourceDefData.getMyText().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (UI.CR((KeyEvent)e)) {
                    BillingEditionControl.this.txtRessourceDefData.doSearch();
                }
            }
        });
        this.txtRessourceDefData.getBtnSearch().addSelectionListener((SelectionListener)new EditorModifyListener((IBaseEditor2)this.fakeEditor){

            public void edited(Event e) {
                RessourceDefDataSearchComposite ressourceDefDataSearch = (RessourceDefDataSearchComposite)((Object)BillingEditionControl.this.ressourceDefDataSearchProvider.get());
                ressourceDefDataSearch.setReferenceControl(BillingEditionControl.this.listRessourceDefDataReferenceControl);
                ressourceDefDataSearch.setFocus();
            }
        });
        this.listPatientReferenceControl = new TxtPatientReferenceControl();
        this.txtPatient.setReferenceControl(this.listPatientReferenceControl);
        this.txtPatient.addSearchTextListener(new ISearchTextListener(){

            public void objectReceived(IDataObject o) {
                boolean ok = BillingEditionControl.this.getController().validPatientChange((XPatient)o);
                IStatus s = null;
                if (!ok) {
                    s = BillingEditionControl.this.doSave(null);
                }
                if (s == null || s.isOK()) {
                    BillingEditionControl.this.getController().setPatient((XPatient)o);
                    BillingEditionControl.this.txtPatient.getMyText().clear();
                    BillingEditionControl.this.refresh();
                }
            }
        });
        this.txtPatient.getMyText().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (UI.CR((KeyEvent)e)) {
                    BillingEditionControl.this.txtPatient.doSearch();
                }
            }
        });
        this.siteCombo.addListener(13, (Listener)new EditorModifyListener((IBaseEditor2)this.fakeEditor){

            public void edited(Event e) {
                BillingEditionControl.this.getController().setSite(BillingEditionControl.this.siteCombo.getSelection());
                BillingEditionControl.this.getController().getBillingRessource().setIdSite(BillingEditionControl.this.getController().getSite().getId());
            }
        });
    }

    protected void deleteBillingRessourceFromGroup(int[] selectionIndices) {
        if (selectionIndices.length > 0) {
            ArrayList<XBillingRessource> lstToDelete = new ArrayList<XBillingRessource>();
            for (XBillingRessource xx : this.myListBillingRessource.getSelection2()) {
                lstToDelete.add(xx);
            }
            for (XBillingRessource b : lstToDelete) {
                b.setDeleted();
            }
            this.billingRessourceChanged();
            this.getController().setCurrentBillingRessource(null);
            this.setBillingRessource(null);
            this.txtRessourceDefData.getMyText().setFocus();
        }
    }

    private void openRessourceDefDataSearchView(XRessourceDefData[] array) {
        RessourceDefDataSearchComposite search = (RessourceDefDataSearchComposite)((Object)this.ressourceDefDataSearchProvider.get());
        search.setReferenceControl(this.listRessourceDefDataReferenceControl);
        search.setFocus();
        String text = this.txtRessourceDefData.getMyText().getText();
        if (StringUtils.isNotBlank((String)text)) {
            search.setSearchText(text);
            if (array == null) {
                search.doSearch();
            } else {
                search.searchResponse(array);
            }
        }
    }

    private void openPatientSearchView(XPatient[] array) {
        PatientSearchComposite search = (PatientSearchComposite)this.patientSearchProvider.get();
        search.setReferenceControl((Object)this.listPatientReferenceControl);
        search.setFocus();
        String text = this.txtPatient.getMyText().getText();
        if (StringUtils.isNotBlank((String)text)) {
            search.setSearchText(text);
            if (array == null) {
                search.doSearch();
            } else {
                search.searchResponse(array);
            }
        }
    }

    public void setFocus() {
        if (this.getController().getCurrentPatient() == null) {
            this.txtPatient.getControl().setFocus();
        } else {
            this.txtRessourceDefData.getControl().setFocus();
        }
    }

    public PatientSearchComposite getPatientSearch() {
        return (PatientSearchComposite)this.patientSearchProvider.get();
    }

    public ProfessionnalSearchComposite getProfessionnalSearch() {
        return (ProfessionnalSearchComposite)this.professionalSearchProvider.get();
    }

    public RessourceDefDataSearchComposite getRessourceDefDataSearch() {
        return (RessourceDefDataSearchComposite)((Object)this.ressourceDefDataSearchProvider.get());
    }

    public void setPatientSearchProvider(ProviderR<PatientSearchComposite> provider) {
        this.patientSearchProvider = provider;
    }

    public void setProfessionalSearchProvider(ProviderR<ProfessionnalSearchComposite> provider) {
        this.professionalSearchProvider = provider;
    }

    public void setRessourceDefDataSearchProvider(ProviderR<RessourceDefDataSearchComposite> provider) {
        this.ressourceDefDataSearchProvider = provider;
    }

    public void dispose() {
        ResourceGetter.dispose((Object)this.white);
    }

    public Control getControl() {
        return this.main;
    }

    public void refresh() {
        logger.fine("AppointmentEditionControl.refresh()");
        if (!this.guiCreated) {
            return;
        }
        this.fakeEditor.setIgnore(true);
        if (!this.getControl().isDisposed()) {
            this.fakeEditor.checkDirty();
            BillingRessourceController controller2 = this.getController();
            this.siteCombo.select(controller2.getSite());
            List<XBillingRessource> lstBillingRessources = this.controller.getLstBillingRessources();
            ArrayList<XBillingRessource> lstModel = new ArrayList<XBillingRessource>();
            for (XBillingRessource xbr : lstBillingRessources) {
                if (xbr.billedRessource != null || xbr.isStatusDeleted()) continue;
                lstModel.add(xbr);
            }
            this.myListBillingRessource.setItems(this.controller.getActiveLstBillingRessources());
            this.setBillingRessource(this.controller.getCurrentBillingRessource());
            this.myListBillingRessource.refresh();
        }
        this.fakeEditor.setIgnore(false);
    }

    private void setPatient(XPatient patient) {
        try {
            boolean hasPt;
            this.fakeEditor.setIgnore(true);
            this.patientControl.showDataObject();
            this.getController().getLstBillingRessources().clear();
            this.myListBillingRessource.removeAll();
            this.fillPatientBillingRessources();
            this.billingRessourceControl.setBillingRessource(null);
            this.billingRessourceControl.showDataObject();
            boolean bl = hasPt = patient != null;
            if (hasPt) {
                this.txtRessourceDefData.setFocus();
            } else {
                this.txtPatient.setFocus();
            }
        }
        finally {
            this.fakeEditor.setIgnore(false);
        }
    }

    private void setBillingRessource(XBillingRessource br) {
        this.billingRessourceControl.setBillingRessource(br);
        this.billingRessourceControl.showDataObject();
        this.billingRessourceControl.setEnabled(br != null);
    }

    @Override
    public void billingRessourceChanged() {
        if (this.main != null && !this.main.isDisposed()) {
            this.main.getDisplay().asyncExec(this.refresh);
        }
    }

    @Override
    public void billingRessourceModified() {
        System.out.println("billingRessourceModified called");
        if (this.main != null && !this.main.isDisposed()) {
            this.main.getDisplay().asyncExec(this.refresh);
        }
    }

    @Override
    public void billedRessourceChanged() {
        System.out.println("billedRessourceChanged called");
        if (this.main != null && !this.main.isDisposed()) {
            this.main.getDisplay().asyncExec(this.refresh);
        }
    }

    @Override
    public void patientChanged() {
        System.out.println("BillingEditionControl.patientChanged() patient = " + this.getController().getCurrentPatient());
        this.setPatient(this.getController().getCurrentPatient());
    }

    @Override
    public void patientModified() {
        System.out.println("BillingEditionControl.patientModified() patient = " + this.getController().getCurrentPatient());
    }

    public final RessourceSearchText getTxtRessourceDefData() {
        return this.txtRessourceDefData;
    }

    public MySearchText getTxtPatient() {
        return this.txtPatient;
    }

    public MySearchText getTxtTreatingProfessionnal() {
        return this.patientControl.getTxtTreatingProfessionnal();
    }

    public XSite getContextSite() {
        return this.controller == null ? null : this.controller.getSite();
    }

    public void fillPatientBillingRessources() {
        block7: {
            if (this.controller != null) {
                XPatient patient = this.controller.getCurrentPatient();
                if (patient != null && patient.getId() != null) {
                    JobCallback callback = new JobCallback(Messages.getString((String)"RECHERCHE", (String[])new String[0])){

                        public void responseReceived(final ReturnObject response) {
                            Display.getDefault().syncExec(new Runnable(){

                                @Override
                                public void run() {
                                    if (!BillingEditionControl.this.isDisposed()) {
                                        if (response == null || response.getObj() == null) {
                                            BillingEditionControl.this.fillPatientBillingRessources(Collections.EMPTY_LIST);
                                        } else {
                                            BillingEditionControl.this.fillPatientBillingRessources((List)response.getObj());
                                        }
                                    }
                                }
                            });
                        }
                    };
                    try {
                        XBillCriteria criteria = new XBillCriteria();
                        criteria.idPatientAnchor = patient.getId();
                        criteria.idBilledNotNull = Boolean.FALSE;
                        RessourceAccessorClient.getInstance().getBillingRessourceByCriteria(criteria, Application.get().getGlobalInstances().getSession(), (ICallback)callback);
                    }
                    catch (CannotConnectToServerException cannotConnectToServerException) {
                        if (callback != null && !callback.killed()) {
                            callback.kill();
                        }
                        break block7;
                    }
                    catch (Exception e) {
                        logger.log(Level.SEVERE, "Failed to fillPatientRecalls, patient " + patient, e);
                        if (callback != null && !callback.killed()) {
                            callback.kill();
                        }
                        break block7;
                    }
                }
                this.fillPatientBillingRessources(Collections.EMPTY_LIST);
            }
        }
    }

    private void fillPatientBillingRessources(List<XBillingRessource> list) {
        this.controller.getLstBillingRessources().clear();
        for (XBillingRessource x : list) {
            this.controller.getLstBillingRessources().add(x);
            x.setListenerEnabled(true);
            for (EditableDataObject e : x.getBillingRessourceDatas()) {
                ObjectListenerManager.addListener((Object)e, (IObjectListener)this.getController());
                if (e == null) continue;
                e.setListenerEnabled(true);
            }
        }
        this.myListBillingRessource.setItems(this.controller.getActiveLstBillingRessources());
        this.myListBillingRessource.refresh();
        this.getController().getProxy().billingRessourceChanged();
    }

    public boolean isDisposed() {
        return this.billingRessourceControl.isDisposed();
    }

    public void refreshFont() {
        if (!this.main.isDisposed()) {
            this.main.refreshFont();
            this.main.layout(true, true);
        }
    }

    private static class StatusHandlerExtension
    implements IStatusHandler {
        public IStatusHandler.State handle(IStatus status) {
            if (status == null || status.getStatus("DUPLICATE_PATIENT") == null) {
                BaseAccessorClient.defaultStatusHandler.handle(status);
            }
            return IStatusHandler.State.HANDLED;
        }
    }

    private final class TxtPatientReferenceControl
    implements IReferenceControl {
        private TxtPatientReferenceControl() {
        }

        public void callback(Object o) {
            XPatient patient = this.parseResponse(o);
            if (patient != null) {
                this.processToGui(patient);
            }
        }

        private XPatient parseResponse(Object o) {
            ((BillingEditionControl)BillingEditionControl.this).patientControl.lblPatientNotFoundText.setVisible(false);
            if (o instanceof XPatient) {
                return (XPatient)o;
            }
            if (o instanceof XPatient[]) {
                XPatient[] array = (XPatient[])o;
                if (array.length == 1) {
                    return this.parseResponse(array[0]);
                }
                if (array.length > 1) {
                    BillingEditionControl.this.openPatientSearchView(array);
                } else {
                    ((BillingEditionControl)BillingEditionControl.this).patientControl.lblPatientNotFoundText.setVisible(true);
                }
                return null;
            }
            if (o instanceof XPatientListText) {
                return this.parseResponse(((XPatientListText)o).patient);
            }
            return null;
        }

        private void processToGui(XPatient patient) {
            boolean ok = BillingEditionControl.this.getController().validPatientChange(patient);
            IStatus s = null;
            if (!ok) {
                s = BillingEditionControl.this.doSave(null);
            }
            if (s == null || s.isOK()) {
                BillingEditionControl.this.getController().setPatient(patient);
                BillingEditionControl.this.txtPatient.getMyText().clear();
                BillingEditionControl.this.setPatient(patient);
            }
        }
    }

    private final class TxtRessourceDefDataReferenceControl
    implements IReferenceControl {
        private TxtRessourceDefDataReferenceControl() {
        }

        public void callback(Object o) {
            XRessourceDefData[] rdd = this.parseResponse(o);
            if (rdd != null) {
                this.processToGui(rdd);
            }
        }

        private XRessourceDefData[] parseResponse(Object o) {
            String searchText = BillingEditionControl.this.txtRessourceDefData.getMyText().getText();
            boolean addAll = searchText.endsWith("+");
            BillingEditionControl.this.lblRessourceNotFoundText.setVisible(false);
            if (o instanceof XRessourceDefData) {
                return new XRessourceDefData[]{(XRessourceDefData)o};
            }
            if (o instanceof List) {
                List list = (List)o;
                if (list.size() == 1) {
                    return new XRessourceDefData[]{(XRessourceDefData)list.get(0)};
                }
                if (list.size() > 1) {
                    XRessourceDefData[] arr = new XRessourceDefData[list.size()];
                    Collections.sort(list, new Comparator<XRessourceDefData>(){

                        @Override
                        public int compare(XRessourceDefData o1, XRessourceDefData o2) {
                            return o2.getNameLocal().compareTo(o1.getNameLocal());
                        }
                    });
                    list.toArray(arr);
                    if (addAll) {
                        return arr;
                    }
                    BillingEditionControl.this.openRessourceDefDataSearchView(arr);
                } else {
                    BillingEditionControl.this.lblRessourceNotFoundText.setVisible(true);
                }
                return null;
            }
            if (o instanceof XRessourceDefData[]) {
                XRessourceDefData[] array = (XRessourceDefData[])o;
                if (array.length == 1 || addAll) {
                    return array;
                }
                if (array.length > 1) {
                    BillingEditionControl.this.openRessourceDefDataSearchView(array);
                } else {
                    BillingEditionControl.this.lblRessourceNotFoundText.setVisible(true);
                }
                return null;
            }
            return null;
        }

        private void processToGui(XRessourceDefData[] rdds) {
            XRessourceDefData[] xRessourceDefDataArray = rdds;
            int n = rdds.length;
            int n2 = 0;
            while (n2 < n) {
                XRessourceDefData rdd = xRessourceDefDataArray[n2];
                XBillingRessource br = BillingEditionControl.this.getController().addNewBillingRessource(rdd);
                if (br != null) {
                    BillingEditionControl.this.getController().setCurrentBillingRessource(br);
                    BillingEditionControl.this.txtRessourceDefData.getMyText().clear();
                    BillingEditionControl.this.myListBillingRessource.setItems(BillingEditionControl.this.getController().getActiveLstBillingRessources());
                    BillingEditionControl.this.myListBillingRessource.refresh();
                    BillingEditionControl.this.myListBillingRessource.select((Object)br);
                    BillingEditionControl.this.billingRessourceControl.setBillingRessource(br);
                    BillingEditionControl.this.billingRessourceControl.showDataObject();
                    BillingEditionControl.this.billingRessourceControl.setEnabled(true);
                } else {
                    BillingEditionControl.this.billingRessourceControl.setEnabled(false);
                }
                ++n2;
            }
        }
    }
}

