/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.ressource;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.CannotConnectToServerException;
import ca.infodata.ofys.data.dataaccess.ICallback;
import ca.infodata.ofys.data.dataaccess.RessourceAccessorClient;
import ca.infodata.ofys.data.dataaccess.callback.IStatusHandler;
import ca.infodata.ofys.data.dataaccess.callback.JobCallback;
import ca.infodata.ofys.data.dataaccess.util.MessageUtil;
import ca.infodata.ofys.data.dataaccess.util.notification.DataObjectNotificationHandler;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.XBaseProfessionnal;
import ca.infodata.ofys.data.middle.dataobjects.XObjectContainer;
import ca.infodata.ofys.data.middle.dataobjects.XPatient;
import ca.infodata.ofys.data.middle.dataobjects.XSession;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IPatient;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.data.middle.dataobjects.notification.DataObject;
import ca.infodata.ofys.data.middle.dataobjects.notification.DataObjectUpdatedNotification;
import ca.infodata.ofys.data.middle.dataobjects.preferences.FormatDateProvider;
import ca.infodata.ofys.data.middle.dataobjects.service.XBillCriteria;
import ca.infodata.ofys.data.middle.dataobjects.service.XBilledRessource;
import ca.infodata.ofys.data.middle.dataobjects.service.XBilledRessourcePaid;
import ca.infodata.ofys.data.middle.dataobjects.service.XBilledStatus;
import ca.infodata.ofys.data.middle.dataobjects.service.XBillingRessource;
import ca.infodata.ofys.data.middle.dataobjects.service.XModePaiement;
import ca.infodata.ofys.data.middle.dataobjects.service.XSecteur;
import ca.infodata.ofys.mb.listener.property.IPropertyListener;
import ca.infodata.ofys.mb.listener.property.PropertyListenerManager;
import ca.infodata.ofys.status.IStatus;
import ca.infodata.ofys.status.MultiStatus;
import ca.infodata.ofys.status.Status;
import ca.infodata.ofys.ui.controls.FontAwareComposite;
import ca.infodata.ofys.ui.controls.FontAwareSection;
import ca.infodata.ofys.ui.controls.form.MyButton;
import ca.infodata.ofys.ui.controls.form.MyText;
import ca.infodata.ofys.ui.controls.plugins.searchview.ErrorWhileSearchingException;
import ca.infodata.ofys.ui.controls.report2.PrintDialog2;
import ca.infodata.ofys.ui.intro.DefaultStatusHandler;
import ca.infodata.ofys.ui.library.IRefreshFont;
import ca.infodata.ofys.ui.library.ResourceGetter;
import ca.infodata.ofys.ui.library.UI;
import ca.infodata.ofys.ui.person.PersonUiPlugin;
import ca.infodata.ofys.ui.ressource.BilledRessourceFormatter;
import ca.infodata.ofys.ui.ressource.BilledRessourcePaidFormatter;
import ca.infodata.ofys.ui.ressource.RessourcePlugin;
import ca.infodata.ofys.ui.ressource.cellediting.ComboBoxEditingSupport;
import ca.infodata.ofys.ui.ressource.cellediting.StringEditingSupport;
import ca.infodata.ofys.ui.ressource.menu.OpenBillingAction;
import ca.infodata.ofys.util.MiscUtil;
import ca.infodata.util1.JoinList;
import ca.infodata.util1.StringUtils;
import ca.infodata.util1.date.DateUtil;
import ca.infodata.util1.date.LocaleProvider;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.time.FastDateFormat;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.part.ViewPart;

public class RessourceView
extends ViewPart
implements IPropertyListener,
IRefreshFont {
    private static final Logger logger = Logger.getLogger(RessourceView.class.getName());
    static final String VIEW_RESSOURCE = Messages.getString((String)"VIEW_RESSOURCE", (String[])new String[0]);
    static final String RECHERCHER = Messages.getString((String)"RECHERCHER", (String[])new String[0]);
    static final String CODE = Messages.getString((String)"CODE", (String[])new String[0]);
    static final String GO = Messages.getString((String)"GO", (String[])new String[0]);
    static final String SERVICES_EN_COURS = Messages.getString((String)"SERVICES_EN_COURS", (String[])new String[0]);
    static final String TERMINES = Messages.getString((String)"TERMINES", (String[])new String[0]);
    static final String FACTURES = Messages.getString((String)"FACTURES", (String[])new String[0]);
    static final String AJOUT_DE = Messages.getString((String)"AJOUT_DE", (String[])new String[0]);
    static final String AUX_FAVORIS = Messages.getString((String)"AUX_FAVORIS", (String[])new String[0]);
    static final String RETRAIT_DE_ = Messages.getString((String)"RETRAIT_DE_", (String[])new String[0]);
    static final String DES_FAVORIS = Messages.getString((String)"DES_FAVORIS", (String[])new String[0]);
    static final String AJOUTER_AUX_FAVORIS = Messages.getString((String)"AJOUTER_AUX_FAVORIS", (String[])new String[0]);
    static final String MODIFIER_COPIE_DU_FORM = Messages.getString((String)"MODIFIER_COPIE_DU_FORM", (String[])new String[0]);
    static final String SUPPRIMER_LE_FORM = Messages.getString((String)"SUPPRIMER_LE_FORM", (String[])new String[0]);
    static final String FILTER_FORM = Messages.getString((String)"RECHERCHE_FORM", (String[])new String[0]);
    static final String RELIE_AU_CLIENT = Messages.getString((String)"RELIE_AU_CLIENT", (String[])new String[0]);
    static final String CANCEL_PMT_ONLY_ONE_BILL = Messages.getString((String)"CANCEL_PMT_ONLY_ONE_BILL", (String[])new String[0]);
    static final String CANCEL_PMT_ENTREE_COMPTABLE = Messages.getString((String)"CANCEL_PMT_ENTREE_COMPTABLE", (String[])new String[0]);
    static final String PLEASE_CONFIRM_CANCEL_PMT = Messages.getString((String)"PLEASE_CONFIRM_CANCEL_PMT", (String[])new String[0]);
    static final String CANCEL_BILL_CREE_PERTE = Messages.getString((String)"CANCEL_BILL_CREE_PERTE", (String[])new String[0]);
    static final String CANCEL_FOLLOWING_BILLS = Messages.getString((String)"CANCEL_FOLLOWING_BILLS", (String[])new String[0]);
    private boolean useOneStepBilling = true;
    private TableViewer tableEnCours;
    private TableViewer tableTermine;
    private TableViewer tableFacture;
    private List<XBillingRessource> lstEnCours = new ArrayList<XBillingRessource>();
    private List<XBillingRessource> lstTermine = new ArrayList<XBillingRessource>();
    private List<XBilledRessource> lstFacture = new ArrayList<XBilledRessource>();
    private FastDateFormat datetimeFormatter = FastDateFormat.getInstance((String)(String.valueOf(FormatDateProvider.getFormatDate().toString()) + " HH:mm"));
    private IPatient patient;
    private List<IPropertyListenerImplementation> listeners = new ArrayList<IPropertyListenerImplementation>();
    private DataObjectNotificationHandler handler = new DataObjectNotificationHandler(){

        public void handle(DataObjectUpdatedNotification notification) {
            DataObject dto;
            if (notification != null && notification.getObject() instanceof DataObject && "ca.infodata.ofys.data.middle.dataobjects.service.XBilledRessource".equals((dto = (DataObject)notification.getObject()).getClazz())) {
                PropertyListenerManager.firePropertyChanged((Object)((Object)RessourceView.this), (int)2);
            }
        }
    };
    private SashForm bodySash;
    public Cursor CURSOR_MOVE;
    int lastMaxItem = 1;
    int minHeight = 9;
    private Composite parent;
    private MyText txtSearch;
    private Color red;

    public RessourceView() {
        Application.get().getGlobalInstances().getNotificationSystem().addDataObjectNotificationHandler(this.handler);
        PropertyListenerManager.addListener((Object)((Object)this), (IPropertyListener)this);
    }

    public void createPartControl(Composite parent) {
        this.red = ResourceGetter.getRedWarningColor();
        this.parent = parent;
        FormToolkit toolkit = UI.createToolKit((Widget)parent);
        toolkit.adapt(parent);
        FormLayout layout = new FormLayout();
        layout.marginBottom = 0;
        layout.marginTop = 0;
        layout.marginLeft = 0;
        layout.marginRight = 0;
        layout.spacing = 0;
        parent.setLayout((Layout)layout);
        this.txtSearch = new MyText(parent, 2048);
        this.bodySash = new SashForm(parent, 66048);
        this.txtSearch.setMessage(FILTER_FORM);
        MyButton btnPrint = new MyButton(parent, 8);
        Image print = ResourceGetter.getImage((String)"images/print-icon16.png");
        btnPrint.setToolTipText(Messages.getString((String)"IMPRIMER", (String[])new String[0]));
        btnPrint.setImage(print);
        MyButton btnRefresh = new MyButton(parent, 8);
        btnRefresh.setImage(ResourceGetter.getImage((String)"images/refresh.png"));
        btnRefresh.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RessourceView.this.loadData();
            }
        });
        FormData fd = new FormData();
        fd.top = new FormAttachment(0);
        fd.right = new FormAttachment(100);
        fd.bottom = new FormAttachment(this.txtSearch.getControl(), 3, 1024);
        btnRefresh.setLayoutData((Object)fd);
        fd = new FormData();
        fd.top = new FormAttachment(0);
        fd.right = new FormAttachment(btnRefresh.getControl());
        fd.bottom = new FormAttachment(this.txtSearch.getControl(), 3, 1024);
        btnPrint.setLayoutData((Object)fd);
        fd = new FormData();
        fd.top = new FormAttachment(0);
        fd.left = new FormAttachment(0);
        fd.right = new FormAttachment(btnPrint.getControl());
        this.txtSearch.setLayoutData((Object)fd);
        fd = new FormData();
        fd.top = new FormAttachment(this.txtSearch.getControl());
        fd.left = new FormAttachment(0);
        fd.right = new FormAttachment(100);
        fd.bottom = new FormAttachment(100);
        this.bodySash.setLayoutData((Object)fd);
        this.CURSOR_MOVE = ResourceGetter.getCursor((int)21);
        FillLayout fillLayout = new FillLayout();
        fillLayout.marginHeight = 2;
        fillLayout.marginWidth = 0;
        int iSect = 60;
        int iNom = 70;
        int iDebut = 110;
        int iFin = 110;
        int iDisp = 130;
        int iDate = 135;
        int iMontant = 80;
        int iStat = 125;
        if (!this.useOneStepBilling) {
            FontAwareSection sectionEnCours = new FontAwareSection((Composite)this.bodySash, 256, toolkit);
            Composite compEnCours = toolkit.createComposite((Composite)sectionEnCours);
            sectionEnCours.setClient((Control)compEnCours);
            sectionEnCours.setText(SERVICES_EN_COURS);
            compEnCours.setLayout((Layout)fillLayout);
            this.createMaximizeListener((Section)sectionEnCours, toolkit, 1);
            this.tableEnCours = new TableViewer(compEnCours, 68354);
            this.tableEnCours.getTable().addControlListener((ControlListener)new ControlAdapter(){

                public void controlResized(ControlEvent e) {
                    if (RessourceView.this.tableEnCours.getTable().getItemCount() > 0) {
                        Timer t = new Timer();
                        TimerTask tt = new TimerTask(){

                            @Override
                            public void run() {
                                Display.getDefault().asyncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        RessourceView.this.tableEnCours.setSelection((ISelection)new StructuredSelection(RessourceView.this.tableEnCours.getElementAt(0)), true);
                                        RessourceView.this.tableEnCours.setSelection(null);
                                    }
                                });
                            }
                        };
                        t.schedule(tt, 100L);
                    }
                }
            });
            this.tableEnCours.addDoubleClickListener(new IDoubleClickListener(){

                public void doubleClick(DoubleClickEvent e) {
                    new OpenBillingAction(RessourceView.this.patient);
                }
            });
            this.tableEnCours.setUseHashlookup(true);
            this.tableEnCours.getTable().setHeaderVisible(true);
            this.tableEnCours.getTable().setLinesVisible(true);
            this.tableEnCours.getTable().setFont(ResourceGetter.getFontNormal());
            this.tableEnCours.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
            this.tableEnCours.setComparator(new ViewerComparator(){

                public int compare(Viewer viewer, Object o1, Object o2) {
                    XBillingRessource e1 = (XBillingRessource)o1;
                    XBillingRessource e2 = (XBillingRessource)o2;
                    int s = LocaleProvider.isFrench() && StringUtils.isEmpty((String)e1.getRessourceDefData().getNameFr()) ? -1 : (StringUtils.isEmpty((String)e1.getRessourceDefData().getNameEn()) ? -1 : (LocaleProvider.isFrench() ? e1.getRessourceDefData().getNameFr().compareTo(e2.getRessourceDefData().getNameFr()) : e1.getRessourceDefData().getNameEn().compareTo(e2.getRessourceDefData().getNameEn())));
                    return s;
                }
            });
            TableViewerColumn tcS = new TableViewerColumn(this.tableEnCours, 0);
            tcS.getColumn().setWidth(iSect);
            tcS.getColumn().setText(Messages.getString((String)"SECTEUR", (String[])new String[0]));
            tcS.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

                public String getText(Object element) {
                    XBillingRessource p = (XBillingRessource)element;
                    if (p.getRessourceDefData() != null && p.getRessourceDefData().getSecteur() != null) {
                        if (LocaleProvider.isFrench()) {
                            return p.getRessourceDefData().getSecteur().getNameFr();
                        }
                        return p.getRessourceDefData().getSecteur().getNameEn();
                    }
                    return "";
                }
            });
            tcS.setEditingSupport((EditingSupport)new ComboBoxEditingSupport(this.tableEnCours, null, "getSecteur", null, XSecteur.class, RessourcePlugin.getDefault().getSecteurs().toArray(), null, 0));
            TableViewerColumn tc0 = new TableViewerColumn(this.tableEnCours, 0);
            tc0.getColumn().setWidth(iNom);
            tc0.getColumn().setText(Messages.getString((String)"NOM", (String[])new String[0]));
            tc0.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

                public String getText(Object element) {
                    XBillingRessource p = (XBillingRessource)element;
                    if (p.getRessourceDefData() != null) {
                        if (LocaleProvider.isFrench()) {
                            return p.getRessourceDefData().getNameFr();
                        }
                        return p.getRessourceDefData().getNameEn();
                    }
                    return "";
                }
            });
            String getName = "";
            getName = LocaleProvider.isFrench() ? "getNameFr" : "getNameEn";
            tc0.setEditingSupport((EditingSupport)new StringEditingSupport(this.tableEnCours, null, getName, null, 0));
            TableViewerColumn tcDd = new TableViewerColumn(this.tableEnCours, 0);
            tcDd.getColumn().setWidth(iDebut);
            tcDd.getColumn().setText(Messages.getString((String)"DEBUT", (String[])new String[0]));
            tcDd.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

                public String getText(Object element) {
                    XBillingRessource p = (XBillingRessource)element;
                    if (p.getDateTimeStart() != null) {
                        return RessourceView.this.datetimeFormatter.format(new Date(p.getDateTimeStart()));
                    }
                    return "";
                }
            });
            tcDd.setEditingSupport((EditingSupport)new StringEditingSupport(this.tableEnCours, null, "getDateTimeStart", null, 0));
            TableViewerColumn tcDf = new TableViewerColumn(this.tableEnCours, 0);
            tcDf.getColumn().setWidth(iFin);
            tcDf.getColumn().setText(Messages.getString((String)"FIN", (String[])new String[0]));
            tcDf.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

                public String getText(Object element) {
                    XBillingRessource p = (XBillingRessource)element;
                    if (p.getDateTimeEnd() != null) {
                        return RessourceView.this.datetimeFormatter.format(new Date(p.getDateTimeEnd()));
                    }
                    return "";
                }
            });
            tcDf.setEditingSupport((EditingSupport)new StringEditingSupport(this.tableEnCours, null, "getDateTimeEnd", null, 0));
            TableViewerColumn tcP = new TableViewerColumn(this.tableEnCours, 0);
            tcP.getColumn().setWidth(iDisp);
            tcP.getColumn().setText(Messages.getString((String)"DISPENSATEUR", (String[])new String[0]));
            tcP.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

                public String getText(Object element) {
                    XBillingRessource p = (XBillingRessource)element;
                    if (p.getRessourceDefData().getIdProfessionnalAnchor() != null) {
                        XBaseProfessionnal prof = PersonUiPlugin.getDefault().getBaseProfessionnal(p.getRessourceDefData().getIdProfessionnalAnchor());
                        return prof == null ? "" : prof.getName();
                    }
                    return "";
                }
            });
            LabelProvider labelProviderProf = new LabelProvider(){

                public String getText(Object element) {
                    if (element != null) {
                        XBaseProfessionnal prof = (XBaseProfessionnal)element;
                        return prof == null ? "" : prof.getName();
                    }
                    return "";
                }
            };
            tcP.setEditingSupport((EditingSupport)new ComboBoxEditingSupport(this.tableEnCours, null, "getProfessionnal", null, XBaseProfessionnal.class, PersonUiPlugin.getDefault().getTreatingProfessionnals().toArray(), labelProviderProf, 0));
            FontAwareSection sectionTermines = new FontAwareSection((Composite)this.bodySash, 256, toolkit);
            Composite compTermines = toolkit.createComposite((Composite)sectionTermines);
            sectionTermines.setClient((Control)compTermines);
            sectionTermines.setText(TERMINES);
            compTermines.setLayout((Layout)fillLayout);
            this.createMaximizeListener((Section)sectionTermines, toolkit, 2);
            this.tableTermine = new TableViewer(compTermines, 68354);
            this.tableTermine.getTable().addControlListener((ControlListener)new ControlAdapter(){

                public void controlResized(ControlEvent e) {
                    if (RessourceView.this.tableTermine.getTable().getItemCount() > 0) {
                        Timer t = new Timer();
                        TimerTask tt = new TimerTask(){

                            @Override
                            public void run() {
                                Display.getDefault().asyncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        RessourceView.this.tableTermine.setSelection((ISelection)new StructuredSelection(RessourceView.this.tableTermine.getElementAt(0)), true);
                                        RessourceView.this.tableTermine.setSelection(null);
                                    }
                                });
                            }
                        };
                        t.schedule(tt, 100L);
                    }
                }
            });
            this.tableTermine.setUseHashlookup(true);
            this.tableTermine.getTable().setHeaderVisible(true);
            this.tableTermine.getTable().setLinesVisible(true);
            this.tableTermine.getTable().setFont(ResourceGetter.getFontNormal());
            this.tableTermine.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
            this.tableTermine.setComparator(new ViewerComparator(){

                public int compare(Viewer viewer, Object o1, Object o2) {
                    XBillingRessource e1 = (XBillingRessource)o1;
                    XBillingRessource e2 = (XBillingRessource)o2;
                    int s = LocaleProvider.isFrench() && StringUtils.isEmpty((String)e1.getRessourceDefData().getNameFr()) ? -1 : (StringUtils.isEmpty((String)e1.getRessourceDefData().getNameEn()) ? -1 : (LocaleProvider.isFrench() ? e1.getRessourceDefData().getNameFr().compareTo(e2.getRessourceDefData().getNameFr()) : e1.getRessourceDefData().getNameEn().compareTo(e2.getRessourceDefData().getNameEn())));
                    return s;
                }
            });
            TableViewerColumn ttcS = new TableViewerColumn(this.tableTermine, 0);
            ttcS.getColumn().setWidth(iSect);
            ttcS.getColumn().setText(Messages.getString((String)"SECTEUR", (String[])new String[0]));
            ttcS.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

                public String getText(Object element) {
                    XBillingRessource p = (XBillingRessource)element;
                    if (p.getRessourceDefData() != null && p.getRessourceDefData().getSecteur() != null) {
                        if (LocaleProvider.isFrench()) {
                            return p.getRessourceDefData().getSecteur().getNameFr();
                        }
                        return p.getRessourceDefData().getSecteur().getNameEn();
                    }
                    return "";
                }
            });
            ttcS.setEditingSupport((EditingSupport)new ComboBoxEditingSupport(this.tableTermine, null, "getSecteur", null, XSecteur.class, RessourcePlugin.getDefault().getSecteurs().toArray(), null, 0));
            TableViewerColumn ttc0 = new TableViewerColumn(this.tableTermine, 0);
            ttc0.getColumn().setWidth(iNom);
            ttc0.getColumn().setText(Messages.getString((String)"NOM", (String[])new String[0]));
            ttc0.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

                public String getText(Object element) {
                    XBillingRessource p = (XBillingRessource)element;
                    if (p.getRessourceDefData() != null) {
                        if (LocaleProvider.isFrench()) {
                            return p.getRessourceDefData().getNameFr();
                        }
                        return p.getRessourceDefData().getNameEn();
                    }
                    return "";
                }
            });
            getName = "";
            getName = LocaleProvider.isFrench() ? "getNameFr" : "getNameEn";
            ttc0.setEditingSupport((EditingSupport)new StringEditingSupport(this.tableTermine, null, getName, null, 0));
            TableViewerColumn ttcDd = new TableViewerColumn(this.tableTermine, 0);
            ttcDd.getColumn().setWidth(iDebut);
            ttcDd.getColumn().setText(Messages.getString((String)"DEBUT", (String[])new String[0]));
            ttcDd.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

                public String getText(Object element) {
                    XBillingRessource p = (XBillingRessource)element;
                    if (p.getDateTimeStart() != null) {
                        return RessourceView.this.datetimeFormatter.format(new Date(p.getDateTimeStart()));
                    }
                    return "";
                }
            });
            ttcDd.setEditingSupport((EditingSupport)new StringEditingSupport(this.tableTermine, null, "getDateTimeStart", null, 0));
            TableViewerColumn ttcDf = new TableViewerColumn(this.tableTermine, 0);
            ttcDf.getColumn().setWidth(iFin);
            ttcDf.getColumn().setText(Messages.getString((String)"FIN", (String[])new String[0]));
            ttcDf.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

                public String getText(Object element) {
                    XBillingRessource p = (XBillingRessource)element;
                    if (p.getDateTimeEnd() != null) {
                        return RessourceView.this.datetimeFormatter.format(new Date(p.getDateTimeEnd()));
                    }
                    return "";
                }
            });
            ttcDf.setEditingSupport((EditingSupport)new StringEditingSupport(this.tableTermine, null, "getDateTimeEnd", null, 0));
            TableViewerColumn ttcP = new TableViewerColumn(this.tableTermine, 0);
            ttcP.getColumn().setWidth(iDisp);
            ttcP.getColumn().setText(Messages.getString((String)"DISPENSATEUR", (String[])new String[0]));
            ttcP.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

                public String getText(Object element) {
                    XBillingRessource p = (XBillingRessource)element;
                    if (p.getRessourceDefData().getIdProfessionnalAnchor() != null) {
                        XBaseProfessionnal prof = PersonUiPlugin.getDefault().getBaseProfessionnal(p.getRessourceDefData().getIdProfessionnalAnchor());
                        return prof == null ? "" : prof.getName();
                    }
                    return "";
                }
            });
            LabelProvider labelTProviderProf = new LabelProvider(){

                public String getText(Object element) {
                    if (element != null) {
                        XBaseProfessionnal prof = (XBaseProfessionnal)element;
                        return prof == null ? "" : prof.getName();
                    }
                    return "";
                }
            };
            ttcP.setEditingSupport((EditingSupport)new ComboBoxEditingSupport(this.tableTermine, null, "getProfessionnal", null, XBaseProfessionnal.class, PersonUiPlugin.getDefault().getTreatingProfessionnals().toArray(), labelTProviderProf, 0));
            this.tableTermine.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent e) {
                }
            });
            this.tableTermine.getTable().addMouseListener(new MouseListener(){

                public void mouseDoubleClick(MouseEvent e) {
                }

                public void mouseDown(MouseEvent e) {
                }

                public void mouseUp(MouseEvent e) {
                }
            });
            this.tableTermine.addDoubleClickListener(new IDoubleClickListener(){

                public void doubleClick(DoubleClickEvent e) {
                    new OpenBillingAction(RessourceView.this.patient);
                }
            });
        }
        this.txtSearch.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RessourceView.this.filterForms();
            }
        });
        FontAwareSection sectionFacture = new FontAwareSection((Composite)this.bodySash, 256, toolkit);
        Composite compFacture = toolkit.createComposite((Composite)sectionFacture);
        compFacture.setLayout((Layout)fillLayout);
        sectionFacture.setClient((Control)compFacture);
        sectionFacture.setText(FACTURES);
        this.createMaximizeListener((Section)sectionFacture, toolkit, 3);
        this.tableFacture = new TableViewer(compFacture, 68386);
        this.tableFacture.getTable().addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                if (RessourceView.this.tableFacture.getTable().getItemCount() > 0) {
                    Timer t = new Timer();
                    TimerTask tt = new TimerTask(){

                        @Override
                        public void run() {
                            Display.getDefault().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    RessourceView.this.tableFacture.setSelection((ISelection)new StructuredSelection(RessourceView.this.tableFacture.getElementAt(0)), true);
                                    RessourceView.this.tableFacture.setSelection(null);
                                }
                            });
                        }
                    };
                    t.schedule(tt, 100L);
                }
            }
        });
        this.tableFacture.setUseHashlookup(true);
        this.tableFacture.getTable().setHeaderVisible(true);
        this.tableFacture.getTable().setLinesVisible(true);
        this.tableFacture.getTable().setFont(ResourceGetter.getFontNormal());
        this.tableFacture.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.tableFacture.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object o1, Object o2) {
                XBilledRessource e1 = (XBilledRessource)o1;
                XBilledRessource e2 = (XBilledRessource)o2;
                return e2.dateBilled.compareTo(e1.dateBilled);
            }
        });
        TableViewerColumn ftcDd = new TableViewerColumn(this.tableFacture, 0);
        ftcDd.getColumn().setWidth(iDate);
        ftcDd.getColumn().setText(Messages.getString((String)"DATE", (String[])new String[0]));
        ftcDd.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                XBilledRessource p = (XBilledRessource)element;
                if (p.getDateBilled() != null) {
                    return RessourceView.this.datetimeFormatter.format(new Date(p.getDateBilled()));
                }
                return "";
            }
        });
        TableViewerColumn ftcP = new TableViewerColumn(this.tableFacture, 0);
        ftcP.getColumn().setWidth(iDisp);
        ftcP.getColumn().setText(Messages.getString((String)"DISPENSATEUR", (String[])new String[0]));
        ftcP.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                XBilledRessource p = (XBilledRessource)element;
                if (p.getIdProfessionnalAnchor() != null) {
                    XBaseProfessionnal prof = PersonUiPlugin.getDefault().getBaseProfessionnal(p.getIdProfessionnalAnchor());
                    return prof == null ? "" : prof.getName();
                }
                return "";
            }
        });
        TableViewerColumn tc6 = new TableViewerColumn(this.tableFacture, 0);
        tc6.getColumn().setWidth(iMontant);
        tc6.getColumn().setAlignment(131072);
        tc6.getColumn().setText("TOTAL");
        tc6.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                XBilledRessource p = (XBilledRessource)element;
                return p.getGrandTotal().toString();
            }
        });
        TableViewerColumn tcSolde = new TableViewerColumn(this.tableFacture, 0);
        tcSolde.getColumn().setWidth(iMontant);
        tcSolde.getColumn().setAlignment(131072);
        tcSolde.getColumn().setText("SOLDE");
        tcSolde.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                XBilledRessource p = (XBilledRessource)element;
                return p.getSolde().toString();
            }

            public void update(ViewerCell cell) {
                XBilledRessource m;
                super.update(cell);
                Object e = cell.getElement();
                if (e instanceof XBilledRessource && (m = (XBilledRessource)e).getSolde().doubleValue() > 0.01) {
                    int cc = cell.getViewerRow().getColumnCount();
                    int i = 0;
                    while (i <= cc) {
                        cell.getViewerRow().setBackground(i, RessourceView.this.red);
                        ++i;
                    }
                }
            }
        });
        TableViewerColumn tcStatus = new TableViewerColumn(this.tableFacture, 0);
        tcStatus.getColumn().setWidth(iStat);
        tcStatus.getColumn().setText("Status");
        tcStatus.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                XBilledRessource q = (XBilledRessource)element;
                if (q.getStatus() != null) {
                    return q.getStatus().toString();
                }
                return "";
            }
        });
        this.tableFacture.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent e) {
            }
        });
        this.tableFacture.getTable().addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
                UI.rightClick((MouseEvent)e);
            }
        });
        MenuManager popManager = new MenuManager();
        PrintSelection menuActionPrint = new PrintSelection(this.tableFacture);
        popManager.add((IAction)menuActionPrint);
        CancelBilledSelection menuActionCancel = new CancelBilledSelection(this.tableFacture);
        popManager.add((IAction)menuActionCancel);
        AnnulerPmtSelection menuActionCancelPmt = new AnnulerPmtSelection(this.tableFacture);
        popManager.add((IAction)menuActionCancelPmt);
        Menu menu = popManager.createContextMenu((Control)this.tableFacture.getTable());
        this.tableFacture.getTable().setMenu(menu);
        btnPrint.addSelectionListener((SelectionListener)new SelectionAdapter((IAction)menuActionPrint){
            private final /* synthetic */ IAction val$menuActionPrint;
            {
                this.val$menuActionPrint = iAction;
            }

            public void widgetSelected(SelectionEvent e) {
                this.val$menuActionPrint.run();
            }
        });
        this.tableFacture.addDoubleClickListener(new IDoubleClickListener((IAction)menuActionPrint){
            private final /* synthetic */ IAction val$menuActionPrint;
            {
                this.val$menuActionPrint = iAction;
            }

            public void doubleClick(DoubleClickEvent e) {
                ISelection selection = RessourceView.this.tableFacture.getSelection();
                if (selection.isEmpty()) {
                    return;
                }
                BigDecimal zero = new BigDecimal(0);
                XBilledRessource data = (XBilledRessource)((IStructuredSelection)selection).getFirstElement();
                if (zero.compareTo(data.getSolde()) < 0) {
                    new OpenBillingAction(RessourceView.this.patient);
                } else {
                    this.val$menuActionPrint.run();
                }
            }
        });
        this.patient = PersonUiPlugin.getDefault().getCurrentPatient();
        this.loadData();
        PropertyListenerManager.addListener((Object)PersonUiPlugin.getDefault(), (IPropertyListener)this);
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                PropertyListenerManager.removeListener((IPropertyListener)RessourceView.this);
                RessourceView.this.patient = null;
                ResourceGetter.dispose((Object)RessourceView.this.CURSOR_MOVE);
            }
        });
        if (!this.useOneStepBilling) {
            this.bodySash.addListener(11, new Listener(){

                public void handleEvent(Event arg0) {
                    RessourceView.this.maximizeBodyPart(RessourceView.this.lastMaxItem);
                }
            });
            Timer time = new Timer();
            TimerTask task = new TimerTask(){

                @Override
                public void run() {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            RessourceView.this.maximizeBodyPart(1);
                        }
                    });
                }
            };
            time.schedule(task, 1000L);
            ResourceGetter.addListener((IRefreshFont)this);
        }
    }

    private void filterForms() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                if (!RessourceView.this.useOneStepBilling) {
                    if (!RessourceView.this.tableTermine.getControl().isDisposed()) {
                        RessourceView.this.tableTermine.setInput((Object)RessourceView.this.getFilteredTermine());
                    }
                    if (!RessourceView.this.tableEnCours.getControl().isDisposed()) {
                        RessourceView.this.tableEnCours.setInput((Object)RessourceView.this.getFilteredEnCours());
                    }
                }
                if (!RessourceView.this.tableFacture.getControl().isDisposed()) {
                    RessourceView.this.tableFacture.setInput((Object)RessourceView.this.getFilteredFacture());
                    RessourceView.this.tableFacture.refresh(true);
                }
            }
        });
    }

    private List<XBillingRessource> getFilteredEnCours() {
        String txt = this.txtSearch.getText();
        ArrayList<XBillingRessource> billingRess = new ArrayList();
        if (txt == null || txt.length() == 0) {
            billingRess = this.lstEnCours;
        } else {
            txt = StringUtils.NormalizeToLowercase((String)txt);
            for (XBillingRessource ef : this.lstEnCours) {
                String name;
                String string = name = LocaleProvider.isFrench() ? ef.getRessourceDefData().getNameFr() : ef.getRessourceDefData().getNameEn();
                if (!StringUtils.NormalizeToLowercase((String)name).contains(txt)) continue;
                billingRess.add(ef);
            }
        }
        this.sortFact(billingRess);
        return billingRess;
    }

    private List<XBillingRessource> getFilteredTermine() {
        String txt = this.txtSearch.getText();
        ArrayList<XBillingRessource> billingRess = new ArrayList();
        if (txt == null || txt.length() == 0) {
            billingRess = this.lstTermine;
        } else {
            txt = StringUtils.NormalizeToLowercase((String)txt);
            for (XBillingRessource ef : this.lstTermine) {
                String name;
                String string = name = LocaleProvider.isFrench() ? ef.getRessourceDefData().getNameFr() : ef.getRessourceDefData().getNameEn();
                if (!StringUtils.NormalizeToLowercase((String)name).contains(txt)) continue;
                billingRess.add(ef);
            }
        }
        this.sortFact(billingRess);
        return billingRess;
    }

    private List<XBilledRessource> getFilteredFacture() {
        String txt = this.txtSearch.getText();
        ArrayList<XBilledRessource> billedRess = new ArrayList();
        if (txt == null || txt.length() == 0) {
            billedRess = this.lstFacture;
        } else {
            txt = StringUtils.NormalizeToLowercase((String)txt);
            for (XBilledRessource ef : this.lstFacture) {
                for (XBillingRessource xbr : ef.getLstBillingRessource()) {
                    String name;
                    String string = name = LocaleProvider.isFrench() ? xbr.getRessourceDefData().getNameFr() : xbr.getRessourceDefData().getNameEn();
                    if (!StringUtils.NormalizeToLowercase((String)name).contains(txt)) continue;
                    billedRess.add(ef);
                }
            }
        }
        this.sortFactBilled(billedRess);
        return billedRess;
    }

    public void loadData() {
        this.loadEnCours();
        this.loadTermine();
        this.loadfacture();
    }

    private void sortFactBilled(List<XBilledRessource> list) {
        Collections.sort(list, new Comparator<XBilledRessource>(){

            @Override
            public int compare(XBilledRessource o1, XBilledRessource o2) {
                return o1.dateBilled.compareTo(o2.dateBilled);
            }
        });
    }

    private void sortFact(List<XBillingRessource> list) {
        Collections.sort(list, new Comparator<XBillingRessource>(){

            @Override
            public int compare(XBillingRessource o1, XBillingRessource o2) {
                return o1.dateTimeStart.compareTo(o2.getDateTimeStart());
            }
        });
    }

    private void loadEnCours() {
        final IPatient patient2 = this.patient;
        if (patient2 == null) {
            return;
        }
        Job job2 = new Job("Chargement des services en cours"){

            protected org.eclipse.core.runtime.IStatus run(IProgressMonitor monitor) {
                block7: {
                    try {
                        XSession session = Application.get().getGlobalInstances().getSession();
                        final ArrayList list = new ArrayList();
                        if (session == null) break block7;
                        XBillCriteria container = new XBillCriteria();
                        container.idPatientAnchor = patient2.getId() == null ? Integer.MIN_VALUE : patient2.getId();
                        container.isTermnated = Boolean.FALSE;
                        JobCallback callback = null;
                        try {
                            callback = new JobCallback(Messages.getString((String)"RECHERCHE", (String[])new String[0]), (IStatusHandler)DefaultStatusHandler.getInstance()){

                                public void responseReceived(ReturnObject response) {
                                    if (patient2.equals(RessourceView.this.patient)) {
                                        List lst = (List)response.getObj();
                                        list.addAll(lst);
                                        RessourceView.this.sortFact(list);
                                        RessourceView.this.lstEnCours.clear();
                                        RessourceView.this.lstEnCours.addAll(list);
                                        RessourceView.this.refreshEnCoursSync();
                                    }
                                }

                                public void exception(Exception e) {
                                    super.exception(e);
                                }
                            };
                            RessourceAccessorClient.getInstance().getBillingRessourceByCriteria(container, session, (ICallback)callback);
                        }
                        catch (CannotConnectToServerException e) {
                            MessageUtil.cannotConnectToServerExceptionMsg();
                            if (callback != null && !callback.killed()) {
                                callback.kill();
                            }
                            throw new ErrorWhileSearchingException((Exception)((Object)e));
                        }
                        catch (Exception e) {
                            logger.log(Level.SEVERE, "Erreur", e);
                            if (callback != null && !callback.killed()) {
                                callback.kill();
                            }
                        }
                    }
                    catch (Exception e) {
                        logger.log(Level.SEVERE, "Error loading En cours list", e);
                    }
                }
                return org.eclipse.core.runtime.Status.OK_STATUS;
            }
        };
        job2.schedule();
    }

    private void loadTermine() {
        final IPatient patient2 = this.patient;
        if (patient2 == null) {
            return;
        }
        Job job2 = new Job("Chargement"){

            protected org.eclipse.core.runtime.IStatus run(IProgressMonitor monitor) {
                block7: {
                    try {
                        XSession session = Application.get().getGlobalInstances().getSession();
                        final ArrayList list = new ArrayList();
                        if (session == null) break block7;
                        XBillCriteria container = new XBillCriteria();
                        container.idPatientAnchor = patient2.getId() == null ? Integer.MIN_VALUE : patient2.getId();
                        container.isTermnated = Boolean.TRUE;
                        JobCallback callback = null;
                        try {
                            callback = new JobCallback(Messages.getString((String)"RECHERCHE", (String[])new String[0]), (IStatusHandler)DefaultStatusHandler.getInstance()){

                                public void responseReceived(ReturnObject response) {
                                    if (patient2.equals(RessourceView.this.patient)) {
                                        List lst = (List)response.getObj();
                                        list.addAll(lst);
                                        RessourceView.this.sortFact(list);
                                        RessourceView.this.lstTermine.clear();
                                        RessourceView.this.lstTermine.addAll(list);
                                        RessourceView.this.refreshTermineSync();
                                    }
                                }

                                public void exception(Exception e) {
                                    super.exception(e);
                                }
                            };
                            RessourceAccessorClient.getInstance().getBillingRessourceByCriteria(container, session, (ICallback)callback);
                        }
                        catch (CannotConnectToServerException e) {
                            MessageUtil.cannotConnectToServerExceptionMsg();
                            if (callback != null && !callback.killed()) {
                                callback.kill();
                            }
                            throw new ErrorWhileSearchingException((Exception)((Object)e));
                        }
                        catch (Exception e) {
                            logger.log(Level.SEVERE, "Erreur", e);
                            if (callback != null && !callback.killed()) {
                                callback.kill();
                            }
                        }
                    }
                    catch (Exception e) {
                        logger.log(Level.SEVERE, "Error loading Termines list", e);
                    }
                }
                return org.eclipse.core.runtime.Status.OK_STATUS;
            }
        };
        job2.schedule();
    }

    private void loadfacture() {
        final IPatient patient2 = this.patient;
        if (patient2 == null) {
            return;
        }
        Job job2 = new Job("Factures"){

            protected org.eclipse.core.runtime.IStatus run(IProgressMonitor monitor) {
                block7: {
                    try {
                        XSession session = Application.get().getGlobalInstances().getSession();
                        final ArrayList list = new ArrayList();
                        if (session == null) break block7;
                        XBillCriteria container = new XBillCriteria();
                        container.idPatientAnchor = patient2.getId() == null ? Integer.MIN_VALUE : patient2.getId();
                        container.isTermnated = Boolean.TRUE;
                        container.idBilledNotNull = Boolean.TRUE;
                        JobCallback callback = null;
                        try {
                            callback = new JobCallback(Messages.getString((String)"RECHERCHE", (String[])new String[0]), (IStatusHandler)DefaultStatusHandler.getInstance()){

                                public void responseReceived(ReturnObject response) {
                                    if (patient2.equals(RessourceView.this.patient)) {
                                        List lst = (List)response.getObj();
                                        list.addAll(lst);
                                        RessourceView.this.sortFactBilled(list);
                                        RessourceView.this.lstFacture.clear();
                                        RessourceView.this.lstFacture.addAll(list);
                                        RessourceView.this.refreshFactureSync();
                                    }
                                }

                                public void exception(Exception e) {
                                    super.exception(e);
                                }
                            };
                            RessourceAccessorClient.getInstance().getBilledRessourceByCriteria(container, session, (ICallback)callback);
                        }
                        catch (CannotConnectToServerException e) {
                            MessageUtil.cannotConnectToServerExceptionMsg();
                            if (callback != null && !callback.killed()) {
                                callback.kill();
                            }
                            throw new ErrorWhileSearchingException((Exception)((Object)e));
                        }
                        catch (Exception e) {
                            logger.log(Level.SEVERE, "Erreur", e);
                            if (callback != null && !callback.killed()) {
                                callback.kill();
                            }
                        }
                    }
                    catch (Exception e) {
                        logger.log(Level.SEVERE, "Error loading factures list", e);
                    }
                }
                return org.eclipse.core.runtime.Status.OK_STATUS;
            }
        };
        job2.schedule();
    }

    public void setFocus() {
        if (!this.useOneStepBilling) {
            this.tableEnCours.getControl().setFocus();
        } else {
            this.tableFacture.getControl().setFocus();
        }
    }

    private void refreshTermineSync() {
        if (!this.useOneStepBilling) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    if (!RessourceView.this.tableTermine.getControl().isDisposed()) {
                        List lst = RessourceView.this.getFilteredTermine();
                        RessourceView.this.tableTermine.setInput((Object)lst);
                        if (lst != null && lst.size() > 0) {
                            Timer t = new Timer();
                            TimerTask tt = new TimerTask(){

                                @Override
                                public void run() {
                                    Display.getDefault().asyncExec(new Runnable(){

                                        @Override
                                        public void run() {
                                            RessourceView.this.tableTermine.setSelection((ISelection)new StructuredSelection(RessourceView.this.tableTermine.getElementAt(0)), true);
                                            RessourceView.this.tableTermine.setSelection(null);
                                        }
                                    });
                                }
                            };
                            t.schedule(tt, 100L);
                        }
                    }
                }
            });
        }
    }

    private void refreshFactureSync() {
        try {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    if (!RessourceView.this.tableFacture.getControl().isDisposed()) {
                        List lst = RessourceView.this.getFilteredFacture();
                        RessourceView.this.tableFacture.setInput((Object)lst);
                        if (lst != null && lst.size() > 0) {
                            Timer t = new Timer();
                            TimerTask tt = new TimerTask(){

                                @Override
                                public void run() {
                                    Display.getDefault().asyncExec(new Runnable(){

                                        @Override
                                        public void run() {
                                            RessourceView.this.tableFacture.setSelection((ISelection)new StructuredSelection(RessourceView.this.tableFacture.getElementAt(0)), true);
                                            RessourceView.this.tableFacture.setSelection(null);
                                        }
                                    });
                                }
                            };
                            t.schedule(tt, 100L);
                        }
                    }
                }
            });
        }
        catch (Exception exception) {}
    }

    private void refreshEnCoursSync() {
        if (!this.useOneStepBilling) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    if (!RessourceView.this.tableEnCours.getControl().isDisposed()) {
                        List lst = RessourceView.this.getFilteredEnCours();
                        RessourceView.this.tableEnCours.setInput((Object)lst);
                        if (lst != null && lst.size() > 0) {
                            Timer t = new Timer();
                            TimerTask tt = new TimerTask(){

                                @Override
                                public void run() {
                                    Display.getDefault().asyncExec(new Runnable(){

                                        @Override
                                        public void run() {
                                            RessourceView.this.tableEnCours.setSelection((ISelection)new StructuredSelection(RessourceView.this.tableEnCours.getElementAt(0)), true);
                                            RessourceView.this.tableEnCours.setSelection(null);
                                        }
                                    });
                                }
                            };
                            t.schedule(tt, 100L);
                        }
                    }
                }
            });
        }
    }

    public void propertyChanged(int propertyId) {
        if (propertyId == 1) {
            RessourcePlugin.getDefault().getWorkbench().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    XPatient currentPatient = PersonUiPlugin.getDefault().getCurrentPatient();
                    if (!MiscUtil.areObjectsEquals((Object)currentPatient, (Object)RessourceView.this.patient)) {
                        RessourceView.this.patient = (IPatient)currentPatient;
                        RessourceView.this.loadData();
                        if (RessourceView.this.patient == null || RessourceView.this.patient.getId() == null) {
                            RessourceView.this.setPartName(VIEW_RESSOURCE);
                        } else {
                            RessourceView.this.setPartName(String.valueOf(VIEW_RESSOURCE) + " ( " + RessourceView.this.patient.getNameBirthdateSex() + " )");
                        }
                    }
                }
            });
        } else if (propertyId == 2) {
            RessourcePlugin.getDefault().getWorkbench().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    RessourceView.this.loadfacture();
                }
            });
        }
    }

    private Label createMaximizeListener(Section parent, FormToolkit toolkit, final int bodyPart) {
        Label label = null;
        Control[] controlArray = parent.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            if (c instanceof Label) {
                label = (Label)c;
                break;
            }
            ++n2;
        }
        label.addMouseTrackListener(new MouseTrackListener(){

            public void mouseEnter(MouseEvent e) {
                RessourceView.this.bodySash.setCursor(RessourceView.this.CURSOR_MOVE);
            }

            public void mouseExit(MouseEvent e) {
                RessourceView.this.bodySash.setCursor(null);
            }

            public void mouseHover(MouseEvent e) {
                RessourceView.this.bodySash.setCursor(RessourceView.this.CURSOR_MOVE);
            }
        });
        label.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                if (e.button == 1) {
                    if (RessourceView.this.lastMaxItem == bodyPart) {
                        RessourceView.this.restoreInitialBodyWeight();
                    } else {
                        RessourceView.this.maximizeBodyPart(bodyPart);
                    }
                }
            }
        });
        return label;
    }

    protected void restoreInitialBodyWeight() {
        if (this.bodySash.isDisposed()) {
            return;
        }
        if (this.bodySash.getChildren().length == 1) {
            return;
        }
        if (this.bodySash.getChildren().length != 3) {
            logger.log(Level.SEVERE, "ResourceView.bodySash should be containing 3 table controls but is not");
        }
        int y = this.bodySash.getSize().y;
        double ratio = ((double)y - 300.0) / (double)y;
        double min = (double)this.minHeight - (double)this.minHeight * ratio;
        double max = 100.0 - 2.0 * min;
        int iMin = (int)min;
        int iMax = (int)max;
        if (iMax > 0 && iMax < 100 && iMin > 0 && iMin < 35) {
            this.bodySash.setWeights(new int[]{iMax, iMin, iMin});
            this.lastMaxItem = 1;
        }
    }

    protected void maximizeBodyPart(int i) {
        if (!this.bodySash.isDisposed()) {
            if (this.bodySash.getChildren().length == 1) {
                return;
            }
            if (this.bodySash.getChildren().length != 3) {
                logger.log(Level.SEVERE, "ResourceView.bodySash should be containing 3 table controls but is not");
            }
            int y = this.bodySash.getSize().y;
            double ratio = ((double)y - 300.0) / (double)y;
            double min = (double)this.minHeight - (double)this.minHeight * ratio;
            double max = 100.0 - 2.0 * min;
            int iMin = (int)min;
            int iMax = (int)max;
            if (iMax > 0 && iMax < 100 && iMin > 0 && iMin < 35) {
                switch (i) {
                    case 1: {
                        try {
                            this.bodySash.setWeights(new int[]{iMax, iMin, iMin});
                        }
                        catch (Exception e) {
                            logger.log(Level.SEVERE, String.format("bodyPart=%s, %s %s", i, iMin, iMax), e);
                        }
                        break;
                    }
                    case 2: {
                        try {
                            this.bodySash.setWeights(new int[]{iMin, iMax, iMin});
                        }
                        catch (Exception e) {
                            logger.log(Level.SEVERE, String.format("bodyPart=%s, %s %s", i, iMin, iMax), e);
                        }
                        break;
                    }
                    case 3: {
                        try {
                            this.bodySash.setWeights(new int[]{iMin, iMin, iMax});
                        }
                        catch (Exception e) {
                            logger.log(Level.SEVERE, String.format("bodyPart=%s, %s %s", i, iMin, iMax), e);
                        }
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("i must be in [1..3]");
                    }
                }
            }
            this.lastMaxItem = i;
        }
    }

    public void dispose() {
        for (IPropertyListenerImplementation listener : this.listeners) {
            PropertyListenerManager.removeListener((IPropertyListener)listener);
        }
        ResourceGetter.removeListener((IRefreshFont)this);
        Application.get().getGlobalInstances().getNotificationSystem().removeDataObjectNotificationHandler(this.handler);
        super.dispose();
    }

    public void refreshFont() {
        FontAwareComposite.refreshFont((Control)this.parent);
        this.parent.layout(true, true);
    }

    private class AnnulerPmtSelection
    extends Action {
        final TableViewer viewer;

        public AnnulerPmtSelection(TableViewer viewer) {
            super(String.valueOf(Messages.getString((String)"ANNULER", (String[])new String[0])) + " " + Messages.getString((String)"PAIEMENT", (String[])new String[0]).toLowerCase() + "(s)");
            this.viewer = viewer;
        }

        public void run() {
            if (this.viewer != null) {
                TableItem[] children = this.viewer.getTable().getItems();
                ArrayList<XBilledRessource> lstData = new ArrayList<XBilledRessource>(children.length);
                int i = 0;
                while (i < children.length) {
                    TableItem item = children[i];
                    if (item.getChecked()) {
                        lstData.add((XBilledRessource)item.getData());
                    }
                    ++i;
                }
                if (lstData.isEmpty()) {
                    XBilledRessource data = null;
                    ISelection selection = this.viewer.getSelection();
                    if (selection.isEmpty()) {
                        return;
                    }
                    data = (XBilledRessource)((IStructuredSelection)selection).getFirstElement();
                    lstData.add(data);
                }
                if (lstData.size() > 1) {
                    MessageUtil.infoMsg((Shell)UI.getWorkbenchShell(), (String)CANCEL_PMT_ONLY_ONE_BILL);
                } else {
                    ArrayList<String> lstDataString = new ArrayList<String>();
                    for (XBilledRessource xBilledRessource : lstData) {
                        lstDataString.add(String.valueOf(Messages.getString((String)"FACTURE", (String[])new String[0])) + ": " + BilledRessourceFormatter.format(xBilledRessource));
                        for (XBilledRessourcePaid pd : xBilledRessource.lstBilledRessourcePaid) {
                            lstDataString.add("- " + BilledRessourcePaidFormatter.format(pd));
                        }
                    }
                    String msg = new JoinList("\n", lstDataString).toString();
                    MessageUtil.infoMsg((Shell)UI.getWorkbenchShell(), (String)CANCEL_PMT_ENTREE_COMPTABLE);
                    if (MessageUtil.askQuestion((Shell)UI.getWorkbenchShell(), (String)(String.valueOf(PLEASE_CONFIRM_CANCEL_PMT) + msg))) {
                        double perte = 0.0;
                        XBilledRessource xBilledRessource = (XBilledRessource)lstData.get(0);
                        for (XBilledRessourcePaid pd : xBilledRessource.lstBilledRessourcePaid) {
                            perte += pd.getPaid().doubleValue();
                        }
                        XBilledRessourcePaid paidPerte = new XBilledRessourcePaid();
                        paidPerte.setBilledRessource(xBilledRessource);
                        paidPerte.setCreatedDatetime(Long.valueOf(DateUtil.now()));
                        paidPerte.setModePaiement(XModePaiement.ANNUL_PMT);
                        paidPerte.setPaid(new BigDecimal(-perte));
                        paidPerte.setNote("");
                        paidPerte.setTag();
                        paidPerte.setNew();
                        xBilledRessource.addBilledRessourcePaid(paidPerte);
                        xBilledRessource.setStatus(XBilledStatus.NON_PAYE);
                        xBilledRessource.setSolde(xBilledRessource.getSolde().add(new BigDecimal(perte)));
                        MultiStatus status = new MultiStatus();
                        try {
                            ArrayList<XBilledRessource> lstBR = new ArrayList<XBilledRessource>();
                            lstBR.add(xBilledRessource);
                            XObjectContainer xObjectContainer = new XObjectContainer(lstBR);
                            ReturnObject ret = null;
                            try {
                                ret = RessourceAccessorClient.getInstance().saveSync(((Object)((Object)this)).hashCode(), Application.get().getGlobalInstances().getSession(), (Serializable)xObjectContainer, false);
                                status.add((IStatus)ret.getStatus());
                            }
                            catch (CannotConnectToServerException e) {
                                status.add((IStatus)new Status(IStatus.Severity.ERROR, "CannotConnectToServer", (Throwable)e));
                                MessageUtil.cannotConnectToServerExceptionMsg();
                            }
                            catch (Exception e) {
                                status.add((IStatus)new Status(IStatus.Severity.ERROR, "save exception", (Throwable)e));
                                logger.log(Level.WARNING, "Failed to save", e);
                            }
                            if (status.isOkToProceed()) {
                                RessourceView.this.loadfacture();
                            }
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    }
                }
            }
        }
    }

    private class CancelBilledSelection
    extends Action {
        final TableViewer viewer;

        public CancelBilledSelection(TableViewer viewer) {
            super(String.valueOf(Messages.getString((String)"ANNULER", (String[])new String[0])) + " " + Messages.getString((String)"FACTURE", (String[])new String[0]).toLowerCase() + "(s)");
            this.viewer = viewer;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void run() {
            if (this.viewer == null) return;
            TableItem[] children = this.viewer.getTable().getItems();
            ArrayList<XBilledRessource> lstData = new ArrayList<XBilledRessource>(children.length);
            int i = 0;
            while (i < children.length) {
                TableItem item = children[i];
                if (item.getChecked()) {
                    lstData.add((XBilledRessource)item.getData());
                }
                ++i;
            }
            if (lstData.isEmpty()) {
                XBilledRessource data = null;
                ISelection selection = this.viewer.getSelection();
                if (selection.isEmpty()) {
                    return;
                }
                data = (XBilledRessource)((IStructuredSelection)selection).getFirstElement();
                lstData.add(data);
            }
            double perte = 0.0;
            for (XBilledRessource xb : lstData) {
                perte += xb.getSolde().doubleValue();
            }
            if (perte > 0.0) {
                ArrayList<String> lstDataString = new ArrayList<String>();
                for (XBilledRessource xBilledRessource : lstData) {
                    lstDataString.add(BilledRessourceFormatter.format(xBilledRessource));
                }
                String msg = new JoinList("\n", lstDataString).toString();
                MessageUtil.infoMsg((Shell)UI.getWorkbenchShell(), (String)CANCEL_BILL_CREE_PERTE);
                if (!MessageUtil.askQuestion((Shell)UI.getWorkbenchShell(), (String)(String.valueOf(CANCEL_FOLLOWING_BILLS) + msg))) return;
                ArrayList<XBilledRessource> lstBR = new ArrayList<XBilledRessource>();
                for (XBilledRessource xBilledRessource : lstData) {
                    XBilledRessourcePaid paidPerte = new XBilledRessourcePaid();
                    paidPerte.setBilledRessource(xBilledRessource);
                    paidPerte.setCreatedDatetime(Long.valueOf(DateUtil.now()));
                    paidPerte.setModePaiement(XModePaiement.PERTE);
                    paidPerte.setPaid(xBilledRessource.getSolde());
                    paidPerte.setNote("");
                    paidPerte.setTag();
                    paidPerte.setNew();
                    xBilledRessource.addBilledRessourcePaid(paidPerte);
                    xBilledRessource.setStatus(XBilledStatus.ANNULE);
                    xBilledRessource.setSolde(new BigDecimal(0));
                    lstBR.add(xBilledRessource);
                }
                MultiStatus status = new MultiStatus();
                try {
                    XObjectContainer xObjectContainer = new XObjectContainer(lstBR);
                    ReturnObject ret = null;
                    try {
                        ret = RessourceAccessorClient.getInstance().saveSync(((Object)((Object)this)).hashCode(), Application.get().getGlobalInstances().getSession(), (Serializable)xObjectContainer, false);
                        status.add((IStatus)ret.getStatus());
                    }
                    catch (CannotConnectToServerException e) {
                        status.add((IStatus)new Status(IStatus.Severity.ERROR, "CannotConnectToServer", (Throwable)e));
                        MessageUtil.cannotConnectToServerExceptionMsg();
                    }
                    catch (Exception e) {
                        status.add((IStatus)new Status(IStatus.Severity.ERROR, "save exception", (Throwable)e));
                        logger.log(Level.WARNING, "Failed to save", e);
                    }
                    if (!status.isOkToProceed()) return;
                    RessourceView.this.loadfacture();
                    return;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            MessageUtil.infoMsg((Shell)UI.getWorkbenchShell(), (String)Messages.getString((String)"NO_BILL_TO_CANCEL", (String[])new String[0]));
        }
    }

    private final class IPropertyListenerImplementation
    implements IPropertyListener {
        private IEditorPart editor;

        private IPropertyListenerImplementation() {
        }

        public void propertyChanged(int propertyId) {
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + ((Object)((Object)this.getOuterType())).hashCode();
            result = 31 * result + (RessourceView.this.lstTermine == null ? 0 : System.identityHashCode(RessourceView.this.lstTermine));
            result = 31 * result + (this.editor == null ? 0 : System.identityHashCode(this.editor));
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            return this.hashCode() == obj.hashCode();
        }

        private RessourceView getOuterType() {
            return RessourceView.this;
        }
    }

    private class PrintSelection
    extends Action {
        final TableViewer viewer;

        public PrintSelection(TableViewer viewer) {
            super(Messages.getString((String)"IMPRIMER", (String[])new String[0]));
            this.viewer = viewer;
        }

        public void run() {
            if (this.viewer != null) {
                TableItem[] children = this.viewer.getTable().getItems();
                ArrayList<XBilledRessource> lstData = new ArrayList<XBilledRessource>(children.length);
                int i = 0;
                while (i < children.length) {
                    TableItem item = children[i];
                    if (item.getChecked()) {
                        lstData.add((XBilledRessource)item.getData());
                    }
                    ++i;
                }
                if (lstData.isEmpty()) {
                    XBilledRessource data = null;
                    ISelection selection = this.viewer.getSelection();
                    if (selection.isEmpty()) {
                        return;
                    }
                    data = (XBilledRessource)((IStructuredSelection)selection).getFirstElement();
                    lstData.add(data);
                }
                PrintDialog2 dialog = new PrintDialog2(UI.getWorkbenchShell(), lstData);
                dialog.open();
            }
        }
    }
}

