/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.ressource;

import ca.infodata.ofys.data.dataaccess.BaseAccessorClient;
import ca.infodata.ofys.data.dataaccess.CannotConnectToServerException;
import ca.infodata.ofys.data.dataaccess.RessourceAccessorClient;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.EditableDataObject;
import ca.infodata.ofys.data.middle.dataobjects.service.XRessource;
import ca.infodata.ofys.ui.controls.EditorInput;
import ca.infodata.ofys.ui.controls.report2.PrintDialog2;
import ca.infodata.ofys.ui.library.ResourceGetter;
import ca.infodata.ofys.ui.library.UI;
import ca.infodata.ofys.ui.ressource.BaseRessourceEditor;
import ca.infodata.util1.date.LocaleProvider;
import java.io.Serializable;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;

public class RessourceEditor
extends BaseRessourceEditor {
    public void showDataObject() {
        this.ressourceControl.showCurrentRessource();
        this.ressourceDefControl.setRessource(this.getRessource());
        this.ressourceDefControl.showCurrentRessourceDef();
    }

    public BaseAccessorClient getAccessor() throws CannotConnectToServerException {
        return RessourceAccessorClient.getInstance();
    }

    public void initDataOverride() {
        if (!(((EditorInput)this.getEditorInput()).getDataObject() instanceof XRessource)) {
            throw new IllegalStateException("Only XRessource EditorInput is supported");
        }
        this.initializeCompleteDataObject((EditableDataObject)((EditorInput)this.getEditorInput()).getDataObject().clone());
    }

    public void setPartName(String partName) {
        XRessource r = this.getRessource();
        if (r != null) {
            partName = r.getId() == null ? Messages.getString((String)"NOUVELLE_RESSOURCE", (String[])new String[0]) : (LocaleProvider.isFrench() ? r.getNameFr() : r.getNameEn());
        }
        super.setPartName(partName);
    }

    public boolean isDataDirty() {
        return this.getRessource().isDirty();
    }

    public void print() {
        if (this.isDirty()) {
            Runnable printCallback = new Runnable(){

                @Override
                public void run() {
                    if (RessourceEditor.this.getLastSaveOrDeleteStatus() != null && RessourceEditor.this.getLastSaveOrDeleteStatus().isOK() && RessourceEditor.this.getRessource() != null && !RessourceEditor.this.isDirty()) {
                        PrintDialog2 dialog = new PrintDialog2(RessourceEditor.this.getSite().getShell(), (Serializable)RessourceEditor.this.getRessource());
                        UI.centerComposite((Composite)dialog.getShell(), (Composite)RessourceEditor.this.getEditorSite().getShell());
                        dialog.open();
                    }
                }
            };
            this.doSave(printCallback);
        } else if (this.getRessource() != null) {
            PrintDialog2 dialog = new PrintDialog2(this.getSite().getShell(), (Serializable)this.getRessource());
            UI.centerComposite((Composite)dialog.getShell(), (Composite)this.getEditorSite().getShell());
            dialog.open();
        }
    }

    public Image getEditorTitleImage() {
        return ResourceGetter.getImage((String)"images/attributes-display-icon32.png");
    }

    public void setToolBarStatus() {
    }
}

