/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.ressource;

import ca.infodata.ofys.data.middle.dataobjects.XBaseProfessionnal;
import ca.infodata.ofys.data.middle.dataobjects.service.XRessourceDefData;
import ca.infodata.ofys.data.middle.dataobjects.service.XRessourceUnit;
import ca.infodata.ofys.ui.person.PersonUiPlugin;
import ca.infodata.util1.StringUtils;
import ca.infodata.util1.date.LocaleProvider;
import java.util.ArrayList;
import org.eclipse.core.runtime.Platform;

public final class RessourceDefDataFormatter {
    public static String format(XRessourceDefData r) {
        if (r == null) {
            return "null";
        }
        ArrayList<String> list = new ArrayList<String>(5);
        if (Platform.inDebugMode()) {
            list.add("id=" + r.getId());
        }
        String langue = LocaleProvider.getLocale().getLanguage();
        String name = String.valueOf(r.getName(langue)) + " " + r.getRessourceDef().getName(langue);
        list.add(name);
        if (r.getSecteur() != null) {
            list.add(r.getSecteur().getName(langue));
        }
        if (!XRessourceUnit.ITEM.equals((Object)r.getUnit())) {
            XBaseProfessionnal prof;
            list.add(r.getStatus().toString());
            if (r.getIdProfessionnalAnchor() != null && (prof = PersonUiPlugin.getDefault().getBaseProfessionnal(r.getIdProfessionnalAnchor())) != null) {
                list.add(prof.getName());
            }
            list.add(String.valueOf(r.getPrixParUnit().toString()) + r.getUnit().toString());
            list.add("R.T. " + r.getRecycleTime() + " min");
        } else {
            list.add(String.valueOf(r.getPrixParUnit().toString()) + "/item");
        }
        if (r.getRessourceDef().getTaxeDef() != null) {
            list.add("Tx " + r.getRessourceDef().getTaxeDef().getCode());
        }
        list.add("Esc max " + (int)(r.getEscompteMax().doubleValue() * 100.0) + "%");
        return StringUtils.join(list, (String)", ");
    }
}

