/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.ressource;

import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IEditableDataObjectList;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IMinimalEditableDataObject;
import ca.infodata.ofys.data.middle.dataobjects.preferences.FormatDateProvider;
import ca.infodata.ofys.data.middle.dataobjects.service.XBilledRessource;
import ca.infodata.ofys.data.middle.dataobjects.service.XBilledRessourcePaid;
import ca.infodata.ofys.data.middle.dataobjects.service.XBilledStatus;
import ca.infodata.ofys.data.middle.dataobjects.service.XModePaiement;
import ca.infodata.ofys.ui.controls.IBaseEditor;
import ca.infodata.ofys.ui.library.ResourceGetter;
import ca.infodata.ofys.ui.library.UI;
import ca.infodata.ofys.ui.ressource.FakeEditor;
import ca.infodata.ofys.ui.ressource.cellediting.ComboBoxEditingSupport;
import ca.infodata.ofys.ui.ressource.cellediting.NumberEditingSupport;
import ca.infodata.ofys.ui.ressource.cellediting.StringEditingSupport;
import ca.infodata.ofys.ui.ressource.cellediting.TaskEditingSupport;
import ca.infodata.ofys.ui.ressource.editor.BillingRessourceController;
import ca.infodata.util1.date.DateUtil;
import java.math.BigDecimal;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TableViewerEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;

public abstract class BaseBilledRessourcePaidControl
extends Composite {
    private static final String STATUS = Messages.getString((String)"STATUS", (String[])new String[0]);
    public IEditableDataObjectList<XBilledRessourcePaid> lstBilledRessourcePaid;
    public XBilledRessourcePaid ressourcePaid;
    protected Button btnAddItem;
    protected Button btnFilter;
    private TableViewer viewer;
    protected String szErrors;
    private FakeEditor parentEditor;
    protected BillingRessourceController controller;

    public BaseBilledRessourcePaidControl(Composite parent, FakeEditor parentEditor, FormToolkit toolkit) {
        super(parent, 0);
        this.parentEditor = parentEditor;
        this.createMyControl(this, toolkit);
    }

    public void createMyControl(Composite parent, FormToolkit toolkit) {
        FormLayout layout = new FormLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.spacing = 0;
        layout.marginTop = 0;
        layout.marginBottom = 0;
        layout.marginLeft = 0;
        layout.marginRight = 0;
        parent.setLayout((Layout)layout);
        this.btnAddItem = new Button(parent, 0x1000008);
        int btnW = 45;
        if (UI.OS_WINDOWS) {
            btnW = 35;
            this.btnAddItem.setText("+");
        } else {
            this.btnAddItem.setText("\u2795");
        }
        this.btnAddItem.setToolTipText(Messages.getString((String)"CLIQUER_POUR_PMT_OU_CREDIT", (String[])new String[0]));
        this.btnFilter = new Button(parent, 2);
        this.btnFilter.setText("F");
        this.btnFilter.setSelection(true);
        this.btnFilter.setToolTipText(Messages.getString((String)"FILTER_TTT", (String[])new String[0]));
        this.viewer = new TableViewer(parent, 68354){

            public void add(Object element) {
                XBilledRessourcePaid xd = (XBilledRessourcePaid)element;
                xd.setBilledRessource(BaseBilledRessourcePaidControl.this.getBilledRessource());
                xd.setPaid(BaseBilledRessourcePaidControl.this.getBilledRessource().getSolde());
                xd.setCreatedDatetime(Long.valueOf(DateUtil.now()));
                xd.setNote("");
                this.add(new Object[]{xd});
                BaseBilledRessourcePaidControl.this.getBilledRessource().lstBilledRessourcePaid.add((IMinimalEditableDataObject)xd);
                BaseBilledRessourcePaidControl.this.calculateSoldeFromPaidData();
                BaseBilledRessourcePaidControl.this.getParentEditor().checkDirty();
                BaseBilledRessourcePaidControl.this.viewer.getTable().setFocus();
                BaseBilledRessourcePaidControl.this.viewer.setSelection((ISelection)new StructuredSelection((Object)xd));
                BaseBilledRessourcePaidControl.this.viewer.editElement((Object)xd, 1);
            }

            public void update(Object element, String[] properties) {
                super.update(element, properties);
                BaseBilledRessourcePaidControl.this.calculateSoldeFromPaidData();
            }
        };
        this.viewer.getTable().setHeaderVisible(true);
        this.viewer.getTable().setLinesVisible(true);
        this.viewer.addFilter((ViewerFilter)this.getParentEditor().getHideDeletedItems());
        this.viewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.viewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object o1, Object o2) {
                XBilledRessourcePaid e1 = (XBilledRessourcePaid)o1;
                XBilledRessourcePaid e2 = (XBilledRessourcePaid)o2;
                return e1.getCreatedDatetime().compareTo(e2.getCreatedDatetime());
            }
        });
        TableViewerColumn tcB = new TableViewerColumn(this.viewer, 0);
        tcB.getColumn().setWidth(60);
        tcB.getColumn().setText(STATUS);
        tcB.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return null;
            }

            public Image getImage(Object element) {
                XBilledRessourcePaid p = (XBilledRessourcePaid)element;
                if (p.getModificationStatus() == null) {
                    return null;
                }
                if (Boolean.TRUE.equals(p.getIsDeleted())) {
                    return ResourceGetter.getImage((String)"images/inactive.png");
                }
                return ResourceGetter.getImage((String)"images/icon-active.gif");
            }
        });
        tcB.setEditingSupport((EditingSupport)new TaskEditingSupport(this.viewer, (IBaseEditor)this.getParentEditor(), toolkit, 1));
        TableViewerColumn tcMethodPmt = new TableViewerColumn(this.viewer, 0);
        tcMethodPmt.getColumn().setWidth(90);
        tcMethodPmt.getColumn().setText(Messages.getString((String)"TYPE", (String[])new String[0]));
        tcMethodPmt.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                XBilledRessourcePaid q = (XBilledRessourcePaid)element;
                if (q.getModePaiement() != null) {
                    return q.getModePaiement().toString();
                }
                return "";
            }
        });
        tcMethodPmt.setEditingSupport((EditingSupport)new ComboBoxEditingSupport(this.viewer, (IBaseEditor)this.getParentEditor(), "getModePaiement", "setModePaiement", XModePaiement.class, XModePaiement.values(), null, 1));
        TableViewerColumn tc6 = new TableViewerColumn(this.viewer, 0);
        tc6.getColumn().setWidth(70);
        tc6.getColumn().setAlignment(131072);
        tc6.getColumn().setText("- $ -");
        tc6.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                XBilledRessourcePaid p = (XBilledRessourcePaid)element;
                return p.getPaid().toString();
            }
        });
        tc6.setEditingSupport((EditingSupport)new NumberEditingSupport(this.viewer, (IBaseEditor)this.getParentEditor(), "getPaid", "setPaid", BigDecimal.class, 1));
        TableViewerColumn tcNote = new TableViewerColumn(this.viewer, 0);
        tcNote.getColumn().setWidth(200);
        tcNote.getColumn().setText(Messages.getString((String)"NOTE", (String[])new String[0]));
        tcNote.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                XBilledRessourcePaid p = (XBilledRessourcePaid)element;
                return p.getNote();
            }
        });
        tcNote.setEditingSupport((EditingSupport)new StringEditingSupport(this.viewer, (IBaseEditor)this.getParentEditor(), "getNote", "setNote", 1));
        TableViewerColumn tcDatePaid = new TableViewerColumn(this.viewer, 0);
        tcDatePaid.getColumn().setWidth(130);
        tcDatePaid.getColumn().setText(Messages.getString((String)"DATE", (String[])new String[0]));
        tcDatePaid.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                XBilledRessourcePaid p = (XBilledRessourcePaid)element;
                String formattedCreatedDate = DateUtil.format((Long)p.getCreatedDatetime(), (String)(String.valueOf(FormatDateProvider.getFormatDate().toString()) + " HH:mm"));
                return formattedCreatedDate;
            }
        });
        tcDatePaid.setEditingSupport((EditingSupport)new NumberEditingSupport(this.viewer, (IBaseEditor)this.getParentEditor(), "getCreatedDatetime", null, Long.class, 1));
        parent.setFocus();
        TableViewerEditor.create((TableViewer)this.viewer, (ColumnViewerEditorActivationStrategy)new ColumnViewerEditorActivationStrategy((ColumnViewer)this.viewer), (int)30);
        this.btnAddItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BaseBilledRessourcePaidControl.this.addItem(null);
            }
        });
        this.btnFilter.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (((Button)e.widget).getSelection()) {
                    BaseBilledRessourcePaidControl.this.viewer.addFilter((ViewerFilter)BaseBilledRessourcePaidControl.this.getParentEditor().getHideDeletedItems());
                } else {
                    BaseBilledRessourcePaidControl.this.viewer.removeFilter((ViewerFilter)BaseBilledRessourcePaidControl.this.getParentEditor().getHideDeletedItems());
                }
            }
        });
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)BaseBilledRessourcePaidControl.this.viewer.getSelection();
                XBilledRessourcePaid firstElement = (XBilledRessourcePaid)selection.getFirstElement();
                System.out.println("selectionChanged: " + firstElement);
            }
        });
        FormData data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(0);
        data.width = btnW;
        this.btnAddItem.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.btnAddItem);
        data.left = new FormAttachment(0);
        data.width = btnW;
        this.btnFilter.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment((Control)this.btnAddItem);
        data.right = new FormAttachment(100);
        data.bottom = new FormAttachment(100);
        this.viewer.getTable().setLayoutData((Object)data);
        toolkit.adapt((Composite)this);
    }

    public void updateViewerInput(IEditableDataObjectList<XBilledRessourcePaid> def) {
        System.out.println("updateViewerInput 1");
        if (def != null) {
            Object[] aa = def.toArray();
            this.viewer.setInput((Object)aa);
        } else {
            this.viewer.setInput(null);
        }
        this.setLstBilledRessourcePaid(def);
        if (def != null && def.size() > 0) {
            Timer t = new Timer();
            TimerTask tt = new TimerTask(){

                @Override
                public void run() {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            BaseBilledRessourcePaidControl.this.viewer.setSelection((ISelection)new StructuredSelection(BaseBilledRessourcePaidControl.this.viewer.getElementAt(0)), true);
                        }
                    });
                }
            };
            t.schedule(tt, 100L);
        }
    }

    public final BillingRessourceController getController() {
        return this.controller;
    }

    public void setController(BillingRessourceController controller) {
        this.controller = controller;
    }

    public FakeEditor getParentEditor() {
        return this.parentEditor;
    }

    public final IEditableDataObjectList<XBilledRessourcePaid> getLstRessourceDefData() {
        return this.lstBilledRessourcePaid;
    }

    public final void setLstBilledRessourcePaid(IEditableDataObjectList<XBilledRessourcePaid> lstRessourceDef) {
        this.lstBilledRessourcePaid = lstRessourceDef;
    }

    public final XBilledRessource getBilledRessource() {
        return this.getController().getCurrentBilledRessource();
    }

    public abstract void showCurrent();

    public void addItem(XModePaiement modePmt) {
        if (this.getBilledRessource() != null) {
            XBilledRessourcePaid newDef = new XBilledRessourcePaid();
            newDef.initialize();
            if (modePmt != null) {
                newDef.setModePaiement(modePmt);
            } else {
                newDef.setModePaiement(XModePaiement.COMPTANT);
            }
            this.viewer.add((Object)newDef);
        }
    }

    public void calculateSoldeFromPaidData() {
        BigDecimal paid = new BigDecimal(0);
        for (XBilledRessourcePaid x : this.getBilledRessource().lstBilledRessourcePaid) {
            BigDecimal b = x.getPaid();
            if (!Boolean.FALSE.equals(x.isDeleted) || b == null) continue;
            paid = paid.add(b);
        }
        BigDecimal solde = this.getBilledRessource().getGrandTotal().subtract(paid).setScale(2, 4);
        this.getBilledRessource().setSolde(solde);
        if (BigDecimal.ZERO.compareTo(this.getBilledRessource().getSolde()) == 0) {
            if (!XBilledStatus.PMT_COMPLET.equals((Object)this.getBilledRessource().getStatus())) {
                this.getBilledRessource().setStatus(XBilledStatus.PMT_COMPLET);
            }
        } else if (this.getBilledRessource().getSolde().compareTo(BigDecimal.ZERO) == 1) {
            if (!XBilledStatus.PMT_PARTIEL.equals((Object)this.getBilledRessource().getStatus())) {
                this.getBilledRessource().setStatus(XBilledStatus.PMT_PARTIEL);
            }
        } else if (this.getBilledRessource().getSolde().compareTo(this.getBilledRessource().getGrandTotal()) == 0 && !XBilledStatus.NON_PAYE.equals((Object)this.getBilledRessource().getStatus())) {
            this.getBilledRessource().setStatus(XBilledStatus.NON_PAYE);
        }
    }
}

