/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.preferences.menu;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.CannotConnectToServerException;
import ca.infodata.ofys.data.dataaccess.GenericReportAccessorClient;
import ca.infodata.ofys.data.dataaccess.ICallback;
import ca.infodata.ofys.data.dataaccess.callback.IStatusHandler;
import ca.infodata.ofys.data.dataaccess.callback.JobCallback;
import ca.infodata.ofys.data.dataaccess.util.MessageUtil;
import ca.infodata.ofys.data.dataaccess.util.notification.IConsumerListener;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.XBaseGenericReport;
import ca.infodata.ofys.data.middle.dataobjects.XGenericReport;
import ca.infodata.ofys.data.middle.dataobjects.XImageDecorator;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.data.middle.dataobjects.notification.DataObjectUpdatedNotification;
import ca.infodata.ofys.data.middle.dataobjects.notification.Notification;
import ca.infodata.ofys.ui.controls.ITreeElements;
import ca.infodata.ofys.ui.intro.DefaultStatusHandler;
import ca.infodata.ofys.ui.library.ResourceGetter;
import ca.infodata.ofys.ui.library.log.Log;
import ca.infodata.ofys.ui.menu.DossierPlugin;
import ca.infodata.ofys.ui.menu.treeelements.LoadingElement;
import ca.infodata.ofys.ui.preferences.menu.LabelElements;
import ca.infodata.ofys.ui.preferences.menu.NewLabelElement;
import ca.infodata.util1.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorInput;

public class ListPatientLabelType
implements ITreeElements {
    private static final Logger logger = Logger.getLogger(ListPatientLabelType.class.getName());
    private static final String ETIQUETTE_CLIENT = Messages.getString((String)"ETIQUETTE_CLIENT", (String[])new String[0]);
    private ITreeElements parent;
    private boolean isLoading;
    private ITreeElements[] children;
    private final IConsumerListener consumerListener;

    public ListPatientLabelType(ITreeElements parent) {
        this.parent = parent;
        this.consumerListener = new IConsumerListener(){

            public void handle(DataObjectUpdatedNotification notification) {
                try {
                    if (notification != null && notification.getObject() instanceof XGenericReport) {
                        final DossierPlugin dossierPlugin = DossierPlugin.getDefault();
                        dossierPlugin.getWorkbench().getDisplay().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                ListPatientLabelType.this.children = null;
                                dossierPlugin.refreshTree((ITreeElements)ListPatientLabelType.this);
                            }
                        });
                    }
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Error in ListPatientLabelType", e);
                }
            }

            public void handleOther(Notification notification) {
            }

            public void forceRefresh() {
                try {
                    DossierPlugin.getDefault().refreshTreeInSwtThread((ITreeElements)ListPatientLabelType.this);
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Error in ListPatientLabelType.forceRefresh", e);
                }
            }
        };
        Application.get().getGlobalInstances().getNotificationSystem().addListener(this.consumerListener);
    }

    public Object[] getChildren() {
        if (this.notLoaded()) {
            this.fillAsLoading();
        }
        return this.children;
    }

    private void fillAsLoading() {
        this.isLoading = true;
        this.children = new ITreeElements[]{new LoadingElement((ITreeElements)this)};
        this.find();
    }

    private boolean notLoaded() {
        return this.children == null || this.isLoading;
    }

    private void find() {
        JobCallback callback = new JobCallback(Messages.getString((String)"RECHERCHE_TOUTES_LES_ETIQUETTES_PERSONNALISEES", (String[])new String[0]), (IStatusHandler)DefaultStatusHandler.getInstance()){

            public void responseReceived(ReturnObject response) {
                if (response != null && response.getObj() instanceof XBaseGenericReport[]) {
                    ListPatientLabelType.this.fill((XBaseGenericReport[])response.getObj());
                } else {
                    ListPatientLabelType.this.fill(null);
                }
            }
        };
        try {
            GenericReportAccessorClient.getInstance().findAllBase((ICallback)callback, Application.get().getGlobalInstances().getSession());
        }
        catch (CannotConnectToServerException cannotConnectToServerException) {
            MessageUtil.cannotConnectToServerExceptionMsg();
            callback.kill();
            this.fill(null);
        }
        catch (Exception e) {
            Log.severe((Throwable)e);
            callback.kill();
            this.fill(null);
        }
    }

    private void fill(XBaseGenericReport[] reports) {
        if (reports != null) {
            List<XBaseGenericReport> list2 = Arrays.asList(reports);
            Collections.sort(list2, new Comparator<XBaseGenericReport>(){

                @Override
                public int compare(XBaseGenericReport o1, XBaseGenericReport o2) {
                    if (o1 == o2) {
                        return 0;
                    }
                    if (o1 == null) {
                        return -1;
                    }
                    if (o2 == null) {
                        return 1;
                    }
                    return StringUtils.compareAscii((String)o1.getName(), (String)o2.getName());
                }
            });
            ArrayList<LabelElements> list = new ArrayList<LabelElements>();
            list.add(new NewLabelElement(this));
            XBaseGenericReport[] xBaseGenericReportArray = reports;
            int n = reports.length;
            int n2 = 0;
            while (n2 < n) {
                XBaseGenericReport report = xBaseGenericReportArray[n2];
                list.add(new LabelElements(this, report));
                ++n2;
            }
            this.children = list.toArray(new ITreeElements[list.size()]);
        } else {
            this.children = new ITreeElements[0];
        }
        this.isLoading = false;
        DossierPlugin.getDefault().refreshTree((ITreeElements)this);
    }

    public Object getParent() {
        return this.parent;
    }

    public boolean hasChildren() {
        return true;
    }

    public String getText() {
        return ETIQUETTE_CLIENT;
    }

    public String getTooltipText() {
        return this.getText();
    }

    public Image getImage() {
        return ResourceGetter.getImage((String)"images/label.gif");
    }

    public String getEditorClass() {
        return null;
    }

    public IEditorInput getEditorInput() {
        return null;
    }

    public XImageDecorator getDecorators() {
        return XImageDecorator.NULL_DECORATORS;
    }

    public void setParent(ITreeElements parent) {
        this.parent = parent;
    }

    public void showContextMenu(Control control) {
    }

    public int hashCode() {
        return new String(String.valueOf(this.parent.hashCode()) + " " + this.getClass().getName()).hashCode();
    }

    public boolean equals(Object toCompare) {
        boolean ret = false;
        if (toCompare instanceof ListPatientLabelType && toCompare.hashCode() == this.hashCode()) {
            ret = true;
        }
        return ret;
    }

    public void doKeyListener(Control control, KeyEvent ke) {
    }

    public int getChildrenNumberForPastille() {
        return 0;
    }
}

