/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.person.patient.search.export;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.CommonAccessorClient;
import ca.infodata.ofys.data.middle.dataobjects.export.XExportOrder;
import ca.infodata.ofys.status.IStatus;
import ca.infodata.ofys.status.Status;
import ca.infodata.ofys.status.StatusException;
import ca.infodata.ofys.ui.person.patient.search.export.CsvExporter;
import ca.infodata.ofys.ui.person.patient.search.export.ExportBean;
import ca.infodata.ofys.ui.person.patient.search.export.ExportConfigPage;
import ca.infodata.ofys.ui.person.patient.search.export.ExportDonePage;
import ca.infodata.ofys.ui.person.patient.search.export.ExportFormat;
import ca.infodata.ofys.ui.person.patient.search.export.ExportJobPage;
import ca.infodata.ofys.ui.person.patient.search.export.IExporter;
import ca.infodata.ofys.ui.person.patient.search.export.Xls97Exporter;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;

public class ExportWizard
extends Wizard {
    private static final Logger logger = Logger.getLogger(ExportWizard.class.getName());
    private static ExportBean currentExportBean;
    private ExportConfigPage configPage;
    private ExportJobPage jobPage;
    private ExportDonePage donePage;
    private ExportBean bean = new ExportBean();
    private IProgressMonitor exportProgressMonitor;
    private int fetchSize = 100;
    private long fetchWaitTimeInSeconds = 20L;
    private int fetchCallEtaInSeconds = 5;

    public ExportWizard(List<Integer> ids) throws StatusException {
        this.bean.format = ExportFormat.XLS97;
        this.bean.toFile = ExportBean.getDefaultTargetFile(this.bean.format);
        this.bean.patientIds = ids;
        if (currentExportBean != null) {
            throw new StatusException((IStatus)new Status(IStatus.Severity.WARNING, "Vous ne pouvez ex\u00e9cuter qu'une exportation \u00e0 la fois"));
        }
        currentExportBean = this.bean;
        this.setNeedsProgressMonitor(true);
        this.setHelpAvailable(false);
    }

    public String computeETA() {
        int size = this.bean.patientIds.size();
        int nbIteration = size / this.fetchSize + (size % this.fetchSize == 0 ? 0 : 1);
        int seconds = (int)((long)nbIteration * ((long)this.fetchCallEtaInSeconds + this.fetchWaitTimeInSeconds));
        return String.valueOf(seconds / 60) + " minutes ";
    }

    public void performExport(IProgressMonitor monitor) {
        block17: {
            this.exportProgressMonitor = monitor;
            IExporter exporter = null;
            try {
                try {
                    this.bean.toFile.createNewFile();
                    XExportOrder order = new XExportOrder();
                    order.setExcel(this.bean.format == ExportFormat.XLS97);
                    order.setFields(this.bean.fields);
                    exporter = this.createExporter();
                    int size = this.bean.patientIds.size();
                    monitor.beginTask("Exportation des clients", size);
                    int batchSize = this.fetchSize;
                    ArrayList<Integer> ids = new ArrayList<Integer>();
                    int i = 0;
                    while (i < size) {
                        if (this.hasCanceled(monitor)) break;
                        int fromIndex = i;
                        int toIndex = Math.min(fromIndex + batchSize, size);
                        ids.clear();
                        ids.addAll(this.bean.patientIds.subList(i, toIndex));
                        order.setPatientIds(ids);
                        this.exportToWithRetry(exporter, order, monitor);
                        if (this.hasCanceled(monitor)) break;
                        monitor.worked(ids.size());
                        monitor.subTask(String.valueOf(toIndex) + " export\u00e9s sur " + size);
                        try {
                            TimeUnit.MILLISECONDS.sleep(50L);
                        }
                        catch (Exception exception) {}
                        i += batchSize;
                    }
                    exporter.appendDone();
                    this.bean.exportResult = true;
                    this.bean.exportResultMessage = "";
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Exception while exporting", e);
                    this.bean.exportResult = false;
                    this.bean.exportResultMessage = e.getMessage();
                    if (exporter != null) {
                        try {
                            exporter.close();
                        }
                        catch (Exception e2) {
                            logger.log(Level.SEVERE, "Exception while closing exporter " + exporter, e2);
                        }
                    }
                    this.exportProgressMonitor = null;
                    break block17;
                }
            }
            catch (Throwable throwable) {
                if (exporter != null) {
                    try {
                        exporter.close();
                    }
                    catch (Exception e2) {
                        logger.log(Level.SEVERE, "Exception while closing exporter " + exporter, e2);
                    }
                }
                this.exportProgressMonitor = null;
                throw throwable;
            }
            if (exporter != null) {
                try {
                    exporter.close();
                }
                catch (Exception e2) {
                    logger.log(Level.SEVERE, "Exception while closing exporter " + exporter, e2);
                }
            }
            this.exportProgressMonitor = null;
        }
        this.donePage = new ExportDonePage(this.bean);
        this.addPage((IWizardPage)this.donePage);
    }

    private boolean hasCanceled(IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            this.bean.exportResult = false;
            this.bean.exportResultMessage = "Vous avez annul\u00e9 l'exportation";
            return true;
        }
        return false;
    }

    private IExporter createExporter() throws Exception {
        if (this.bean.format == ExportFormat.XLS97) {
            return new Xls97Exporter(this.bean);
        }
        if (this.bean.format == ExportFormat.CSV) {
            return new CsvExporter(this.bean);
        }
        throw new Exception("Format non support\u00e9 " + (Object)((Object)this.bean.format));
    }

    private void exportToWithRetry(IExporter exporter, XExportOrder order, IProgressMonitor monitor) throws Exception {
        List data = null;
        int dataTry = 0;
        boolean dataOk = false;
        do {
            if (this.hasCanceled(monitor)) {
                return;
            }
            try {
                ++dataTry;
                data = CommonAccessorClient.getInstance().exportSearchResult(order, Application.get().getGlobalInstances().getSession());
                dataOk = true;
            }
            catch (Exception exception) {
                dataOk = false;
                try {
                    TimeUnit.SECONDS.sleep(5L);
                }
                catch (InterruptedException interruptedException) {}
            }
        } while (!dataOk && dataTry < 3);
        if (data == null) {
            throw new Exception("Impossible d'obtenir les donn\u00e9es d'exportations du serveur.");
        }
        if (this.hasCanceled(monitor)) {
            return;
        }
        try {
            exporter.append(data);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error writing data to exporter", e);
            throw new Exception("Erreur lors de l'\u00e9criture des donn\u00e9s dans le fichier " + this.bean.toFile.getName());
        }
    }

    public void addPages() {
        this.configPage = new ExportConfigPage(this.bean);
        this.addPage((IWizardPage)this.configPage);
        this.jobPage = new ExportJobPage(this.bean);
        this.addPage((IWizardPage)this.jobPage);
    }

    public void performPreviousPage() {
        this.getContainer().showPage(this.getPreviousPage(this.getContainer().getCurrentPage()));
    }

    public void performNextPage() {
        IWizardPage currentPage = this.getContainer().getCurrentPage();
        if (currentPage.canFlipToNextPage()) {
            this.getContainer().showPage(this.getNextPage(this.getContainer().getCurrentPage()));
        }
    }

    public boolean canNextPage() {
        IWizardPage page = this.getContainer().getCurrentPage();
        return page.isPageComplete() && page == this.configPage;
    }

    public boolean canPreviousPage() {
        return this.exportProgressMonitor == null || this.exportProgressMonitor.isCanceled();
    }

    public boolean canExport() {
        IWizardPage page = this.getContainer().getCurrentPage();
        return page == this.jobPage && page.isPageComplete() && this.exportProgressMonitor == null;
    }

    public boolean canFinish() {
        return false;
    }

    public boolean performFinish() {
        currentExportBean = null;
        return false;
    }

    public boolean performCancel() {
        currentExportBean = null;
        return super.performCancel();
    }
}

