/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.person.patient.search.editor;

import apple.finder.search.ui.AppleFinderGrid;
import apple.finder.search.ui.IAppleFinderGridFactory;
import apple.finder.search.ui.ICriteriaField;
import apple.finder.search.ui.ICriteriaRowFactory;
import apple.finder.search.ui.ISetFactory;
import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.BaseAccessorClient;
import ca.infodata.ofys.data.dataaccess.CannotConnectToServerException;
import ca.infodata.ofys.data.dataaccess.CommonAccessorClient;
import ca.infodata.ofys.data.dataaccess.ICallback;
import ca.infodata.ofys.data.dataaccess.callback.EventLockCallback;
import ca.infodata.ofys.data.dataaccess.util.MessageUtil;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.EditableDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.data.middle.dataobjects.preferences.FormatDateProvider;
import ca.infodata.ofys.data.middle.dataobjects.search.XSearchResult;
import ca.infodata.ofys.ui.controls.BaseEditor;
import ca.infodata.ofys.ui.controls.BaseView;
import ca.infodata.ofys.ui.controls.EditorInput;
import ca.infodata.ofys.ui.controls.form.MyButton;
import ca.infodata.ofys.ui.controls.form.MyLabel;
import ca.infodata.ofys.ui.controls.form.MyText;
import ca.infodata.ofys.ui.library.ResourceGetter;
import ca.infodata.ofys.ui.person.PersonUiPlugin;
import ca.infodata.ofys.ui.person.patient.search.AbstractCriteria;
import ca.infodata.ofys.ui.person.patient.search.IAppleFinderGridFactory2;
import ca.infodata.ofys.ui.person.patient.search.XmlSetFactory;
import ca.infodata.ofys.ui.person.patient.search.editor.SearchResultView;
import ca.infodata.util1.StringUtils;
import ca.infodata.util1.date.DateUtil;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;

public class SearchResultEditor
extends BaseEditor
implements IAppleFinderGridFactory2 {
    private static final Logger logger = Logger.getLogger(SearchResultEditor.class.getName());
    public static final String PATIENT_SEARCH_CRITERIA_ID = "ca.infodata.ofys.ui.person.patientSearchCriteria";
    private Map<ICriteriaField, ICriteriaRowFactory> fields;
    private Map<ICriteriaField, AbstractCriteria> fields2;
    private AppleFinderGrid grid;
    private MyLabel lblDate;
    private MyLabel lblId;
    private MyLabel lblOrderId;
    private MyLabel lblOrderName;
    private MyLabel lblUser;
    private MyLabel lblTotal;
    private MyText txtErrorMessage;
    private MyButton btnBrowseResult;

    public void showDataObject() {
        XSearchResult result = this.getResult();
        if (result == null) {
            this.lblId.setTextWithPrefix((Object)"");
            this.lblDate.setTextWithPrefix((Object)"");
            this.lblOrderId.setTextWithPrefix((Object)"");
            this.lblOrderName.setTextWithPrefix((Object)"");
            this.lblTotal.setTextWithPrefix((Object)"");
            this.lblUser.setTextWithPrefix((Object)"");
            this.txtErrorMessage.clear();
            this.grid.deleteAll();
        } else {
            this.lblId.setTextWithPrefix((Object)result.getId());
            this.lblDate.setTextWithPrefix((Object)DateUtil.format((Long)result.getDatetime(), (String)(String.valueOf(FormatDateProvider.getFormatDate().toString()) + " HH:mm")));
            this.lblOrderId.setTextWithPrefix((Object)result.getOrderId());
            this.lblOrderName.setTextWithPrefix((Object)result.getOrderName());
            this.lblTotal.setTextWithPrefix((Object)result.getTotal());
            this.lblUser.setTextWithPrefix((Object)PersonUiPlugin.getDefault().getUserCompleteName(result.getUserId()));
            this.txtErrorMessage.setText(result.getErrorMessage());
            try {
                XmlSetFactory factory = new XmlSetFactory(this, result.getOrderTemplateXml());
                this.grid.setGroup((ISetFactory)factory);
            }
            catch (Exception exception) {
                logger.log(Level.SEVERE, "Failed to load xml into grid for result " + StringUtils.safeToString((Logger)logger, (Object)result));
                MessageUtil.bugMsg((Shell)this.getSite().getShell(), (String)"\u00c9chec du chargement de la grille de recherche");
            }
        }
    }

    public void initDataOverride() {
        EditorInput input = (EditorInput)this.getEditorInput();
        XSearchResult order = (XSearchResult)input.getDataObject();
        this.initializeCompleteDataObject((EditableDataObject)order);
    }

    public void createMyControl(Composite parent) {
        this.lblDate = new MyLabel(parent, "Date : ", 16384, this.toolkit);
        this.lblId = new MyLabel(parent, "Id : ", 16384, this.toolkit);
        this.lblOrderId = new MyLabel(parent, "Id de la demande : ", 16384, this.toolkit);
        this.lblOrderName = new MyLabel(parent, "Nom de la demande : ", 16384, this.toolkit);
        this.lblUser = new MyLabel(parent, "Demandeur : ", 16384, this.toolkit);
        this.lblTotal = new MyLabel(parent, "Total : ", 16384, this.toolkit);
        MyLabel lblErrorMessage = new MyLabel(parent, "Message d'erreur : ", 16448, this.toolkit);
        this.txtErrorMessage = new MyText(parent, 2626);
        this.btnBrowseResult = new MyButton(parent, "Consulter la liste", 8, this.toolkit);
        this.btnBrowseResult.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SearchResultEditor.this.doBrowseResult();
            }
        });
        this.grid = new AppleFinderGrid(parent, 0){

            public void layoutRows() {
                super.layoutRows();
                if (!this.isDeferRowLayout()) {
                    SearchResultEditor.this.getForm().reflow(true);
                }
            }
        };
        this.grid.setFactory((IAppleFinderGridFactory)this);
        this.grid.setEnabled(false);
        FormLayout layout = new FormLayout();
        layout.spacing = 5;
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        parent.setLayout((Layout)layout);
        FormData data = new FormData();
        data.top = new FormAttachment(0);
        data.right = new FormAttachment(100);
        data.width = 200;
        this.btnBrowseResult.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(0);
        this.lblDate.setLayoutData((Object)data);
        Control control = this.lblDate.getControl();
        data = new FormData();
        data.top = new FormAttachment(control);
        data.left = new FormAttachment(0);
        this.lblId.setLayoutData((Object)data);
        control = this.lblId.getControl();
        data = new FormData();
        data.top = new FormAttachment(control);
        data.left = new FormAttachment(0);
        this.lblOrderId.setLayoutData((Object)data);
        control = this.lblOrderId.getControl();
        data = new FormData();
        data.top = new FormAttachment(control);
        data.left = new FormAttachment(0);
        this.lblOrderName.setLayoutData((Object)data);
        control = this.lblOrderName.getControl();
        data = new FormData();
        data.top = new FormAttachment(control);
        data.left = new FormAttachment(0);
        this.lblUser.setLayoutData((Object)data);
        control = this.lblUser.getControl();
        data = new FormData();
        data.top = new FormAttachment(control);
        data.left = new FormAttachment(0);
        this.lblTotal.setLayoutData((Object)data);
        control = this.lblTotal.getControl();
        data = new FormData();
        data.top = new FormAttachment(control);
        data.left = new FormAttachment(0);
        lblErrorMessage.setLayoutData((Object)data);
        control = lblErrorMessage.getControl();
        data = new FormData();
        data.top = new FormAttachment(control);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        data.height = 200;
        this.txtErrorMessage.setLayoutData((Object)data);
        control = this.txtErrorMessage.getControl();
        data = new FormData();
        data.top = new FormAttachment(control);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        data.bottom = new FormAttachment(100);
        this.grid.setLayoutData((Object)data);
    }

    protected void doBrowseResult() {
        EventLockCallback callback = new EventLockCallback(){

            protected void responseOverride(final ReturnObject response) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        SearchResultEditor.this.doBrowseResult((List)response.getObj());
                    }
                });
            }
        };
        try {
            CommonAccessorClient.getInstance().getSearchResultIds(this.getResult(), Application.get().getGlobalInstances().getSession(), (ICallback)callback);
        }
        catch (CannotConnectToServerException cannotConnectToServerException) {
            MessageUtil.cannotConnectToServerExceptionMsg();
            callback.kill();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to get ids from result " + this.getResult(), e);
            callback.kill();
        }
    }

    private void doBrowseResult(List<Integer> ids) {
        IViewPart viewPart = BaseView.openView(SearchResultView.class, (int)3);
        if (viewPart instanceof SearchResultView) {
            SearchResultView view = (SearchResultView)viewPart;
            view.setPartName(this.getResult().format());
            view.setIds(ids);
        }
    }

    public BaseAccessorClient getAccessor() throws CannotConnectToServerException {
        return CommonAccessorClient.getInstance();
    }

    public XSearchResult getResult() {
        EditorInput input = (EditorInput)this.getEditorInput();
        return input == null ? null : (XSearchResult)input.getCompleteDataObject();
    }

    public void setToolBarStatus() {
    }

    public boolean isDataDirty() {
        return false;
    }

    public Image getEditorTitleImage() {
        return ResourceGetter.getImage((String)"images/search-icon32.png");
    }

    public String getEditorTitle() {
        XSearchResult r = this.getResult();
        if (r != null) {
            return String.valueOf(DateUtil.format((Long)r.getDatetime(), (String)(String.valueOf(FormatDateProvider.getFormatDate().toString()) + " HH:mm"))) + "  " + r.getOrderName();
        }
        return Messages.getString((String)"RESULTATS", (String[])new String[0]);
    }

    public Set<ICriteriaField> getFields() {
        if (this.fields == null) {
            this.fields2 = new HashMap<ICriteriaField, AbstractCriteria>();
            this.fields = new TreeMap<ICriteriaField, ICriteriaRowFactory>(new Comparator<ICriteriaField>(){

                @Override
                public int compare(ICriteriaField o1, ICriteriaField o2) {
                    return StringUtils.compareAscii((String)o1.getText(), (String)o2.getText());
                }
            });
            IConfigurationElement[] config = Platform.getExtensionRegistry().getConfigurationElementsFor(PATIENT_SEARCH_CRITERIA_ID);
            try {
                IConfigurationElement[] iConfigurationElementArray = config;
                int n = config.length;
                int n2 = 0;
                while (n2 < n) {
                    AbstractCriteria factory;
                    IConfigurationElement e = iConfigurationElementArray[n2];
                    AbstractCriteria field = factory = (AbstractCriteria)e.createExecutableExtension("factory");
                    this.fields.put(field, factory);
                    this.fields2.put(field, factory);
                    ++n2;
                }
            }
            catch (CoreException ex) {
                logger.log(Level.WARNING, "Failed to load patient search criteria extensions for " + this.getClass().getName(), ex);
            }
        }
        return this.fields.keySet();
    }

    public ICriteriaRowFactory get(ICriteriaField field) {
        return this.fields.get(field);
    }

    @Override
    public AbstractCriteria getCriteria(ICriteriaField field) {
        return this.fields2.get(field);
    }
}

