/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.person.patient.search;

import apple.finder.search.ui.ICriteriaOperator;
import ca.infodata.ofys.data.middle.dataobjects.search.CID;
import ca.infodata.ofys.data.middle.dataobjects.search.ServerCriteria;
import ca.infodata.ofys.ui.controls.DateText;
import ca.infodata.ofys.ui.controls.calendarcombo.MyCalendarText;
import ca.infodata.ofys.ui.person.patient.search.AbstractCriteria;
import ca.infodata.ofys.ui.person.patient.search.CriteriaOperator;
import ca.infodata.util1.StringUtils;
import ca.infodata.util1.date.IPartialDate;
import ca.infodata.util1.date.LocalDate;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.widgets.Composite;

public abstract class AbstractDateCriteria
extends AbstractCriteria {
    public AbstractDateCriteria(CID cid, String text) {
        super(cid, text);
    }

    public AbstractDateCriteria(CID cid) {
        super(cid);
    }

    public String getOperatorPrefix() {
        return null;
    }

    public List<? extends ICriteriaOperator> getOperators() {
        List<CriteriaOperator> list = Arrays.asList(CriteriaOperator.IS_NULL, CriteriaOperator.LT, CriteriaOperator.LE, CriteriaOperator.EQ, CriteriaOperator.GE, CriteriaOperator.GT);
        return list;
    }

    public ICriteriaOperator getDefaultOperator() {
        return CriteriaOperator.EQ;
    }

    public Object createValueControl(Composite parent, ICriteriaOperator operator, Object valueReference) {
        if (this.operatorIn(operator, CriteriaOperator.LT, CriteriaOperator.LE, CriteriaOperator.EQ, CriteriaOperator.GE, CriteriaOperator.GT)) {
            final LocalDate[] date = valueReference == null ? new LocalDate[1] : valueReference;
            MyCalendarText text = new MyCalendarText(parent, 0);
            text.setDate((IPartialDate)date[0]);
            text.getTextControl().setMessage("Entrez une date");
            text.getTextControl().addDateListener((DateText.IDateListener)new DateText.DateAdapter(){

                public void dateChanged(LocalDate d) {
                    date[0] = d;
                }
            });
            return date;
        }
        return null;
    }

    @Override
    public ServerCriteria toCriteria(ICriteriaOperator operator, Object valueReference) {
        ServerCriteria c = new ServerCriteria();
        c.id = this.cid;
        c.operator = ((CriteriaOperator)operator).getOperator();
        if (valueReference != null) {
            LocalDate[] date = (LocalDate[])valueReference;
            c.value = date[0];
        } else {
            c.value = null;
        }
        return c;
    }

    @Override
    public Map<String, String> valueToXml(ICriteriaOperator operator, Object valueReference) {
        LocalDate[] date = (LocalDate[])valueReference;
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("value", date == null || date[0] == null ? null : String.valueOf(date[0].dayFrom1970));
        return map;
    }

    @Override
    public Object xmlToValue(Map<String, String> map) {
        String svalue = map.get("value");
        LocalDate[] date = new LocalDate[1];
        if (StringUtils.isNotBlank((String)svalue)) {
            date[0] = LocalDate.fromDayFrom1970((int)Integer.parseInt(svalue));
        }
        return date;
    }
}

