/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.person.patient;

import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.patient.XPatientInactiveRaison;
import ca.infodata.ofys.ui.controls.calendarcombo.MyCalendarText;
import ca.infodata.ofys.ui.controls.form.MyButton;
import ca.infodata.ofys.ui.controls.form.MyLabel;
import ca.infodata.ofys.ui.controls.form.MyText;
import ca.infodata.ofys.ui.controls.form.combo.MyCombo;
import ca.infodata.ofys.ui.library.ResourceGetter;
import ca.infodata.ofys.ui.library.UI;
import ca.infodata.util1.StringUtils;
import ca.infodata.util1.date.IPartialDate;
import ca.infodata.util1.date.LocalDate;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.widgets.FormToolkit;

public abstract class PatientInactiationDialog {
    private Shell dialog;
    private FormToolkit toolkit;
    private MyButton btnRemoveAppRec;
    private MyCalendarText txtRaisonDate;
    private MyCombo<XPatientInactiveRaison> cmbRaison;
    private MyLabel lblAutre;
    private MyText txtAutre;
    private boolean haveFinish = false;
    private boolean fromDcd;

    public PatientInactiationDialog(Shell parent, String delAppRecallText) {
        this.createDialog(parent, delAppRecallText);
    }

    private void createDialog(Shell parent, String delAppRecallText) {
        this.dialog = new Shell(parent, 67680);
        FormLayout layout = new FormLayout();
        layout.marginBottom = 10;
        layout.marginTop = 10;
        layout.marginLeft = 10;
        layout.marginRight = 10;
        layout.spacing = 10;
        this.dialog.setText(Messages.getString((String)"PATIENT_INACTIVE_DIALOG.TITLE", (String[])new String[0]));
        this.dialog.setLayout((Layout)layout);
        this.dialog.setBackground(ResourceGetter.getColor((int)255, (int)255, (int)255));
        this.toolkit = UI.createToolKit((Widget)this.dialog);
        this.createChilds(this.dialog, delAppRecallText);
    }

    private void createChilds(Shell parent, String delAppRecallText) {
        MyLabel lblRemoveText = null;
        if (StringUtils.isNotBlank((String)delAppRecallText)) {
            lblRemoveText = new MyLabel((Composite)parent, delAppRecallText, 0, this.toolkit);
            this.btnRemoveAppRec = new MyButton((Composite)parent, Messages.getString((String)"PATIENT_INACTIVE_DIALOG.CANCEL_CHKBOX", (String[])new String[0]), 32, this.toolkit);
            this.btnRemoveAppRec.setSelection(true);
        }
        MyLabel lblRaison = new MyLabel((Composite)parent, Messages.getString((String)"PATIENT_INACTIVE_DIALOG.RAISON_DES", (String[])new String[0]), 0, this.toolkit);
        this.lblAutre = new MyLabel((Composite)parent, Messages.getString((String)"PATIENT_INACTIVE_DIALOG.ADD_NOTE", (String[])new String[0]), 0, this.toolkit);
        this.txtRaisonDate = new MyCalendarText((Composite)parent, 0, this.toolkit);
        this.cmbRaison = new MyCombo((Composite)parent, 0, this.toolkit);
        this.txtAutre = new MyText((Composite)parent, this.toolkit);
        MyButton btnContinue = new MyButton((Composite)parent, Messages.getString((String)"PATIENT_INACTIVE_DIALOG.CONTINUER", (String[])new String[0]), 8, this.toolkit);
        MyButton btnCancel = new MyButton((Composite)parent, Messages.getString((String)"PATIENT_INACTIVE_DIALOG.ANNULER", (String[])new String[0]), 8, this.toolkit);
        this.lblAutre.setFont(-3, 0);
        this.dialog.setTabList(new Control[]{this.cmbRaison.getControl(), this.txtRaisonDate, this.txtAutre.getControl()});
        FormData data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        lblRaison.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(lblRaison.getControl());
        data.left = new FormAttachment(0);
        this.cmbRaison.setLayoutData(data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.cmbRaison.getControl(), 0, 0x1000000);
        data.left = new FormAttachment((Control)this.cmbRaison.getControl(), 5);
        data.right = new FormAttachment(100);
        this.txtRaisonDate.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.cmbRaison.getControl(), 5);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        this.txtAutre.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.txtAutre.getControl(), -3);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        this.lblAutre.setLayoutData((Object)data);
        if (lblRemoveText != null) {
            data = new FormData();
            data.top = new FormAttachment(this.lblAutre.getControl(), 8);
            data.left = new FormAttachment(5);
            data.right = new FormAttachment(100);
            lblRemoveText.setLayoutData((Object)data);
            data = new FormData();
            data.top = new FormAttachment(lblRemoveText.getControl());
            data.left = new FormAttachment(0);
            data.right = new FormAttachment(100);
            this.btnRemoveAppRec.setLayoutData((Object)data);
            data = new FormData();
            data.top = new FormAttachment(this.btnRemoveAppRec.getControl(), 5);
            data.right = new FormAttachment(100);
            btnContinue.setLayoutData((Object)data);
        } else {
            data = new FormData();
            data.top = new FormAttachment(this.lblAutre.getControl(), 5);
            data.right = new FormAttachment(100);
            btnContinue.setLayoutData((Object)data);
        }
        data = new FormData();
        data.top = new FormAttachment(btnContinue.getControl(), 0, 0x1000000);
        data.right = new FormAttachment(btnContinue.getControl(), 3);
        btnCancel.setLayoutData((Object)data);
        btnContinue.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                boolean mustDeleteAppRec = PatientInactiationDialog.this.btnRemoveAppRec == null ? false : PatientInactiationDialog.this.btnRemoveAppRec.getSelection();
                XPatientInactiveRaison raison = (XPatientInactiveRaison)PatientInactiationDialog.this.cmbRaison.getSelection();
                IPartialDate date = PatientInactiationDialog.this.txtRaisonDate.getPartialDate();
                String comments = PatientInactiationDialog.this.txtAutre.getText();
                PatientInactiationDialog.this.haveFinish = true;
                PatientInactiationDialog.this.onFinsh(mustDeleteAppRec, raison, date, comments);
                PatientInactiationDialog.this.dialog.close();
            }
        });
        btnCancel.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                PatientInactiationDialog.this.dialog.close();
            }
        });
        XPatientInactiveRaison[] xPatientInactiveRaisonArray = XPatientInactiveRaison.values();
        int n = xPatientInactiveRaisonArray.length;
        int n2 = 0;
        while (n2 < n) {
            XPatientInactiveRaison xpir = xPatientInactiveRaisonArray[n2];
            this.cmbRaison.add((Object)xpir);
            ++n2;
        }
        this.cmbRaison.setDefaultSelection((Object)XPatientInactiveRaison.AUTRE);
        this.txtRaisonDate.setDate((IPartialDate)LocalDate.today());
        this.cmbRaison.setFocus();
    }

    protected abstract void onFinsh(boolean var1, XPatientInactiveRaison var2, IPartialDate var3, String var4);

    private void showData() {
        this.cmbRaison.setEnabled(!this.fromDcd);
        if (this.fromDcd) {
            this.lblAutre.setVisible(false);
            this.txtAutre.setVisible(false);
            this.txtRaisonDate.setFocus();
        }
    }

    public boolean open() {
        this.dialog.pack();
        UI.centerComposite((Composite)this.dialog, (Composite)this.dialog.getParent());
        this.dialog.open();
        UI.waitForWindowToClose((Shell)this.dialog);
        return this.haveFinish;
    }

    public void setInactionRaison(XPatientInactiveRaison r) {
        this.cmbRaison.select((Object)r);
    }

    public void setInactionDate(IPartialDate d) {
        this.txtRaisonDate.setDate(d);
    }

    public void fromDcd(boolean d) {
        this.fromDcd = d;
        this.showData();
    }
}

