/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.person.menu;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.XBasePatient;
import ca.infodata.ofys.data.middle.dataobjects.XRight;
import ca.infodata.ofys.data.middle.dataobjects.XSession;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IPatient;
import ca.infodata.ofys.ui.controls.BaseEditor;
import ca.infodata.ofys.ui.controls.BaseView;
import ca.infodata.ofys.ui.controls.EditorInput;
import ca.infodata.ofys.ui.controls.IContributionManagerExtension;
import ca.infodata.ofys.ui.controls.plugins.searchview.BaseSearchView;
import ca.infodata.ofys.ui.library.ResourceGetter;
import ca.infodata.ofys.ui.person.PersonMultiEditorFactory;
import ca.infodata.ofys.ui.person.patient.PatientMultiEditor;
import ca.infodata.ofys.ui.person.search.PatientSearchView;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IWorkbenchPage;

public class PersonContributionManagerExtension
implements IContributionManagerExtension {
    protected final boolean usingTabletPerspective;

    public PersonContributionManagerExtension() {
        IWorkbenchPage page = BaseView.getPage();
        IPerspectiveDescriptor perspective = page.getPerspective();
        this.usingTabletPerspective = perspective != null && perspective.getId().equals("ca.infodata.ofys.ui.menu.EncounterPerspective");
    }

    public void contribute(IContributionManager manager) {
        XSession session;
        if (Application.get().getGlobalInstances().hasRight(XRight.PATIENT) && (session = Application.get().getGlobalInstances().getSession()) != null && manager instanceof IToolBarManager) {
            if (!this.usingTabletPerspective) {
                Action newPatient = new Action(){

                    public void run() {
                        if (Application.get().getGlobalInstances().getSession() != null && Application.get().getGlobalInstances().getSession().getClientPreferences() != null && Application.get().getGlobalInstances().getSession().getClientPreferences().isMultiplePatientWindows()) {
                            PersonMultiEditorFactory.openPatient((IPatient)new XBasePatient());
                        } else {
                            BaseEditor.openEditorSafePlain((IEditorInput)new EditorInput((IDataObject)new XBasePatient()), (String)PatientMultiEditor.class.getName());
                        }
                    }
                };
                newPatient.setImageDescriptor(ImageDescriptor.createFromImage((Image)ResourceGetter.getImage((String)"images/person-add32.png")));
                newPatient.setToolTipText(Messages.getString((String)"DossierPerspective.openNewPt", (String[])new String[0]));
                manager.add((IAction)newPatient);
            }
            Action searchPatient = new Action(){

                public void run() {
                    BaseSearchView.openView(PatientSearchView.class);
                }
            };
            searchPatient.setImageDescriptor(ImageDescriptor.createFromImage((Image)ResourceGetter.getImage((String)"images/person-search32.png")));
            searchPatient.setToolTipText(Messages.getString((String)"DossierPerspective.openSearchPt", (String[])new String[0]));
            manager.add((IAction)searchPatient);
        }
    }
}

