/*
 * Decompiled with CFR 0.152.
 */
package org.nightlabs.util.ds;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

class DirectedGraphNode<T> {
    private List<DirectedGraphNode<T>> children = new ArrayList<DirectedGraphNode<T>>();
    private T value;
    private int inDegree = 0;
    private int inDegreeStored;

    public DirectedGraphNode(T value) {
        this.value = value;
    }

    public int getInDegree() {
        return this.inDegree;
    }

    public void decrementInDegree() {
        --this.inDegree;
    }

    public void addChild(DirectedGraphNode<T> child) {
        if (!this.children.contains(child)) {
            this.children.add(child);
            ++child.inDegree;
        }
    }

    public void storeInDegree() {
        this.inDegreeStored = this.inDegree;
    }

    public void restoreInDegree() {
        this.inDegree = this.inDegreeStored;
    }

    public Collection<DirectedGraphNode<T>> getChildren() {
        return this.children;
    }

    public T getElement() {
        return this.value;
    }

    public String toString() {
        return "(" + this.value.toString() + ", " + this.inDegree + ")";
    }
}

