/*
 * Decompiled with CFR 0.152.
 */
package org.nightlabs.io.pcx;

import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import javax.imageio.ImageReader;
import javax.imageio.spi.ImageReaderSpi;
import org.nightlabs.io.pcx.ImageInputStream;
import org.nightlabs.io.pcx.PCXImageReader;
import org.nightlabs.io.pcx.PCXReaderWriterConstants;

public class PCXImageReaderSPI
extends ImageReaderSpi {
    public PCXImageReaderSPI() {
        this.init();
    }

    public PCXImageReaderSPI(String vendorName, String version, String[] names, String[] suffixes, String[] MIMETypes, String readerClassName, Class[] inputTypes, String[] writerSpiNames, boolean supportsStandardStreamMetadataFormat, String nativeStreamMetadataFormatName, String nativeStreamMetadataFormatClassName, String[] extraStreamMetadataFormatNames, String[] extraStreamMetadataFormatClassNames, boolean supportsStandardImageMetadataFormat, String nativeImageMetadataFormatName, String nativeImageMetadataFormatClassName, String[] extraImageMetadataFormatNames, String[] extraImageMetadataFormatClassNames) {
        super(vendorName, version, names, suffixes, MIMETypes, readerClassName, inputTypes, writerSpiNames, supportsStandardStreamMetadataFormat, nativeStreamMetadataFormatName, nativeStreamMetadataFormatClassName, extraStreamMetadataFormatNames, extraStreamMetadataFormatClassNames, supportsStandardImageMetadataFormat, nativeImageMetadataFormatName, nativeImageMetadataFormatClassName, extraImageMetadataFormatNames, extraImageMetadataFormatClassNames);
    }

    protected void init() {
        this.inputTypes = new Class[]{InputStream.class, javax.imageio.stream.ImageInputStream.class};
        this.suffixes = PCXReaderWriterConstants.suffixes;
        this.names = PCXReaderWriterConstants.names;
    }

    @Override
    public boolean canDecodeInput(Object source) throws IOException {
        if (source != null) {
            if (source instanceof InputStream) {
                return this.checkHeader((InputStream)source);
            }
            if (source instanceof javax.imageio.stream.ImageInputStream) {
                javax.imageio.stream.ImageInputStream imageStream = (javax.imageio.stream.ImageInputStream)source;
                ImageInputStream iis = new ImageInputStream(imageStream);
                return this.checkHeader(iis);
            }
        }
        return false;
    }

    protected boolean checkHeader(InputStream in) {
        return PCXImageReader.getHeader(in) != null;
    }

    @Override
    public ImageReader createReaderInstance(Object extension) throws IOException {
        return new PCXImageReader(this);
    }

    @Override
    public String getDescription(Locale locale) {
        return "PCX Format Reader";
    }
}

