/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.library.log.console;

import ca.infodata.ofys.ui.library.log.LoggerTreeControl;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.part.ViewPart;

public class LogConsoleView
extends ViewPart {
    private static String[] levelsText = new String[]{"Off", "Severe", "Warning", "Info", "Config", "Fine", "Finer", "Finest", "All"};
    private static Level[] levels = new Level[]{Level.OFF, Level.SEVERE, Level.WARNING, Level.INFO, Level.CONFIG, Level.FINE, Level.FINER, Level.FINEST, Level.ALL};
    private StyledText text;
    private Composite main;
    private Button btnErase;
    private Combo cmbLevel;
    private TabFolder folder;
    private TabItem consoleTab;
    private TabItem loggerTab;
    private ConsoleLogHandler consoleLogHandler;
    private ConsoleOutputStream serr;
    private ConsoleOutputStream sout;

    public void createPartControl(Composite parent) {
        this.main = new Composite(parent, 2048);
        this.main.setLayout((Layout)new FillLayout());
        this.folder = new TabFolder(this.main, 0);
        this.consoleTab = new TabItem(this.folder, 0);
        this.consoleTab.setText("Console");
        Composite consoleMain = new Composite((Composite)this.folder, 0);
        this.consoleTab.setControl((Control)consoleMain);
        this.btnErase = new Button(consoleMain, 8);
        this.btnErase.setText("effacer");
        this.cmbLevel = new Combo(consoleMain, 8);
        this.cmbLevel.setItems(levelsText);
        this.text = new StyledText(consoleMain, 522);
        FormLayout layout = new FormLayout();
        layout.spacing = 5;
        consoleMain.setLayout((Layout)layout);
        FormData data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(50);
        this.btnErase.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment((Control)this.btnErase);
        data.right = new FormAttachment(100);
        this.cmbLevel.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.btnErase);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        data.bottom = new FormAttachment(100);
        this.text.setLayoutData((Object)data);
        this.loggerTab = new TabItem(this.folder, 0);
        this.loggerTab.setText("Logger");
        Composite loggerMain = new Composite((Composite)this.folder, 0);
        this.loggerTab.setControl((Control)loggerMain);
        new LoggerTreeControl(loggerMain);
        loggerMain.setLayout((Layout)new FillLayout());
        this.consoleLogHandler = new ConsoleLogHandler();
        this.cmbLevel.select(0);
        this.consoleLogHandler.setLevel(Level.OFF);
        Logger.getLogger("").addHandler(this.consoleLogHandler);
        this.sout = new ConsoleOutputStream(System.out);
        System.setOut(new PrintStream(this.sout, true));
        this.serr = new ConsoleOutputStream(System.err);
        System.setErr(new PrintStream(this.serr, true));
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                Logger.getLogger("").removeHandler(LogConsoleView.this.consoleLogHandler);
                LogConsoleView.this.sout.dispose();
                LogConsoleView.this.serr.dispose();
            }
        });
        this.btnErase.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LogConsoleView.this.text.setText("");
            }
        });
        this.cmbLevel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int selectionIndex = LogConsoleView.this.cmbLevel.getSelectionIndex();
                if (selectionIndex != -1) {
                    LogConsoleView.this.consoleLogHandler.setLevel(levels[selectionIndex]);
                }
            }
        });
    }

    private void appendToConsole(final String s) {
        if (s != null) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    LogConsoleView.this.text.append(s);
                }
            });
        }
    }

    public void setFocus() {
        this.main.setFocus();
    }

    private class ConsoleLogHandler
    extends Handler {
        public ConsoleLogHandler() {
            this.setLevel(Level.OFF);
            this.setFormatter(new SimpleFormatter());
        }

        @Override
        public void publish(LogRecord record) {
            if (this.isLoggable(record)) {
                LogConsoleView.this.appendToConsole(this.getFormatter().format(record));
            }
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() throws SecurityException {
        }
    }

    private class ConsoleOutputStream
    extends OutputStream {
        private ByteArrayOutputStream stream;
        private final PrintStream printStream;

        public ConsoleOutputStream(PrintStream printStream) {
            if (printStream == null) {
                throw new NullPointerException("printStream");
            }
            this.printStream = printStream;
            this.stream = new ByteArrayOutputStream(1000);
        }

        @Override
        public void write(int b) throws IOException {
            this.printStream.write(b);
            if (this.stream != null) {
                this.stream.write(b);
            }
        }

        @Override
        public void flush() throws IOException {
            this.printStream.flush();
            if (this.stream != null) {
                LogConsoleView.this.appendToConsole(this.stream.toString("UTF-8"));
                this.stream.reset();
            }
        }

        @Override
        public void close() throws IOException {
            if (this.stream != null) {
                this.stream.close();
            }
            this.printStream.close();
        }

        public void dispose() {
            this.stream = null;
        }
    }
}

