/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.library;

import ca.infodata.ofys.ui.library.LibPlugin;
import java.io.File;
import java.io.FileInputStream;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ProxyStartupManager {
    private static final Logger logger = Logger.getLogger("ca.infodata.ofys.ui.intro.ProxyStartupManager");
    private static boolean useProxy = false;

    public static void startUp() {
        File f = new File(LibPlugin.OFYS_HOME);
        f = new File(f, "Ofys/proxy.prop");
        logger.log(Level.INFO, "Look at proxy file... '" + f.getAbsolutePath() + "'");
        if (f.exists()) {
            logger.log(Level.INFO, "\tProxy exist : loading properties.  If nothing happen after, remove the proxy file.");
            try {
                Properties p = new Properties();
                FileInputStream sras = new FileInputStream(f);
                p.load(sras);
                for (Map.Entry<Object, Object> set : p.entrySet()) {
                    System.setProperty((String)set.getKey(), (String)set.getValue());
                }
                useProxy = true;
                logger.log(Level.INFO, "Using proxy with :");
                for (Map.Entry<Object, Object> entry : p.entrySet()) {
                    logger.log(Level.INFO, "  -" + entry.getKey() + "\t:\t" + entry.getValue());
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Failed processing proxy file to put to system prop : " + f.getAbsolutePath(), e);
            }
        } else {
            logger.log(Level.INFO, "No proxy property file. So, we won't try to use it.");
            useProxy = true;
        }
    }

    public static boolean isUsingProxy() {
        return useProxy;
    }
}

