/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.laboresults.menu;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.LaboResultsAccessorClient;
import ca.infodata.ofys.data.middle.dataobjects.XBaseProfessionnal;
import ca.infodata.ofys.data.middle.dataobjects.chat.MessageLink;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IPatient;
import ca.infodata.ofys.data.middle.dataobjects.laboresults.XLaboResultsProfessionnalQuery;
import ca.infodata.ofys.data.middle.dataobjects.laboresults.XNumberByLaboResultsProfessionnalQuery;
import ca.infodata.ofys.data.middle.dataobjects.patient.IPatientRelated;
import ca.infodata.ofys.ui.controls.ITreeElements;
import ca.infodata.ofys.ui.laboresults.Messages;
import ca.infodata.ofys.ui.laboresults.menu.ListResultats;
import ca.infodata.ofys.ui.laboresults.menu.ListResultatsNoBodySee;
import ca.infodata.ofys.ui.laboresults.menu.ListResultatsOpenWithFile;
import ca.infodata.ofys.ui.laboresults.menu.ListResultatsToResolve;
import ca.infodata.ofys.ui.laboresults.menu.ListResultatsToSee;
import ca.infodata.ofys.ui.laboresults.menu.ListResultatsYear;
import ca.infodata.ofys.ui.library.ResourceGetter;
import ca.infodata.ofys.ui.menu.treeelements.LoadingElement;
import ca.infodata.ofys.ui.person.PersonUiPlugin;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class ListResultatsPatient
extends ListResultats
implements IPatientRelated,
IFontProvider,
IColorProvider {
    private static final Logger logger = Logger.getLogger(ListResultatsPatient.class.getName());
    private static final String _a_REGLER = Messages.getString("ListResultatsToSeen._a_REGLER");
    private static final String A_VOIR = Messages.getString("ListResultatsToSeen._a_VOIR");
    private static final String RESULTAT_LABO_SIZE = Messages.getString("ListResultatsToSeen.RESULTAT_LABO_SIZE");
    private static final String PERSONNE_A_VU = Messages.getString("ListResultatsToSeen.PERSONNE_A_VU");
    private final IPatient patient;
    private XBaseProfessionnal professionnal;
    private Color foreground;
    private Font font;

    public ListResultatsPatient(ITreeElements parent, IPatient patient) {
        super(parent);
        this.patient = patient;
        if (patient == null) {
            throw new NullPointerException("patient");
        }
        this.professionnal = PersonUiPlugin.getDefault().getSessionProfessionnal();
        this.container = new XLaboResultsProfessionnalQuery();
        this.container.setIdPatient(patient.getId());
        this.container.setIdProfessionnal(this.professionnal == null ? null : this.professionnal.getId());
        this.foreground = null;
        this.font = ResourceGetter.getFontNormal();
        this.initAsLoading();
        this.loadCountAsync();
    }

    public void initAsLoading() {
        this.setText(String.valueOf(RESULTAT_LABO_SIZE) + this.getLoadingTextFlag());
        ArrayList<ListResultats> list = new ArrayList<ListResultats>();
        list.add(new ListResultatsToResolve(this, this.patient, this.professionnal));
        list.add(new ListResultatsToSee(this, this.patient, this.professionnal));
        list.add(new ListResultatsNoBodySee(this, this.patient, this.professionnal));
        list.add(new ListResultatsOpenWithFile(this, this.patient, this.professionnal));
        list.addAll(this.getChildrenByExtension());
        list.add((ListResultats)new LoadingElement((ITreeElements)this));
        this.setChilds(list);
    }

    @Override
    public void loadCountResponseOverride(XNumberByLaboResultsProfessionnalQuery number) {
        int toSee = -1;
        int toResolve = -1;
        int noBodySee = -1;
        if (number != null) {
            toSee = number.numberUnseen;
            toResolve = number.numberToResolve;
            noBodySee = number.numberNoBodySee;
        }
        this.setText(String.valueOf(RESULTAT_LABO_SIZE) + " (" + (toResolve == -1 ? "-" : String.valueOf(toResolve)) + _a_REGLER + ", " + (toSee == -1 ? "-" : String.valueOf(toSee)) + A_VOIR + ", " + (noBodySee == -1 ? "-" : String.valueOf(noBodySee)) + " " + PERSONNE_A_VU + ")");
        if (noBodySee > 0) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    int[] nArray = new int[3];
                    nArray[0] = 255;
                    ListResultatsPatient.this.foreground = ResourceGetter.getColor((int[])nArray);
                }
            });
        }
        if (toSee > 0 || toResolve > 0 || noBodySee > 0) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    ListResultatsPatient.this.font = ResourceGetter.getFontBold();
                }
            });
        }
        this.forwardResponseToChildren(0, number);
    }

    @Override
    public void loadListResponse(Object response) {
        List years = response == null ? new ArrayList(0) : (List)response;
        Collections.sort(years, Collections.reverseOrder());
        ArrayList<ListResultatsYear> list = new ArrayList<ListResultatsYear>(this.getChilds());
        this.removeLoadingElements(list);
        for (Integer year : years) {
            list.add(new ListResultatsYear((ITreeElements)this, (int)year, this.patient));
        }
        this.setChilds(list);
    }

    @Override
    public void loadListAsync() {
        try {
            Integer idPatient = this.getLaboResultsContainer().getIdPatient();
            Integer idProfessionnal = null;
            LaboResultsAccessorClient.getInstance().getYearsOfLaboResults(Application.get().getGlobalInstances().getSession(), this.getCallback(1), idPatient, idProfessionnal);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to get list for " + this.container, e);
            this.loadResponse(0, null);
        }
    }

    public Image getImage() {
        return ResourceGetter.getImage((String)"images/pechere.gif");
    }

    public IPatient getPatient() {
        return this.patient;
    }

    public Font getFont(Object element) {
        return this.font;
    }

    public Color getForeground(Object element) {
        return this.foreground;
    }

    public Color getBackground(Object element) {
        return null;
    }

    public MessageLink getMessageLink() {
        return null;
    }
}

