/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.intro.login;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.CannotConnectToServerException;
import ca.infodata.ofys.data.dataaccess.ICallback;
import ca.infodata.ofys.data.dataaccess.UserAccessorClient;
import ca.infodata.ofys.data.dataaccess.callback.JobCallback;
import ca.infodata.ofys.data.dataaccess.util.MessageUtil;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.XSession;
import ca.infodata.ofys.data.middle.dataobjects.XUser;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.status.MultiStatus;
import ca.infodata.ofys.ui.controls.form.MyButton;
import ca.infodata.ofys.ui.controls.form.MyLabel;
import ca.infodata.ofys.ui.controls.form.MyText;
import ca.infodata.ofys.ui.intro.DefaultStatusHandler;
import ca.infodata.ofys.ui.library.LibPlugin;
import ca.infodata.ofys.ui.library.UI;
import ca.infodata.util1.encryption.DesEncrypter;
import ca.infodata.util1.encryption.EncryptionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class PasswordChangeDialog {
    private static final Logger logger = Logger.getLogger(PasswordChangeDialog.class.getName());
    private Shell dialog;
    private MyText txtPass;
    private MyText txtPassConfirm;
    private FormToolkit toolkit;
    private boolean okPressed = false;
    private final boolean forceUserToChange;
    private XUser user = PasswordChangeDialog.getUser();

    public PasswordChangeDialog(Shell parent, boolean forceUserToChange) {
        this.forceUserToChange = forceUserToChange;
        this.createPartControl(parent);
    }

    private static XUser getUser() {
        XSession session = Application.get().getGlobalInstances().getSession();
        if (session != null) {
            return session.getUser();
        }
        return null;
    }

    private void createPartControl(Shell parent) {
        this.dialog = new Shell(parent, 65536);
        this.dialog.setText(Messages.getString((String)"MOT_DE_PASSE", (String[])new String[0]));
        this.toolkit = UI.createToolKit((Widget)this.dialog);
        this.toolkit.adapt((Composite)this.dialog);
        this.dialog.addListener(31, new Listener(){

            public void handleEvent(Event e) {
                if (e.detail == 2) {
                    e.doit = !PasswordChangeDialog.this.forceUserToChange;
                }
            }
        });
        MyLabel lblMessage = new MyLabel((Composite)this.dialog, "", 64, this.toolkit);
        MyLabel lblName = new MyLabel((Composite)this.dialog, Messages.getString((String)"NOMUSER", (String[])new String[0]), 0, this.toolkit);
        MyText txtName = new MyText((Composite)this.dialog, this.toolkit);
        txtName.setTextLimit(30);
        txtName.setEnabled(false);
        MyLabel lblPass = new MyLabel((Composite)this.dialog, Messages.getString((String)"NEWMOTPASSE", (String[])new String[0]), 0, this.toolkit);
        this.txtPass = new MyText((Composite)this.dialog, this.toolkit);
        char cbit = '\u2a2a';
        this.txtPass.setEchoChar(LibPlugin.ON_MAC ? cbit : (char)'*');
        this.txtPass.setTextLimit(30);
        MyLabel lblPassConfirm = new MyLabel((Composite)this.dialog, Messages.getString((String)"CONFIRMMOTPASSE", (String[])new String[0]), 0, this.toolkit);
        this.txtPassConfirm = new MyText((Composite)this.dialog, this.toolkit);
        this.txtPassConfirm.setEchoChar(LibPlugin.ON_MAC ? cbit : (char)'*');
        this.txtPassConfirm.setTextLimit(30);
        this.txtPassConfirm.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.character == '\r') {
                    PasswordChangeDialog.this.onOk();
                }
            }
        });
        MyButton btnOk = new MyButton((Composite)this.dialog, Messages.getString((String)"OK", (String[])new String[0]), 8, this.toolkit);
        btnOk.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                PasswordChangeDialog.this.onOk();
            }
        });
        MyButton btnCancel = new MyButton((Composite)this.dialog, Messages.getString((String)"ANNULER", (String[])new String[0]), 8, this.toolkit);
        btnCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                PasswordChangeDialog.this.onCancel();
            }
        });
        btnCancel.setEnabled(!this.forceUserToChange);
        FormLayout layout = new FormLayout();
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        layout.spacing = 5;
        this.dialog.setLayout((Layout)layout);
        FormData data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(0);
        data.height = this.user != null && this.user.isMustChangePassword() ? 60 : 0;
        lblMessage.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(lblMessage.getControl());
        data.left = new FormAttachment(0);
        lblName.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(lblName.getControl());
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        txtName.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(txtName.getControl());
        data.left = new FormAttachment(0);
        lblPass.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(lblPass.getControl());
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        this.txtPass.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.txtPass.getControl());
        data.left = new FormAttachment(0);
        lblPassConfirm.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(lblPassConfirm.getControl());
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        this.txtPassConfirm.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.txtPassConfirm.getControl(), 10);
        data.right = new FormAttachment(100);
        data.width = MyButton.getStandardButtonWidth();
        btnCancel.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.txtPassConfirm.getControl(), 10);
        data.right = new FormAttachment(btnCancel.getControl(), -5);
        data.width = MyButton.getStandardButtonWidth();
        btnOk.setLayoutData((Object)data);
        this.dialog.setTabList(new Control[]{this.txtPass.getControl(), this.txtPassConfirm.getControl(), btnOk.getControl(), btnCancel.getControl()});
        if (this.user != null) {
            if (this.user.isMustChangePassword()) {
                lblMessage.setText(Messages.getString((String)"VOTRE_MOT_DE_PASSE_EST_EXPIRE_VOUS_DEVEZ_EN_CREER_UN_NOUVEAU", (String[])new String[0]));
            }
            txtName.setText(this.user.getName());
        } else {
            this.txtPass.setEnabled(false);
            this.txtPassConfirm.setEnabled(false);
            btnOk.setEnabled(false);
        }
    }

    public void open() {
        this.dialog.pack();
        this.dialog.setSize(400, this.dialog.getSize().y + 5);
        UI.centerComposite((Composite)this.dialog, (Composite)this.dialog.getParent());
        this.dialog.open();
    }

    private void onOk() {
        try {
            if (this.validatePassword()) {
                this.changePassword();
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error", e);
        }
    }

    private boolean validatePassword() {
        boolean valid = this.txtPass.getText().equals(this.txtPassConfirm.getText());
        if (!valid) {
            MessageBox msg = new MessageBox(this.dialog, 40);
            msg.setText(Messages.getString((String)"AVERTISSEMENT", (String[])new String[0]));
            msg.setMessage(Messages.getString((String)"LES_DEUX_MOTS_DE_PASSE_NE_CORRESPONDENT_PAS", (String[])new String[0]));
            msg.open();
        }
        return valid;
    }

    private void changePassword() {
        try {
            String newPassword = DesEncrypter.encryptMe((String)this.txtPass.getText());
            JobCallback callback = new JobCallback(Messages.getString((String)"CHANGER_LE_MOT_DE_PASSE", (String[])new String[0]), DefaultStatusHandler.getInstance()){

                public void responseReceived(ReturnObject response) {
                    PasswordChangeDialog.this.processResponseChangePassword(response);
                }
            };
            UserAccessorClient.getInstance().changePasswordUser((ICallback)callback, Application.get().getGlobalInstances().getSession(), newPassword);
        }
        catch (EncryptionException encryptionException) {
            MessageUtil.unexpectedExceptionMsg((Shell)this.dialog);
        }
        catch (CannotConnectToServerException cannotConnectToServerException) {
            MessageUtil.cannotConnectToServerExceptionMsg();
        }
    }

    private void processResponseChangePassword(final ReturnObject response) {
        if (this.dialog.isDisposed()) {
            return;
        }
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                MultiStatus status = response.getStatus();
                if (status.isOK()) {
                    MessageUtil.infoMsg((Shell)PasswordChangeDialog.this.dialog, (String)Messages.getString((String)"MOT_DE_PASSE_CHANGE_AVEC_SUCCES", (String[])new String[0]));
                    PasswordChangeDialog.this.okPressed = true;
                    PasswordChangeDialog.this.dialog.close();
                } else {
                    PasswordChangeDialog.this.txtPass.setFocus();
                }
            }
        });
    }

    private void onCancel() {
        this.dialog.close();
    }

    public boolean isOkPressed() {
        return this.okPressed;
    }

    public Shell getShell() {
        return this.dialog;
    }
}

