/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.intro.login;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.client.dataaccess.LogAccessorClient;
import ca.infodata.ofys.data.dataaccess.CannotConnectToServerException;
import ca.infodata.ofys.data.dataaccess.ICallback;
import ca.infodata.ofys.data.dataaccess.LoginAccessorClient;
import ca.infodata.ofys.data.dataaccess.autolog.AutologConnexionRespond;
import ca.infodata.ofys.data.dataaccess.callback.DefaultCallback;
import ca.infodata.ofys.data.dataaccess.callback.IStatusHandler;
import ca.infodata.ofys.data.dataaccess.callback.JobCallback;
import ca.infodata.ofys.data.dataaccess.util.GlobalInstancesAdapter;
import ca.infodata.ofys.data.dataaccess.util.GlobalInstancesListener;
import ca.infodata.ofys.data.dataaccess.util.MessageUtil;
import ca.infodata.ofys.data.dataaccess.util.SessionLock;
import ca.infodata.ofys.data.dataaccess.util.SessionLockException;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.XSession;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.data.middle.dataobjects.log.XLogType1;
import ca.infodata.ofys.data.middle.dataobjects.log.XNewLog;
import ca.infodata.ofys.data.middle.dataobjects.preferences.FormatDateProvider;
import ca.infodata.ofys.status.IStatus;
import ca.infodata.ofys.status.MultiStatus;
import ca.infodata.ofys.status.StatusException;
import ca.infodata.ofys.ui.browser.HtmlBrowserTools;
import ca.infodata.ofys.ui.controls.BaseView;
import ca.infodata.ofys.ui.controls.FontAwareComposite;
import ca.infodata.ofys.ui.controls.MyMessageDialogBuilder;
import ca.infodata.ofys.ui.controls.form.MyButton;
import ca.infodata.ofys.ui.controls.form.MyLabel;
import ca.infodata.ofys.ui.controls.form.MyText;
import ca.infodata.ofys.ui.controls.util.MyDialogSettings;
import ca.infodata.ofys.ui.intro.DefaultStatusHandler;
import ca.infodata.ofys.ui.intro.IntroPlugin;
import ca.infodata.ofys.ui.intro.PerspectiveManager;
import ca.infodata.ofys.ui.intro.login.LauncherTool;
import ca.infodata.ofys.ui.intro.login.LegalDialog;
import ca.infodata.ofys.ui.intro.login.PasswordChangeDialog;
import ca.infodata.ofys.ui.intro.login.autolog.ADManagement;
import ca.infodata.ofys.ui.intro.login.autolog.ADManager;
import ca.infodata.ofys.ui.library.IRefreshFont;
import ca.infodata.ofys.ui.library.LibPlugin;
import ca.infodata.ofys.ui.library.ResourceGetter;
import ca.infodata.ofys.ui.library.UI;
import ca.infodata.ofys.ui.library.Util;
import ca.infodata.util1.MutableBoolean;
import ca.infodata.util1.StringUtils;
import ca.infodata.util1.date.LocalDate;
import ca.infodata.util1.date.LocalDateFormat;
import ca.infodata.util1.encryption.DesEncrypter;
import ca.infodata.util1.encryption.EncryptionException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.BrowserFunction;
import org.eclipse.swt.browser.ProgressAdapter;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.tools.layout.spy.internal.dialogs.LayoutSpyDialog;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.handlers.IHandlerService;

public final class LogInView2
extends BaseView
implements IRefreshFont {
    private static final Logger logger = Logger.getLogger(LogInView2.class.getName());
    public static final String ID = "ca.infodata.ofys.ui.intro.login.LogInView";
    private boolean connecting = false;
    private MyButton btnLogin;
    private MyButton btnWorkspaceStandard;
    private MyButton btnNewUiExt;
    private MyButton btnNewUiInt;
    private MyText txtUser;
    private MyText txtPassword;
    private MyText txtClient;
    private MyButton chkKeepInfo;
    private MyButton btnChangePassword;
    private Browser newsBrowser;
    private FormToolkit toolkit;
    private Form form;
    private MyLabel lblDateFinLocation;
    private MyLabel lblDMECertifie;
    private MyLabel lblVersion;
    private MyLabel lblExpirationPassword;
    private MyDialogSettings loginInfo;
    private MyLabel lblUser;
    private MyLabel lblPassword;
    private MyLabel lblClient;
    private MyButton btnUseWindowsDomain;
    private final GlobalInstancesListener listener = new GlobalInstancesAdapter(){

        public void sessionChanged() {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    if (!LogInView2.this.btnLogin.isDisposed()) {
                        LogInView2.this.setInterfaceStatus();
                    }
                }
            });
        }
    };
    private MyLabel lblServerPath;
    private String uid;

    public LogInView2() {
        Application.get().getGlobalInstances().addGlobalInstancesListener(this.listener);
        this.loginInfo = new MyDialogSettings(".login.xml", "login"){

            public void setDefaultValues() {
                this.put("USER", "");
                this.put("PSWD", "");
                this.put("OPEN_LAST", "");
                this.put("KEEP", "");
                super.setDefaultValues();
            }
        };
    }

    public void setFocus() {
        this.txtUser.setFocus();
    }

    public void createMyPartControl(Composite parent) {
        this.toolkit = new FormToolkit(parent.getDisplay());
        this.form = this.toolkit.createForm(parent);
        this.lblUser = new MyLabel(this.form.getBody(), Messages.getString((String)"USERNAME", (String[])new String[0]), 0, this.toolkit);
        this.lblPassword = new MyLabel(this.form.getBody(), Messages.getString((String)"MOTPASSE", (String[])new String[0]), 0, this.toolkit);
        this.lblClient = new MyLabel(this.form.getBody(), Messages.getString((String)"CODE_CLIENT", (String[])new String[0]), 0, this.toolkit);
        this.lblExpirationPassword = new MyLabel(this.form.getBody(), "", 0, this.toolkit);
        MyLabel vSeparator = new MyLabel(this.form.getBody(), null, 514, this.toolkit);
        this.txtUser = new MyText(this.form.getBody(), "", 4, this.toolkit);
        this.txtPassword = new MyText(this.form.getBody(), "", 0x400000, this.toolkit);
        this.txtClient = new MyText(this.form.getBody(), "", 4, this.toolkit);
        this.btnChangePassword = new MyButton(this.form.getBody(), Messages.getString((String)"CHANGER_LE_MOT_DE_PASSE", (String[])new String[0]), 8, this.toolkit);
        if (Application.get().getGlobalInstances().getSession() == null) {
            this.btnChangePassword.setVisible(false);
        }
        this.lblServerPath = new MyLabel(this.form.getBody(), "", 64, this.toolkit);
        this.lblServerPath.setVisible(Application.get().getGlobalInstances().inDebugMode());
        this.chkKeepInfo = new MyButton(this.form.getBody(), Messages.getString((String)"CONSERVERDATA", (String[])new String[0]), 32, this.toolkit);
        this.chkKeepInfo.setVisible(false);
        this.btnLogin = new MyButton(this.form.getBody(), Messages.getString((String)"SECONNECTER", (String[])new String[0]), 8, this.toolkit);
        Image image = ResourceGetter.getImage((String)"images/connexion.png");
        this.btnLogin.setImage(image);
        this.btnWorkspaceStandard = new MyButton(this.form.getBody(), Messages.getString((String)"COMMENCER_STANDARD", (String[])new String[0]), 8, this.toolkit);
        this.btnWorkspaceStandard.setImage(ResourceGetter.getScaledImageSameAs((String)"images/medVisite.gif", (Image)image));
        this.btnWorkspaceStandard.setVisible(false);
        this.btnNewUiInt = new MyButton(this.form.getBody(), Messages.getString((String)"NEW_UI_INT", (String[])new String[0]), 8, this.toolkit);
        this.btnNewUiInt.setVisible(false);
        this.btnNewUiExt = new MyButton(this.form.getBody(), Messages.getString((String)"NEW_UI_EXT", (String[])new String[0]), 8, this.toolkit);
        this.btnNewUiExt.setVisible(false);
        this.btnUseWindowsDomain = new MyButton(this.form.getBody(), Messages.getString((String)"AVEC_DOMAINE_WINDOWS", (String[])new String[0]), 32, this.toolkit);
        try {
            this.btnUseWindowsDomain.setVisible(UI.OS_WINDOWS && StringUtils.isNotBlank((String)this.getUID()));
        }
        catch (Exception exception) {
            this.btnUseWindowsDomain.setVisible(false);
        }
        this.lblDMECertifie = new MyLabel(this.form.getBody(), Messages.getString((String)"DME_CERTIFIE", (String[])new String[0]), 0x1000000, this.toolkit);
        this.lblDMECertifie.setFont(14, 1);
        this.lblVersion = new MyLabel(this.form.getBody(), "version " + LibPlugin.getVersion(), 0x1000000, this.toolkit);
        this.lblDateFinLocation = new MyLabel(this.form.getBody(), "", 0x1000000, this.toolkit);
        Label img_Label = new Label(this.form.getBody(), 0x1000000);
        img_Label.setBackground(ResourceGetter.getColor((int)255, (int)255, (int)255));
        img_Label.setForeground(ResourceGetter.getColor((int)255, (int)255, (int)255));
        img_Label.setImage(ResourceGetter.getImage((String)"images/ofys_login.gif"));
        this.newsBrowser = new Browser(this.form.getBody(), 0);
        String newsUrl = System.getProperty("ca.infodata.ofys.news.url");
        this.newsBrowser.setUrl(newsUrl == null ? "about:blank" : newsUrl);
        this.newsBrowser.addProgressListener((ProgressListener)new ProgressAdapter(){

            public void completed(ProgressEvent event) {
                String user = LogInView2.this.txtUser != null && !LogInView2.this.txtUser.isDisposed() ? LogInView2.this.txtUser.getText() : "";
                String client = LogInView2.this.txtClient != null && !LogInView2.this.txtClient.isDisposed() ? LogInView2.this.txtClient.getText() : "";
                String mac = Util.getMacAddress();
                String cmd = "loadSondage(\"" + (user != null ? user.replace("\"", "\\\"") : "") + "\",\"" + (client != null ? client.replace("\"", "\\\"") : "") + "\",\"" + (mac != null ? mac.replace("\"", "\\\"") : "") + "\");";
                try {
                    boolean execute = LogInView2.this.newsBrowser.execute(cmd);
                    if (!execute) {
                        logger.log(Level.INFO, "Unable to execute 'loadSondage()' :: " + cmd);
                    }
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Failed to execute 'loadSondage()' :: " + cmd, e);
                }
                Object obj = null;
                try {
                    obj = LogInView2.this.newsBrowser.evaluate("return document.documentMode");
                    logger.log(Level.INFO, "DOCUMENT MODE: " + obj);
                    Double dc = (Double)obj;
                    if (dc != null && dc < 10.0) {
                        String s = "Ce poste est dans un mode document invalide: " + dc;
                        if (LogInView2.this.txtClient != null && !LogInView2.this.txtClient.isDisposed()) {
                            s = String.valueOf(s) + " / " + LogInView2.this.txtClient.getText();
                        }
                        if (LogInView2.this.txtUser != null && !LogInView2.this.txtUser.isDisposed()) {
                            s = String.valueOf(s) + " / " + LogInView2.this.txtUser.getText();
                        }
                        logger.log(Level.INFO, s);
                    }
                }
                catch (Exception exception) {
                    logger.log(Level.WARNING, "Validation du mode de document a \u00e9chou\u00e9 : " + obj + "/" + obj.getClass().getName());
                }
            }
        });
        UI.loopExecForWidget((long)5000L, (long)TimeUnit.HOURS.toMillis(2L), (int)-1, (boolean)true, (Widget)this.newsBrowser, (Runnable)new Runnable(){

            @Override
            public void run() {
                if (!LogInView2.this.newsBrowser.isDisposed()) {
                    LogInView2.this.newsBrowser.refresh();
                }
            }
        });
        new BrowserFunction(this.newsBrowser, "open_java"){

            public Object function(Object[] arguments) {
                String href = null;
                try {
                    href = (String)arguments[0];
                    IWebBrowser browser = PlatformUI.getWorkbench().getBrowserSupport().getExternalBrowser();
                    if (browser == null) {
                        browser = PlatformUI.getWorkbench().getBrowserSupport().createBrowser("loginView");
                    }
                    URL url = new URL(href);
                    browser.openURL(url);
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "Failed to open url " + href, e);
                }
                return null;
            }
        };
        this.btnChangePassword.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LogInView2.this.changePassword(false);
            }
        });
        this.txtUser.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                LogInView2.this.lblUser.setForeground(ResourceGetter.getColor((int)0, (int)0, (int)0));
                if (UI.CR((KeyEvent)e)) {
                    LogInView2.this.log();
                }
            }
        });
        this.txtUser.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                ((Text)e.getSource()).selectAll();
            }
        });
        this.txtPassword.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                LogInView2.this.lblPassword.setForeground(ResourceGetter.getColor((int)0, (int)0, (int)0));
                if (UI.CR((KeyEvent)e)) {
                    LogInView2.this.log();
                }
            }
        });
        this.txtPassword.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                ((Text)e.getSource()).selectAll();
            }
        });
        this.txtClient.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                LogInView2.this.lblClient.setForeground(ResourceGetter.getColor((int)0, (int)0, (int)0));
                if (UI.CR((KeyEvent)e)) {
                    LogInView2.this.log();
                }
            }
        });
        this.txtClient.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                ((Text)e.getSource()).selectAll();
            }
        });
        this.btnLogin.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.stateMask == 262144) {
                    LayoutSpyDialog popupDialog = new LayoutSpyDialog(UI.getWorkbenchShell());
                    popupDialog.open();
                } else if (!LogInView2.this.connecting) {
                    LogInView2.this.log();
                }
            }
        });
        this.btnWorkspaceStandard.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                PerspectiveManager.open(PerspectiveManager.Perspective.OFYS_PERSPECTIVE, true, false);
            }
        });
        this.btnNewUiExt.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                LogInView2.this.openOfysPerspectiveAsync(TimeUnit.SECONDS.toMillis(10L));
                if (UI.OS_WINDOWS) {
                    Program.launch((String)(String.valueOf(HtmlBrowserTools.getJettyUrl(null)) + "/dashboard"));
                } else {
                    Program.launch((String)(String.valueOf(HtmlBrowserTools.getJettyUrl(null)) + "/dashboard"));
                }
            }
        });
        this.btnNewUiInt.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                if (UI.OS_MAC) {
                    PerspectiveManager.open(PerspectiveManager.Perspective.OFYS_PERSPECTIVE, true, false);
                    try {
                        ICommandService service = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
                        Command command = service.getCommand("ca.infodata.ofys.ui.dashboard.CefHandler");
                        try {
                            ExecutionEvent event = new ExecutionEvent(command, new HashMap(), null, null);
                            command.executeWithChecks(event);
                        }
                        catch (ExecutionException | NotEnabledException | NotHandledException | NotDefinedException e) {
                            logger.log(Level.SEVERE, "ERROR Command ca.infodata.ofys.ui.dashboard.CefHandler", e);
                        }
                    }
                    catch (Exception e) {
                        logger.log(Level.SEVERE, "Dashboard editor open error", e);
                    }
                } else {
                    LogInView2.this.openOfysPerspectiveAsync(TimeUnit.SECONDS.toMillis(10L));
                    try {
                        ICommandService service = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
                        Command command = service.getCommand("ca.infodata.ofys.ui.dashboard.CefHandler");
                        try {
                            ExecutionEvent event = new ExecutionEvent(command, new HashMap(), null, null);
                            command.executeWithChecks(event);
                        }
                        catch (ExecutionException | NotEnabledException | NotHandledException | NotDefinedException e) {
                            logger.log(Level.SEVERE, "ERROR Command ca.infodata.ofys.ui.dashboard.CefHandler", e);
                        }
                    }
                    catch (Exception e) {
                        logger.log(Level.SEVERE, "Dashboard editor open error", e);
                    }
                }
            }
        });
        this.form.getBody().setTabList(new Control[]{this.txtUser.getControl(), this.txtPassword.getControl(), this.txtClient.getControl(), this.chkKeepInfo.getControl(), this.btnLogin.getControl(), this.btnWorkspaceStandard.getControl(), this.btnNewUiInt.getControl(), this.btnNewUiExt.getControl(), this.btnChangePassword.getControl()});
        FormLayout layout = new FormLayout();
        this.form.getBody().setLayout((Layout)layout);
        int txtWidth = 200;
        int btnWidth = ((Button)this.btnNewUiExt.getControl()).computeSize((int)-1, (int)-1).x;
        int marginTop = 28;
        int marginLeft = 20;
        FormData data = new FormData();
        data.top = new FormAttachment(0, marginTop);
        data.left = new FormAttachment(0, marginLeft);
        this.lblUser.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.lblUser.getControl(), 5);
        data.left = new FormAttachment(0, marginLeft);
        data.width = txtWidth;
        this.txtUser.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.txtUser.getControl(), 10);
        data.left = new FormAttachment(0, marginLeft);
        this.lblPassword.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.lblPassword.getControl(), 5);
        data.left = new FormAttachment(0, marginLeft);
        data.width = txtWidth;
        this.txtPassword.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.txtPassword.getControl(), 10);
        data.left = new FormAttachment(0, marginLeft);
        this.lblClient.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.lblClient.getControl(), 5);
        data.left = new FormAttachment(0, marginLeft);
        data.width = txtWidth;
        this.txtClient.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.txtClient.getControl(), 10);
        data.left = new FormAttachment(0, marginLeft);
        this.btnUseWindowsDomain.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.btnUseWindowsDomain.getControl(), 10);
        data.left = new FormAttachment(0, marginLeft);
        data.right = new FormAttachment(this.txtClient.getControl(), 0, 131072);
        this.btnLogin.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.lblUser.getControl(), 0, 128);
        data.bottom = new FormAttachment(this.btnLogin.getControl(), 0, 1024);
        data.left = new FormAttachment(this.btnLogin.getControl(), 15);
        vSeparator.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(0, marginTop);
        data.left = new FormAttachment(vSeparator.getControl(), 15);
        data.width = btnWidth;
        this.btnWorkspaceStandard.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.btnWorkspaceStandard.getControl(), 5);
        data.left = new FormAttachment(vSeparator.getControl(), 15);
        data.width = btnWidth;
        this.btnNewUiInt.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.btnNewUiInt.getControl(), 5);
        data.left = new FormAttachment(vSeparator.getControl(), 15);
        data.width = btnWidth;
        this.btnNewUiExt.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.btnChangePassword.getControl(), 2);
        data.left = new FormAttachment(vSeparator.getControl(), 15);
        data.width = btnWidth;
        this.lblExpirationPassword.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.btnLogin.getControl(), 0, 128);
        data.bottom = new FormAttachment(this.btnLogin.getControl(), 0, 1024);
        data.left = new FormAttachment(vSeparator.getControl(), 15);
        data.width = btnWidth;
        this.btnChangePassword.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.btnLogin.getControl(), 2);
        data.left = new FormAttachment(this.btnLogin.getControl(), 0, 16384);
        data.width = btnWidth;
        this.lblServerPath.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(0, 10);
        data.left = new FormAttachment(50);
        data.right = new FormAttachment(100, -30);
        img_Label.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)img_Label, 2);
        data.left = new FormAttachment((Control)img_Label, 0, 16384);
        data.right = new FormAttachment((Control)img_Label, 0, 131072);
        this.lblDMECertifie.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.lblDMECertifie.getControl(), 2);
        data.left = new FormAttachment((Control)img_Label, 0, 16384);
        data.right = new FormAttachment((Control)img_Label, 0, 131072);
        this.lblVersion.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.lblVersion.getControl(), 2);
        data.left = new FormAttachment((Control)img_Label, 0, 16384);
        data.right = new FormAttachment((Control)img_Label, 0, 131072);
        this.lblDateFinLocation.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.lblExpirationPassword.getControl(), 1);
        data.left = new FormAttachment(0, 10);
        data.right = new FormAttachment(100, -10);
        data.bottom = new FormAttachment(100);
        this.newsBrowser.setLayoutData((Object)data);
        this.setInterfaceStatus();
        this.loadAndFillLoginInfo();
        this.toolkit.paintBordersFor(this.form.getBody());
        ResourceGetter.addListener((IRefreshFont)this);
    }

    private void openOfysPerspectiveAsync(long delay) {
        try {
            new Job("open"){

                protected org.eclipse.core.runtime.IStatus run(IProgressMonitor arg0) {
                    try {
                        if (PerspectiveManager.getCurrentPerspective() != PerspectiveManager.Perspective.OFYS_PERSPECTIVE) {
                            if (UI.OS_MAC) {
                                PerspectiveManager.openInSwtThread(PerspectiveManager.Perspective.OFYS_PERSPECTIVE, true, false);
                            } else {
                                PerspectiveManager.openInSwtThread(PerspectiveManager.Perspective.OFYS_PERSPECTIVE, true, false);
                            }
                        }
                    }
                    catch (Exception e) {
                        logger.log(Level.SEVERE, "Error opening ofys perspective", e);
                    }
                    return Status.OK_STATUS;
                }
            }.schedule(delay);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error opening ofys perspective", e);
        }
    }

    private void setInterfaceStatus() {
        if (this.isDisposed()) {
            return;
        }
        if (this.connecting) {
            this.lblDateFinLocation.setVisible(false);
            this.lblExpirationPassword.setVisible(false);
            this.btnLogin.setText(Messages.getString((String)"EN_COURS", (String[])new String[0]));
            this.btnWorkspaceStandard.setVisible(false);
            this.btnNewUiInt.setVisible(false);
            this.btnNewUiExt.setVisible(false);
            this.txtUser.setEnabled(false);
            this.txtPassword.setEnabled(false);
            this.txtClient.setEnabled(false);
            this.chkKeepInfo.setEnabled(false);
            this.btnChangePassword.setVisible(false);
        } else if (Application.get().getGlobalInstances().getSession() != null) {
            this.lblDateFinLocation.setVisible(true);
            this.lblExpirationPassword.setVisible(true);
            this.btnLogin.setText(Messages.getString((String)"SEDECONNECTER", (String[])new String[0]));
            Image image = ResourceGetter.getImage((String)"images/disconnect.png");
            this.btnLogin.setImage(image);
            this.btnWorkspaceStandard.setVisible(true);
            boolean dashboardVisible = Application.get().getGlobalInstances().isDashboardVisible();
            this.btnNewUiInt.setVisible(dashboardVisible);
            this.btnNewUiExt.setVisible(dashboardVisible);
            this.txtUser.setText(Application.get().getGlobalInstances().getSession().getUser().getName());
            this.txtUser.setEnabled(false);
            this.txtPassword.setEnabled(false);
            this.txtClient.setEnabled(false);
            this.chkKeepInfo.setEnabled(false);
            this.btnChangePassword.setVisible(true);
            this.btnWorkspaceStandard.setFocus();
            this.setLocalionEndControl();
            this.setPasswordExpirencyControl();
        } else if (Application.get().getGlobalInstances().getSession() == null) {
            this.lblDateFinLocation.setVisible(false);
            this.lblExpirationPassword.setVisible(false);
            this.txtUser.setEnabled(true);
            this.txtPassword.setEnabled(true);
            this.txtClient.setEnabled(true);
            this.chkKeepInfo.setEnabled(true);
            this.btnChangePassword.setVisible(false);
            this.btnLogin.setText(Messages.getString((String)"SECONNECTER", (String[])new String[0]));
            Image image = ResourceGetter.getImage((String)"images/connexion.png");
            this.btnLogin.setImage(image);
            this.btnWorkspaceStandard.setVisible(false);
            this.btnNewUiInt.setVisible(false);
            this.btnNewUiExt.setVisible(false);
        }
    }

    private void setPasswordExpirencyControl() {
        XSession session = Application.get().getGlobalInstances().getSession();
        assert (session != null);
        int nbDays = session.getClientPreferences().getPasswordChangeFrequency();
        if (nbDays > 0) {
            boolean willExpireInOneWeek;
            LocalDate creationDate = session.getUser().getPasswordCreationDate();
            LocalDate expirationDate = creationDate.plusDay(nbDays);
            boolean bl = willExpireInOneWeek = expirationDate.dayFrom1970 - LocalDate.today().dayFrom1970 <= 7;
            if (willExpireInOneWeek) {
                this.lblExpirationPassword.setForeground(ResourceGetter.getColor((int)255, (int)0, (int)0));
                this.lblExpirationPassword.redraw();
            } else {
                this.lblExpirationPassword.setForeground(ResourceGetter.getColor((int)0, (int)0, (int)0));
                this.lblExpirationPassword.redraw();
            }
            this.lblExpirationPassword.setText(String.valueOf(Messages.getString((String)"DATE_DEXPIRATION_DU_MOT_DE_PASSE_", (String[])new String[0])) + LocalDateFormat.format((LocalDate)expirationDate, (String)FormatDateProvider.getFormatDate().toString()));
        } else {
            this.lblExpirationPassword.setText("");
        }
    }

    private void setLocalionEndControl() {
        boolean willExpireInOneMonth;
        XSession session = Application.get().getGlobalInstances().getSession();
        assert (session != null);
        LocalDate expirationDate = session.getClient().getLicenceExpirationDate();
        boolean bl = willExpireInOneMonth = expirationDate.dayFrom1970 - LocalDate.today().dayFrom1970 <= 30;
        if (willExpireInOneMonth) {
            this.lblDateFinLocation.setForeground(ResourceGetter.getColor((int)255, (int)0, (int)0));
            this.lblDateFinLocation.redraw();
        } else {
            this.lblDateFinLocation.setForeground(ResourceGetter.getColor((int)0, (int)0, (int)0));
            this.lblDateFinLocation.redraw();
        }
        this.lblDateFinLocation.setText(String.valueOf(Messages.getString((String)"DATEFINLOCATION", (String[])new String[0])) + LocalDateFormat.format((LocalDate)expirationDate, (String)FormatDateProvider.getFormatDate().toString()));
    }

    private void log() {
        if (Application.get().getGlobalInstances().getSession() == null) {
            this.logIn();
        } else {
            this.logOut();
        }
    }

    private void logOut() {
        try {
            IHandlerService service = (IHandlerService)this.getSite().getService(IHandlerService.class);
            service.executeCommand("ca.infodata.ofys.ui.intro.commands.logoutCommand", null);
            IntroPlugin.mqScheduledFuture.cancel(true);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to execute ca.infodata.ofys.ui.intro.commands.logoutCommand", e);
            MessageUtil.unexpectedExceptionMsg((Shell)this.getSite().getShell());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void logIn() {
        boolean continueWithLogin = true;
        try {
            LauncherTool update = new LauncherTool();
            boolean valid = update.isInstalledVersionValid();
            if (valid) {
                continueWithLogin = true;
            } else {
                MyMessageDialogBuilder builder = new MyMessageDialogBuilder();
                builder.useWarningBundle();
                builder.setMessage("Une mise \u00e0 jour doit \u00eatre install\u00e9e maintenant. \nSi d'autres applications Ofys sont pr\u00e9sentement ouvertes, veuillez les fermer avant de continuer.");
                builder.setButtonLabels(new String[]{"Continuer et red\u00e9marrer Ofys"});
                builder.setDefaultButton(-1);
                builder.setTitle("Mise \u00e0 jour obligatoire");
                int r = builder.buildAndOpen();
                if (r == 0) {
                    update.doRestart();
                }
                continueWithLogin = false;
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to check for update before login. Proceed anyway", e);
            continueWithLogin = true;
        }
        if (continueWithLogin) {
            this.saveLoginInfo();
            boolean useWindowsDomain = this.btnUseWindowsDomain.getSelection();
            boolean invalidUser = !useWindowsDomain && StringUtils.isEmpty((String)this.txtUser.getText());
            boolean invalidPassword = !useWindowsDomain && StringUtils.isEmpty((String)this.txtPassword.getText());
            boolean invalidClient = StringUtils.isEmpty((String)this.txtClient.getText());
            if (invalidUser || invalidPassword || invalidClient) {
                if (invalidUser) {
                    this.lblUser.setForeground(ResourceGetter.getColor((int)255, (int)0, (int)0));
                }
                if (invalidPassword) {
                    this.lblPassword.setForeground(ResourceGetter.getColor((int)255, (int)0, (int)0));
                }
                if (invalidClient) {
                    this.lblClient.setForeground(ResourceGetter.getColor((int)255, (int)0, (int)0));
                }
                Util.shakeIt((Shell)this.getSite().getShell());
                this.txtUser.setFocus();
                return;
            } else {
                String password = this.txtPassword.getText();
                LoginCallback callback = new LoginCallback();
                try {
                    this.connecting = true;
                    SessionLock sessionLock = new SessionLock(this.txtUser.getText());
                    sessionLock.tryLockAndRelease();
                    this.setInterfaceStatus();
                    LoginAccessorClient.getInstance().logIn((ICallback)callback, this.txtUser.getText(), DesEncrypter.encryptMe((String)password), null, this.txtClient.getText(), this.uid, this.btnUseWindowsDomain.getSelection());
                    return;
                }
                catch (CannotConnectToServerException e) {
                    logger.log(Level.INFO, "Exception on login", e);
                    this.connecting = false;
                    this.setInterfaceStatus();
                    MessageUtil.cannotConnectToServerExceptionMsg();
                    if (callback.killed()) return;
                    callback.kill();
                    return;
                }
                catch (EncryptionException encryptionException) {
                    MessageUtil.unexpectedExceptionMsg((Shell)this.getSite().getShell());
                    return;
                }
                catch (SessionLockException e) {
                    if (e.getCause() != null) {
                        logger.log(Level.SEVERE, "Exception on login", e);
                    }
                    this.connecting = false;
                    this.setInterfaceStatus();
                    MessageUtil.errorMsg((Shell)this.getSite().getShell(), (String)e.getMessage());
                    if (callback.killed()) return;
                    callback.kill();
                    return;
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Exception on login", e);
                    if (callback.killed()) return;
                    callback.kill();
                }
            }
            return;
        } else {
            this.setInterfaceStatus();
        }
    }

    private void loginResponse(ReturnObject response) {
        block12: {
            try {
                MultiStatus status = response.getStatus();
                if (!status.isOkToProceed()) break block12;
                try {
                    Application.get().getGlobalInstances().setSession((XSession)response.getObj());
                }
                catch (StatusException e) {
                    if (e.getStatus().isOkToProceed()) {
                        MessageUtil.show((Shell)this.getSite().getShell(), (Exception)((Object)e));
                    }
                    throw e;
                }
                if (!this.isDisposed()) {
                    IntroPlugin.setApplicationTitle();
                    if (status.getStatus("PASSWORD_EXPIRED") != null) {
                        this.changePassword(true);
                    } else if (status.getStatus("USER_RESPONSABILITIES") != null) {
                        final MutableBoolean accepted = new MutableBoolean(false);
                        ArrayList<String> urls = new ArrayList<String>();
                        urls.add("https://ofys.net/download/ofys_html/terms.htm");
                        urls.add("https://ofys.net/download/ofys_html/privacy.htm");
                        urls.add("https://ofys.net/download/ofys_html/msss.htm");
                        new LegalDialog(this.getSite().getShell(), urls){

                            @Override
                            public void onAcceptFinal() {
                                accepted.setTrue();
                                this.close();
                            }
                        };
                        if (accepted.booleanValue()) {
                            XNewLog log = new XNewLog();
                            log.setType1(XLogType1.RESPONSIBILITY_STATEMENT_ACCEPTED);
                            LogAccessorClient.getInstance().log(Application.get().getGlobalInstances().getSession(), (ICallback)new DefaultCallback(), log);
                            this.connecting = false;
                            this.setInterfaceStatus();
                        } else {
                            this.logOut();
                        }
                    }
                }
            }
            catch (StatusException e) {
                this.connecting = false;
                this.setInterfaceStatus();
                MessageUtil.show((Shell)this.getSite().getShell(), (Exception)((Object)e));
                this.logOut();
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Erreur", e);
                this.connecting = false;
                this.setInterfaceStatus();
                MessageUtil.show((Shell)this.getSite().getShell(), (Exception)e);
                this.logOut();
            }
        }
    }

    private void badPassword() {
        this.connecting = false;
        this.setInterfaceStatus();
        Util.shakeIt((Shell)this.getSite().getShell());
        this.txtPassword.setText("");
        this.txtUser.setFocus();
    }

    private void badCodeClient(IStatus status) {
        if (status != null) {
            MessageUtil.show((IStatus)status);
        }
        this.connecting = false;
        this.setInterfaceStatus();
    }

    private void changePassword(boolean forceUserToChange) {
        this.connecting = false;
        this.setInterfaceStatus();
        PasswordChangeDialog dialog = new PasswordChangeDialog(this.getSite().getShell(), false);
        dialog.open();
        UI.waitForWindowToClose((Shell)dialog.getShell());
        if (!dialog.isOkPressed() && forceUserToChange) {
            this.logOut();
        }
    }

    public void dispose() {
        ResourceGetter.removeListener((IRefreshFont)this);
        Application.get().getGlobalInstances().removeGlobalInstancesListener(this.listener);
        this.toolkit.dispose();
        super.dispose();
    }

    private void loadAndFillLoginInfo() {
        try {
            String user = this.loginInfo.get("USER");
            String client = this.loginInfo.get("CLIENT");
            Boolean openLast = this.loginInfo.getBoolean("OPEN_LAST");
            Boolean keep = this.loginInfo.getBoolean("KEEP");
            if (client != null) {
                LibPlugin.setCodeClient((String)DesEncrypter.decryptMeOr((String)client, null));
            }
            if (user != null) {
                LibPlugin.setUserName((String)DesEncrypter.decryptMeOr((String)user, null));
            }
            user = user == null ? "" : user;
            openLast = openLast == null ? false : openLast;
            keep = keep == null ? false : keep;
            client = client == null ? "" : client;
            this.txtUser.setText(DesEncrypter.decryptMeOr((String)user, (String)""));
            this.txtClient.setText(DesEncrypter.decryptMeOr((String)client, (String)""));
            this.chkKeepInfo.setSelection(keep.booleanValue());
            this.setLabelServerPath();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to load and fill login info", e);
        }
    }

    private void updateBtnUseWindowsDomain() {
        String client = this.txtClient.getText();
        String user = this.txtUser.getText();
        String password = this.txtPassword.getText();
        boolean useWindowsDomain = false;
        boolean forceDomain = false;
        ADManagement autologManager = IntroPlugin.getDefault().getAutologService();
        if (StringUtils.isNotBlank((String)client) && autologManager != null && autologManager.isEnabled()) {
            this.uid = this.getUID();
            if (StringUtils.isNotBlank((String)this.uid)) {
                try {
                    String password2;
                    AutologConnexionRespond user2 = autologManager.askForConnexion("ofys" + client, this.uid);
                    if (user2 != null && StringUtils.isNotBlank((String)user2.getUsername()) && StringUtils.isNotBlank((String)(password2 = autologManager.askForPassword("ofys" + client, this.uid)))) {
                        user = user2.getUsername();
                        forceDomain = user2.isForced();
                        password = password2;
                        useWindowsDomain = true;
                    }
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "Erreur", e);
                }
                this.txtUser.setText(user);
                this.txtPassword.setText(password);
                this.btnUseWindowsDomain.setSelection(useWindowsDomain);
                this.btnUseWindowsDomain.setEnabled(!forceDomain);
                if (forceDomain) {
                    this.log();
                }
            }
        }
    }

    private String getUID() {
        try {
            return ADManager.getUID();
        }
        catch (Exception e) {
            logger.log(Level.INFO, "Failed to get sid", e);
            return null;
        }
    }

    private void setLabelServerPath() {
        String s = String.valueOf(Messages.getString((String)"SERVEUR", (String[])new String[0])) + " : " + Application.get().getGlobalInstances().getConnectionInfo().getServerAddress();
        this.btnLogin.setToolTipText(s);
        this.lblServerPath.setText(s);
    }

    private void saveLoginInfo() {
        try {
            LibPlugin.setCodeClient((String)this.txtClient.getText());
            LibPlugin.setUserName((String)this.txtUser.getText());
            if (this.chkKeepInfo.getSelection()) {
                this.loginInfo.put("USER", DesEncrypter.encryptMeOr((String)this.txtUser.getText(), (String)""));
                this.loginInfo.put("PSWD", DesEncrypter.encryptMeOr((String)this.txtPassword.getText(), (String)""));
                this.loginInfo.put("KEEP", "true");
            } else {
                this.loginInfo.put("USER", "");
                this.loginInfo.put("PSWD", "");
                this.loginInfo.put("KEEP", "false");
            }
            this.loginInfo.put("USE_DOMAIN", String.valueOf(this.btnUseWindowsDomain.getSelection()));
            this.loginInfo.put("CLIENT", DesEncrypter.encryptMeOr((String)this.txtClient.getText(), (String)""));
            this.loginInfo.save();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to save login info", e);
        }
    }

    public void refreshFont() {
        FontAwareComposite.refreshFont((Control)this.getCompMain());
        this.getCompMain().layout(true, true);
    }

    private class LoginCallback
    extends JobCallback {
        private LoginCallback() {
            super(Messages.getString((String)"CONNEXION_EN_COURS", (String[])new String[0]), (IStatusHandler)new LoginStatusHandler());
        }

        public void responseReceived(final ReturnObject response) {
            if (response != null && !LogInView2.this.isDisposed()) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        LogInView2.this.loginResponse(response);
                    }
                });
            }
        }

        public void kill() {
            super.kill();
            if (!LogInView2.this.isDisposed()) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        LogInView2.this.connecting = false;
                        LogInView2.this.setInterfaceStatus();
                    }
                });
            }
        }

        public void exception(Exception e) {
            logger.log(Level.INFO, "Exception on login " + this.toString(), e);
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    LogInView2.this.connecting = false;
                    LogInView2.this.setInterfaceStatus();
                    MessageUtil.cannotConnectToServerExceptionMsg();
                }
            });
        }
    }

    private final class LoginStatusHandler
    extends DefaultStatusHandler {
        private LoginStatusHandler() {
        }

        @Override
        public IStatusHandler.State handle(final IStatus status) {
            final boolean[] handled = new boolean[1];
            if (LogInView2.this.isDisposed()) {
                handled[0] = true;
            } else {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!LoginStatusHandler.this.nullOrOkStatus(status)) {
                            if (status.getStatus("MAXIMUM_ACTIVE_SESSION_FOR_ROLE_HAS_BEEN_REACHED") != null) {
                                handled[0] = false;
                            } else if (status.getStatus("USER_RESPONSABILITIES") != null) {
                                handled[0] = true;
                            } else if (status.getStatus("BAD_PASSWORD_BAD_LOGIN") != null) {
                                LogInView2.this.badPassword();
                                handled[0] = true;
                            } else {
                                IStatus s = status.getStatus("CLIENT_DOES_NOT_EXIST");
                                if (s != null) {
                                    LogInView2.this.badCodeClient(s);
                                    handled[0] = true;
                                }
                            }
                        }
                    }
                });
            }
            if (handled[0]) {
                return IStatusHandler.State.HANDLED;
            }
            return super.handle(status);
        }
    }
}

