/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.eform;

import ca.infodata.ofys.client.modules.eform.EFormPrepare;
import ca.infodata.ofys.client.modules.eform.EformController;
import ca.infodata.ofys.data.middle.dataobjects.XBaseProfessionnal;
import ca.infodata.ofys.data.middle.dataobjects.XCompletionProposalType;
import ca.infodata.ofys.data.middle.dataobjects.eform.XEform;
import ca.infodata.ofys.data.middle.dataobjects.eform.XEformData;
import ca.infodata.ofys.data.middle.dataobjects.eform.XEformType;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IPatient;
import ca.infodata.ofys.data.middle.dataobjects.patient.IPatientRelated;
import ca.infodata.ofys.data.middle.dataobjects.template.XTemplate;
import ca.infodata.ofys.ui.controls.BaseEditor;
import ca.infodata.ofys.ui.controls.TimeTriggeredProgressMonitorDialog2;
import ca.infodata.ofys.ui.controls.assistant.gabarit.tools.TemplateHelper;
import ca.infodata.ofys.ui.controls.browser.BrowserComposite;
import ca.infodata.ofys.ui.controls.form.IReferenceControl;
import ca.infodata.ofys.ui.controls.plugins.searchview.BaseSearchView;
import ca.infodata.ofys.ui.controls.template.AssistTextDialog;
import ca.infodata.ofys.ui.controls.template.TemplateAccessorClient;
import ca.infodata.ofys.ui.controls.template.editor.TemplateEditor;
import ca.infodata.ofys.ui.controls.template.editor.XTemplateContainer;
import ca.infodata.ofys.ui.person.search.PatientSearchView;
import ca.infodata.ofys.ui.person.search.ProfessionnalSearchView;
import ca.infodata.ofys.util.EnumWithValues;
import ca.infodata.util1.StringUtils;
import com.google.gson.Gson;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.BrowserFunction;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class EFormBrowserComposite
extends BrowserComposite {
    private static final Logger logger = Logger.getLogger(EFormBrowserComposite.class.getName());
    private XEform form;
    private final EformController eformController = new EformController();

    public EFormBrowserComposite(Composite parent, FormToolkit toolkit) {
        super(parent, toolkit);
    }

    protected void init() {
        super.init();
        new SearchProfessionnalFunction(this.getInnerBrowser());
        new SearchPatientFunction(this.getInnerBrowser());
        new AssistTextFunction(this.getInnerBrowser());
        new AssistantGetterFunction(this.getInnerBrowser());
        new AssistantCountFunction(this.getInnerBrowser());
        new AssistantNewFunction(this.getInnerBrowser());
        new GabaritGetDescriptionFunction(this.getInnerBrowser());
        new GabaritGetFinalTextFunction(this.getInnerBrowser());
        new OpenTemplateEditorFunction(this.getInnerBrowser());
        new OpenJavaFunction(this.getInnerBrowser());
    }

    protected String getResourceName() {
        return "eform" + System.currentTimeMillis() + ".html";
    }

    protected void viewEFormData(final XEformData data) {
        if (data == null) {
            this.internalViewEform(null);
            return;
        }
        try {
            TimeTriggeredProgressMonitorDialog2 dialog = new TimeTriggeredProgressMonitorDialog2(this.getShell(), 1000L);
            dialog.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask("Chargement du formulaire", -1);
                    EFormBrowserComposite.this.internalViewEform((XEform)data.getForm());
                }
            });
        }
        catch (Exception e) {
            logger.log(Level.WARNING, data.toString(), e);
        }
    }

    public void viewEForm(final XEform f) {
        try {
            TimeTriggeredProgressMonitorDialog2 dialog = new TimeTriggeredProgressMonitorDialog2(this.getShell(), 500L);
            dialog.run(true, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask("Chargement du formulaire", -1);
                    EFormBrowserComposite.this.internalViewEform(f);
                    monitor.done();
                }
            });
        }
        catch (Exception e) {
            logger.log(Level.WARNING, f.toString(), e);
        }
    }

    protected void internalViewEform(XEform form) {
        this.form = form;
        try {
            String html = this.form.getType() == XEformType.CRDS ? EFormPrepare.injectAdditionalHtmlCRDS((String)form.getHtml()) : EFormPrepare.injectAdditionalHtml((String)form.getHtml());
            this.setHtmlInUIThread(html);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to show html resource", e);
            this.setHtmlInUIThread(e);
        }
    }

    public Map<String, Object> listFormInputs() {
        if (this.form.getType() == XEformType.CRDS) {
            return Collections.emptyMap();
        }
        Object[] inputs = (Object[])this.evaluate("return listFormInputs();");
        if (inputs == null) {
            return Collections.emptyMap();
        }
        String errorMessge = StringUtils.safeToString((Logger)logger, this.form == null ? null : this.form.getName());
        return this.eformController.mapFormInputs(inputs, errorMessge);
    }

    public Object[] listMetadata() {
        try {
            return (Object[])this.evaluate("return ofys_get_metadata();");
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to get medatada values from browser", e);
            throw new RuntimeException(e);
        }
    }

    public void setBrowserDirty(boolean b) {
        this.getInnerBrowser().evaluate("dirty = " + b + ";");
    }

    public void setBrowsertReadonly(boolean b) {
        this.getInnerBrowser().execute("setReadonlyOld(" + b + ");");
    }

    public String getResumeValue() {
        String func = "return getResumeValueInfodataCall();";
        String val = (String)this.getInnerBrowser().evaluate(func);
        return val == null ? "" : val;
    }

    public void preSaveForm() {
        String text = "SubmitImage();";
        this.getInnerBrowser().execute(text);
    }

    public void postLoadForm() {
        String text = "ReloadImage();";
        this.getInnerBrowser().execute(text);
    }

    public void setLoadedInfo(EFormPrepare config) {
        Gson gson = new Gson();
        String jMeta = gson.toJson((Object)config.meta);
        String jAuto = gson.toJson((Object)config.auto);
        String jSave = gson.toJson((Object)config.saved);
        String s = "setLoaded(_M_, _A_, _S_);";
        s = StringUtils.isBlank((CharSequence)jMeta) ? s.replace("_M_", "null") : s.replace("_M_", "\"" + EFormBrowserComposite.escapeAndPrepareJSValue(jMeta) + "\"");
        s = StringUtils.isBlank((CharSequence)jAuto) ? s.replace("_A_", "null") : s.replace("_A_", "\"" + EFormBrowserComposite.escapeAndPrepareJSValue(jAuto) + "\"");
        s = StringUtils.isBlank((CharSequence)jSave) ? s.replace("_S_", "null") : s.replace("_S_", "\"" + EFormBrowserComposite.escapeAndPrepareJSValue(jSave) + "\"");
        this.getInnerBrowser().execute(s);
    }

    public void setVariableInBrowser(String var, Object value) {
        this.setVariableInBrowser(this.getInnerBrowser(), var, value);
    }

    protected void setVariableInBrowser(Browser browser, String var, Object value) {
        String value2 = String.valueOf(value).replaceAll("\n", "\\\\n");
        value2 = value2.replaceAll("\r", "\\\\r");
        value2 = value2.replace("\"", "\\\"");
        String escapedValue = EFormBrowserComposite.escapeAndPrepareJSValue(value2);
        if (this.form.getType() == XEformType.CRDS) {
            String text = "setValeursChamp(\"" + var + "\", \"" + escapedValue + "\");";
            browser.execute(text);
        } else {
            String text = "setVariable(\"" + var + "\", \"" + escapedValue + "\");";
            browser.execute(text);
        }
    }

    private static String escapeAndPrepareJSValue(Object value) {
        String value2 = String.valueOf(value);
        value2 = value2.replace("\\", "\\\\");
        value2 = value2.replaceAll("\n", "\\\\n");
        value2 = value2.replaceAll("\r", "\\\\r");
        value2 = value2.replace("\"", "\\\"");
        return value2;
    }

    public void setVariablesInBrowser(Properties prop) {
        String js = "setVariables(" + EFormPrepare.propertiesToString((Properties)prop) + ")";
        this.getInnerBrowser().execute(js);
    }

    public boolean validate() {
        try {
            Object r = this.evaluate("return formValidator.validate();");
            return "true".equals(r) || Boolean.TRUE.equals(r);
        }
        catch (Exception exception) {
            return true;
        }
    }

    protected class AssistTextFunction
    extends BrowserFunction {
        AssistTextFunction(Browser browser) {
            super(browser, "assistText");
        }

        public Object function(Object[] arguments) {
            try {
                double aTypeD = (Double)arguments[0];
                final String nameField = (String)arguments[1];
                int aType = (int)aTypeD;
                XCompletionProposalType xcpt = (XCompletionProposalType)EnumWithValues.from(XCompletionProposalType.class, (Integer)aType);
                AssistTextDialog atd = new AssistTextDialog(EFormBrowserComposite.this.getShell(), null, xcpt){

                    public void onSelect(String value) {
                        if (value != null) {
                            EFormBrowserComposite.this.setVariableInBrowser(AssistTextFunction.this.getBrowser(), nameField, value);
                        }
                    }
                };
                atd.open();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return null;
        }
    }

    protected class AssistantCountFunction
    extends BrowserFunction {
        AssistantCountFunction(Browser browser) {
            super(browser, "assistantSelectedCount");
        }

        public Object function(Object[] arguments) {
            try {
                int idTemplate = ((Double)arguments[0]).intValue();
                TemplateAccessorClient.getInstance().use(Integer.valueOf(idTemplate));
                return null;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
    }

    protected class AssistantGetterFunction
    extends BrowserFunction {
        AssistantGetterFunction(Browser browser) {
            super(browser, "getAssistText");
        }

        public Object function(Object[] arguments) {
            try {
                String text = (String)(arguments.length > 1 ? arguments[1] : null);
                int aType = Integer.parseInt((String)arguments[0]);
                if (text != null) {
                    text = StringUtils.removeAccent((String)text.toLowerCase());
                }
                List list = TemplateAccessorClient.getInstance().findOneListGrouping(Integer.valueOf(aType), text);
                Gson gs = new Gson();
                String jsString = gs.toJson((Object)list);
                return jsString;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
    }

    protected class AssistantNewFunction
    extends BrowserFunction {
        AssistantNewFunction(Browser browser) {
            super(browser, "createNewAssistant");
        }

        public Object function(Object[] arguments) {
            try {
                String text = (String)(arguments.length > 1 ? arguments[1] : null);
                String name = (String)(arguments.length > 2 ? arguments[2] : null);
                int aType = Integer.parseInt((String)arguments[0]);
                XTemplate t = new XTemplate();
                t.setIsActif(Boolean.valueOf(true));
                t.setIsClientPrivate(Boolean.valueOf(false));
                t.setIsHtml(Boolean.valueOf(false));
                t.setName(name);
                t.setText(text);
                t.setType(Integer.valueOf(aType));
                TemplateAccessorClient.getInstance().save(t);
                return null;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
    }

    protected class GabaritGetDescriptionFunction
    extends BrowserFunction {
        GabaritGetDescriptionFunction(Browser browser) {
            super(browser, "gabaritGetDescription");
        }

        public Object function(Object[] arguments) {
            try {
                String value = (String)arguments[0];
                if (value != null) {
                    String text = TemplateHelper.getDescriptionString((String)value);
                    return text;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return null;
        }
    }

    protected class GabaritGetFinalTextFunction
    extends BrowserFunction {
        GabaritGetFinalTextFunction(Browser browser) {
            super(browser, "gabaritGetFinalText");
        }

        public Object function(Object[] arguments) {
            try {
                String value = (String)arguments[0];
                if (value != null) {
                    String text = TemplateHelper.getFinalString((String)value, (TemplateHelper.TemplateHelperComplexCallback)new TemplateHelper.TemplateHelperComplexCallback(){

                        public void callback(Object ... context) {
                        }
                    });
                    return text;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return null;
        }
    }

    private final class OpenJavaFunction
    extends BrowserFunction {
        private OpenJavaFunction(Browser browser) {
            super(browser, "open_java");
        }

        public Object function(Object[] arguments) {
            String href = null;
            try {
                href = (String)arguments[0];
                IWebBrowser browser = PlatformUI.getWorkbench().getBrowserSupport().getExternalBrowser();
                if (browser == null) {
                    browser = PlatformUI.getWorkbench().getBrowserSupport().createBrowser("eform");
                }
                URL url = new URL(href);
                browser.openURL(url);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Failed to open url " + href, e);
            }
            return null;
        }
    }

    protected class OpenTemplateEditorFunction
    extends BrowserFunction {
        OpenTemplateEditorFunction(Browser browser) {
            super(browser, "openTemplateEditor");
        }

        public Object function(Object[] arguments) {
            Integer type = null;
            try {
                type = ((Double)arguments[0]).intValue();
                XCompletionProposalType xcpt = XCompletionProposalType.getType((int)type);
                if (xcpt == null) {
                    xcpt = XCompletionProposalType.EFORM_ADAPTER;
                }
                XTemplateContainer xtc = new XTemplateContainer(xcpt, type.intValue());
                xtc.load();
                BaseEditor.openEditor((IEditorInput)xtc, (String)TemplateEditor.class.getName());
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Unable to open template editor: type=" + type, e);
            }
            return null;
        }
    }

    protected class SearchPatientFunction
    extends BrowserFunction {
        SearchPatientFunction(Browser browser) {
            super(browser, "searchPatient");
        }

        public Object function(Object[] arguments) {
            final String idField = (String)arguments[0];
            final String nameField = (String)arguments[1];
            BaseSearchView.openView(PatientSearchView.class, (Object)new IReferenceControl(){

                public void callback(Object o) {
                    if (o instanceof IPatient) {
                        EFormBrowserComposite.this.setVariableInBrowser(SearchPatientFunction.this.getBrowser(), idField, ((IPatient)o).getId());
                        EFormBrowserComposite.this.setVariableInBrowser(SearchPatientFunction.this.getBrowser(), nameField, ((IPatient)o).getName());
                    } else if (o instanceof IPatientRelated) {
                        this.callback(((IPatientRelated)o).getPatient());
                    }
                }
            });
            return null;
        }
    }

    protected class SearchProfessionnalFunction
    extends BrowserFunction {
        SearchProfessionnalFunction(Browser browser) {
            super(browser, "searchProf");
        }

        public Object function(Object[] arguments) {
            final String idField = (String)arguments[0];
            final String nameField = (String)arguments[1];
            final String codeField = arguments.length > 2 ? (String)arguments[2] : "";
            BaseSearchView.openView(ProfessionnalSearchView.class, (Object)new IReferenceControl(){

                public void callback(Object o) {
                    if (o instanceof XBaseProfessionnal) {
                        EFormBrowserComposite.this.setVariableInBrowser(SearchProfessionnalFunction.this.getBrowser(), idField, ((XBaseProfessionnal)o).getId());
                        EFormBrowserComposite.this.setVariableInBrowser(SearchProfessionnalFunction.this.getBrowser(), nameField, ((XBaseProfessionnal)o).getName());
                        if (!StringUtils.isEmpty((String)codeField)) {
                            EFormBrowserComposite.this.setVariableInBrowser(SearchProfessionnalFunction.this.getBrowser(), codeField, ((XBaseProfessionnal)o).getCode());
                        }
                    }
                }
            });
            return null;
        }
    }
}

