/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.dashboard;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.util.MessageUtil;
import ca.infodata.ofys.data.dataaccess.util.notification.IConsumerListener;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.XMsgImportance;
import ca.infodata.ofys.data.middle.dataobjects.XPatient;
import ca.infodata.ofys.data.middle.dataobjects.XSession;
import ca.infodata.ofys.data.middle.dataobjects.chat.LINK_TYPE;
import ca.infodata.ofys.data.middle.dataobjects.chat.MessageLink;
import ca.infodata.ofys.data.middle.dataobjects.chat.XCourrielDest;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IPatient;
import ca.infodata.ofys.data.middle.dataobjects.notification.DataObjectUpdatedNotification;
import ca.infodata.ofys.data.middle.dataobjects.notification.Notification;
import ca.infodata.ofys.ui.browser.sonar.SonarWS;
import ca.infodata.ofys.ui.controls.IContributionManagerExtension;
import ca.infodata.ofys.ui.dashboard.DashboardPlugin;
import ca.infodata.ofys.ui.intro.IntroPlugin;
import ca.infodata.ofys.ui.library.ResourceGetter;
import ca.infodata.ofys.ui.person.PersonUiPlugin;
import ca.infodata.ofys.ui.task.TaskPlugin;
import ca.infodata.util1.StringUtils;
import java.util.ArrayList;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class ChatContributionManagerExtension
implements IContributionManagerExtension {
    public static Action sendMessage = null;
    protected static final String sendMessageImg = "images/chat-icon32.png";
    protected static final String sendMessageImgNew = "images/chat-icon32new.png";
    protected static final String sendMessageImgUrg = "images/chat-icon32urg.png";
    private static String clientUid = null;
    Timer timer;
    TimerTask task;
    private final IConsumerListener consumerListener = new IConsumerListener(){

        public void handleOther(Notification notification) {
        }

        public void handle(DataObjectUpdatedNotification notification) {
            try {
                this._handle(notification);
            }
            catch (Exception exception) {}
        }

        private void _handle(DataObjectUpdatedNotification notification) {
            IDataObject dataObject = notification.getObject();
            if (dataObject instanceof XCourrielDest) {
                XCourrielDest dest = (XCourrielDest)dataObject;
                Integer sessionPersonId = Application.get().getGlobalInstances().getSessionPerson();
                if (dest.getIdPerson().equals(sessionPersonId)) {
                    if (XMsgImportance.HAUT.equals((Object)dest.getCourrielTexte().getImportance())) {
                        sendMessage.setImageDescriptor(ImageDescriptor.createFromImage((Image)ResourceGetter.getImage((String)ChatContributionManagerExtension.sendMessageImgUrg)));
                    } else {
                        sendMessage.setImageDescriptor(ImageDescriptor.createFromImage((Image)ResourceGetter.getImage((String)ChatContributionManagerExtension.sendMessageImgNew)));
                    }
                }
            }
        }

        public void forceRefresh() {
        }
    };

    public ChatContributionManagerExtension() {
        Application.get().getGlobalInstances().getNotificationSystem().addListener(this.consumerListener);
    }

    public void contribute(IContributionManager manager) {
        XSession session = Application.get().getGlobalInstances().getSession();
        if (session != null) {
            if (manager instanceof IToolBarManager) {
                sendMessage = new Action(){

                    public void run() {
                        XSession session = Application.get().getGlobalInstances().getSession();
                        if (session != null) {
                            if (Application.get().getGlobalInstances().canConnectToServer()) {
                                MessageLink ml = null;
                                if (TaskPlugin.getDefault().getCurrentMessageLink() != null) {
                                    ml = TaskPlugin.getDefault().getCurrentMessageLink();
                                }
                                XPatient pt = null;
                                if (ml == null && (pt = PersonUiPlugin.getDefault().getCurrentPatient()) != null) {
                                    ml = new MessageLink((IPatient)pt, LINK_TYPE.PATIENT, pt.getId());
                                }
                                ChatContributionManagerExtension.this.newMessageInOfys5(pt);
                            }
                        } else {
                            MessageUtil.cannotConnectToServerExceptionMsg();
                        }
                    }
                };
            }
            sendMessage.setImageDescriptor(ImageDescriptor.createFromImage((Image)ResourceGetter.getImage((String)sendMessageImg)));
            sendMessage.setToolTipText(Messages.getString((String)"DossierPerspective.messageSecretaire_ttt", (String[])new String[0]));
            manager.add((IAction)sendMessage);
        }
    }

    private void newMessageInOfys5(final XPatient patient) {
        ArrayList<String> uids = new ArrayList<String>();
        boolean foundIt = false;
        for (Map.Entry socket : SonarWS.getInstances().entrySet()) {
            if (!StringUtils.isNotBlank((String)((String)socket.getKey())) || !((SonarWS)socket.getValue()).ping()) continue;
            uids.add((String)socket.getKey());
            if (!((String)socket.getKey()).equals(clientUid)) continue;
            foundIt = true;
            break;
        }
        if (uids.isEmpty()) {
            DashboardPlugin.getDefault().openOfysChrome();
            final ArrayList lstUid = new ArrayList();
            if (this.timer != null) {
                this.timer.cancel();
            }
            if (this.task != null) {
                this.task.cancel();
            }
            this.timer = new Timer();
            this.task = new TimerTask(){

                @Override
                public void run() {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            for (Map.Entry socket : SonarWS.getInstances().entrySet()) {
                                if (!StringUtils.isNotBlank((String)((String)socket.getKey()))) continue;
                                lstUid.add((String)socket.getKey());
                                break;
                            }
                            if (!lstUid.isEmpty()) {
                                (this).ChatContributionManagerExtension.this.task.cancel();
                                (this).ChatContributionManagerExtension.this.timer.cancel();
                                ChatContributionManagerExtension.this.newMessageInOfys5(patient);
                            }
                        }
                    });
                }
            };
            this.timer.schedule(this.task, 2000L, 2000L);
            return;
        }
        if (!foundIt) {
            clientUid = (String)uids.get(0);
        }
        if (StringUtils.isNotEmpty((String)clientUid)) {
            String m = Messages.getString((String)"NEW_COURRIEL_IN_OFYSPRO", (String[])new String[0]);
            ArrayList<String> lst = new ArrayList<String>();
            lst.add(m);
            IntroPlugin.getDefault().showInfoWindow(lst, IntroPlugin.TypeMsg.ACTIF);
            DashboardPlugin.getDefault().getPatientControllerWeb().newCourriel(patient, clientUid);
        }
    }
}

