/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.dashboard;

import ca.infodata.ofys.data.middle.dataobjects.interfaces.IDataObject;
import ca.infodata.ofys.ui.controls.BaseEditor;
import ca.infodata.ofys.ui.controls.DownloadProgressDialogSWT;
import ca.infodata.ofys.ui.controls.EditorInput;
import ca.infodata.ofys.ui.dashboard.DashboardData;
import ca.infodata.ofys.ui.dashboard.DashboardEditor;
import ca.infodata.ofys.ui.dashboard.DashboardPlugin;
import ca.infodata.ofys.ui.library.DaemonThread;
import ca.infodata.ofys.ui.library.LibPlugin;
import ca.infodata.ofys.ui.library.MyAbstractHandler;
import ca.infodata.ofys.ui.library.UI;
import ca.infodata.util1.date.LocaleProvider;
import ca.infodata.util1.file.FileUtil;
import ca.infodata.util1.http.download.Download;
import ca.infodata.util1.http.download.Util;
import ca.infodata.util1.http.download.ValidatedDownload;
import java.io.File;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.zeroturnaround.zip.ZipUtil;

public class CefHandler
extends MyAbstractHandler {
    private static final Logger logger = Logger.getLogger(CefHandler.class.getName());
    static boolean alwaysUseChromium = true;
    static boolean alwaysUseExternalBrowser = false;
    private static String ofysChromeMacMd5gz = "7f69e6e5fa9af452de83e56d867a5d01";
    private static String ofysChromeMacMd5exe = "90aafe2986ec630119094cc9f9913f34";
    private static String ofysChromeMacASMd5gz = "7f69e6e5fa9af452de83e56d867a5d01";
    private static String ofysChromeMacASMd5exe = "90aafe2986ec630119094cc9f9913f34";
    private static String ofysChromeWin64Md5zip = "681af52b1a5b58dc3ec49b6cd7626a7a";
    private static String ofysChromeWin64Md5exe = "345561345fd65a35e349f56aa7536475";
    private static String ofysChromeWin32Md5zip = "76a779fc71bee5812796c6e393b50935";
    private static String ofysChromeWin32Md5exe = "b362085d029403ec9ee4ac5a80602bc4";
    private static String ofysChromeServer;
    private String dossierInstall = "/ofys-chrome";

    static {
        String key = "ofys.chrome.mac.md5.gz";
        String md5 = System.getProperty(key);
        if (md5 != null) {
            ofysChromeMacMd5gz = md5;
        }
        if ((md5 = System.getProperty(key = "ofys.chrome.mac.md5.exe")) != null) {
            ofysChromeMacMd5exe = md5;
        }
        if ((md5 = System.getProperty(key = "ofys.chrome.macAS.md5.gz")) != null) {
            ofysChromeMacASMd5gz = md5;
        }
        if ((md5 = System.getProperty(key = "ofys.chrome.macAS.md5.exe")) != null) {
            ofysChromeMacASMd5exe = md5;
        }
        if ((md5 = System.getProperty(key = "ofys.chrome.win64.md5.zip")) != null) {
            ofysChromeWin64Md5zip = md5;
        }
        if ((md5 = System.getProperty(key = "ofys.chrome.win64.md5.exe")) != null) {
            ofysChromeWin64Md5exe = md5;
        }
        if ((md5 = System.getProperty(key = "ofys.chrome.win32.md5.zip")) != null) {
            ofysChromeWin32Md5zip = md5;
        }
        if ((md5 = System.getProperty(key = "ofys.chrome.win32.md5.exe")) != null) {
            ofysChromeWin32Md5exe = md5;
        }
        ofysChromeServer = "https://www.ofys.net/chrome/";
    }

    public static void main(String[] a) throws Exception {
        if (a != null && a.length > 0) {
            String[] stringArray = a;
            int n = a.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                File appFile = new File(s.trim());
                if (!appFile.exists()) {
                    System.out.println("DOES NOT EXIST: " + s.trim());
                } else {
                    String computeMd5 = Util.computeMd5((File)appFile);
                    System.out.println("zipfile " + appFile.getAbsolutePath() + "\n" + "md5: " + computeMd5);
                }
                ++n2;
            }
        }
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        block7: {
            try {
                try {
                    if (alwaysUseChromium || UI.OS_WINDOWS) {
                        this.openFromHost(event);
                        break block7;
                    }
                    try {
                        BaseEditor.openEditor((IEditorInput)new EditorInput((IDataObject)new DashboardData()), (String)DashboardEditor.class.getName());
                    }
                    catch (Exception e) {
                        logger.log(Level.SEVERE, "Dashboard editor open error", e);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.openFromWeb(event);
                }
            }
            catch (Exception e) {
                throw new ExecutionException("Failed to run CefHandler", (Throwable)e);
            }
        }
        return null;
    }

    private void openFromWeb(ExecutionEvent event) throws Exception {
        try {
            String enUrl = "https://www.ofys.ca/en/index.html";
            String frUrl = "https://www.ofys.ca/fr/index.html";
            String surl = LocaleProvider.isEnglish() ? enUrl : frUrl;
            URL url = new URL(surl);
            IWorkbenchWindow window = this.getOrOpenActiveWorkbenchWindow(event);
            IWorkbenchBrowserSupport browserSupport = window.getWorkbench().getBrowserSupport();
            IWebBrowser browser = browserSupport.createBrowser(128, "ca.infodata.ofys.ui.remotehelp", null, null);
            browser.openURL(url);
        }
        catch (Exception e) {
            String s = "Failed to open ofys-chrome from web";
            logger.log(Level.SEVERE, s, e);
            throw new ExecutionException(s, (Throwable)e);
        }
    }

    private void openFromHost(ExecutionEvent event) throws Exception {
        File exeFile;
        String md5Zip;
        String filename;
        String winMacExe;
        String string = winMacExe = UI.OS_WINDOWS ? "ofys-chrome.exe" : "cefsimple.app";
        String string2 = UI.OS_WINDOWS ? (UI.OS_WINDOWS64B ? "ofyschromewin_202109.zip" : "ofyschromewin32_202109.zip") : (filename = "ofyschromemac_202109.gz");
        String string3 = UI.OS_WINDOWS ? (UI.OS_WINDOWS64B ? ofysChromeWin64Md5zip : ofysChromeWin32Md5zip) : (md5Zip = ofysChromeMacMd5gz);
        String md5Exe = UI.OS_WINDOWS ? (UI.OS_WINDOWS64B ? ofysChromeWin64Md5exe : ofysChromeWin32Md5exe) : ofysChromeMacMd5exe;
        String address = String.valueOf(ofysChromeServer) + filename;
        File userDir = new File(Platform.getLocation().toString()).getParentFile();
        File zipFile = new File(userDir, filename);
        if (UI.OS_WINDOWS) {
            exeFile = new File(String.valueOf(zipFile.getParent()) + this.dossierInstall, winMacExe);
        } else {
            File appFile = new File(String.valueOf(zipFile.getParent()) + this.dossierInstall, winMacExe);
            exeFile = new File(String.valueOf(appFile.getAbsolutePath()) + "/Contents/MacOS/cefsimple");
        }
        boolean exeOk = this.exeFileOk(md5Exe, String.valueOf(zipFile.getParent()) + this.dossierInstall, exeFile);
        if (!exeOk) {
            this.getOrDownload(event, zipFile, new URL(address), md5Zip);
            if (zipFile.exists()) {
                if (UI.OS_WINDOWS) {
                    try {
                        ZipUtil.unpack((File)zipFile, (File)new File(String.valueOf(zipFile.getParent()) + this.dossierInstall));
                    }
                    catch (Exception e) {
                        logger.log(Level.SEVERE, "Failed to unzip " + zipFile.getAbsolutePath(), e);
                        throw e;
                    }
                }
                try {
                    String[] cmdExeS;
                    boolean ok;
                    String cmdTar = "/usr/bin/tar";
                    if (!new File(cmdTar).exists()) {
                        cmdTar = "tar";
                    }
                    if (!(ok = ca.infodata.ofys.ui.library.Util.doProcess((String[])(cmdExeS = new String[]{cmdTar, "xvzf", zipFile.getAbsolutePath(), "-C", zipFile.getParent()})))) {
                        logger.severe("Failed to untar file ... " + zipFile.getAbsolutePath());
                    } else {
                        System.out.println("untar successful for " + zipFile.getAbsolutePath());
                    }
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Failed to untar " + zipFile.getAbsolutePath(), e);
                    throw e;
                }
                exeOk = this.exeFileOk(md5Exe, String.valueOf(zipFile.getParent()) + this.dossierInstall, exeFile);
            } else {
                throw new Exception("Failed to download " + filename + " from " + address);
            }
        }
        if (exeOk) {
            DashboardPlugin.getDefault().setExeOfysChromeBrowser(exeFile.getAbsolutePath());
            DashboardPlugin.getDefault().openOfysChromeBrowser();
        }
    }

    protected boolean exeFileOk(String md5Exe, String chromeFolder, File exeFile) throws Exception {
        boolean exeOk = false;
        if (exeFile.exists()) {
            String computeMd5 = Util.computeMd5((File)exeFile);
            System.out.println("<" + exeFile.getAbsolutePath() + "> md5=" + computeMd5);
            exeOk = computeMd5.equals(md5Exe);
            if (!exeOk) {
                FileUtil.deleteFile((File)new File(chromeFolder));
            }
        }
        return exeOk;
    }

    private void getOrDownload(ExecutionEvent event, File file, URL url, String referenceMD5) throws ExecutionException {
        if (file.exists()) {
            try {
                boolean delete;
                String computedMd5 = Util.computeMd5((File)file);
                System.out.println("<" + file.getAbsolutePath() + "> md5=" + computedMd5);
                if (!referenceMD5.equals(computedMd5) && !(delete = file.delete())) {
                    logger.severe("Failed to delete invalid file ... " + file.getName());
                    return;
                }
            }
            catch (Exception exception) {
                logger.log(Level.SEVERE, "Failed to compute md5 sum of file " + file);
                return;
            }
        }
        if (!file.exists()) {
            Shell shell = LibPlugin.getDefault().getWorkbench().getWorkbenchWindows()[0].getShell();
            final DownloadProgressDialogSWT dialog = new DownloadProgressDialogSWT(shell);
            dialog.setBlockOnOpen(true);
            final ValidatedDownload download = new ValidatedDownload(url, file);
            download.setMd5(referenceMD5);
            download.setMonitor(dialog.getMonitor());
            DaemonThread downloadThread = new DaemonThread(new Runnable(){

                @Override
                public void run() {
                    download.run();
                    dialog.setDone();
                }
            }, "download-" + file.getName());
            downloadThread.start();
            dialog.open();
            if (download.getStatus() != Download.STATUS.COMPLETE) {
                return;
            }
        }
        try {
            String computeMd5 = Util.computeMd5((File)file);
            System.out.println("zipfile md5:" + computeMd5);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

