/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.ArrayUtil;

class MinShouldMatchSumScorer
extends Scorer {
    private int numScorers;
    private final int mm;
    private final Scorer[] sortedSubScorers;
    private int sortedSubScorersIdx = 0;
    private final Scorer[] subScorers;
    private int nrInHeap;
    private final Scorer[] mmStack;
    private int doc = -1;
    protected int nrMatchers = -1;
    private double score = Double.NaN;

    public MinShouldMatchSumScorer(Weight weight, List<Scorer> subScorers, int minimumNrMatchers) throws IOException {
        super(weight);
        this.nrInHeap = this.numScorers = subScorers.size();
        if (minimumNrMatchers <= 0) {
            throw new IllegalArgumentException("Minimum nr of matchers must be positive");
        }
        if (this.numScorers <= 1) {
            throw new IllegalArgumentException("There must be at least 2 subScorers");
        }
        this.mm = minimumNrMatchers;
        this.sortedSubScorers = subScorers.toArray(new Scorer[this.numScorers]);
        ArrayUtil.timSort(this.sortedSubScorers, new Comparator<Scorer>(){

            @Override
            public int compare(Scorer o1, Scorer o2) {
                return Long.signum(o2.cost() - o1.cost());
            }
        });
        this.mmStack = new Scorer[this.mm - 1];
        int i = 0;
        while (i < this.mm - 1) {
            this.mmStack[i] = this.sortedSubScorers[i];
            ++i;
        }
        this.nrInHeap -= this.mm - 1;
        this.sortedSubScorersIdx = this.mm - 1;
        this.subScorers = new Scorer[this.nrInHeap];
        i = 0;
        while (i < this.nrInHeap) {
            this.subScorers[i] = this.sortedSubScorers[this.mm - 1 + i];
            ++i;
        }
        this.minheapHeapify();
        assert (this.minheapCheck());
    }

    public MinShouldMatchSumScorer(Weight weight, List<Scorer> subScorers) throws IOException {
        this(weight, subScorers, 1);
    }

    @Override
    public final Collection<Scorer.ChildScorer> getChildren() {
        ArrayList<Scorer.ChildScorer> children = new ArrayList<Scorer.ChildScorer>(this.numScorers);
        int i = 0;
        while (i < this.numScorers) {
            children.add(new Scorer.ChildScorer(this.subScorers[i], "SHOULD"));
            ++i;
        }
        return children;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public int nextDoc() throws IOException {
        if (MinShouldMatchSumScorer.$assertionsDisabled || this.doc != 0x7FFFFFFF) ** GOTO lbl11
        throw new AssertionError();
        {
            if (this.subScorers[0].nextDoc() != 0x7FFFFFFF) {
                this.minheapSiftDown(0);
            } else {
                this.minheapRemoveRoot();
                --this.numScorers;
                if (this.numScorers < this.mm) {
                    this.doc = 0x7FFFFFFF;
                    return 0x7FFFFFFF;
                }
            }
lbl11:
            // 4 sources

            do {
                if (this.subScorers[0].docID() == this.doc) continue block0;
                this.evaluateSmallestDocInHeap();
            } while (this.nrMatchers < this.mm);
        }
        return this.doc;
    }

    private void evaluateSmallestDocInHeap() throws IOException {
        this.doc = this.subScorers[0].docID();
        if (this.doc == Integer.MAX_VALUE) {
            this.nrMatchers = Integer.MAX_VALUE;
            return;
        }
        this.score = this.subScorers[0].score();
        this.nrMatchers = 1;
        this.countMatches(1);
        this.countMatches(2);
        int i = this.mm - 2;
        while (i >= 0) {
            if (this.mmStack[i].docID() >= this.doc || this.mmStack[i].advance(this.doc) != Integer.MAX_VALUE) {
                if (this.mmStack[i].docID() == this.doc) {
                    ++this.nrMatchers;
                    this.score += (double)this.mmStack[i].score();
                } else if (this.nrMatchers + i < this.mm) {
                    return;
                }
            } else {
                --this.numScorers;
                if (this.numScorers < this.mm) {
                    this.doc = Integer.MAX_VALUE;
                    this.nrMatchers = Integer.MAX_VALUE;
                    return;
                }
                if (this.mm - 2 - i > 0) {
                    System.arraycopy(this.mmStack, i + 1, this.mmStack, i, this.mm - 2 - i);
                }
                while (!this.minheapRemove(this.sortedSubScorers[this.sortedSubScorersIdx++])) {
                }
                this.mmStack[this.mm - 2] = this.sortedSubScorers[this.sortedSubScorersIdx - 1];
                if (this.nrMatchers + i < this.mm) {
                    return;
                }
            }
            --i;
        }
    }

    private void countMatches(int root) throws IOException {
        if (root < this.nrInHeap && this.subScorers[root].docID() == this.doc) {
            ++this.nrMatchers;
            this.score += (double)this.subScorers[root].score();
            this.countMatches((root << 1) + 1);
            this.countMatches((root << 1) + 2);
        }
    }

    @Override
    public float score() throws IOException {
        return (float)this.score;
    }

    @Override
    public int docID() {
        return this.doc;
    }

    @Override
    public int freq() throws IOException {
        return this.nrMatchers;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public int advance(int target) throws IOException {
        if (this.numScorers >= this.mm) ** GOTO lbl12
        this.doc = 0x7FFFFFFF;
        return 0x7FFFFFFF;
lbl-1000:
        // 1 sources

        {
            if (this.subScorers[0].advance(target) != 0x7FFFFFFF) {
                this.minheapSiftDown(0);
                continue;
            }
            this.minheapRemoveRoot();
            --this.numScorers;
            if (this.numScorers >= this.mm) continue;
            this.doc = 0x7FFFFFFF;
            return 0x7FFFFFFF;
lbl12:
            // 3 sources

            ** while (this.subScorers[0].docID() < target)
        }
lbl13:
        // 1 sources

        this.evaluateSmallestDocInHeap();
        if (this.nrMatchers >= this.mm) {
            return this.doc;
        }
        return this.nextDoc();
    }

    @Override
    public long cost() {
        long costCandidateGeneration = 0L;
        int i = 0;
        while (i < this.nrInHeap) {
            costCandidateGeneration += this.subScorers[i].cost();
            ++i;
        }
        return (long)(1.0f * (float)costCandidateGeneration + 1.0f * (float)costCandidateGeneration * (float)(this.mm - 1));
    }

    protected final void minheapHeapify() {
        int i = (this.nrInHeap >> 1) - 1;
        while (i >= 0) {
            this.minheapSiftDown(i);
            --i;
        }
    }

    protected final void minheapSiftDown(int root) {
        Scorer scorer = this.subScorers[root];
        int doc = scorer.docID();
        int i = root;
        while (i <= (this.nrInHeap >> 1) - 1) {
            int lchild = (i << 1) + 1;
            Scorer lscorer = this.subScorers[lchild];
            int ldoc = lscorer.docID();
            int rdoc = Integer.MAX_VALUE;
            int rchild = (i << 1) + 2;
            Scorer rscorer = null;
            if (rchild < this.nrInHeap) {
                rscorer = this.subScorers[rchild];
                rdoc = rscorer.docID();
            }
            if (ldoc < doc) {
                if (rdoc < ldoc) {
                    this.subScorers[i] = rscorer;
                    this.subScorers[rchild] = scorer;
                    i = rchild;
                    continue;
                }
                this.subScorers[i] = lscorer;
                this.subScorers[lchild] = scorer;
                i = lchild;
                continue;
            }
            if (rdoc < doc) {
                this.subScorers[i] = rscorer;
                this.subScorers[rchild] = scorer;
                i = rchild;
                continue;
            }
            return;
        }
    }

    protected final void minheapSiftUp(int i) {
        Scorer scorer = this.subScorers[i];
        int doc = scorer.docID();
        while (i > 0) {
            int parent = i - 1 >> 1;
            Scorer pscorer = this.subScorers[parent];
            int pdoc = pscorer.docID();
            if (pdoc <= doc) break;
            this.subScorers[i] = this.subScorers[parent];
            i = parent;
        }
        this.subScorers[i] = scorer;
    }

    protected final void minheapRemoveRoot() {
        if (this.nrInHeap == 1) {
            this.nrInHeap = 0;
        } else {
            --this.nrInHeap;
            this.subScorers[0] = this.subScorers[this.nrInHeap];
            this.minheapSiftDown(0);
        }
    }

    protected final boolean minheapRemove(Scorer scorer) {
        int i = 0;
        while (i < this.nrInHeap) {
            if (this.subScorers[i] == scorer) {
                this.subScorers[i] = this.subScorers[--this.nrInHeap];
                this.minheapSiftUp(i);
                this.minheapSiftDown(i);
                return true;
            }
            ++i;
        }
        return false;
    }

    boolean minheapCheck() {
        return this.minheapCheck(0);
    }

    private boolean minheapCheck(int root) {
        if (root >= this.nrInHeap) {
            return true;
        }
        int lchild = (root << 1) + 1;
        int rchild = (root << 1) + 2;
        if (lchild < this.nrInHeap && this.subScorers[root].docID() > this.subScorers[lchild].docID()) {
            return false;
        }
        if (rchild < this.nrInHeap && this.subScorers[root].docID() > this.subScorers[rchild].docID()) {
            return false;
        }
        return this.minheapCheck(lchild) && this.minheapCheck(rchild);
    }
}

