/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.util.List;
import org.apache.lucene.index.CompositeReaderContext;
import org.apache.lucene.index.IndexReader;

public abstract class CompositeReader
extends IndexReader {
    private volatile CompositeReaderContext readerContext = null;

    protected CompositeReader() {
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        Class<?> clazz = this.getClass();
        while (clazz != null) {
            if (!clazz.isAnonymousClass()) {
                buffer.append(clazz.getSimpleName());
                break;
            }
            clazz = clazz.getSuperclass();
        }
        buffer.append('(');
        List<? extends IndexReader> subReaders = this.getSequentialSubReaders();
        assert (subReaders != null);
        if (!subReaders.isEmpty()) {
            buffer.append(subReaders.get(0));
            int i = 1;
            int c = subReaders.size();
            while (i < c) {
                buffer.append(" ").append(subReaders.get(i));
                ++i;
            }
        }
        buffer.append(')');
        return buffer.toString();
    }

    protected abstract List<? extends IndexReader> getSequentialSubReaders();

    @Override
    public final CompositeReaderContext getContext() {
        this.ensureOpen();
        if (this.readerContext == null) {
            assert (this.getSequentialSubReaders() != null);
            this.readerContext = CompositeReaderContext.create(this);
        }
        return this.readerContext;
    }
}

