/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.hunspell5;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.hunspell.HunspellAffix;
import org.apache.lucene.analysis.hunspell.HunspellStemmer;
import org.apache.lucene.analysis.hunspell5.Dictionary;
import org.apache.lucene.analysis.hunspell5.HunspellStemFilter;
import org.apache.lucene.analysis.hunspell5.Stemmer;
import org.apache.lucene.analysis.util.FilesystemResourceLoader;
import org.apache.lucene.analysis.util.ResourceLoader;
import org.apache.lucene.analysis.util.ResourceLoaderAware;
import org.apache.lucene.analysis.util.TokenFilterFactory;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.search.spell.PlainTextDictionary;
import org.apache.lucene.search.spell.SpellChecker;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.SimpleFSDirectory;
import org.apache.lucene.util.CharsRef;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.Version;

public class HunspellStemFilterFactory
extends TokenFilterFactory
implements ResourceLoaderAware {
    private static final String PARAM_DICTIONARY = "dictionary";
    private static final String PARAM_AFFIX = "affix";
    private static final String PARAM_RECURSION_CAP = "recursionCap";
    private static final String PARAM_IGNORE_CASE = "ignoreCase";
    private static final String PARAM_LONGEST_ONLY = "longestOnly";
    private final String dictionaryFiles;
    private final String tempPath;
    private final String affixFile;
    private final boolean ignoreCase;
    private final boolean longestOnly;
    private Dictionary dictionary;

    public HunspellStemFilterFactory(Map<String, String> args) {
        super(args);
        this.dictionaryFiles = this.require(args, PARAM_DICTIONARY);
        this.tempPath = this.require(args, "path");
        this.affixFile = this.get(args, PARAM_AFFIX);
        this.ignoreCase = this.getBoolean(args, PARAM_IGNORE_CASE, false);
        this.longestOnly = this.getBoolean(args, PARAM_LONGEST_ONLY, false);
        this.getBoolean(args, "strictAffixParsing", true);
        this.getInt(args, PARAM_RECURSION_CAP, 0);
        if (!args.isEmpty()) {
            throw new IllegalArgumentException("Unknown parameters: " + args);
        }
    }

    @Override
    public void inform(ResourceLoader loader) throws IOException {
        block8: {
            String[] dicts = this.dictionaryFiles.split(",");
            InputStream affix = null;
            ArrayList<InputStream> dictionaries = new ArrayList<InputStream>();
            try {
                try {
                    dictionaries = new ArrayList();
                    String dictLangue = null;
                    String[] stringArray = dicts;
                    int n = dicts.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String file = stringArray[n2];
                        dictionaries.add(loader.openResource(file));
                        if (dictLangue == null) {
                            dictLangue = new File(file).getName().substring(0, 2);
                        }
                        ++n2;
                    }
                    affix = loader.openResource(this.affixFile);
                    this.dictionary = new Dictionary(affix, dictionaries, this.ignoreCase, this.tempPath, dictLangue);
                }
                catch (ParseException e) {
                    throw new IOException("Unable to load hunspell data! [dictionary=" + dictionaries + ",affix=" + this.affixFile + "]", e);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    IOUtils.closeWhileHandlingException(affix);
                    IOUtils.closeWhileHandlingException(dictionaries);
                    break block8;
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeWhileHandlingException(affix);
                IOUtils.closeWhileHandlingException(dictionaries);
                throw throwable;
            }
            IOUtils.closeWhileHandlingException(affix);
            IOUtils.closeWhileHandlingException(dictionaries);
        }
    }

    @Override
    public TokenStream create(TokenStream tokenStream) {
        return new HunspellStemFilter(tokenStream, this.dictionary, true, this.longestOnly);
    }

    public static void main(String[] args) throws IOException, ParseException {
        String[] words;
        String dictLangue = "fr";
        FileInputStream textInputStream = new FileInputStream("/Users/pdrolet/user/tools/dicts/" + dictLangue + "_CA.txt");
        PlainTextDictionary textDict = new PlainTextDictionary(textInputStream);
        FSDirectory dir = SimpleFSDirectory.open(new File("/Users/pdrolet/user/tools/dicts/idx_" + dictLangue + "/"));
        SpellChecker spellchecker = new SpellChecker(dir);
        spellchecker.indexDictionary(textDict, new IndexWriterConfig(Version.LUCENE_45, null), false);
        HashMap<String, String> m = new HashMap<String, String>();
        m.put(PARAM_DICTIONARY, "/Users/pdrolet/user/tools/dicts/fr-toutesvariantes.dic");
        m.put(PARAM_AFFIX, "/Users/pdrolet/user/tools/dicts/fr-toutesvariantes.aff");
        HunspellStemFilterFactory filter = new HunspellStemFilterFactory(m);
        FilesystemResourceLoader loader = new FilesystemResourceLoader();
        filter.inform(loader);
        Stemmer stemmer = new Stemmer(filter.dictionary);
        String[] stringArray = words = new String[]{"iPad", "ammour", "jeus", "crayons", "styllot", "chaise"};
        int n = words.length;
        int n2 = 0;
        while (n2 < n) {
            String word = stringArray[n2];
            System.out.println(word);
            List<CharsRef> lst = stemmer.stem(word);
            boolean found = lst.size() > 0;
            for (CharsRef charsRef : lst) {
                System.out.println(" -> " + charsRef);
            }
            if (!found) {
                String[] sugg;
                System.out.println("NOT FOUND... suggestions?");
                String[] stringArray2 = sugg = spellchecker.suggestSimilar(word, 8, 0.7f);
                int n3 = sugg.length;
                int n4 = 0;
                while (n4 < n3) {
                    String s = stringArray2[n4];
                    System.out.println("         Suggestion: " + s);
                    ++n4;
                }
            }
            ++n2;
        }
        spellchecker.close();
    }

    private static void printStemResults(String originalWord, List<HunspellStemmer.Stem> stems) {
        StringBuilder builder = new StringBuilder().append("stem(").append(originalWord).append(")").append("\n");
        for (HunspellStemmer.Stem stem : stems) {
            builder.append("- ").append(stem.getStem()).append(": ");
            for (HunspellAffix prefix : stem.getPrefixes()) {
                builder.append(prefix.getAppend()).append("+");
                if (!HunspellStemFilterFactory.hasText(prefix.getStrip())) continue;
                builder.append(prefix.getStrip()).append("-");
            }
            builder.append(stem.getStem());
            for (HunspellAffix suffix : stem.getSuffixes()) {
                if (HunspellStemFilterFactory.hasText(suffix.getStrip())) {
                    builder.append("-").append(suffix.getStrip());
                }
                builder.append("+").append(suffix.getAppend());
            }
            builder.append("\n");
        }
        System.out.println(builder);
    }

    private static boolean hasText(String str) {
        return str != null && str.length() > 0;
    }

    public Dictionary getDictionary() {
        return this.dictionary;
    }
}

