/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.controls.util;

import ca.infodata.ofys.status.MultiStatus;
import ca.infodata.ofys.ui.controls.util.IDialogSettings3;
import ca.infodata.ofys.ui.controls.util.IPreferenceListener;
import ca.infodata.ofys.ui.controls.util.MyDialogSettings;
import ca.infodata.util1.MutableBoolean;
import java.util.logging.Logger;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.mb.listeners.GenListenerManager;

public class PreferencesSettings
extends MyDialogSettings {
    private static final Logger logger = Logger.getLogger(PreferencesSettings.class.getName());
    private static PreferencesSettings instance;
    private GenListenerManager<IPreferenceListener> manager = new GenListenerManager(IPreferenceListener.class);
    private IPreferenceListener proxy = (IPreferenceListener)this.manager.getProxy();

    public static void setInstance(PreferencesSettings instance) {
        PreferencesSettings.instance = instance;
    }

    public static PreferencesSettings getInstance() {
        return instance;
    }

    public PreferencesSettings(String fileName, String section) {
        super(fileName, section);
    }

    @Override
    protected void beforePutEvent(String key, String oldValue, String value) {
        MultiStatus status = new MultiStatus();
        this.proxy.validChange(key, oldValue, value, status);
        if (!status.isOK()) {
            throw new RuntimeException(status.getMessage());
        }
    }

    @Override
    public void afterPutEvent(String key, String oldValue, String value) {
        if (!PreferencesSettings.areEquals(value, oldValue)) {
            this.proxy.changed(key, oldValue, value);
        }
    }

    @Override
    protected void beforePutEvent(String key, String[] oldValue, String[] value) {
        logger.severe("unsupported beforePutEvent(String, String[], String[]) call for key " + key);
    }

    @Override
    protected void afterPutEvent(String key, String[] oldValue, String[] value) {
        logger.severe("unsupported afterPutEvent(String, String[], String[]) call for key " + key);
    }

    private static boolean areEquals(String o1, String o2) {
        if (o1 == null && o2 == null) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        return o1.equals(o2);
    }

    @Override
    public IDialogSettings3 addNewSection(String sectionName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addSection(IDialogSettings3 section) {
        throw new UnsupportedOperationException();
    }

    public void addListener(IPreferenceListener arg0) throws IllegalArgumentException {
        this.manager.addListener((Object)arg0);
    }

    public void removeListener(IPreferenceListener arg0) throws IllegalArgumentException {
        this.manager.removeListener((Object)arg0);
    }

    public void linkCheckbox(final Button checkbox, final String key, final MutableBoolean linkValue) {
        checkbox.setSelection(this.getBoolean(key, linkValue.booleanValue()));
        checkbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean v = checkbox.getSelection();
                linkValue.setValue(v);
                PreferencesSettings.this.put(key, v);
            }
        });
    }
}

