/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.controls.template.editor;

import ca.infodata.ofys.client.modules.template.DField;
import ca.infodata.ofys.client.modules.template.DList;
import ca.infodata.ofys.client.modules.template.TypeDeDonnee;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.XCompletionProposalType;
import ca.infodata.ofys.ui.controls.MyMaskedText;
import ca.infodata.ofys.ui.controls.MyMessageDialogBuilder;
import ca.infodata.ofys.ui.controls.form.MyButton;
import ca.infodata.ofys.ui.controls.form.MyLabel;
import ca.infodata.ofys.ui.controls.form.combo.MyCombo;
import ca.infodata.ofys.ui.library.UI;
import ca.infodata.util1.StringUtils;
import java.util.regex.Pattern;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class DListDialog
extends MyMessageDialogBuilder {
    private static String REQUIRED_DATA = Messages.getString((String)"REQUIRED_DATA", (String[])new String[0]);
    private DList field;
    private MyMaskedText txtName;
    private Text txtSeparator;
    private MyButton chkMultiple;
    private MyCombo<TypeDeDonnee> cmbTypeDeDonnee;
    private MyButton chkRequired;
    private MyMaskedText txtAddItem;
    private List listItem;
    private Button btnAddItem;
    private Button btnRemoveItem;
    private Button btnUpItem;
    private Button btnDownItem;
    private final XCompletionProposalType type;

    public DListDialog(Shell shell, DList field, XCompletionProposalType xType) {
        this.field = field;
        this.type = xType;
        this.setButtonLabels(Messages.getString((String)"OK", (String[])new String[0]), Messages.getString((String)"CANCEL", (String[])new String[0]));
        this.setDefaultButton(-1);
        this.setParent(shell);
        this.setTitle("Liste");
    }

    @Override
    protected Control createCustomArea(Composite parent) {
        parent = new Composite(parent, 0);
        MyLabel lblName = new MyLabel(parent, "Nom du groupe:", 16384);
        this.txtName = new MyMaskedText(parent, Pattern.compile(DField.regExpForName));
        this.txtName.setValidStyle(6);
        MyLabel lblSeparator = new MyLabel(parent, "S\u00e9parateur des \u00e9l\u00e9ments (espace?, virgule?, ...):", 16384);
        this.txtSeparator = new Text(parent, 2048);
        this.chkMultiple = new MyButton(parent, "Permettre une s\u00e9lection multiple", 32, null);
        MyLabel lblType = new MyLabel(parent, "Type de donn\u00e9es :", 16384);
        this.cmbTypeDeDonnee = new MyCombo(parent, 8);
        this.cmbTypeDeDonnee.setItems((TypeDeDonnee[])TypeDeDonnee.values());
        this.chkRequired = new MyButton(parent, REQUIRED_DATA, 32, null);
        MyLabel lblList = new MyLabel(parent, Messages.getString((String)"ELEMENTS", (String[])new String[0]), 16384);
        this.txtAddItem = new MyMaskedText(parent, Pattern.compile(DField.regExpForItems)){

            @Override
            public void setText(String s) {
                super.setText(s);
                this.setEnabled(true);
            }
        };
        this.txtAddItem.setEnabled(false);
        this.btnAddItem = new Button(parent, 0x1000008);
        this.btnRemoveItem = new Button(parent, 0x1000008);
        Label sep = new Label(parent, 258);
        this.btnUpItem = new Button(parent, 0x1000008);
        this.btnDownItem = new Button(parent, 0x1000008);
        this.listItem = new List(parent, 2560);
        int btnW = 45;
        if (UI.OS_WINDOWS) {
            btnW = 35;
            this.btnAddItem.setText("+");
            this.btnRemoveItem.setText("-");
            this.btnUpItem.setText("\u2191");
            this.btnDownItem.setText("\u2193");
        } else {
            this.btnAddItem.setText("\u2795");
            this.btnRemoveItem.setText("\u2796");
            this.btnUpItem.setText("\u2b06\ufe0e");
            this.btnDownItem.setText("\u2b07\ufe0e");
        }
        FormLayout layout = new FormLayout();
        layout.spacing = 5;
        parent.setLayout((Layout)layout);
        FormData data = new FormData();
        data.top = new FormAttachment(this.txtName.getControl(), 0, 0x1000000);
        data.left = new FormAttachment(0);
        lblName.setLayoutData(data);
        data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(lblName.getControl());
        data.right = new FormAttachment(100);
        this.txtName.setLayoutData(data);
        data = new FormData();
        data.top = new FormAttachment(this.txtName.getControl());
        data.left = new FormAttachment(0);
        this.chkMultiple.setLayoutData(data);
        data = new FormData();
        data.top = new FormAttachment(this.chkMultiple.getControl());
        data.left = new FormAttachment(0);
        if (!XCompletionProposalType.ENCOUNTER_NOTE.equals((Object)this.type)) {
            data.height = 0;
            lblType.setVisible(false);
        }
        lblType.setLayoutData(data);
        data = new FormData();
        data.top = new FormAttachment(this.chkMultiple.getControl());
        data.left = new FormAttachment(lblType.getControl());
        if (!XCompletionProposalType.ENCOUNTER_NOTE.equals((Object)this.type)) {
            data.height = 0;
            this.cmbTypeDeDonnee.setVisible(false);
        }
        this.cmbTypeDeDonnee.setLayoutData(data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.cmbTypeDeDonnee.getControl());
        data.left = new FormAttachment(0);
        lblSeparator.setLayoutData(data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.cmbTypeDeDonnee.getControl());
        data.left = new FormAttachment(lblSeparator.getControl());
        data.right = new FormAttachment(100);
        this.txtSeparator.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.txtSeparator);
        data.left = new FormAttachment(0);
        this.chkRequired.setLayoutData(data);
        data = new FormData();
        data.top = new FormAttachment(this.chkRequired.getControl());
        data.left = new FormAttachment(0);
        lblList.setLayoutData(data);
        data = new FormData();
        data.top = new FormAttachment(lblList.getControl());
        data.left = new FormAttachment(0);
        data.right = new FormAttachment((Control)this.listItem, 0, 131072);
        this.txtAddItem.setLayoutData(data);
        data = new FormData();
        data.top = new FormAttachment(this.txtAddItem.getControl());
        data.left = new FormAttachment(0);
        data.height = 200;
        data.width = 300;
        this.listItem.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.listItem, 0, 128);
        data.left = new FormAttachment((Control)this.listItem);
        data.width = btnW;
        this.btnAddItem.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.listItem, 25, 128);
        data.left = new FormAttachment((Control)this.listItem);
        data.width = btnW;
        this.btnRemoveItem.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.listItem, 55, 128);
        data.left = new FormAttachment((Control)this.btnAddItem, 0, 16384);
        data.right = new FormAttachment((Control)this.btnAddItem, 0, 131072);
        sep.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.listItem, 60, 128);
        data.left = new FormAttachment((Control)this.listItem);
        data.right = new FormAttachment((Control)this.btnAddItem, 0, 131072);
        data.width = btnW;
        this.btnUpItem.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.listItem, 85, 128);
        data.left = new FormAttachment((Control)this.listItem);
        data.right = new FormAttachment((Control)this.btnAddItem, 0, 131072);
        data.width = btnW;
        this.btnDownItem.setLayoutData((Object)data);
        this.chkMultiple.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DListDialog.this.txtSeparator.setEnabled(DListDialog.this.chkMultiple.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.txtAddItem.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                String s;
                if (UI.CR((KeyEvent)e) && (s = DListDialog.this.txtAddItem.getText().trim()).length() != 0) {
                    DListDialog.this.listItem.add(s);
                    DListDialog.this.txtAddItem.setText("");
                    DListDialog.this.txtAddItem.setFocus();
                }
            }
        });
        this.txtAddItem.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (DListDialog.this.listItem.getSelectionCount() == 1) {
                    DListDialog.this.listItem.setItem(DListDialog.this.listItem.getSelectionIndex(), ((Text)e.widget).getText());
                }
            }
        });
        this.btnAddItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = DListDialog.this.listItem.getItemCount();
                if (DListDialog.this.listItem.getSelectionCount() == 1) {
                    index = DListDialog.this.listItem.getSelectionIndex();
                }
                DListDialog.this.listItem.add("", index);
                DListDialog.this.listItem.deselectAll();
                DListDialog.this.listItem.select(index);
                DListDialog.this.txtAddItem.setText("");
                DListDialog.this.txtAddItem.setFocus();
            }
        });
        this.btnRemoveItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (DListDialog.this.listItem.getSelectionCount() > 0) {
                    int index = DListDialog.this.listItem.getSelectionIndex();
                    DListDialog.this.listItem.remove(index);
                    if (index >= DListDialog.this.listItem.getItemCount()) {
                        index = DListDialog.this.listItem.getItemCount() - 1;
                    }
                    DListDialog.this.listItem.select(index);
                    DListDialog.this.listItem.notifyListeners(13, new Event());
                }
            }
        });
        this.btnUpItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (DListDialog.this.listItem.getSelectionCount() == 1 && DListDialog.this.listItem.getItemCount() > 1 && DListDialog.this.listItem.getSelectionIndex() > 0) {
                    int index = DListDialog.this.listItem.getSelectionIndex();
                    String s = DListDialog.this.listItem.getItem(index);
                    DListDialog.this.listItem.setItem(index, DListDialog.this.listItem.getItem(index - 1));
                    DListDialog.this.listItem.setItem(index - 1, s);
                    DListDialog.this.listItem.deselectAll();
                    DListDialog.this.listItem.select(index - 1);
                }
            }
        });
        this.btnDownItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (DListDialog.this.listItem.getSelectionCount() == 1 && DListDialog.this.listItem.getItemCount() > 1 && DListDialog.this.listItem.getSelectionIndex() < DListDialog.this.listItem.getItemCount() - 1) {
                    int index = DListDialog.this.listItem.getSelectionIndex();
                    String s = DListDialog.this.listItem.getItem(index);
                    DListDialog.this.listItem.setItem(index, DListDialog.this.listItem.getItem(index + 1));
                    DListDialog.this.listItem.setItem(index + 1, s);
                    DListDialog.this.listItem.deselectAll();
                    DListDialog.this.listItem.select(index + 1);
                }
            }
        });
        this.listItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (DListDialog.this.listItem.getSelectionCount() == 1) {
                    String s = ((List)e.getSource()).getItem(((List)e.getSource()).getSelectionIndex());
                    DListDialog.this.txtAddItem.setText(s);
                }
            }
        });
        this.setTitle("Liste " + StringUtils.defaultString((String)this.field.name));
        this.txtSeparator.setText(StringUtils.defaultString((String)this.field.separator));
        this.txtName.setText(StringUtils.defaultString((String)this.field.name));
        if (this.field.items != null) {
            this.listItem.setItems(this.field.items);
        }
        if (this.field.name != null) {
            this.txtName.setSelection(this.field.name.length());
        }
        this.chkMultiple.setSelection(this.field.multiple == null ? false : this.field.multiple);
        if (this.cmbTypeDeDonnee != null) {
            if (this.field.typeDeDonnee != null) {
                this.cmbTypeDeDonnee.select(this.field.typeDeDonnee);
            } else {
                this.cmbTypeDeDonnee.select(TypeDeDonnee.S_O);
            }
        }
        this.txtSeparator.setEnabled(this.chkMultiple.getSelection());
        this.chkRequired.setSelection(this.field.required);
        this.listItem.setSelection(this.field.defaultItem);
        return parent;
    }

    @Override
    protected boolean customShouldTakeFocus() {
        return true;
    }

    @Override
    protected boolean buttonPressed(int buttonId) {
        if (buttonId == 0) {
            String name = this.txtName.getText().trim();
            if (StringUtils.isBlank((CharSequence)name)) {
                return false;
            }
            this.field.name = name;
            this.field.separator = this.txtSeparator.getText();
            this.field.multiple = new Boolean(this.chkMultiple.getSelection());
            this.field.typeDeDonnee = this.cmbTypeDeDonnee.getSelection();
            this.field.items = this.listItem.getItems();
            this.field.required = new Boolean(this.chkRequired.getSelection());
            this.field.defaultItem = this.listItem.getSelectionIndex();
        }
        return true;
    }
}

