/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.controls.handlers;

import ca.infodata.ofys.ui.controls.IBaseEditor;
import ca.infodata.ofys.ui.controls.IFmedxAction;
import ca.infodata.ofys.ui.controls.ISaveablePart;
import ca.infodata.ofys.ui.controls.MyProgressMonitorDialog;
import ca.infodata.ofys.ui.controls.actions.ISaveEditorWithProgressMonitorDialog;
import ca.infodata.ofys.ui.controls.handlers.AbstractEditionHandler;
import ca.infodata.ofys.ui.controls.handlers.InternalHandlerUtil;
import java.lang.reflect.InvocationTargetException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;

public class SaveHandler
extends AbstractEditionHandler {
    private static final Logger logger = Logger.getLogger(SaveHandler.class.getName());

    public SaveHandler() {
        this.registerEnablement();
    }

    public Object execute(ExecutionEvent event) {
        final ISaveablePart saveablePart = this.getSaveablePart(event);
        if (saveablePart == null) {
            return null;
        }
        if (saveablePart instanceof IEditorPart) {
            IEditorPart editorPart = (IEditorPart)saveablePart;
            if (editorPart instanceof IFmedxAction) {
                ((IFmedxAction)editorPart).save();
            } else if (saveablePart instanceof IBaseEditor || saveablePart instanceof ISaveEditorWithProgressMonitorDialog) {
                try {
                    MyProgressMonitorDialog progressMonitorDialog2 = new MyProgressMonitorDialog(editorPart.getSite().getShell());
                    progressMonitorDialog2.setOpenOnRun(true);
                    progressMonitorDialog2.run(true, false, new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            monitor.beginTask("Sauvegarde en cours...", -1);
                            saveablePart.doSave(monitor);
                        }
                    });
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Error on doSave " + editorPart.getClass().getName(), e);
                }
            } else {
                saveablePart.doSave((IProgressMonitor)new NullProgressMonitor());
            }
            try {
                editorPart.setFocus();
            }
            catch (Exception exception) {}
        }
        return null;
    }

    @Override
    protected EvaluationResult evaluate(IEvaluationContext context) {
        IWorkbenchWindow window = InternalHandlerUtil.getActiveWorkbenchWindow(context);
        if (window == null) {
            return EvaluationResult.FALSE;
        }
        IWorkbenchPage page = window.getActivePage();
        if (page == null) {
            return EvaluationResult.FALSE;
        }
        ISaveablePart saveablePart = this.getSaveablePart(context);
        if (saveablePart == null) {
            return EvaluationResult.FALSE;
        }
        if (saveablePart != null && saveablePart.isSaveAllowed()) {
            return EvaluationResult.TRUE;
        }
        return EvaluationResult.FALSE;
    }
}

