/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.controls.form.combo;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.CannotConnectToServerException;
import ca.infodata.ofys.data.dataaccess.CompletionComboAccessorClient;
import ca.infodata.ofys.data.dataaccess.ICallback;
import ca.infodata.ofys.data.dataaccess.callback.Callback;
import ca.infodata.ofys.data.dataaccess.callback.JobCallback;
import ca.infodata.ofys.data.dataaccess.util.MessageUtil;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.XBaseUser;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ICompletionComboItem;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.ui.controls.form.combo.MyCombo;
import ca.infodata.ofys.ui.controls.form.combo.NullXBaseUser;
import ca.infodata.ofys.ui.controls.form.combo.SOXBaseUser;
import ca.infodata.ofys.ui.library.UI;
import ca.infodata.util1.PredicateA;
import ca.infodata.util1.ProviderAR;
import ca.infodata.util1.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class UserCombo
extends MyCombo<XBaseUser> {
    private static final Logger logger = Logger.getLogger(UserCombo.class.getName());
    private static final List<UserCombo> instances = new CopyOnWriteArrayList<UserCombo>();
    private static final CompletionComboAccessorClient.CompletionComboListener listener = new CompletionComboAccessorClient.CompletionComboListener(){
        private final Runnable refresh = new Runnable(){

            @Override
            public void run() {
                ArrayList<UserCombo> toRemoveList = new ArrayList<UserCombo>();
                for (UserCombo combo : instances) {
                    if (combo != null && !combo.getControl().isDisposed()) continue;
                    toRemoveList.add(combo);
                }
                instances.removeAll(toRemoveList);
            }
        };

        public void shouldRefresh(ICompletionComboItem item) {
            Display.getDefault().asyncExec(this.refresh);
        }
    };
    private static final int STANDARD_TEXT_LIMIT = 100;
    private boolean cnull;
    private boolean cso;
    private NullXBaseUser snull;
    private SOXBaseUser sso;

    static {
        CompletionComboAccessorClient.addListener((String)"user", (CompletionComboAccessorClient.CompletionComboListener)listener);
    }

    public UserCombo(Composite parent, int style, FormToolkit toolkit) {
        super(parent, style, toolkit);
        this.cnull = (style | 0x10000) == style;
        this.cso = (style | 0x2000) == style;
        this.setLabelProvider(new ProviderAR<XBaseUser, String>(){

            public String get(XBaseUser user) {
                if (user != null) {
                    return user.getPersonNameOrTextOrEmpty();
                }
                return "";
            }
        });
        if (!UI.containsStyle((int)8, (int)style)) {
            this.setAutoComplete(true);
            this.setDisplayPredicate(new PredicateA<XBaseUser>(){

                public boolean evaluate(XBaseUser user) {
                    return user != null && (user.isActive() && user.getIdPerson() != null || user instanceof SOXBaseUser || user instanceof NullXBaseUser);
                }
            });
        }
        this.setTextLimit(100);
        instances.add(this);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                instances.remove(UserCombo.this);
            }
        });
    }

    public void fill(boolean async) {
        if (async) {
            this.fillAsync();
        } else {
            this.fillSync();
        }
    }

    private void fillSync() {
        block4: {
            Callback callback = new Callback(){

                public void responseReceived(ReturnObject response) {
                    if (!UserCombo.this.getControl().isDisposed()) {
                        UserCombo.this.fill((List)response.getObj());
                    }
                }
            };
            try {
                CompletionComboAccessorClient.getInstance().findAll(Application.get().getGlobalInstances().getSession(), (ICallback)callback, "user");
            }
            catch (CannotConnectToServerException cannotConnectToServerException) {
                MessageUtil.cannotConnectToServerExceptionMsg();
                if (callback != null && !callback.killed()) {
                    callback.kill();
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "failed to fill usercombo", e);
                if (callback == null || callback.killed()) break block4;
                callback.kill();
            }
        }
    }

    private void fillAsync() {
        block4: {
            JobCallback callback = new JobCallback(Messages.getString((String)"RECHERCHE", (String[])new String[0])){

                public void responseReceived(final ReturnObject response) {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (!UserCombo.this.getControl().isDisposed()) {
                                UserCombo.this.fill((List)response.getObj());
                            }
                        }
                    });
                }
            };
            try {
                CompletionComboAccessorClient.getInstance().findAllAsync(Application.get().getGlobalInstances().getSession(), (ICallback)callback, "user");
            }
            catch (CannotConnectToServerException cannotConnectToServerException) {
                MessageUtil.cannotConnectToServerExceptionMsg();
                if (callback != null && !callback.killed()) {
                    callback.kill();
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "failed to fill usercombo", e);
                if (callback == null || callback.killed()) break block4;
                callback.kill();
            }
        }
    }

    protected void fill(List<XBaseUser> users) {
        if (users != null) {
            XBaseUser[] temp;
            Collections.sort(users, new Comparator<XBaseUser>(){

                @Override
                public int compare(XBaseUser o1, XBaseUser o2) {
                    if ("infodata".equalsIgnoreCase(o1.str)) {
                        return 1;
                    }
                    if ("infodata".equalsIgnoreCase(o2.str)) {
                        return -1;
                    }
                    if (o1.getPersonName() == null) {
                        return 1;
                    }
                    if (o2.getPersonName() == null) {
                        return -1;
                    }
                    return StringUtils.compareAscii((String)o1.getPersonName(), (String)o2.getPersonName());
                }
            });
            XBaseUser[] items = users.toArray(new XBaseUser[users.size()]);
            XBaseUser defaultSelection = (XBaseUser)this.getDefaultSelection();
            if (defaultSelection != null) {
                XBaseUser[] xBaseUserArray = items;
                int n = items.length;
                int n2 = 0;
                while (n2 < n) {
                    XBaseUser i = xBaseUserArray[n2];
                    if (defaultSelection.equals((Object)i)) {
                        defaultSelection = i;
                        break;
                    }
                    ++n2;
                }
            }
            this.snull = null;
            if (this.cnull) {
                this.snull = new NullXBaseUser();
                temp = new XBaseUser[items.length + 1];
                temp[0] = this.snull;
                System.arraycopy(items, 0, temp, 1, items.length);
                items = temp;
                if (defaultSelection == null) {
                    defaultSelection = this.snull;
                }
            }
            this.sso = null;
            if (this.cso) {
                this.sso = new SOXBaseUser();
                temp = new XBaseUser[items.length + 1];
                temp[0] = this.sso;
                System.arraycopy(items, 0, temp, 1, items.length);
                items = temp;
                if (defaultSelection == null) {
                    defaultSelection = this.sso;
                }
            }
            this.setItems(items);
            if (defaultSelection != null) {
                this.setDefaultSelection(defaultSelection);
            }
        }
    }

    @Override
    public XBaseUser getSelection() {
        XBaseUser selection = (XBaseUser)super.getSelection();
        if (selection instanceof NullXBaseUser) {
            return null;
        }
        return selection;
    }

    public XBaseUser getUserById(Integer userId) {
        if (userId == null) {
            return null;
        }
        for (XBaseUser u : this.getItems()) {
            if (!userId.equals(u.getId())) continue;
            return u;
        }
        return null;
    }

    @Override
    public void select(XBaseUser item) {
        if (item == null) {
            this.forceSelect2(this.snull);
        } else {
            this.forceSelect2(item);
        }
    }

    private void forceSelect2(XBaseUser item) {
        if (this.contains(item)) {
            super.select(item);
        } else {
            this.add(item);
            super.select(item);
        }
    }
}

